/* HPUX_ID: @(#)hil.h	27.2     85/06/27  */
/* HIL KERNAL DEFINITIONS */

/* Status 5 Bits */

#define	H_LERROR	0x080		/* Status 5 Error Bit */
#define	H_LRECONFIG	0x080		/* Loop has reconfigured */
#define	H_LDERROR	0x081		/* Data error to Loop */
#define	H_TIMEOUT	0x082		/* Loop Timeout */
#define	H_LDOWN		0x084		/* Loop is being reconfigured */
#define	H_LCOMMAND	0x008		/* Data to follow is the Command
					   which caused the previous data */
#define	H_POLLING	0x010		/* Data to follow is in response
					   to a poll command */
#define	H_DEVADR	0x007		/* Device address */
#define	H_LMAXDEVICES	9		/* Maximum number of loop devices
					   plus a device for cooked keys
					   and RPG input */
#define H_NIMITZKBD	8		/* Address of 'cooked' keyboards */
#define H_NIMITZKNOB	9		/* Address of 'cooked' knob */
#define H_MAXGATORS     4               /* Maximum number of gators supported */
#define MAX_PACKET_LENGTH 20            /* Maximum poll packet length including
					   the time stamp */

/* LPCTRL Bits */

#define	H_DORECONFIGURE	0x080		/* Reconfigure the Loop */
#define H_COOKED	0x010		/* Cook selected keyboards */
#define	H_NORECONFIG	0x004		/* Don't Report Loop Reconfiguration */
#define	H_NOERRS	0x002		/* Don't Report Loop Errors */
#define	H_DOAUTOPOLL	0x001		/* Autopoll */

/* Commands */

#define	H_READCTRL	0xfb
#define	H_WRITECTRL	0xeb
#define H_READKBDS 	0xf9
#define H_WRITEKBDS	0xe9
#define	H_STARTCMD	0xe0
#define	H_WRITEDATA	0xe0
#define	H_READBUSY	0x02
#define	H_TRIGGER	0xc5
#define	H_TIMEOUT20	0xfe
#define	H_READLSTAT	0xfa
#define	H_IDCMD		0x03
#define H_READTIME	0x13
#define H_INTON		0x5c

#define	H_DATASTARTING	0
#define	H_DATAENDED	1
#define	H_RESETDEVICE	2
#define H_INT_MASK	0x1f

#define H_IOC_RIDC      "H"
#define H_IOC_HIDC      "h"
#define H_IOC_NIDC      "N"
#define H_IOCSIZE	0x3fff
#define H_IOCCMD	0xff

/* DEV fields for the 8042 */

#define H_GATOR		0x0f<<8
#define H_HIL_DEVICE	0x0f<<4

#define HILHOG		512
#define HILIPRI		PZERO+3
#define HILBUF_SIZE	384

/* Structure for select */

struct hilselect {
	 struct proc *hil_selp;
	 short hil_selflag;
	};

/* Device data record */

struct devicerec {
	 struct	clist	hdevqueue;
	 struct hilselect hil_sel;
	 unsigned char	open_flag;
         unsigned char	sleep;
		 };

/* Gator buffer record */

struct gatorbuf {
	 ushort		*g_inbuf;	/* Input queue */
	 ushort		*g_in_head;	/* Head of input queue */
	 ushort		*g_in_tail;	/* Tail of input queue */
	 ushort		g_in_count;	/* Number of characters in queue */
	 unsigned char	g_int_flag;	/* Interrupt flags */
	 unsigned char	g_rcv_flag;	/* Pending interrupt for receive */
	 int		g_int_lvl;	/* Interrupt level of the gator */
	 struct sw_intloc g_rcv_intloc;	/* Software trigger receive structure */
		};
/* Gator data record */

struct gatorec	{
	 long		  hilbase;
	 long		  hildata;
	 long		  hilstatus;
	 long		  hilcommand;
	 unsigned char	  has_ite_kbd;
	 unsigned char	  nimitz_took_ite_kbd;
	 unsigned char	  active_device;
	 unsigned char	  command_device;
	 unsigned char	  command_ending;
	 unsigned char	  loopcmddone;
	 unsigned char	  collecting;
	 unsigned char	  raw_8042_data;
	 unsigned char 	  packet[MAX_PACKET_LENGTH];
         unsigned char	  packet_length;
	 unsigned char	  loop_response[MAX_PACKET_LENGTH];
	 unsigned char	  response_length;
         unsigned char    cooked_mask;
         unsigned char    current_mask;
         unsigned char    num_ldevices;
	 unsigned char	  repeat_rate;
	 struct gatorbuf  gb;
	 struct devicerec loopdevices[H_LMAXDEVICES+1];
		};

struct h_ioctl	{
	 unsigned ioc_in      : 1;
	 unsigned ioc_out     : 1;
	 unsigned ioc_size    : 14;
	 unsigned ioc_idc     : 8;
	 unsigned ioc_cmd     : 8;
		};
