/* HPUX_ID: @(#)dma.h	27.1     85/02/21  */
/*
** structure definitions for the dma channels
** both logical and physical
*/

/* physical addresses for dma channels 0 and 1 */

#define	DMA_CHANNEL0	0x500000
#define	DMA_CHANNEL1	0x500008
#define PROGRAMABLE_DMA	0x508000	/* to see if we have new dma */


/* physical dma channel definition */

struct dma {
	caddr_t dma_address;
	unsigned short dma_count;
	unsigned char pad1;
	unsigned char dma_control;
};

#define	dma_reset dma_address
#define dma_status dma_control

/* bit definitions for dma channels */

/* interrupt level settings */
#define	DMA_LVL3	0x0000
#define	DMA_LVL4	0x0010
#define	DMA_LVL5	0x0020
#define	DMA_LVL6	0x0030
#define	DMA_LVL7	0x0040

/* control register bits */
#define	DMA_PRI		0x0008
#define	DMA_IO		0x0004
#define	DMA_WB		0x0002
#define	DMA_ENABLE	0x0001

/* status register bits */
#define	DMA_INT		0x0002
#define	DMA_ARM		0x0001

/*
** logical dma channel definition
*/
struct dma_channel {
	struct buf *b_actf;		/* for queue of requests */
	struct buf *b_actl;		/* for queue of requests */
	struct dma *card;		/* address of dma channel */
	int reserved;			/* bit map of reserving sc's */
	short locked;			/* locked by a single sc */
	struct dma_chain *base;		/* start of chain array */
	struct dma_chain *extent;	/* end of chain array */
	struct isc_table_type *sc;	/* interface owning channel */
	int (*isr)();			/* current dma isr address */
	int arg;			/* argument to isr */
};


/* 
** Each entry in the chain has the following format:
**      bytes   0-3:	address of io card register
**	byte      4:	level on which interrupt is supposed to occur
**	byte      5:	io card byte (used to modify io card state)
**	bytes   6-9:	address of transfer buffer
**      bytes 10-11:	transfer count
**	bytes 12-13:	dma channel arm word
*/
struct dma_chain {
	caddr_t	       card_reg;
	unsigned char  level;
	unsigned char  card_byte;
	caddr_t	       buffer;
	unsigned short count;
	unsigned short arm;
};


/*
** Defines for the number of physical page dma transfers (max)
** and the number of bytes (max)
*/
#define	DMA_BYTES	65536
#define	DMA_PAGES	(DMA_BYTES / NBPG)
#define DMACHANSZ 	(sizeof(struct dma_chain) * (DMA_PAGES+3))

/*
** boolean for dma installed
*/
int dma_here;

/*
** dma allocation state info
*/
int free_dma_channels;	/* (channels)-(active sc's); can go negative */

/* pre allocated dma chain arrays -- one per channel */
/* hpibio.s has a dependency on this structure! */

struct dma_chain *dmachain[2];

struct dma_channel dmatab[2];
