/* HPUX_ID: @(#)dilio.h	27.2     85/06/27  */
/*
**	dilio.h	Device I/O Library header for kernel
*/

/************** for now ****************/
#define	NDILBUFFERS	10	/* allocate the dil buffers */
#define DIL_IOVS	30	/* number of vectors for hpibio */
/************** for now ****************/

/* stuff kept in buf structure */
#define	pass_data1		b_bufsize	/* put temp parameter info */
#define	pass_data2		b_pfcent	/* put temp parameter info */
#define	return_data		b_bufsize	/* put temp return info */
#define	wait_event		b_s0	/* wait for bus status */
#define ppoll_data		b_s1	/* put termination reason stuff here */
#define	gpio_lines		b_s1	/* control/status lines */

/* stuff kept in iobuf structure */
#define	read_pattern		io_nreg	/* hold read terminating pattern */
#define term_reason		io_s0	/* put termination reason stuff here */
#define	activity_timeout	io_s1	/* for use during any activity */
#define	block_timeout		io_s2	/* for use while waiting for resource */
#define	dil_timeout		timeo	/* for all timeouts */
#define	dil_trigger		intloc	/* to drop priorty level */
#define	dil_state		b_errcnt	/* keep dil info (size char) */
#define	dil_speed		b_clock_ticks	/* keep speed for user */

/* buf.h uses 0x40000000 for B_DIL to show that this is a dil buffer */

/*
 * These flags are kept in dil_state.
 */
/* DIL state stuff */
#define D_CHAN_LOCKED	0x01	/* this process has the channel locked */
#define D_16_BIT 	0x02	/* transfer width is 16 bit */
#define D_RAW_CHAN 	0x04	/* this is a raw open */
#define D_MAPPED 	0x08	/* this was mapped into user space */


/* transfer information for select code in dil state */
#define TFR_MASK	0xf0
#define USE_DMA		0x10
#define USE_INTR	0x20
#define READ_PATTERN	0x40
#define EOI_CONTROL	0x80

/* sc->intr_wait and sc->intr_event info */
#define WAIT_CTLR	0x01
#define WAIT_SRQ	0x02
#define WAIT_TALK	0x04
#define WAIT_LISTEN	0x08

/* extra bit to see if process can touch card */
#define NO_PERMISSION	0x0100

/* extra bit in term_reason to keep track of SRQ event */
#define TERM_SRQ	0x80

#define OWNER		0x02	/* this is the owner(see ioctl's) */

#define NO_ADDRESS	31	/* invalid address for the bus*/

#define	DEFAULT_TIMEOUT	HZ*15	/* default timeout value */


/* iov generic structure */
struct diliovec {
	int	*buffer;
	int	count;
	int	command;
};


/*
**	info for 98622 card 
*/
#define MAX_GPIO 6	/* max number of 98622's */

enum gpio_states { get = 0, get2, transfer, drop, timedout, defaul};

/* memory layout of the card */
struct GPIO {				/* address */
	unsigned char ready;		/*   0	   */
#define set_pctl ready
	unsigned char id_reg;		/*   1 	   */
#define	reset_gpio id_reg
	unsigned char intr_mask;	/*   2 	   */
	unsigned char intr_control;	/*   3 	   */
#define	intr_status intr_control
	union {				/*   4,5   */
		struct {
			unsigned char upper;
			unsigned char lower;
		} byte;
		unsigned short word;
	} data;
	unsigned char nop1;
	unsigned char p_status;		/*   7	   */
#define p_control p_status
};

/* (addr 2) ready/external interrupt control assignments */
#define	GP_EIR1 	0x01
#define	GP_EIR0 	0x00
#define	GP_RDYEN1	0x02
#define	GP_RDYEN0	0x00

/* (addr 3) interrupt/dma control assignments */
#define	GP_DMA0		0x01
#define	GP_DMA1		0x02
#define	GP_WORD		0x04
#define	GP_BURST	0x08
#define	GP_ENAB		0x80

/* (addr 7) status register */
#define	GP_INT_EIR	0x04
#define	GP_PSTS		0x08
