/* HPUX_ID: @(#)dil.h	27.2     85/06/27  */
/*
**	dil.h	Device I/O Library header
*/

#include <sys/ioctl.h>


struct ioctl_type {
	int type;
	int data[3];
};

#define	CMDSIZE	122

struct ioctl_cmd_type {
	int length;
	unsigned char data[CMDSIZE];
};

struct ioctl_env_type {
	int channel_type;
	int timeout;
	int status;
	int term_reason;
	int read_pattern;
	int signal_mask;
	int width;
	int speed;
	int locking_pid;
};

/* ioctl's for all dil channels */

#define	IO_CONTROL	_IOWR(I, 1, struct ioctl_type)
#define	IO_STATUS	_IOWR(I, 2, struct ioctl_type)
#define	HPIB_CONTROL	_IOWR(H, 1, struct ioctl_type)
#define	HPIB_STATUS	_IOWR(H, 2, struct ioctl_type)
#define	HPIB_SEND_CMD	_IOWR(H, 3, struct ioctl_cmd_type)
#define	HPIB_ENVIRONMENT _IOWR(H, 4, struct ioctl_env_type)
#define	GPIO_CONTROL	_IOWR(g, 1, struct ioctl_type)
#define	GPIO_STATUS	_IOWR(g, 2, struct ioctl_type)


/* IO types for all channels */
#define	IO_TIMEOUT		1
#define	IO_WIDTH		2
#define	IO_SPEED		3
#define	IO_READ_PATTERN		4
#define	IO_RESET		5
#define	IO_TERM_REASON		6
#define	IO_LOCK			7
#define	IO_UNLOCK		8

/* lock functions */
#define	LOCK		1
#define	UNLOCK		2

/* channel types */
#define	CHANNEL_TYPE		22

#define GPIO_CHAN		0x00000200
#define RS232_CHAN		0x00000400

/* termination reasons */
#define TR_ABNORMAL		0x00000000
#define TR_COUNT		0x00000001
#define TR_MATCH		0x00000002
#define TR_END			0x00000004
#define TR_TIMEOUT		0x00000008
#define TR_ERROR		0x00000010
#define TR_NOTERM		0x00000020
#define TR_MASK			0x0000003f
