C STARBASE_ID:sb.f2.h   11/15/85   15:33:06
C************************************************************************
C*									*
C*	definitions and types to be included with STARBASE application	*
C*	programs written in Fortran					*
C*									*
C************************************************************************
C    (c) Copyright Hewlett-Packard Company, 1985.  
C     All rights are reserved.  Copying or other
C     reproduction of this program except for archival
C     purposes is prohibited without the prior 
C     written consent of Hewlett-Packard Company. 
C                 
C                 
C                 RESTRICTED RIGHTS LEGEND
C     
C     Use, duplication, or disclosure by the Government
C     is subject to restrictions as set forth in 
C     paragraph (b) (3) (B) of the Rights in Technical
C     Data and Computer Software clause in 
C     DAR 7-104.9(a).
C     
C     HEWLETT-PACKARD COMPANY
C     Fort Collins, Colorado


C	boolean values
	integer*4 FALSE, TRUE
	parameter(FALSE=0)
	parameter(TRUE=1)

C	kinds of graphics devices
	integer*4 OUTDEV, INDEV, OUTINDEV, OUTMETA, INMETA
	parameter(OUTDEV=0)
	parameter(INDEV=1)
	parameter(OUTINDEV=2)
	parameter(OUTMETA=3)
	parameter(INMETA=4)

C	clear control parameters
	integer*4 CLEAR_VDC_EXTENT, CLEAR_CLIP_RECTANGLE
	integer*4 CLEAR_DISPLAY_SURFACE
	parameter(CLEAR_VDC_EXTENT=1)
	parameter(CLEAR_CLIP_RECTANGLE=33)
	parameter(CLEAR_DISPLAY_SURFACE=65)

C	clip control parameters
	integer*4 CLIP_TO_RECT, CLIP_TO_VDC, CLIP_OFF
	parameter(CLIP_TO_RECT=1)
	parameter(CLIP_TO_VDC=2)
	parameter(CLIP_OFF=3)

C	gopen open_mode parameter masks
	integer*4 SPOOLED, INIT, THREE_D, RESET_DEVICE
	parameter(SPOOLED=1)
C	if this bit is on, output is spooled
	parameter(INIT=2)
C	if this bit is on, device initialization occurs
	parameter(THREE_D=4)
C	if this bit is on, all transformations are 3D
	parameter(RESET_DEVICE=8)
C	if this bit is on, do a device reset operation

C	set p1 p2 units
	integer*4 FRACTIONAL, METRIC
	parameter(FRACTIONAL=0)
	parameter(METRIC=1)

C	mapping modes
	integer*4 ISOTROPIC,DISTORT
	parameter(ISOTROPIC=0)
	parameter(DISTORT=1)

C	Starbase linetypes
	integer*4 SOLID, DASH, DOT, DASH_DOT, DASH_DOT_DOT, LONG_DASH
	integer*4 CENTER_DASH, CENTER_DASH_DASH
	parameter(SOLID=0)
	parameter(DASH=1)
	parameter(DOT=2)
	parameter(DASH_DOT=3)
	parameter(DASH_DOT_DOT=4)
	parameter(LONG_DASH=5)
	parameter(CENTER_DASH=6)
	parameter(CENTER_DASH_DASH=7)

C	polygon interior styles
	integer*4 INT_HOLLOW, INT_SOLID
	parameter(INT_HOLLOW=0)
	parameter(INT_SOLID=1)

C   Matrix concatenation types 
	integer*4 PRE, POST, REPLACE, PUSH
	parameter(PRE=0)
	parameter(POST=1)
	parameter(REPLACE=0)
	parameter(PUSH=1)

C	character switching modes
	integer*4 ISO_7BIT, ISO_8BIT, HP_8BIT
	parameter(ISO_7BIT=0)
	parameter(ISO_8BIT=1)
	parameter(HP_8BIT=2)

C	text transformation types
	integer*4 VDC_TEXT, WORLD_COORDINATE_TEXT, TOS_TEXT
	parameter(VDC_TEXT=0)
	parameter(WORLD_COORDINATE_TEXT=1)
	parameter(TOS_TEXT=2)

C	text precision types
	integer*4 STRING_TEXT, CHARACTER_TEXT, STROKE_TEXT
	parameter(STRING_TEXT=0)
	parameter(CHARACTER_TEXT=1)
	parameter(STROKE_TEXT=2)

C	text alignment enumerated types
	integer*4 TA_LEFT, TA_CENTER, TA_RIGHT
	integer*4 TA_CONTINUOUS_HORIZONTAL, TA_NORMAL_HORIZONTAL
	parameter(TA_LEFT=0)
	parameter(TA_CENTER=1)
	parameter(TA_RIGHT=2)
	parameter(TA_CONTINUOUS_HORIZONTAL=3)
	parameter(TA_NORMAL_HORIZONTAL=4)
	
	integer*4 TA_TOP, TA_CAP, TA_HALF, TA_BASE, TA_BOTTOM
	integer*4 TA_CONTINUOUS_VERTICAL, TA_NORMAL_VERTICAL
	parameter(TA_TOP=0)
	parameter(TA_CAP=1)
	parameter(TA_HALF=2)
	parameter(TA_BASE=3)
	parameter(TA_BOTTOM=4)
	parameter(TA_CONTINUOUS_VERTICAL=5)
	parameter(TA_NORMAL_VERTICAL=6)

C	character path and line path enumerated types
	integer*4 PATH_RIGHT, PATH_LEFT, PATH_UP, PATH_DOWN
	parameter(PATH_RIGHT=0)
	parameter(PATH_LEFT=1)
	parameter(PATH_UP=2)
	parameter(PATH_DOWN=3)

C	input device class enumerated types
	integer*4 ALL, LOCATOR, CHOICE
	parameter(ALL=0)
	parameter(LOCATOR=1)
	parameter(CHOICE=4)

C	event queue states
	integer*4 EMPTY_NO_OVERFLOW, EMPTY_OVERFLOW
	integer*4 NOT_EMPTY_NO_OVERFLOW, NOT_EMPTY_OVERFLOW
	parameter(EMPTY_NO_OVERFLOW=0)
	parameter(EMPTY_OVERFLOW=1)
	parameter(NOT_EMPTY_NO_OVERFLOW=2)
	parameter(NOT_EMPTY_OVERFLOW=3)

C	event message link enumerated types
	integer*4 SIMULTANEOUS_EVENT_FOLLOWS, SINGLE_EVENT
	parameter(SIMULTANEOUS_EVENT_FOLLOWS=0)
	parameter(SINGLE_EVENT=1)

C	gerr printing flags
	integer*4 NO_ERROR_PRINTING, PRINT_ERRORS, PRINT_WARNINGS
	parameter(NO_ERROR_PRINTING=0)
	parameter(PRINT_ERRORS=1)
	parameter(PRINT_WARNINGS=2)

C	 GLOBAL gescapes
	integer*4 SWITCH_SEMAPHORE,READ_COLOR_MAP,BLINK_PLANES
	parameter(SWITCH_SEMAPHORE=0)
	parameter(READ_COLOR_MAP=1)
	parameter(BLINK_PLANES=2)

C	 GLOBAL raster gescapes
	integer*4  R_GET_FRAME_BUFFER
	parameter(R_GET_FRAME_BUFFER=20)
	integer*4  R_LOCK_DEVICE
	parameter(R_LOCK_DEVICE=21)
	integer*4  R_UNLOCK_DEVICE
	parameter(R_UNLOCK_DEVICE=22)
	integer*4  R_GET_WINDOW_INFO
	parameter(R_GET_WINDOW_INFO=23)
	integer*4  R_FULL_FRAME_BUFFER
	parameter(R_FULL_FRAME_BUFFER=24)
	integer*4  R_ALLOC_OFFSCREEN
	parameter(R_ALLOC_OFFSCREEN=25)
	integer*4  R_FREE_OFFSCREEN
	parameter(R_FREE_OFFSCREEN=26)
	integer*4  R_BIT_MODE
	parameter(R_BIT_MODE=27)
	integer*4  R_BIT_MASK
	parameter(R_BIT_MASK=28)
	integer*4  R_DEF_FILL_PAT
	parameter(R_DEF_FILL_PAT=29)

C	 HPGL gescapes
	integer*4 HPGL_WRITE_BUFFER,HPGL_SET_PEN_NUM
	integer*4 HPGL_SET_PEN_SPEED
	parameter(HPGL_WRITE_BUFFER=100)
	parameter(HPGL_SET_PEN_NUM=101)
	parameter(HPGL_SET_PEN_SPEED=102)

C	 HP26XX/HPTERM gescapes
	integer*4 HP26_PRINT_ESC
	parameter(HP26_PRINT_ESC=200)
	integer*4 HPTERM_PRINT_ESC
	parameter(HPTERM_PRINT_ESC=200)
	integer*4 HPTERM_640x400
	parameter(HPTERM_640x400=201)

C	 GATOR BOX gescapes
	integer*4 GB_NONE
	parameter(GB_NONE=300)

C	 GATORADE gescapes
	integer*4 GA_NONE
	parameter(GA_NONE=400)

C	 TOPCAT gescapes
	integer*4 TC_HALF_PIXEL
	parameter(TC_HALF_PIXEL=500)

C	 HIL gescapes
	integer*4 ENABLE_AUTO_PROMPT,DISABLE_AUTO_PROMPT
	integer*4 PROMPT_ON,PROMPT_OFF
	integer*4 TRIGGER_ON_RELEASE,IGNORE_RELEASE
	parameter(ENABLE_AUTO_PROMPT=600)
	parameter(DISABLE_AUTO_PROMPT=601)
	parameter(PROMPT_ON=602)
	parameter(PROMPT_OFF=603)
	parameter(TRIGGER_ON_RELEASE=604)
	parameter(IGNORE_RELEASE=605)

C	 GKSM gescapes
	integer*4 GKSM_WRITE_ITEM,GKSM_GET_ITEM_TYPE
	integer*4 GKSM_READ_ITEM,GKSM_SKIP_ITEM
	integer*4 GKSM_INQ_COLOR_NDCES,GKSM_INQ_PAT_REP
	parameter(GKSM_WRITE_ITEM=700)
	parameter(GKSM_GET_ITEM_TYPE=701)
	parameter(GKSM_READ_ITEM=702)
	parameter(GKSM_SKIP_ITEM=703)
	parameter(GKSM_INQ_COLOR_NDCES=704)
	parameter(GKSM_INQ_PAT_REP=705)

	external gclose, gopen
	external read_choice_event,read_locator_event,disable_events
	integer*4 gclose, gopen
	integer*4 read_choice_event,read_locator_event,disable_events
