/* HPUX_ID: @(#)magic.h	27.1     85/02/21  */

/*
   magic.h:  info about HP-UX "magic numbers"
*/

/* where to find the magic number in a file and what it looks like: */
#define MAGIC_OFFSET	0L

struct magic
	 {
	  unsigned short int system_id;
	  unsigned short int file_type;
	 };
typedef struct magic MAGIC;

/* predefined (required) file types: */
#define RELOC_MAGIC	0x106		/* relocatable only */
#define EXEC_MAGIC	0x107		/* normal executable */
#define SHARE_MAGIC	0x108		/* shared executable */

#define AR_MAGIC	0xFF65

/* optional (implementation-dependent) file types: */
#define DEMAND_MAGIC	0x10B		/* demand-load executable */

/* predefined HP-UX target system machine IDs */
#define HP9000_ID	0x208
#define HP98x6_ID	0x20A
#define HP9000S200_ID	0x20C
