/* HPUX_ID: @(#)trap.h	27.3		85/05/06 */

/*
** Trap type values (the types are just the offset into the exception table)
*/

/* 0 (thru 4) is for the reset vector and not used by trap */

#define	T_BUSFLT	8	/* bus error            */
#define	T_ADDRFLT	12	/* address error        */
#define T_ILLFLT	16	/* illegal instruction  */
#define	T_ARITHTRAP	20	/* zero divide          */
#define T_CHKFLT	24	/* chk instruction      */
#define T_TRAPV		28	/* trapv instruction    */
#define	T_PRIVFLT	32	/* privilege violation  */
#define	T_TRCTRAP	36	/* trace trap           */
#define	T_LINEA		40	/* line 1010 trap  (iot)*/
#define	T_LINEF		44	/* line 1111 trap  (emt)*/

#define	T_CPROTO	52	/* coprocessor protocol violation */
#define	T_FORMAT	56	/* format error */

#define T_SPURIOUS	96	/* spurious interrupt   */

#define	T_SYSCALL	128	/* trap0 -- syscall     */
#define	T_BPTFLT	132	/* trap1 -- breakpoint  */
#define T_TRAP2		136	/* trap2 -- illegal    	*/
#define	T_TRAP3 	140	/* trap3 -- illegal     */
#define T_TRAP4		144	/* trap -- illegal	*/
#define T_TRAP5		148	/* trap -- illegal      */
#define T_TRAP6		152	/* trap -- illegal      */
#define T_TRAP7		156	/* trap -- illegal      */
#define T_TRAP8		160	/* trap -- fpe          */
#define T_TRAP9		164	/* trap -- illegal      */
#define T_TRAP10	168	/* trap -- illegal      */
#define T_TRAP11	172	/* trap -- illegal      */
#define T_TRAP12	176	/* trap -- illegal      */
#define T_TRAP13	180	/* trap -- illegal      */
#define T_TRAP14	184	/* trap -- illegal      */
#define T_TRAP15	188	/* trap -- illegal      */

/* 68881 floating point coprocessor exceptions */
#define T_BSUN		192	/* 68881 branch or set byte on unordered cond */
#define T_INEX		196	/* 68881 inexact result */
#define T_ZDIV		200	/* 68881 divide by zero */
#define T_UNDRFLW	204	/* 68881 underflow */
#define T_OPERR		208	/* 68881 operand error */
#define T_OVRFLW	212	/* 68881 overflow */
#define T_SNAN		216	/* 68881 signalling NAN */

#define	T_RESCHED	256	/* trap -- reschedule   */

#define	T_SEGFLT	1008	/* limit violation	*/
#define	T_PROTFLT	1012	/* protection fault	*/
#define	T_PAGEFLT	1016	/* page fault		*/
#define	T_TABLEFLT	1020	/* page table fault	*/

/*
** Special status word masks
*/

#define	FC	0x8000			/* pipe C fault        -- 68020  */
#define	FB	0x4000			/* pipe B fault        -- 68020  */
#define	RC	0x2000			/* rerun stage C       -- 68020  */
#define	RB	0x1000			/* rerun stage B       -- 68020  */
#define	DF	0x0100			/* data access fault   -- 68020  */
#define	RM	0x0080			/* data read-mod-write -- 68020 */
#define	RRW	0x0040			/* data read/write     -- 68020 */
#define	SZ	0x0030			/* data size code      -- 68020 */
#define	AS	0x0007			/* data function code  -- 68020 */

/*
** The following is used by trap to decypher what kind of exception happened.
** It describes the worst case exception stack (those cased by bus error or
** address error).
*/

struct exception_stack {
	int 	e_regs[20];			/* sfc + dfc + 16 gprs +    */
						/* ps (long) + pc           */
	u_short	e_offset;			/* vector offset (type)     */
    union {
	struct {
		u_short	e_ssw;			/* special status word      */
		int	e_address;		/* fault address            */
		short	e_unused1;		/* unused                   */
		u_short	e_data_ob;		/* data output buffer       */
		short	e_unused2;		/* unused                   */
		u_short	e_data_ib;		/* data input buffer        */
		short	e_unused3;		/* unused                   */
		u_short	e_ins_ib;		/* instruction input buffer */
		short	e_internal[16];		/* 16 words of internal info*/
	} e_68010;

	struct {
		u_short	e_ir1;			/* 1 internal register      */
		u_short	e_ssw;			/* special status word      */
		u_short	e_ips_c;		/* instruction pipe stage C */
		u_short	e_ips_b;		/* instruction pipe stage B */
		int	e_address;		/* fault address            */
		u_short	e_ir2[2];		/* 2 internal registers     */
		int    	e_data_ob;		/* data output buffer       */
		u_short	e_ir3[2];		/* 2 internal registers     */
	} e_68020_short;

	struct {
		u_short	e_ir1;			/* 1 internal register      */
		u_short	e_ssw;			/* special status word      */
		u_short	e_ips_c;		/* instruction pipe stage C */
		u_short	e_ips_b;		/* instruction pipe stage B */
		int	e_address;		/* fault address            */
		u_short	e_ir2[2];		/* 2 internal registers     */
		int    	e_data_ob;		/* data output buffer       */
		u_short	e_ir3[4];		/* 4 internal registers     */
		int    	e_stage_b;		/* stage B address          */
		u_short	e_ir4[2];		/* 2 internal registers     */
		int    	e_data_ib;		/* data input buffer        */
		u_short	e_ir5[22];		/* 22 internal registers    */
	} e_68020_long;
    } e_union;
};
