/* HPUX_ID: @(#)sendsig.h	27.2		85/05/06 */

/*
** General purpose registers d0-d7,a0-a6 are saved in fs_regs array
** Float card registers fstatus, ferrbit, fpr0-fpr7 are saved in fs_regs array
** MC68881 saves internal state (184 bytes), 3 control registers (12 bytes),
**         and 8 96 bit floating point registers (96 bytes) in fs_regs array
** See also reg.h
*/
#define	GPR_START		0
#define	FLOAT_START		15	
#define	MC68881_START		25	

#define	GPR_REGS		15
#define	FLOAT_CARD_REGS		10
#ifdef	WOPR
#define	MC68881_REGS		73
#else
#define	MC68881_REGS		0
#endif

/* Note - registers must be last field in sigframe, as the rest of the frame */
/*        is copied out to the user stack.                                   */

struct	full_sigcontext {
	struct	sigcontext	fs_context;
	char			fs_eosys;
	u_char			fs_error;
	int			fs_rval1;
	int			fs_rval2;
	int			fs_regs[GPR_REGS+FLOAT_CARD_REGS+MC68881_REGS];
};

struct sigframe {
	int			(*sf_handler)();
	int			sf_signum;
	int			sf_code;
	struct	sigcontext	*sf_scp;
	struct	full_sigcontext	sf_full;
};
