/* HPUX_ID: @(#)reg.h	27.2		85/05/06 */
/*
 * Location of the users' stored
 * registers relative to SFC.
 * SFC and DFC are the source and destination
 * function code registers respectively.
 * R0-R7 are the data registers.
 * AR0-AR7 are the address registers.
 * RPS is the status register (long)
 * PC is the program counter
 *
 * Usage is u.u_ar0[XX].
 */

#define SFC	0
#define DFC	1
#define	R0	2
#define	R1	3
#define	R2	4
#define	R3	5
#define	R4	6
#define	R5	7
#define	R6	8
#define	R7	9
#define	AR0     10
#define	AR1     11
#define	AR2     12
#define	AR3	13
#define	AR4	14
#define	AR5	15
#define	AR6	16
#define	AR7	17
#define	SP	17
#define	RPS	18
#define	PC	19

/* as defined for vax */
#define PS	RPS

/*
 * Location of the users' stored
 * floating point registers (float card and mc68881).
 *
 * FERRBIT is the float card errbit register.
 * FSTATUS is the float card status register.
 * FR0-FR7 are the float card floating point registers.
 * Usage is u.u_pcb.pcb_float[XX].
 *
 * FMC68881_C is the mc68881 control register (32 bit).
 * FMC68881_S is the mc68881 status register (32 bit).
 * FMC68881_I is the mc68881 instruction address register (32 bit).
 * FMC68881_R0-FMC68881_R7 are the mc68881 floating point registers (96 bit).
 * Usage is u.u_pcb.pcb_mc68881[XX].
 * Note that the MC68881 float registers are 96 bits wide (12 bytes).
 */

#define FERRBIT	0
#define FSTATUS	1
#define FR0	2
#define FR1	3
#define FR2	4
#define FR3	5
#define FR4	6
#define FR5	7
#define FR6	8
#define FR7	9

#define FMC68881_C 	46
#define FMC68881_S	47
#define FMC68881_I	48
#define FMC68881_R0	49
#define FMC68881_R1	52
#define FMC68881_R2	55
#define FMC68881_R3	58
#define FMC68881_R4	61
#define FMC68881_R5	64
#define FMC68881_R6	67
#define FMC68881_R7	70
