/* HPUX_ID: @(#)pte.h	27.4.1.3		85/11/05 */
#ifndef MMU_BASE

/* UMM/WOPR cpu board register addresses */

#define MMU_BASE    0x5F4000
#define SSEGPTR     (MMU_BASE +0x00)
#define USEGPTR     (MMU_BASE +0x04)
#define PTLB        (MMU_BASE +0x08)
#define TLBSELP     (MMU_BASE +0x08)
#define MMU_CONTROL (MMU_BASE +0x0c)

/* UMM/WOPR status and control register bits */
#define MMU_UMEN     0x0001
#define MMU_SMEN     0x0002
#define MMU_CEN      0x0004
#define MMU_BERR     0x0008

/* WOPR only status bits */
#define MMU_IEN      0x0020
#define MMU_FPE      0x0040
#define MMU_WPF      0x2000
#define MMU_PF       0x4000
#define MMU_PTF      0x8000

/* defines for fill on demand page table entries */


#define	PG_FZERO	1	
#define	PG_FTEXT	2	
#define	PG_FMAX		(PG_FTEXT)


/* generic pte related macros */

#define	dirty(pte)	((pte)->pg_fod == 0 && (pte)->pg_pfnum && \
			    ((pte)->pg_m || (pte)->pg_swapm))

#define PURGE_TLB	{ asm("	move.l 0x5F4008,d0"); \
			  asm("	addq.l	#1,d0"); };



#define	LPTESIZE	2		/* log2(sizeof(struct pte)) */
#define UMSG_SHIFT   	19

/*
 *
 * There are two major kinds of pte's: those which have ever existed (and are
 * thus either now in core or on the swap device), and those which have
 * never existed, but which will be filled on demand at first reference.
 * There is a structure describing each.  There is also an ancillary
 * structure used in page clustering.
 */

#ifdef	WOPR

/* WOPR segment table entry */

struct ste
{
unsigned int	sg_pfnum:20,		/* page table frame number */
		:8,			/* reserved at 0 */
		:1,			/* reserved at 1 */
		sg_prot:1,		/* write protect bit */
		sg_v:2			/* valid bits */
};

/* WOPR page table entry */
struct pte
{
unsigned int	pg_pfnum:20,		/* page frame number or 0 */
		pg_fod:1,		/* is fill on demand (=0) */
		pg_acc:1,		/* accessable page */
		pg_swapm:1,		/* have to write back to swap */
		pg_we:1,		/* write protect simulation bit */
		:1,			/* reserved for gateways */
		pg_ci:1,		/* cache inhibit bit */
		:1,			/* reserved at zero */
		pg_m:1,			/* hardware modified (dirty) bit */
		pg_ref:1,		/* hardware reference bit */
		pg_prot:1,		/* write protect bit */
		pg_v:2			/* valid bit */
};


/* Other representations of the pte when the valid bits are off */

struct hpte
{
unsigned int	pg_pfnum:20,
		pg_high:9,		/* special for clustering */
		:1,			/* unused bit */
		:2			/* valid bits -- must be zero */
};

struct fpte
{
unsigned int	pg_blkno:20,		/* file system block number */
		pg_fod:1,		/* is fill on demand (=1) */
		pg_acc:1,		/* accessable page */
		pg_swapm:1,		/* have to write back to swap */
		pg_rw:1,		/* write protect simulation bit */
		:1,			/* gateway */	
		:1,			/* cache inhibit */
		pg_fileno:3,		/* file mapped from or TEXT or ZERO */
		:1,
		pg_v:2
};


/* fields in the 68020 instruction cache control register */
#define IC_CLR       0x0008	/* clear entire cache */
#define IC_CE        0x0004	/* clear cache entry  */
#define IC_FREEZE    0x0002	/* freeze cache       */
#define IC_ENABLE    0x0001	/* enable cache       */

/* Various defines dealing with segment table entries */
#define SG_V		0x00000002	/* ste valid bit */
#define	SG_PROT		0x00000004	/* mask for write protect bit */
#define SG_RO		0x00000004	/* ste write protect */
#define SG_RW		0x00000000	/* ste read/write */
#define	SG_FRAME	0xfffff000
#define SG_IMASK	0xffc00000	/* mask for segment index field */
#define SG_PMASK	0x003ff000	/* mask for ste page index field */
#define SG_ISHIFT	22		/* shift for segment index field */
#define SG_PSHIFT	12		/* shift for segment page field */

/* Various defines dealing with page table entries */
#define	PG_V		0x00000001
#define	PG_PROT		0x00000004	/* mask for write protect bit */
#define	PG_WE		0x00000100	/* mask for write protect simulation bit */
#define	PG_NOACC	0x00000000
#define	PG_ACC		0x00000400	/* used by the fault handler  */
#define	PG_RO		0x00000004
#define	PG_RW		0x00000000
#define	PG_M		0x00000010
#define	PG_FOD		0x00000800
#define	PG_FRAME	0xfffff000
#define	PG_CI		0x00000040
#define	PG_PFNUM(x)	(((x) & PG_FRAME) >> PGSHIFT)
#define	PG_INCR		0x00001000
#define INVALID		0x00000000
#define PURGE_ICACHE	purge_icache();

#define	SZPT	1024	/* maximum number of page tables per process */

#else UMM

/*
 *
 * There are two major kinds of pte's: those which have ever existed (and are
 * thus either now in core or on the swap device), and those which have
 * never existed, but which will be filled on demand at first reference.
 * There is a structure describing each.  There is also an ancillary
 * structure used in page clustering.
 */

struct pte
{
unsigned int	pg_v:1,			/* valid bit */
		pg_prot:4,		/* access control */
		pg_m:1,			/* hardware maintained modified bit */
		pg_fod:1,		/* is fill on demand (=0) */
		pg_swapm:1,		/* have to write back to swap */
		pg_vreadm:1,		/* modified since vread (or with _m) */
		:2,
		pg_pfnum:21;		/* core page frame number or 0 */
};
struct hpte
{
unsigned int	pg_high:9,		/* special for clustering */
		:2,
		pg_pfnum:21;
};
struct fpte
{
unsigned int	pg_v:1,
		pg_prot:4,
		:1,
		pg_fod:1,		/* is fill on demand (=1) */
		pg_fileno:3,		/* file mapped from or TEXT or ZERO */
		:2,			/* unused */
		pg_blkno:20;		/* file system block number */
};

/* page table entry defines */
#define	PG_V		0x80000000
#define	PG_PROT		0x78000000
#define	PG_M		0x04000000
#define	PG_FOD		0x02000000
#define	PG_VREADM	0x00800000
#define	PG_PFNUM	0x001fffff

/* page table entry protection defines */
#define	PG_NOACC	0
#define	PG_KW		0x10000000
#define	PG_KR		0x18000000
#define	PG_UW		0x20000000
#define	PG_URKW		0x70000000
#define	PG_URKR		0x78000000


/* UMM related constants and macros */

#define INVALID    (0x5FC000>>10)

/* umm segment access capability */
#define SG_SYSRO    0x0000
#define SG_SYSRW    0x4000
#define SG_UROSRW   0x8000
#define SG_URWSRW   0xC000         /* user read/write, sys read/write 
				      the only mode currently used   */
#define SG_PROTMASK 0xC000
#define SG_SHFT         19         /* 2**19   */

/* page access capability    */
#define UMPG_WE     0x8000   /* write enable bit */
#define UMPG_WD     0x0000   /* write disable    */
#define UMPG_REF    0x4000   /* umm reference bit */

#define UMSH 2            /* ratio of umm ptes / shadow pte */

/* the following shifts and masks assume a 24 bit address */

#define NBUMPG       1024 
#define UMPGSHFT     10   /* 1k=1024=2**10 */

#define UMSG_STES    32   /* number of segments per segment table (1k pages) */
#define NSEGS	     (UMSG_STES/UMSH) /* number of segments per segment table (2k pages) */
#define UMSZPT	     (UMSG_STES)	/* max number of umm page tables (segments) */
#define SZPT	     (UMSG_STES/UMSH)	/* max number of page tables (segments) */

#define UMSG_IMASK   0x1F
#define UMPG_IMASK   0x1FF
#define UM_PPMASK    0x3FFF   /* umm physical page mask  */

#define UMSG_OFFSET  480  /* offset into segment table where
			     segment 0 starts. */

#define UMPTESIZE    2    /* 2 bytes */
#define LUMPTESIZE   1    /* log2 of UMPTESIZE */
#define UMPG_PTES    (NBUMPG/UMPTESIZE)  /* umm entries in an umm page */

/* bytes to umm pages */
#define btoumc(x) (((unsigned) (x)+(1<<UMPGSHFT)-1)>>UMPGSHFT)
#define btoumct(x) ((unsigned) (x)>>UMPGSHFT)
#define umstob(x)  ((unsigned) (x)<<SG_SHFT)     /* umm segment to bytes */
#define btoums(x)  (((unsigned)(x)+(1<<SG_SHFT)-1)>>SG_SHFT)
#define btoumst(x) ((unsigned) (x)>>SG_SHFT)
#endif else UMM

#endif
