/* HPUX_ID: @(#)param.h	27.5     85/06/28  */

/*
 * Machine dependent constants
 */
#define	NBPG_M320	4096		/* bytes/page */
#define	PGOFSET_M320	(NBPG-1)	/* byte offset into page */
#define	PGSHIFT_M320	12		/* LOG2(NBPG) */

#define	NBPG_WOPR	NBPG_M320
#define	PGOFSET_WOPR	PGOFSET_M320
#define	PGSHIFT_WOPR	PGSHIFT_M320

#define	NBPG_UMM	2048		/* bytes/page */
#define	PGOFSET_UMM	(NBPG-1)	/* byte offset into page */
#define	PGSHIFT_UMM	11		/* LOG2(NBPG) */

/* The following are only defined if either UMM or WOPR is defined */
#ifdef	WOPR
#define	NBPG	NBPG_M320		/* bytes/page */
#define	PGOFSET	PGOFSET_M320		/* byte offset into page */
#define	PGSHIFT	PGSHIFT_M320		/* LOG2(NBPG) */
#endif	WOPR

#ifdef	UMM
#define	NBPG	NBPG_UMM		/* bytes/page */
#define	PGOFSET	PGOFSET_UMM		/* byte offset into page */
#define	PGSHIFT	PGSHIFT_UMM		/* LOG2(NBPG) */
#endif	UMM

#define	CLSIZE		1
#define	CLSIZELOG2	0

/*
 * Some macros for units conversion
 */
/* Core clicks (??? bytes) to segments and vice versa */
#define	ctos(x)	(x)
#define	stoc(x)	(x)

/* Core clicks to disk blocks */
#define	ctod(x)	(x<<(PGSHIFT- DEV_BSHIFT))
#define	dtoc(x)	(x>>(PGSHIFT- DEV_BSHIFT))         /* truncated conversion only */
#define	dtob(x)	((x)<<DEV_BSHIFT)       

/* clicks to bytes */
#define	ctob(x)	((x)<<PGSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((unsigned)(x)+(NBPG -1))>>PGSHIFT)

/* pages to clicks */
#define	ptoc(x)	(((x)+CLSIZE-1) >> CLSIZELOG2)

/* page count to physical page frame number */
#define	pctopfn(x)	((x) + physmembase)

/*
 * Macros to decode processor status word.
 */
#define	USERMODE(ps)	(((ps) & PS_S) == 0)  /*check for user mode */
#define	BASEPRI(ps)	(((ps) & PS_IPL) == 0)   /*check for int level 0 */

#define	DELAY(n)	{ register int N = (n); while (--N > 0); }

