/* @(#)  HP Windows/9000  fonticon.h  39.1  11/15/85  16:35:25 */

/*
 * HP Windows/9000 definitions related to font and icon/sprite files.
 */

#define	FMAGICNUM (0x4da7eee8)		/* header for all file types */


/*
 * FORMAT OF ICON OR SPRITE FILE:
 */

struct iconstruct
{
	unsigned int	magic;		/* magic number for image files	*/
	int		header_length;  /* offset to mask from start of file */
	unsigned char	version;	/* version number for this file	*/
	unsigned char	filetype;	/* 0=font, 1=sprite, 2=icon	*/
	unsigned char	width;		/* image width,  pixels (1-127)	*/
	unsigned char	height;		/* image height, pixels (1-127)	*/

	/* icon/sprite-specific information */

	int		mbytes;		/* number of bytes in mask	*/
	int		ibytes;		/* number of bytes in image	*/
	unsigned char	idepth;		/* image bytes/pixel; 0 = 1 bit/pixel */
	char		hotx;		/* sprite X hotspot		*/
	char		hoty;		/* sprite Y hotspot		*/
	char		unused;		/* padding			*/
	/* unsigned char mask[mbytes]	/* mask definition, 1 bit/pixel	*/
	/* unsigned char image[ibytes]	/* image definition		*/
};


/*
 * FORMAT OF FONT FILE:
 *
 * The structure varies somewhat (see below) if the font is a 16-bit
 * character set instead of the usual 8-bit character set.  It also varies
 * if the font is proportional instead of uniform spacing.
 *
 * 16-bit character sets are indexed by two separate operations.  The first
 * byte of a 16-bit character is used as an index into the index1 table,
 * which tells which of the index2 tables to use for the second byte.  Then
 * index2 tells which of the bitmaps defines the character image.  This
 * data structure saves space because the Kanji character set is defined
 * in terms of 256-character blocks, some of which may not exist.
 */

struct fontstruct
{
	unsigned int	magic;		/* magic number for image files	*/
	int		header_length;  /* offset to mask from start of file */
	unsigned char	version;	/* version number for this file	*/
	unsigned char	filetype;	/* 0=font, 1=sprite, 2=icon	*/
	unsigned char	width;		/* image width,  pixels (1-127)	*/
	unsigned char	height;		/* image height, pixels (1-127)	*/

	/* font-specific information */

	unsigned short	num_images;	/* number of images defined	*/
	short	image_bytes;		/* number of bytes per image	*/
	unsigned char	depth;		/* bytes/pixel; 0 = bit/pixel	*/
	unsigned char	optimize;	/* 0 = don't, 1 = optimize on load */
	unsigned char	kanjitables;	/* 0: 8 bit file; otherwise the number
					   of INDEX2 tables contained.	*/
	unsigned char	pixelformat;	/* 0 = square, 1 = rectangular	*/
	char	symbol_char;		/* the escapecode symbolset character
					   (e.g.: the "U" from 8U)	*/
	unsigned char	cursorval;      /* cursor value (0-255)		*/
	char	unused2;		/* reserved for expansion	*/
	char	unused3;		/* reserved for expansion	*/

	struct escapecodes	/* all pitches/heights assume 80 pixels/inch */
	{
	    int symbol_int;	/* escapecode number (e.g: 8 from "8U")	*/

	    int typeface;	/* 0 = default  1 = pica      2 = elite    */
				/* 3 = courier  4 = helvetic  5 = roman    */
				/* 6 = gothic   7 = script    8 = prestige */
				/* 9 = ocr A   10 = ocr B		   */

	    int proportional;	/* 0 = uniform  1 = proportional font	*/
	    int hpitch;		/* horizontal pitch			*/
	    int vheight;	/* height				*/
	    int style;		/*  0 = upright   1 = italic		*/
	    int boldness;	/* -7 = lightest  7 = darkest		*/

	    int quality;	/* 0 = data processing
				   1 = near letter quality
				   2 = correspondance quality	*/

	    int unused4;	/* reserved for expansion		*/

	} escapecodes;

	char	descender;	/* reference point for descenders	*/
	char	baseline;	/* reference point for baseline		*/
	char	lowercase;	/* reference point for lowercase top	*/
	char	uppercase;	/* reference point for uppercase top	*/

	/*
	 * The following tables are aligned on word boundaries.
	 *
	 * 8-bit file:  index to bitmap defining each ASCII image.
	 * 16-bit file: index to table for defining second byte;
	 * 0 means this entry is invalid (no table exists).
	 */

	unsigned char index1 [256];

	/*
	 * The next entry exists only for 16-bit font files (n = 0 for 8-bit
	 * files).  One table exists for each line defined in index1.  Each
	 * entry is the index into the image's bit-map to define the character.
	 */

        /* short index2 [n] [256]; */

	/*
	 * For uniformly-spaced fonts, each image consists of the raster lines
	 * only; each raster line begins on a byte boundary.  Proportional-
	 * spaced fonts are similar, but have four bytes of prefix per image:
	 *
	 *	char	width;		(-128..+127)
	 *	char	height;		(-128..+127)
	 *	char	x_advance;	(-128..+127)
	 *	char	y_advance;	(-128..+127)
	 *
	 * (The meaning of negative width and height is debatable.)
	 */

	/* char images [m] [n];	  /* m = number of images; n = bytes/image */
};
