/* HPUX_ID:  @(#)errnet.h	27.2    85/07/15  */
/****************************************************************************/
/**                                                                        **/
/**           /usr/include/errnet.h               #include <errnet.h>      **/
/**                                                                        **/
/****************************************************************************/
/**                                                                        **/
/**   These are all the possible values for the variable errnet.           **/
/**                                                                        **/
/**   'errnet' is reached by saying                                        **/
/**                     extern int errnet;                                 **/
/**                                                                        **/
/**   'errnet' is only defined when errno == ENET.  ENET is defined        **/
/**   in the file #include <errno.h>.                                      **/
/**                                                                        **/
/****************************************************************************/

#define NE_INTERNAL     256	/*   Network internal error		*/
#define NE_NETSTATE     257	/*   Network is in wrong state		*/
#define NE_HARDWARE     259	/*   Network hardware failure		*/
#define NE_TIMEOUT      261	/*   Network timeout			*/
#define NE_PROTOVIOL    262	/*   Network protocol violation		*/
#define NE_NOSERV       263	/*   Network cannot provide service	*/
#define NE_NOREMOTE     264	/*   Network cannot find remote		*/
#define NE_CONNLOST     265	/*   Network connection aborted		*/
#define NE_NOCONNECT    266	/*   Network has no connection		*/
#define NE_RSRCREM      271	/*   Network remote out of resources	*/
#define NE_NOLOGIN      272	/*   Network login denied		*/
#define NE_NOUSERS      273	/*   Network over user limit		*/
#define NE_DUPNAME      300	/*   Network name duplicated		*/
#define NE_NONAME       301	/*   Network name not found		*/
#define NE_SOCKDIED     302	/*   Network socket died		*/
#define NE_CANTNAME     303	/*   Network cannot name socket		*/
#define NE_CONNPEND     304	/*   Network connection pending		*/
#define NE_DONTOWN      305	/*   Network ownership wrong		*/
#define NE_NONBLOCK     306	/*   Network not allowed to block	*/
#define NE_BADPROG      350	/*   Network cannot start program	*/
