.H 1 "Compiler Testing"

.SP
.H 2 "Compilers to Test"
.SP
Both of the compilers shipped with PaWS (COMPILER and COMP20) will
be tested across the compiler test suite using the 362, 382 and 385
SPUs as test machines.
.SP
.H 2 "Hardware to Test"
.SP
The main purpose of the 3.25 release is new hardware support.
Since the compiler source has not changed since 3.23 the testing
will be limited to this new hardware.
.P
.H 2 "Compiler Directives"
.SP
The compiler directives RANGE, OVFLCHECK, FLOAT_HDW, PARTIAL_EVAL,
and STACKCHECK could be varied for the purpose of compiler testing.
The standard variation for the standard compiler (default values) are
RANGE ON, OVFLCHECK ON, FLOAT_HDW OFF, PARTIAL_EVAL OFF, and
STACKCHECK ON.
.SP
These are the same for the COMPILE20 compiler except
FLOAT_HDW ON is the default value here.
.SP
The different variations are controlled for testing purposes by
recompiling the compiler with the desired variation treated as
the default.
.SP
With the standard compiler, FLOAT_HDW ON instructs the compiler to
generate accesses to a 98635 for certain floating point operations.
If this H/W is not installed, an error will be reported when the
program is executed.
.SP
FLOAT_HDW OFF instructs the standard compiler to generate math
library calls for floating point operations.
.SP
FLOAT_HDW TEST instructs the standard compiler to generate both
H/W (98635) accesses and library calls. The code includes tests
for the presence of a 98635. If the H/W is present at run time
the H/W accesses are used, otherwise the library calls are used.
.SP
FLOAT_HDW ON causes COMPILE20 to generate accesses to a 68882 co-
processor. For the 68040 some of these instructions are emulated
in software.
.SP
FLOAT_HDW OFF causes COMPILE20 to generate calls to library routines
for floating point operations.
.SP
FLOAT_HDW TEST is not allowed with COMPILE20.
.SP
The other compiler directives are pretty much self explanatory.

.H 2 "Compiler Test Matrix"
.SP
There are actually two matrices, one for the standard compiler
(COMPILER)
and one for the 68020 compiler (COMPILE20).

.SP
.H 3 "Standard Compiler Test Matrix"
.SP
The standard compiler should generate correct code for all
680xx based workstations. The standard compiler test matrix
consists of all the hardware configurations and variations
of the compiler directives listed above.

.DS 0 0 0
      H/W   Std  FLT_ON  FLT_TEST RANGE_OFF OVFL_OFF PART_ON STACK_OFF
     -----  ---  ------  -------- --------- -------- ------- ---------

  1.) 385   YES   SOME      NO      YES         NO     NO       YES 

  2.) 382   YES   SOME      NO       NO        YES     NO        NO

  3.) 362   YES   SOME     YES       NO         NO    YES        NO

  SOME - Indicates a directive/SPU combination exercising H/W not
	 supported. Such testing is for graceful failure only and
	 need not involve the entire test suite.
.DE

.SP
.H 3 "COMPILE20 Compiler Test Matrix"
.SP
COMPILE20 should generate correct code for 68020, 68030 and 68040
based workstations.

.DS 0 0 0
      H/W   Std  FLT_OFF RANGE_OFF OVFL_OFF PART_ON STACK_OFF
     -----  ---  ------- --------- -------- ------- ---------

  1.) 385   YES     NO       NO       YES      NO       NO 

  2.) 382   YES    YES       NO        NO     YES       NO

  3.) 362   YES     NO      YES        NO      NO      YES 

.DE
.P
Each H/W configuration with a 'YES' marked in the matrix requires
2 MTS hours (50 %) or 3 MTS hours (90 %) of setup time (moving
H/W, etc.).
.P
There are 3 H/W configurations to
be tested, for a total of 6 hours setup time (50 %) or 9 hours
(90 %) setup time. 
.P
In addition, each test requires about 1 hour for result
interpretation. 
.P
Total MTS time is estimated to be 3 days (50 %) and 4 days (90 %)
for compiler testing.
.P
This time estimate represents MTS time and NOT the total
time required for the actual tests to run. Actual running time
is estimated to be 12 hours per each 'YES' test configuration,
for a total running time of 192 QA hours (50 and 90 %). This
time estimate should not appear in the PERT chart but it should
be counted as QA time for metrics purposes.
.P
Defect repair for the compiler is estimated at 0 hours (50 %) and
24 hours (90 %).

.H 2 "Summary"
.P
The total estimate of effort for 3.25 compiler testing is :
.NF
.SP
        50                90
    3 mts days        4 mts days     test execution
    0 mts days        3 mts days     defect repair             

    3 mts days        7 mts days     TOTAL
.FI
