.SA 1
.H 1 "68040 Investigation Report"
.SP
.P
This document will describe major features possessed by the 68040
processor and the changes needed within the PaWS
O/S to support Hewlett Packard 68040 based workstations. 
Estimates will be made for the effort required to complete the
investigation and design (I/D) and
the implementation and test (I/T) phases of this project.  This
description is based upon everything known as of August, 1989.
As such this document will be modified, if necessary, as more
information becomes available.
.SP
.H 2 "Internal Use Only"
.P
This  document contains Hewlett-Packard and MOTOROLA
proprietary information, and is for use within the
Pascal Workstation group only. PLEASE DO NOT COPY
THIS DOCUMENT.
.P
.H 2 "68040 Features"
.P
.P
.H 3 "General Remarks"
.P
The MC68040 processor may be available in-house around the middle
of October. Prototype Summit-40 workstations might be available as early
as December. Our goal is to have a version of PaWS ready to come up
on the first Summit prototype as early as the prototype is available.
.SP
.H 3 "Stack Frames"
.P
The format for some of the stack frames will change for the
68040. This will cause the bus error handling within the
debugger to change. Changes may be required elsewhere,
but an investigation is required to be sure about this.
.SP
.H 3 "Floating Point Processing"
.P
The most noticeable difference of the 68040 relative to
68020/68030 processors is the lack of support for a
floating point co-processor. It is Motorola's intention,
however, to provide full user compatibility with the 68881/68882
instruction set. This will be accomplished by way of the 
following scheme.
.P
Some of the 68881/68882 instructions will be supported 
with all the previously supported data types in H/W
directly on the 68040 processor. Other 68881/68882 instructions will
generate an F-line trap with special stack frames. Motorola
will provide special emulation S/W for each of these
instructions that can be branched to from the exception
vector table and executed to simulate the effect of the
co-processor instruction causing the exception.
.P
Some of the instructions will be supported in H/W but
not for all of the previously supported data types. In
particular, the packed decimal real data type 
when used with some instructions will cause an
unimplemented data type exception. Again, Motorola will
provide emulation S/W which can be branched to to carry
out a conversion. The instruction will resume with the
converted data upon return from exception.
.SP
.H 3 "New Instructions"
.P
Three new instructions are available on the 68040. The
instruction MOVE16 will move 16 consecutive bytes of
data in memory. Privileged instructions CINV and CPUSH
invalidate cache lines. Our assembler will have to
be enhanced to support these. 
.P
In addition, new versions of some of the 68881/68882
instructions are available that explicitly force
single or double precision rounding. The assembler
will have to be modified to support these new versions
of the those instructions as well.
.SP
.H 3 "Dropped Instructions"
.P
A good many of the generic co-processor instructions were
dropped (with no co-processor they don't make any sense).
PLOAD and PMOVE are being replaced by PTEST and MOVEC.
The assembler won't need enhancing, but we need to make
sure that none of these instructions being dropped were
used in the PaWS O/S. Since they are privileged instructions
these changes should be invisible from the user point
of view.
.SP
.H 2 "Outline of Tasks"
.P
As of August, 1989 I have identified the following specific
tasks which need to be performed to carry out this project :
.P
.nf
      1.) Modify the exception vector table to include the
          unimplemented floating point operation and data
          type traps

      2.) Receive the emulation code from Motorola for the
          unimplemented floating point operations and data
          types, and

          a.) Modify (port) this code so it is suitable for
              input to the PaWS assembler
          b.) Make sure that the error handling this code
              employs is compatible with PaWS
          c.) Figure where and when this code will be loaded
              by PaWS
          d.) Develop a testing scheme for each of these 
              opcode and data type emulations

      3.) Enhance the assembler to handle the new instructions
          and the new versions of some of the floating point
          instructions

      4.) Compare the new stack frame format with the old
          to see if PaWS is impacted (Note - we can be sure
          that the Debugger is impacted. This investigation
          will examine PaWS as a whole)

      5.) Make sure our current cache control conventions
          will work on the 68040 - modify where needed

      6.) Turn the system

.fi
.SP
.H 2 "Estimate of Tasks"
.P
This section will attempt to generate 50% and 90% numbers
for each of the tasks identified in the previous section.
.SP
.H 3 "Warning, Disclaimer Etc."
.P
These estimates are based on what was known as of August,
1989. This document ,especially the estimates, may have
to change as more detailed information becomes available.
.P
All times given refer to 1 MTS, e.g. a time of '5 days'
refers to '5 MTS days'.
.SP
.H 3 "Exception Vector Table Modification"
.SP
.nf
     Estimate :

     Modify exception vector table 

     I/D : 1 days ( 50% ),  2 days ( 90% )
     I/T : 1 days ( 50% ),  2 days ( 90% ) 

.fi
.SP
.H 3 "Motorola Emulation Code Incorporation"
.SP
.P
This is broken down by sub-task.
.SP
.H 4 "Port the Emulation Code"
.SP
.P
As of August, 1989 the emulation code is known to consist
of some 5200 lines of assembly code. This code has been
received from Motorola and is available for incorporation
into PaWS.
.nf
     Estimate :

     Port the emulation code to PaWS

     I/D : 4 days ( 50% ),  7 days ( 90% )
     I/T : 5 days ( 50% ),  8 days ( 90% ) 

.fi
.SP
.H 4 "Verify Error Handling, Other Conventions"
.SP
.P
I don't think this amounts to much, but it has to
be done.
.SP
.nf
     Estimate :

     Verify Error Handling, Etc.

     I/D : 1 days ( 50% ),  1 days ( 90% )
     I/T : 1 days ( 50% ),  1 days ( 90% ) 

.fi
.SP
.H 4 "Emulation Code Management"
.SP
.P
Same comments as previous task.
.SP
.nf
     Estimate :

     Load and Manage the Emulation Code

     I/D : 1 days ( 50% ),  2 days ( 90% )
     I/T : 1 days ( 50% ),  2 days ( 90% ) 
.fi
.SP
.H 4 "Emulation Code Testing"
.SP
.P
A testing scheme will have to be devised and carried out
that will exercise all the emulation code.
.SP
.nf
     Estimate :

     Test the Emulation Code

     I/D : 4 days ( 50% ),  8 days ( 90% )
     I/T : 4 days ( 50% ),  8 days ( 90% ) 
.fi
.SP
.H 3 "Enhance the Assembler"
.SP
.P
This shouldn't be too bad (only 3 new opcodes to support),
but it does involve re-turning
the assembler and running it against the assembler test
suite.
.P
The task of discovering the modifications to be made is now
complete, they only have to be incorporated into the assembler.
.SP
.nf
     Estimate :

     Modify and Test the Assembler

     I/D : 1 days ( 50% ),  2 days ( 90% )
     I/T : 3 days ( 50% ),  5 days ( 90% ) 
.fi
.SP
.H 3 "Stack Frame Investigation"
.SP
.P
This involves finding the current usage of the stack frames,
and, for those frames that have changed, making sure that
information used within those frames has not changed
either in terms of offset or format.
.P
Any changes found will require corresponding changes in PaWS.
.P
The numbers here are a bit conservative as I've really not
much idea what this actually entails.
.SP
.nf
     Estimate :

     Check Out the Stack Frames

     I/D : 2 days ( 50% ),  4 days ( 90% )
     I/T : 2 days ( 50% ),  4 days ( 90% ) 
.fi
.SP
.H 3 "Cache Control"
.SP
.P
I don't think this is too bad. 
.SP
.nf
     Estimate :

     Cache Control Compatibility

     I/D : 1 days ( 50% ),  1 days ( 90% )
     I/T : 1 days ( 50% ),  1 days ( 90% ) 
.fi
.SP
.H 2 "Summary - Estimate of Effort - PaWS on 68040"
.SP
.P
This section sums all the previous sections.
.SP
.nf
     Estimate :

     Total Effort Required - PaWS onto 68040

     I/D : 15 days ( 50% ),  27 days ( 90% )
     I/T : 18 days ( 50% ),  31 days ( 90% ) 
          ----------------------------------
           33 days ( 50% ),  58 days ( 90% )
.fi
.SP
.H 2 "Concluding Remarks"
.SP
.P
I believe the 50% numbers are realistic, and that the 90% numbers
would be accurate only if there turns out to be undo difficulty
in porting the Motorola emulation code.
