<front>
<title> Read Me Before Installing or Updating Pascal
<hardware> HP 9000 Series 200/300
<partno> 98617-90604
<printdate> March 1991
<edition> E0590
<copyright> Hewlett-Packard makes no warranty of any kind with 
regard to this material, including, but not limited to, the 
implied warranties of merchantability and fitness for a 
particular purpose. Hewlett-Packard shall not be 
liable for errors contained herein or for incidental or 
consequential damages in connection with the furnishing, 
performance, or use of this material.

Hewlett-Packard assumes no responsibility for the 
use or reliability of its software on equipment that is 
not furnished by Hewlett-Packard.

This document contains proprietary information which is 
protected by copyright.  All rights are reserved. No part 
of this document may be photocopied, reproduced, or 
translated to another language without the prior 
written consent of Hewlett-Packard Company. The information 
in this document is subject to change without notice.

&copy Hewlett-Packard Company 1989, 1991. All rights are reserved.

<chapter>Read Me Before Installing\or Updating Pascal
<s1>Pascal 3.24

This release adds support for the 25 Mhz MC68040 Model 380 SPU,
and also the HP-UX SRM/UX server.

<s2>New Hardware

<list>
* SPU Model 380 (25 Mhz MC68040 processor)
<\list>

<newpage>
<s2>New Peripherals

<list>
* Plotter Model 7550B in 7550A emulation mode only.

<\list>

<s2>Object Code Compatibility

Pascal 3.24 is generally upward code compatible from other 3.2!!x!!
systems. Programs compiled with the 3.2, 3.21, 3.22, or 3.23 systems
should run on 3.24 with no recompilation required.  Note that this may
not apply if the application contains linked in system modules or contains 
self-modifying code. Also, when executing floating point instructions
on the 380 SPU, there may be some differences in speed and accuracy of
computed results as compared to the MC68881 or MC68882 floating point
co-processor. See the section below on floating point processing for
more details.

<s2>Software Changes

<list>
* The SRM module now works with SRM/UX as well as SRM servers.

* A floating point emulation module (FP40) has been provided to
emulate the MC68881/MC68882 floating point instructions not
directly supported on the MC68040 processor. This package, together
with the MC68040 processor itself, provides upward compatibility
for programs compiled or assembled to run on series 300 SPU's
with either the MC68881 or MC68882 co-processor.

* The FILER has been enhanced to work with SRM/UX volumes.
     
<\list>

<newpage>
<s2>System Discs

The following changes were made:

<lablist width=4cm>
\Single-sided discs:\
A new floppy disc BOOT3: was created. This disc is for use with
SPU's using the 98700 graphics controller only (for all
other machines, BOOT: and BOOT2: discs are used exactly as before).

FP40 was added to the LIB: disc. This file contains the
floating point emulation module.

COPY_ON.TEXT and COPY_OFF.TEXT were added to the DOC: disc.
    
\Double-sided discs:\
FP40 was added to the SYSVOL: disc. This file contains the
floating point emulation module.
                         
COPY_ON.TEXT and COPY_OFF.TEXT were added to the DOC: disc.
<\lablist>

For more information on system discs, read the appendix "Pascal System
Components" in the <book|Pascal 3.2 User's Guide|.


<s2>Floating Point Processing

The following MC68881/MC68882 instructions are supported directly on the
MC68040 processor itself :

FABS
FADD
FBcc
FCMP
FDBcc
FDIV
FMOVE
FMOVEM
FMUL
FNEG
FNOP
FRESTORE
FSAVE
FScc
FSQRT
FSUB
FTRAPcc
FTST

The remaining MC68881/MC68882 instructions are supported by way of the
floating point emulation package, FP40. When using the Pascal Language
System on an MC68040 based series 300 workstation, the module FP40
should be executed before using code with any of the emulated opcodes.
Another way to install the package is to place the FP40 module in one's
INITLIB file.

<s3>Speed and Accuracy of Emulated Floating Point Instructions. 

The user may notice some differences in both speed and computational
accuracy with the emulated floating point instructions as compared
with the execution of these instructions on an MC68882/MC68881
coprocessor. Testing indicates the computational accuracy of the
package is very good, and any differences should only be seen at the
extreme levels of precision, however.

<newpage>
<\table>


