.PAGE
.H 1 "Centronics Investigation Report"
.H 2 "Protocol History"
.P
The Centronics Parallel interface was first developed by
Centronics Inc. in the late 1970s for use with its printers.
With the advent of the PC, the centronics parallel interface became
an industry standard.
.P
As originally designed, the centronics interface
was an output only interface,
that is, data could only flow from the host to the peripheral.
When HP introduced the ScanJet, it extended the Centronics interface
to be bidirectional, that is data could flow from the host to the
peripheral and from the peripheral to the host.
The ScanJet bidirectional centronics interface has become an 
industry standard for scanner products.
.P
When IBM introduced the PS/2 line that came with the new micro-channel
bus, it also introduced a bidirectional centronics interface.
As can be expected from IBM, this new protocol was not compatible with
the ScanJet protocol.
.P
To keep up with the PS/2 centronics interface products, the XT/AT PC
centronics interface was expanded to use an almost, but not quite,
PS/2 interface.
.P
.B
NOTE:
.R
In all of the bidirectional implementations, the output protocol (host
to peripheral) has
.ul
not
been changed.  It is the input protocols that
vary with each version.
.P
HP, recognizing the expanding products that use the PS/2 and XT/AT
centronics interfaces, has started defining the interface of HP PCs and
peripherals, called Advanced Functionality Parallel Port (AFPP).
Although released in a preliminary state, this definition has not been
completed, nor has it been accepted (nor is it guaranteed to be).
The AFPP
document defines in detail how HP product developers are to
implement the PS/2 and XT/AT centronics interface.
.H 2 "S300"
.P
Because of the growth in the number of peripherals using the centronics
interface (in one form or another), the SUMMIT project is planning on
including a centronics port as a standard feature on the Human Interface
card.  (SUMMIT is the new internal name for what used to be APEX-30).
.P
For the SUMMIT, a chip is being developed that will allow a driver to
use all of the aforementioned centronics protocols.
However, their is some prejudice.  For input operations, the chip
is intelligent about the ScanJet protocol and thus DMA can be used.
However, for the XT/AT and PS/2 protocols, the centronics bus lines
must be driven by the driver.  Therefore, the implementation for these
protocols will be slower and without DMA.
Output operations for all protocols can use DMA.
.P
There are currently no plans to provide centronics support with a
separate DIO or DIO-II card.
.H 2 "Centronics Company History"
I find it interesting that the company that invented the centronics
interface is now selling "baking pans, spatulas, can and bottle openers and
many other household products." ('New England Business', 1/4/88, p. 33, 34).
During the economic squeeze of the early 1980s, (also the Japanese are blamed),
Centronics Inc. lost $80 million.  Due to these loses and high debt, the
centronics printer business was sold to Genicom in 1987.
Centronics Inc. has since become "a basic houseware maker and marketer".
.H 1 "Centronics on PWS"
.P
The centronics parallel interface is a natural for the PWS I/O subsystem.
The only real difficulty will be in dealing with the multiple methods
of inputing data.
Incremental estimates will be provided (next section) for each interface.
.P
Because the chip has so much built in support for the ScanJet, it is
little extra effort to support ScanJet communications in the driver.
This does not mean that a ScanJet application is going to be provided.
That is an entirely different matter and is not addressed here.
.P
Because adding the XT/AT-PS/2 communication protocols to the driver
will require a great effort in both development and QA, it may be
necessary to eliminate that from the release.
If this turns out to be the case, the PWS user would have to be
able to take over the hardware in order to write his own driver.
.P
If the XT/AT-PS/2 communication protocols are supported within the
driver, it does not mean that an XT/AT-PS/2 application is going to
be provided.
That is an entirely different matter and is not addressed here.
.H 2 "I/O Subsystem"
.H 3 "Communication Modes"
.SP
.P
The centronics driver will have to be in a communication mode which
determines the protocol currently being used on the centronics bus.
This can be determined empirically or an application can
place the driver in a desired mode through the IOCONTROL procedure.
.P
If the driver supports the XT/AT-PS/2 protocols, the following modes
are required:
.AL 1 5 1
.LI
Output_Only
.LI
ScanJet (determined when device is reset).
.LI
XT/AT
.LI
PS/2
.LI
Possible_XT/AT_PS/2 (don't know until peripheral attempts to input).
.LI
Other
.LE
.P
If the driver only supports the ScanJet bidirectional protocol,
the following modes are required:
.AL 1 5 1
.LI
Output_Only
.LI
ScanJet (determined when device is reset).
.LI
Other
.LE
.P
The Other mode tells the driver to not do anything, instead an
outside application has taken over the hardware to implement an
unsupported mode.
Because output communications are identical for all modes,
a driver writer could use the Output_Only mode for output and then
switch to Other for input.
.H 3 "I/O Hooks"
.SP
.P
The centronics interface will require the following I/O hooks be implemented:
.VL 15 
.LI "iod_init"
Initialize the interface.
Reset the peripheral. Set communication mode.
.P
If the driver does not support the XT/AT_PS/2 communications
modes, iod_init will set the communication mode to ScanJet or
Output_Only, otherwise it will be ScanJet or Possible_XT/AT_PS/2.
.LI "iod_isr"
Centronics driver interrupt service routine.
Handles system interrupts for peripheral errors, bus turn arounds,
DMA complete, FIFO full/empty, or line transitions for the XT/AT_PS/2
interfaces.
.P
If XT/AT_PS/2 protocols are not supported,
then a way must be provided for the application writer to insert
his own ISR.
.LI "iod_rdb"
Read a single byte off of the centronics interface using the current
communication mode.
.LI "iod_wdb"
Write a single byte to the centronics interface.  (All output on the
centronics interface is the same, no matter the communication mode).
.LI "iod_rdw"
Read a word from the centronics interface.
The centronics interface is a byte wide, so this routine would simply
interface with iod_rdb.
.LI "iod_wtw"
Write a word to the centronics interface.
The centronics interface is a byte wide, so this routine would simply
interface with iod_wtb.
.LI "iod_rds"
Read a centronics driver status register.
The contents of the various status registers requires a full definition.
Currently, at least the communication mode would have to be present.
.LI "iod_wtc"
Write a centronics driver control register.
The contents of the various control registers requires a full definition.
Currently, at least the communication mode would have to be present.
.LI "iod_tfr"
Read/write a buffer from/to the centronics interface.  For output in
any communication mode, Programmatic, DMA, and Overlap would be provided.
For input, the ScanJet mode will provide Programmatic, DMA, and Overlap.
The XT/AT_PS/2 modes could not provide DMA or Overlap.
.P
The TRANSFER_END routine will not be supported.
.H 2 "Printer TM"
.P
The PWS Printer TM will require slight modifications to ensure the driver
is in Output_Only mode.
In addition, the printer application's channel initialization code
will have to be closely examined.
.H 2 "Tests"
Centronics tests will have to be written and added to the I/O test
subsystem.
In addition to standard I/O communications, a battery of printer tests
should be developed.
.H 2 "Documentation"
A new chapter will have to be added to the Procedure Library.
Following the lead of current chapters, the centronics chapter will
have to explain in detail the centronics protocols and interface registers.
.H 1 "Estimates"
.DS

					(Man Weeks)
.ul
	Description			50%	90%   

	Output & ScanJet Input
	   Development			2	3
	   QA (incl Test Plan		2	3
	       and development)

	XT/AT-PS/2 Input (in addition
        to above)
	   Development			1	2
	   QA (incl Test Plan		2	3
	       and development)

	Documentation			2	3

	Printer TM			1day    .5


From above, the following is extrapolated:

	Centronics, w/out XT/AT-PS/2	7	11.5
	Centronics, with XT/AT-PS/2	9	14.5
.DE
