.fi
.ce
.ul
PaintJet Support in PAWS 3.21
.SP
PAWS 3.21 will be the first version to support the PaintJet color graphics
printer.
.SP
PaintJet will be supported both with the least-common-denominator (LCD) printer
driver (primary-color alpha, and monochrome alpha and graphics dump), and
with a library which allows one to dump an image of a supported CRT 
in color.  There will be no color "dump" key, nor will any color dump
be supported in DGL directly.
.SP
.SP
Background
.SP
PAWS does not know what printer is connected to the SPU. It assumes that
a printer is there, and assumes it can understand lowest-level PCL. It makes
the assumption that the printer is monochrome. However the printer driver does
not try to interpret the outgoing data stream, so essentially any data can be
sent to the printer device.
.SP
This lack of knowledge of device type makes it impossible for us to choose
or vary printer driver operation to tune it to the printer, without MAJOR
development. The problem is complex, and any solution would ultimately 
be heuristic. We choose to solve it by defaulting to the LCD 
(Least-Common-Denominator) driver.
.SP
.SP
Characteristics of alpha operation
.SP
Control characters in the data stream will do any special control of the
printer functions. This is very similar to ThinkJet and QuietJet operation.
The user reads the printer manual to discover printer capabilities, and their
control character sequences, then inserts them in the data stream.
.SP
.nf
    eg. WRITELN(LISTING,'Hello '#27'&v1Sworld'#27'&v0S'); {untested code}
    prints 'Hello ' in black text, then 'world' in red, on one line

.fi
Unfortunately, this control language is different than that used for the
CRT driver, and the colors have different indices. The same effect 
(swapping white for black) on the CRT is achieved with:
.SP
.nf
    eg. WRITELN(LISTING,'Hello '#137'world'#136); {untested code}
    prints 'Hello ' in white text, then 'world' in red, on one line

.fi
There is no intent to attempt to have the OS match these up in either 
the printer or the alpha CRT driver. Application writers must account for the
difference, as is true for all other printers in all PAWS revs.
.SP
.SP
DGL Operation
.SP
DGL provides a procedure (output_esc) for doing many kinds of device dependent 
operations.
One use is to dump the current graphics screen (not DGL "window") to the system
printer. The procedure takes an "opcode" parameter, which tells it what 
operation to perform. This will not change. DGL will dump the screen in
monochrome, and the opcodes 52 and 54 will work in ways similar to how they
work on ThinkJet.
.SP
The DGL programmer will have to go outside DGL to get a PaintJet color
dump from his screen.  In the paintjet_dump routine, a select code
parameter of 6 will attempt to (but may not guarantee) dump the
"alternate" (non-console) CRT image to a PaintJet.  
.SP
.SP
Dump Operation
.SP
If pre-3.21 code which accesses a printer is run, operation will be 
indistinguishable from, for example, QuietJet operation. 
This provides a backwards compatible default.
.SP
Therefore, we will supply the existing (pre-3.21) LCD "dump key" driver in the 
INITLIB 
that we ship, and will make
available a new library on an auxiliary existing disc (ACCESS: for 
double-sided, or 
CONFIG: for single-sided). This library will form the only color dump support
for PaintJet. The programmer (and through his or her human
interface code in the application, possibly the application user) will be
charged with deciding whether he/she wants extra capability, and has the 
appropriate printer H/W, and what model of CRT contains the graphic. Once 
the decision is made, using the library
merely requires calling the color dump routine and providing the
correct parameters for the H/W configuration and desired rendering.
.SP
We will also provide source for this library to requesting developers, as it
is a very 
"hackable" piece of code, and does not require MODCAL for compilation. The 
sources will be
heavily commented, but we will not document modifying them in any of the
product manuals.
.SP
The library will only support dumps of color graphic Series 300 CRT images 
to a PaintJet printer, under
programmatic control.  It will NOT enable the DUMP GRAPHICS key for
color dump, nor will it affect the DUMP ALPHA key.  It will NOT turn
the PaintJet into a "virtual plotter"; that is, DGL can not specify a
PaintJet type to plot to, nor can any other graphics library
automatically know how to create rasters from vectors, polygons, text,
etc.
.SP
DUMP GRAPHICS and DUMP ALPHA will continue to dump any supported
screens (color, mono, etc) that can be CRT consoles, in mono to the
PaintJet, treating it as if it were a ThinkJet.
.SP
DGL output_esc dump will dump monochrome renderings to PaintJet much
as it does now for ThinkJet.
.SP
The library will contain 1 procedure to set up parameters and cause a
dump of the specified CRT to PaintJet.  It will have no other functions
or procedures.
.SP
.SP
.nf
Supported devices:			Unsupported Devices:
	hp98543A (lo-res color)			98627A (moonunit)
	hp98545A (mid-res color)		all Series 200 CRTs
	hp98547A (mid-res color)		98700A (GatorBox)
	hp98549A (mid-res color)		monochrome Bobcat
	hp98550A (hi-res color)			monochrome CATSEYE
.fi
.SP
.SP
Screen dump routine
.SP
Characteristics of screen dump library:
.SP
.nf
.ne 10
                     | LCD  DUMP G key |       library routine 
    Characteristic   |(comparison only)|    dither    |  error-dist
==================== | =============   | =============| ===========
pixel mapping across |     1:1         |     1:2      |    1:1   
pixel mapping down   |     1:1         |     1:2      |    1:1   
print rotation       |      0          | 0 or 90 deg  |  0 or 90 deg
color transform      |to mono (black)  | 2x2 cell appx|error distribution
speed                |printer speed    |<printer speed|< printer speed
                     |                 |              | 
.fi
.SP
The "pixel mapping" says how many printer pixels will be generated for
each screen pixel. The dither dump will expand each screen pixel to
a 2x2 cell, to increase color accuracy.
.SP
Note that LCD may "lose" some pixels from the right of the screen, as may
the unrotated library dumps, as the
screen has many pixels across. The library routines may lose pixels from the
bottom of the screen, if the screen is "deep", and may spread the dump across
more than one page.
.SP
The LCD dump screen driver treats PaintJet as a mono black 
dump device. The "dither" driver
is good for dumping color text, line drawings, etc with accurate pixel 
representations at the cost of color accuracy. It loses pixels to
the right even when rotated. The "error-dist" will dump 
filled 
areas, etc with reasonable color accuracy, at the possible expense of
lost pixels, blurriness, etc. It will not lose pixels to the right if the
dump is rotated. The user can choose what is best for him
or her by invoking the routine with the appropriate rendering parameter.
.SP
Interface:
.nf
module PaintJetDump_module;

import SYSGLOBALS;
export
 type 
	PJ_crt_type=(hp98543A, hp98545A, hp98547A,
		     hp98549A, hp98550A);
	
	orientation_type=(normal, rotated);

	rendering_type=(dither2x2, error_distributed);

 function paintjet_dump(sc: byte; crt: PJ_crt_type; 
			orientation: orientation_type; 
			rendering: rendering_type) : shortint;

implement

end.

.fi
Paintjet_dump will return 0 for success, or an error code (from
the file system errors).

.nf
Example:

	...
	err:= paintjet_dump(6, hp98547A, rotated, error_distributed);
	if err <> 0 then report_dump_error(err);
	...
.fi
Some difficulties for the programmer:
.SP
must specify crt select code (eg 3, 6, 28, etc)
.SP
must specify crt type (eg hp98547A). This may be the biggie!
.SP
not part of DGL
.SP
not available through dump key
.SP
will dump only to the volume PRINTER:
.SP
not very expandable interface (eg new crts, new printers)
.SP
not hooked (could link fail at application load time, if not
linked in to the application)
.SP
.nf
Proposed filename:
.nf
	PaintJet
.fi
.SP
No source is currently provided for the LCD driver. The oject for the LCD
driver
is contained in one of CRT/CRTB/CRTC/CRTD(/CRTE), depending on the CRT used.
