.fi
This document describes the early (3.21 pre-release) CATSEYE support 
pre-release of PAWS. It may have errors, as the software may have bugs and has
not undergone QA, though it has been tested reasonably well.
.SP
3 models of CATSEYE display are supported in the 3.21 pre-release (henceforth
called early3.21): 98548A (High Resolution Monochrome, HRM), 98549A (Low
Cost Color CATSEYE, LCC), and 98550A (High Resolution Color, HRC). HRC and
HRM are sometimes referred to collectively as HRx. (The 98549A is the display
board used in the model 319C+.)
.SP
Support for these 3 models is provided both for alpha display and for DGL
graphics. Support is based on support of the Topcat series of displays
(98542/3/4/5/7) or the GatorBox (98700), and is an extension or 
generalization of the support for these.
.SP
.SP
If you wish to make any response to this document, or about early3.21 in
general, please talk to the person from whom you received early3.21. That
person is responsible for getting information back to us.
.SP
.SP
.ul
Alpha support: 
.SP
Early3.21 works with the 320, 330 and 350 SPUs, with the 98548A, 98549A 
and 98550A display boards, as well as with the 319C+ SPU.
.SP
A new driver has been written to handle all 3 CATSEYE versions. 
A new driver is desirable 
because there are architectural, timing, and feature differences between
CATSEYE and its nearest relative, Topcat (Bobcat display driver hardware).
This new driver provides average 2X - 3X performance
increase in character writing speed over Topcat displays on the same CPU,
especially for dense text. This is due to a minor internal redesign of the 
driver, which is based on the CRTC driver, and also to inherent H/W speed
advantages over Topcat.
.SP
The new driver is called CRTE, and is supplied in the CRTE file 
on the early3.21 disc.
.SP
CRTE has similar functionality to CRTC, except it does not support
a flashing cursor. CATSEYE hardware does not support a flashing cursor.
As an experiment, soliciting feedback from early3.21 users, and for possible
inclusion in the 3.21 product release, the alpha cursor has been set up as
a full character cell inverse-video "blot". 
There are a lot of character positions on the screen (128*50 for HRx), and a 
non-flashing underline is very hard to see. We solicit your input on this
cursor design.
.SP
Early3.21 CRTE supports CATSEYE at control address $560000 in DIO I space (this
is an internal select code, not a "real" or external one), but not in DIO II
space. 
.SP
The driver provides capabilities/support as follows:
.SP
.nf
.ne 22
                   |                      Model
     Function      |     LCC        |      HRM        |       HRC 
================== | ============== | =============== | ================
Screenpix width    |     1024       |     1280        |      1280       
Screenpix height   |      768       |     1024        |      1024       
Width  (characters)|      128       |      128        |       128       
Height (lines)     |       48       |       51        |        51       
Print lines        |       47       |       50        |        50       
Scan lines used    |      752       |     1000        |      1000       
Font char width    |        8       |       10        |        10       
Font char height   |       16       |       20        |        20       
Typeahead length   |      119       |      119        |       119       
Background color   |    black       |    black        |     black       
Alpha color        |    white       |    white        |     white       
Language           |  based on kbd  |   based on kbd  |   based on kbd
Font style         |in graphics ROM | in graphics ROM | in graphics ROM
Number font chars  |  3 x 128       |  3 x 128        |   3 x 128       
Cursor style       |   "blot"       |    "blot"       |    "blot"       
Cursor color       |    white       |    white        |     white       
DGL interaction    |share DGL planes| share DGL planes| share DGL planes
Togglealpha        | disabled       | disabled        |  disabled       
Togglegraphics     | disabled       | disabled        |  disabled       
Default colormap   | same as 98547A |  no colormap    |same as 98700-8pln
                   |                |                 |                 
.SP
.fi
Note that setup for LCC is the same as for 98547A.
.SP
Internals users can and do change some of the above values for previously
supported displays. In general the same changes can be made the same way
for CATSEYE on PAWS as they were for Topcat on PAWS.
Values which can be changed and their ranges are:
.SP
Width in characters:		
.in +3
any n, 20 <= n <= <screenpix width> div <character width> 
.in -3
.SP
Height in lines:		
.in +3
any n, 1 <= n <= <screenpix height> div <character height>
.in -3
.SP
Background color: 
.in +3
changed by changing color map entry 0 (LCC/HRC only).
.in -3
.SP
Alpha color:	
.in +3
changed by sending characters 136..143 to CRT (can be disabled) (LCC/HRC only). 
.br
Also 
changed by changing color map entries 0..7 (LCC/HRC only).
.in -3
.SP
Language:	
.in +3
Language automatically selected based on keyboard installed at bootup.
.in -3

.bp
.ul
DGL Support
.SP
Early3.21 DGL supports all CATSEYEs as "soft frame buffers". 
Except for graphics_clear, all drawing operations are done by the CPU, 
rather than by
the CATSEYE assist hardware.
.SP
DGL accesses CATSEYE using either address 3 or 6 in the display_init call.
In DGL, 3 talks to the current console device (which could be a CATSEYE), while
6 accesses an alternate "internal" graphics display (which could be CATSEYE,
when alpha is being displayed on some other device).
.SP
CATSEYE hardware cannot
be used in DIO I address space except at the "select code" that corresponds
to 3 or 6; therefore display_init (3.. or display_init(6.. are the only
ways to access it from DGL in DIO I space.
.SP
Early3.21 DGL does not support CATSEYE in DIO II address space. 
.SP
DGL provides monochrome graphics on HRM, 64 colors (same as hexagon) on
LCC, and 256 colors on HRC. Resolutions are 1024 x 752 on LCC, and
1280 x 1000 on HRx, increasable to 1024 x 768 on LCC and 1280 x 1024 on HRx
by disabling typeahead, or by using a separate alpha console.
.SP
All DGL display functions that are applicable to raster displays are
functional with CATSEYE, with the note that HRM supports only monochrome
graphics. LCC defaults to the same color map as 98547A, and HRC 
defaults to the same color map as 98700-8plane. This is the same color map
that is used by the alpha driver.
.bp
.ul
Internals Information:
.SP
.SP
To help get internals users started, I provide some information about the
frame buffer usage, and a little on the CATSEYE hardware. This information is
of course subject to change at any time.
.SP
.SP
Frame buffer usage
.SP
LCC - frame buffer is 1024(X) by 1024(Y) by 6(planes). Offscreen area is
the rectangle (0,768),(1023,1023). Of this, alpha font uses only the
rectangle (0,768),(527,783), all planes. DGL uses no offscreen framebuffer;
area fill is accomplished using the Three Operand Replacement Rule (TRR), a new
CATSEYE feature. Warning! while DGL is active, it owns the TRR pattern
registers. All visible pixels are usable by alpha operations.
.SP
HRM - frame buffer is 2048(X) by 1024(Y) by 1 plane. Offscreen area is
the rectangle (1280,0),(2047,1023). Of this, alpha font uses only the
rectangle (1280,0),(2039,119). DGL uses no offscreen framebuffer. Same notes
on TRR apply as for LCC. The bottom 4 scanlines are untouched by alpha (except
during screen clears), as display height does not divide evenly by character
height.
.SP
HRC - frame buffer is 2048(X) by 1024(Y) by 8(planes). Offscreen area is
the rectangle (1280,0),(2047,1023). Of this, alpha font uses only the
rectangle (1280,0),(2029,19), all planes. DGL uses no offscreen framebuffer. 
Same notes on TRR apply as for LCC.
The bottom 4 scanlines are untouched by alpha (except
during screen clears), as display height does not divide evenly by character
height.
.SP
.SP
Color Map
.SP
All 3 models actually have a color map, 256 entries by 24 bits (8 each R,G,B),
but for simplicity's sake, and to present a consistent model, LCC is treated
as having only 64 entries, and HRM is treated as having no color map at all.
.SP
.SP
Optimization
.SP
The alpha driver does not update the cursor with each character output.
Instead, at entry to the TM (alpha driver), the IO request is evaluated
as to whether the cursor will be affected. If it will be, the character
under the cursor position is restored, effectively turning off the cursor.
If the request was to write out characters, all the characters are written,
then, at the end of the driver call, if the cursor was turned off, it is
updated to its new position, saving the character under the new position.
.SP
The above strategy, combined with a one-time display-hardware context save
and restore (to provide reentrancy in the driver), instead of the
during-every-character-write save of the Topcat driver, leads to most of the
alpha display speedup you see over previous bitmap implementations. Does
it cause any bugs? We have seen none.
.SP
.SP
DGL change
.SP
Output_esc opcode 250 (set resolution, pixels/mm) is now enabled for all
raster devices. This is needed as the LCC and HRC have 2 different possible
monitor sizes (16" and 19"). We set the default resolution for 19" for
both models. Using the H/W specs and output_esc opcode 250, you can reset
it to match the 16" monitors. Unfortunately, the monitors are "passive"
devices and provide no way to inform the programmer of their resolutions.
