$SYSPROG$
{ This program is similiar to, but not identical to,
{ MKCTBETA used by the turn system to create internal
{ and external versions of CTABLE.
{
{ This program recognizes (and no others) :
{
{       {INTERNAL ONLY BEGIN}
{       {INTERNAL ONLY END}
{       {EXTERNAL ONLY BEGIN}
{       {EXTERNAL ONLY END}
{
{       These directives must be the only item on a line,
{       the program throws away the whole line.
{
{ The user is queried as to whether an internal or external version
{ is desired. If internal, all source between
{EXTERNAL ONLY BEGIN}
{ and
{EXTERNAL ONLY END}
{  will be ignored. If external is selected,
{ all source between
{INTERNAL ONLY BEGIN}
{ and
{INTERNAL ONLY END}
{ will be ignored.}

program xxx(input, output);

var
    inline: string[255];
    inname: string[255];
    outname: string[255];
    infile, outfile: text;
    passing: boolean;
    internal: boolean;
    response: char;

begin
    write('internal (I) or external (E) version? ');
    readln(response);
    if ((response = 'i') or (response = 'I')) then
      internal := true
    else if ((response = 'e') or (response = 'E')) then
      internal := false
    else
      begin
       writeln('Bad Response - Later Gator !!!');
       escape(0);
      end;

    write('name of source input file? ');
    readln(inname);
    reset(infile, inname);

    write('name of output file? ');
    readln(outname);
    rewrite(outfile, outname);

    passing := true;

    if internal then
     begin { INTERNAL VERSION DESIRED }
       while not eof(infile) do begin
	readln(infile, inline);
	inline := strrtrim(inline);
	  if inline = '{EXTERNAL ONLY BEGIN}' then
	    passing := false
	  else
	  if inline = '{EXTERNAL ONLY END}' then
	    passing := true
	  else
	  if passing then
	    writeln(outfile, inline);
	end; { While }
     end { IF - INTERNAL VERSION }
    else
     begin { EXTERNAL VERSION DESIRED }
       while not eof(infile) do begin
	readln(infile, inline);
	inline := strrtrim(inline);
	  if inline = '{INTERNAL ONLY BEGIN}' then
	    passing := false
	  else
	  if inline = '{INTERNAL ONLY END}' then
	    passing := true
	  else
	  if passing then
	    writeln(outfile, inline);
	end; { While }
     end; { ELSE - EXTERNAL VERSION }


    close(outfile, 'save');
end.

