.SA 1
.H 1 "SRM-UX Preliminary ERS"
.SP
.H 2 "HP Confidential"
.SP
.H 2 "General Remarks"
.SP
.P
This software is currently in investigation phase and is not to be 
redistributed without consent of John Schmidt of the Colorado 
Language Lab.  SRM-UX is currently in the planning stages. HP has 
not committed to produce SRM-UX as a product at this stage. It is 
therefore not to be redistributed inside or outside HP. We will 
not provide source code at this time.  
.P
The code has not undergone 
QA and is therefore potentially unsafe. We are currently 
using it in the Lab for software development, and have found it to 
be reliable in ordinary use. We suggest you test it on an isolated 
system before using it in any work-related capacity. We also suggest 
you not use it for storage of critical data, or in configurations 
whose continued uptime is critical to HP's business.
.P
The code will change in the future. The underlying LAN transport protocol,
in particular, is currently being changed.  Be warned that if your 
application depends on the details of the current implementation,
it may break in future. No compatibility is guaranteed between this 
and subsequent versions.
.P
We are a small Lab team and cannot provide much support, if any,
beyond what is in this document. We do solicit e-mail describing
any opinions you have, features you would like to see 
us implement, or defects you encounter. 
Please mail to quist@hpfclw, jwh@hpfclw, or jws@hpfclw.
.H 1 "SRM-UX Overview"
.SP
.H 2 "What is SRM-UX?"
.SP
.P
SRM-UX is a cooperative effort between Pascal Workstation (PAWS),
Rocky Mountain Basic, and HP-UX on the Series 300.
SRM-UX brings PAWS and RMB into the Cooperative Computing
Environment (CCE) as "junior partners", doing what they do best:
real time I/O and data acquisition. It makes it easy for them to
cooperate with HP-UX, letting it do what it does best: computation,
networked communication, graphics, and data management.
.SP
.P
SRM-UX is a transparent HP-UX emulation of the SRM (Shared Resource Manager)
that allows existing PAWS applications to transparently access the HP-UX
file system. It provides diskless boot of PAWS using the HP-UX diskless
mechanism, rbootd. It also usually can provide increased file I/O performance
over "real" SRM, and provides automatic data sharing among workstations
to an even greater extent than has SRM in the past. It will provide data
sharing among PAWS, RMB, HP-UX, and RMB-UX.
.SP
.P
SRM-UX will be supported in a new revision of PAWS, tentatively named
revision 3.3. This revision should not require any but a few very
special "internals" PAWS applications to be recompiled. Similarly
RMB applications should remain "object-code" compatible. On 
the HP-UX side, full SRM-UX functionality will probably require
revision 7.0, due to some weaknesses in the HP-UX 98629A card driver.
.SP
.H 2 "What SRM-UX is NOT"
SRM-UX will not provide access by other machines to a PAWS file system.
It will not add multi-tasking or multi-user capabilities to PAWS.
It will not change the "look and feel" of the PAWS system as far as
the PAWS user is concerned. It need not, and does not in the 
current implementation, use any ATT or other licensed code.
It does not require significantly greater amounts of RAM or disk
in the PAWS or HP-UX machines over current SRM capabilities.
.SP
.H 2 "How Does it Work?"
The diagram on the next page shows the connectivity and data paths
for SRM-UX and another new PAWS utility called pwsvt (pwsvt will be
described in a separate document.) It should be viewed in conjunction
with the following explanations.
.SP
.H 2 "System Model"
A series 300 HP-UX server task (srmd) emulates an SRM, and allows PAWS
or RMB clients to access files and directories which are actually
resident on the server's file system. The clients treat SRM-UX
as though it were a real SRM, providing application compatibility. 
SRM-UX supports client connections with either 98629A SRM cards
or 98643A LAN cards. PAWS and RMB OSs have been upgraded to support
SRM transactions using these cards. Provision is made for diskless
booting of PAWS and RMB via SRM-UX.
.SP
.H 2 "Booting PAWS"
.P
SRM-UX will support booting of PAWS clients over either 98643A LAN
cards or 98629A SRM cards. Different mechanisms are used for each card.
The difference is transparent to the PAWS user.  When using the 98643A
LAN card, booting occurs through the HP-UX diskless boot mechanism.
.SP
.P
A small amount of extra administration is required from the HP-UX root
user in order to maintain information needed for PAWS diskless boot.
Otherwise, the mechanism is the same as for HP-UX diskless boot clients.
No Series 200 machines will be able to boot over the 98643A card,
due to BOOTROM limitations. All Series 300 machines will be able to
boot on the 98643A if they have Revision B or later BOOTROMs, and all
can be upgraded to Revision B BOOTROMs if needed.
.SP
.P
All Series 200 and 300 machines can be booted from the 98629A SRM card
over SRM-UX. Some of the older BOOTROMs may not support booting from
the 98629A card, but all Series 200 and 300 machines can accept
BOOTROM upgrades to allow this. No special mechanism is required in
SRM-UX to allow booting from 98629A cards.
.SP
.P
After booting is complete, control is passed off to srmd on the HP-UX
side and the SRM driver on the PAWS side.
.SP
.H 2 "HP-UX Side"
.SP
.P
On the HP-UX side, srmd emulates the Shared
Resource Manager (SRM) host. Communication can occur either over the
original dedicated SRM wiring, using the 98629A SRM card, or over
the LAN wires, using the 98643A card. LAN provides increased bandwidth
over the 98629A card.
.SP
.P
The HP-UX server, srmd, when transmitting on the LAN card, uses the Link
Level Access (LLA) library of HP-UX to "wrap" the standard SRM protocol
(known as Ganglink protocol) in a transport protocol which lives
comfortably on the LAN. It also strips the LAN protocol from incoming
packets, before presenting them to the Ganglink interpreter. The 
Ganglink interpreter accepts packets from either the 98629A card or
the LAN card, and emulates SRM operations such as opening files,
reading data from files, etc.
.SP
.P
Access is controlled by two mechanisms. The first is the standard HP-UX 
read/write/execute permission set. The second is a subtree mechanism,
whereby the PAWS client sees only a subtree of the HP-UX file system
mount tree, and cannot go above the root of that tree. The two access
mechanisms are completely configurable using an HP-UX file called
srmconf, which is administered by the root user on the srmd server
machine. A possible third access control mechanism is discussed under
"What Are the Issues?"
.SP
.H 2 "PAWS Side"
.SP
.P
On the PAWS side, modified existing drivers use the new LAN driver,
introduced in revision 3.22, to communicate with the srmd server as
though it were an SRM. The PAWS file system code sends data and commands
to the PAWS SRM driver, SRM, in the same way it always has. SRM
creates standard Ganglink packets for the transactions, then checks
to see if the transactions are aimed at a LAN or an SRM card. If they
are going to SRM, they go out as usual. If they are going to LAN, they
are wrapped in the LAN transport protocol by the LANSRM part of SRM,
and shipped.
.SP
.P
Packets incoming to PAWS on SRM wires are treated as usual. Packets
incoming from LAN are stripped of their transport protocol by the
LANSRM part of SRM and presented to SRM as though they had come from
the SRM card. The PAWS side approach minimizes new code, with its
attendant risk of new defects.
.SP
.H 2 "RMB"
.SP
.P
RMB will use the same diskless boot mechanism and srmd server as
will PAWS. Details of the RMB implementation are not discussed in
this paper.
.SP
.H 2 "What Are the Issues?"
Most of the purely technical issues, such as general architecture,
and many implementation details, have been solved in the prototype
code developed at CoLL. Two major technical marketing issues are
still unclear:
.SP
.H 3 "Gateways"
The question of whether and how SRM-UX should be gatewayed when
running on the 98643A card is another open issue. In this context,
gatewaying means providing access to an HP-UX machine running srmd
on another network. The gateway could be mediated by an HP-UX machine,
a Cisco box, or the like, and would be transparent at the driver 
level, though not necessarily so at the network administration level.
.SP
.P
Customers may desire gateway capability because of the increased
connectivity it provides for their PAWS and RMB clients over
non-gatewayed SRM-UX. They may dislike gateways for the increased
system administration burdens they will undoubtedly impose. IP gateway
capability will require that each SRM-UX client know 
and remember at least two IP addresses: its own, and that of its SRM-UX host.
.SP
.P
There are alternatives to gateways that may give equivalent or even
improved capability. These revolve around having the SRM-UX host remote
mount the desired file systems via NFS or RFA. A more detailed discussion
appears at the end of this chapter.
.SP
.H 3 "Password/Access Control Schemes"
.SP
.P
The difficulty here is that SRM and HP-UX access control schemes are
very different. SRM uses a password-per-file scheme, with each password
controlling up to 6 different properties. The SRM control properties
are unrelated to the HP-UX read/write/execute properties. SRM also
supports multiple passwords per file or directory, each with different
property control sets.
.SP
.P
HP-UX's user/group/other-read/write/execute permission set is the one
that must be observed by srmd for protection of the HP-UX users and
processes running on the server machine. We can identify no good mapping
of the SRM passwords onto the HP-UX scheme.
.SP
.P
There does seem to be a possibility of simulating the SRM passwording
scheme under srmd; the simulation will probably not be complete or
consistent, and may impact performance considerably. 
.SP
.P
It is also possible to ignore the SRM passwording scheme completely
when using SRM-UX, and employ the native HP-UX permissions. A model
for this in both PAWS and RMB exists in the HFS local file system
drivers for each, introduced in PAWS revision 3.2, and RMB revision
5.0. The model seems reasonably satisfactory. Some existing
SRM-based applications may not port immediately to SRM-UX without
SRM-style passwording.
.SP
.P
The major alternatives, then, seem to be these:
.SP
.nf
1.) Simulate SRM passwords under SRM-UX. Simulation may be
    partial, and performance may suffer.  Directories and
    certain file types may not be allowed  to have  passwords.
    Users  may get unexpected results when attempting to
    access the file system with a given password.

2.) Employ the native HP-UX permission set. Some applications
    may not port directly, due to dependence on SRM passwording
    semantics.  Our own applications, such  as PWS FILER, can
    be modified to handle this.  Applications coded by others
    may present  problems; very few applications are likely to
    be affected.
.fi
.SP
.P
These questions need to be investigated by Marketing, with guidance
from the Lab as to the technical realities. They are customer
satisfaction and usability questions.
.SP
.H 3 "Who does what?"
.SP
.P
Much of the code for SRM-UX will be executing under HP-UX,
in the srmd server. The PAWS product line has not to date included
code intended to execute anywhere else except under PAWS.
We need to find a mechanism whereby the HP-UX code can 
be maintained, supported, and distributed in a timely fashion.
Issues here include HP-UX version compatibility, testing, distribution
media and channel, documentation, TWG approval, and support
responsibilities, both in the field and at the factory.
.SP
.P
CND may be the most suitable channel for distribution and support of srmd. 
DLD can probably best maintain HP-UX version compatibility and
documentation, and acquire the necessary HP-UX approvals. 
Testing is a complex issue, not yet well understood in DLD. We do not
understand how to test SRM-UX, nor the interoperability requirements
that might be placed on it. We will need CND's help in planning and
executing testing. Marketing must help us decide the best answers to
these questions.
.SP
.P
The PAWS Lab Team is probably the best developer and
maintainer for the portion of the code (LAN driver and SRM/LANSRM code)
that executes under PAWS. Our distribution channels can handle the new
code, which will be embedded in the current product. Our Learning Products
team can adequately document PAWS-specific procedures for the customer.
And support can be modeled on the current support mechanisms for
"real" SRM, which is also a remote file system.
.SP
.P
The RMB team can probably best develop and support the analogous
code under RMB.
.SP
.H 3 "Series 800 Support"
Should HP Series 800 SPUs support SRM-UX? We have some feedback that they 
should, but not an overwhelming volume or vehemence of requests.
Marketing needs to sort this out.
.SP
.H 3 "Miscellaneous Compatibility Issues"
.SP
.P
Node numbers - Currently, when using the 98643A card, PAWS replaces
the real SRM's 2-digit "system volume" node number with a 6-digit
number that is the last 6 digits of the LAN card address. We do this
in order to provide a unique name for the "*" directory: e.g.
"/WORKSTATIONS/SYSTEM003542". The uniqueness is desirable, the
change from 2 to 6 digits may not be. However, with 2 digits,
we cannot automatically provide unique numbers.
.P
The configuration file for SRM-UX, /etc/srmconf,
contains a field called "Your Node"
that provides a 2-digit emulated node number for the host 
that RMB will use. PAWS will not be able to use the 2-digit number
for assigning the "*" directory, as the value is not available to
PAWS at the right time. The 2-digit value will be available to
applications which runs after the boot completes, using an
existing PAWS "internal" procedure. Is this a problem?
.SP
.P
Other SRM functionality - we currently have a design for
printer/plotter spooling emulation. This design allows PAWS and RMB
users to do spooling to SRM-UX exactly as they currently do for real SRM.
It also provides a trapdoor for other remote functionality, such
as mail spooling, if the administrator desires to allow it. We think
this is a non-issue.
.SP
.H 3 "SRM Console Emulation"
.SP
.P
Currently, administration of SRM-UX at the server is done HP-UX-style,
by editing textual configuration files, starting up daemons, etc.
Although not complex compared to many HP-UX sysadmin tasks, it is
completely different than real SRM system administration, which is
done from the dedicated SRM console via menus and prompts.
Rick Dow of CND has written an SRM console emulator, which provides
the look and feel of a real SRM console to the SRM-UX administrator.
We do not know whether or not it maps well onto the real SRM-UX admin
tasks in our design. SRM-UX requires HP-UX, and HP-UX usually requires
an administrator comfortable with its style, and who usually demands
full control over the system.
.SP
.P
The new HP-UX tool, SAM, may provide an easy-to-use front-end for
configuring SRM-UX. We have a SAM ERS, etc., and indications are that
SAM will do the job nicely, though requiring someone to write some
HP-UX code for a SAM SRM-UX driver module.  It will probably be best
to wait until SAM usability designs gell, then use it to simplify
SRM-UX admin, rather than doing a probably inadequate emulation of
the SRM console, or inventing yet another tool that will require
learning, documentation, support, etc.
.SP
.P
In the interim, we can document use of an HP-UX editor to modify
the file.
.SP
.H 3 "More on Gateways"
.SP
.P
Gatewayed SRM-UX (using either 98643A LAN card or 98629A SRM card)
connections are not possible with the current implementation. If
gatewaying is required, it will probably be best to implement
Internet Protocol (IP), which provides a standard transport among 
subnets.
.SP
.P
Gatewaying using the 98629A card is an unexplored possibility. We
should probably complete any LAN-based gateway investigation before
attacking 98629A gateways, as LAN gateways are better understood.
.SP
.P
Gatewaying SRM-UX may not be desirable. For one thing, the standard
SRM node numbering scheme only allows for node numbers from 0 to 63.
In a large extended network, assigning such a limited address space
may be a very confusing and difficult job. An srmd running on another
network may cause unintended confusion by responding inappropriately 
to SRM-UX traffic on the local subnet. There is no way to shut off IP
gatewaying.
.SP
.P
Another difficulty is that of assigning and retaining IP addresses.
PAWS does not currently have system management tools for system name,
IP address, etc. Assigning values to these at boot time or in the
AUTOSTART file (so they need not be entered after every boot) needs
to be investigated, should we decide to use IP. Tools to propagate
knowledge of these data also do not exist in PAWS. In HP-UX, tools do
exist, such as Yellow Pages and puthosts, that automate this task.
In a single-tasking system such as PAWS, it is very difficult to
simulate operation of a crontab or daemon-based tool such as these.
This leaves the management burden on the user, and network management
can be very complex and time consuming.
.SP
.P
If IP is used, the PAWS machine will also need tools to receive
information about the SRM-UX LAN network. To establish a connection
with an SRM-UX host using IP, it will be necessary for PAWS to know
the IP address of the host. The same difficulties arise here 
as noted above.
.SP
.P
Note that diskless boot does not work over gateways. Providing gatewayed
LAN SRM-UX either requires upgrading rbootd to work over gateways, or
creates a difference between the scope of the booting and file access
parts of SRM-UX. Such a difference, combined with the fact that one
cannot gateway with the 98629A SRM card, could lead to considerable
user confusion, and could present technical difficulties.
.SP
.P
Should we decide to use diskless protocol as the transport, gatewaying
will not be possible; diskless protocol does not support gateways.
.SP
.H 4 "Gateway Alternatives"
.SP
.P
Given the nature of HP-UX, some alternatives exist that may obviate
most needs for SRM-UX gateways. HP-UX can remote mount other filesystems
using NFS or RFA. If the PAWS user needs access to files not on the
SRM-UX host machine, remote mounting the desired file system 
will provide access. This approach has some advantages over gatewaying:
.SP
.SP
.nf
1.) Works over  both 98643A and 98629A  SRM-UX connections.
    Since the remote file system is transparently mounted
    into the SRM-UX host file system, it doesn't matter which
    interface is carrying SRM-UX traffic.

2.) Works  with non-Series 300  and non-HPUX machines.  NFS
    provides the  ability to mount "foreign" file systems.
    Srmd will not be supported on other than Series 300 HP-UX
    machines.  A remote mount  would provide SRM-UX access
    to, for instance, a Series 800 file system when desired,
    even though srmd may not run on Series 800.

3.) Reduces system administration on the PAWS machine, and
    puts it back on the HP-UX root user, who is accustomed
    to complex configuration tasks, and has existing tools
    to manage them.
.fi
.SP
.H 3 "Issues Summary"
.SP
.P
The issues are, in brief:
.SP
.NF
 1.) What transport protocol should SRM-UX use on the LAN?

 2.) Should gateway capability be provided for SRM-UX on
     the LAN? On the 98629A card?

 3.) Which access control scheme should be implemented,
     an SRM emulation, or the native HP-UX scheme?

 4.) Who should develop, document, and maintain the srmd
     code?

 5.) Who should distribute and support srmd?

 6.) Who  should acquire the appropriate approvals for
     code and protocol?

 7.) What are  appropriate testing  procedures and
     environments?

 8.) Should SRM-UX be supported on Series 800 servers?

 9.) Should we  emulate 2-digit SRM node  numbers, or
     continue with 6-digit LAN numbers?

10.) Should we provide an SRM console emulation for
     SRM-UX system administration, or continue with the
     "direct" HP-UX style control currently implemented?
     Should we wait for SAM?
.FI
.SP
.H 1 "User's Guide"
.SP
.P
Some terms need brief explanation:
.SP
.P
SRM-UX client is a PAWS or Rocky Mountain BASIC (RMB) machine that "thinks" 
the SRM-UX is a real SRM.
.P
SRM-UX server is an HP Series 300 HP-UX machine running a special application 
(srmd) that makes clients think they are speaking to a "real" SRM.
.P
Daemon is an HP-UX program that runs continually, providing some kind of
background processing.
.P
Diskless hub is an HP-UX machine from which other HP-UX machines (or SRM-UX 
clients) can boot over LAN, and on which they can store their files.
.P
Root user or root is the system administrator for a machine running
HP-UX, and has special privileges and powers that other HP-UX users
do not. Root often maintains files that cannot be modified by other
users.
.P
Link Address is a 6-byte (12-hex-digit) number stored in EPROM on each HP
LAN card, and unique to that card.
.P
Node Number is a 2-digit number settable with switches on the 98629A
SRM card.
.P
TABLE is a configuration program for PAWS; it sets up the entries in
the PAWS unit table, usually at boot time. The code file TABLE is on
the boot microfloppy that HP ships with PAWS, and should be copied to
a boot directory on the SRM-UX server. The source for TABLE, called
CTABLE.TEXT, is supplied with PAWS on the ACCESS: or CONFIG: disks,
so that the user can easily modify the unit table configuration.
.SP
.H 2 "Booting"
.SP
.P
The PAWS client machine can be booted either from an SRM or from SRM-UX.
Booting from SRM is well covered in existing PAWS documentation.
Booting from SRM-UX is discussed below. Booting from SRM-UX on a 98643A
LAN card is actually done using the HP-UX diskless boot daemon, rbootd.
The HP-UX machine to be booted from must be a Series 300 HP-UX 
diskless hub server, and must be running rbootd. You may still use SRM-UX
if the server is not executing rbootd, but the client must boot from
another device, such as an SRM, hard disc, or floppies.
Booting from SRM-UX using a 98629A LAN card requires the server be running
srmd, but does not require it be a diskless hub running rbootd.
.SP
.H 3 "Boottab"
.SP
.P
There is a configuration file for rbootd, administered by the root user
on the diskless hub server. It is called /etc/boottab. To be able to
boot PAWS correctly from the server, a line similar to that below must
be added to /etc/boottab:
.SP
.NF
paws-srm:HPS300:SYSTEM_P:INITLIB,TABLE,STARTUP
.FI
.SP
.P
The first item, paws-srm, tells rbootd that the file /etc/srmconf
(discussed below) exists and should be processed. Rbootd will cooperate
with srmd (another HP-UX daemon, discussed below) to ensure that the
boot volume stays on-line if the above line is present in /etc/boottab.
.P
The next item is machine type. The only legal value for SRM-UX here is HPS300.
The item after machine type is the name of the boot file. This file
should be in directory /SYSTEMS on volume 8 in the SRM-UX srmconf file,
as described in the next section. Volume 8 is the only place a boot file
can be booted from. The usual valid boot names can be used, for example
SYSP33. More than one boot file can be specified by separating them 
with commas.
.P
The next field contains 3 items, the standard Pascal extension boot files.
They can be found in one of two places, but must be on Volume 8, just
like the SYSTEM_P file. More than one set of boot extension files can
be specified by listing them separated by commas. E.g. :
.SP
.NF
paws-srm:HPS300:SYSTEM_P,SYSP33:INITLIB,TABLE,STARTUP,
INITP33,STARTP33,TABLEP33
.FI
.SP
.P
The first place these files are looked for is in /WORKSTATIONS/SYSTEMnnnnnn,
where nnnnnn is a 6-hex-digit number. For example, if the Link address
of the LAN card in the client is 0x80009003542 ($80009003542 in Pascal
notation), nnnnnn is the last six digits: 003542. In this case the 3 files
would be found under the path /WORKSTATIONS/SYSTEM003542 in volume 8.
This is analogous to the real SRM notation /WORKSTATIONS/SYSTEMnn, where
nn is the 2-digit node number of the 98629A card plugged into the PAWS
client machine.
.P
If /WORKSTATIONS/SYSTEMnnnnnn does not exist, the path /WORKSTATIONS/SYSTEM
is searched for the 3 extension boot files. If neither of these 
paths exist, or if the INITLIB file is not found, the boot will fail with
an error  -10. If the STARTUP or TABLE files are not found, booting will
be completed, but the system may be practically unusable.
.P
Note that the paths /WORKSTATIONS/SYSTEMnnnnnn, etc are relative to the
Root Directory specified for Volume 8 in srmconf, described below.
So the path /WORKSTATIONS/SYSTEM003542 as seen by the PAWS client is
actually /srmserve/WORKSTATIONS/SYSTEM003542 in the example in the next
section. The names of the INITLIB, STARTUP and TABLE programs should
follow the standard rules, based on the name of the SYSTEM_P file.
E.g. if the system file has the name SYSP33, the other files should be
named INITP33, STARTP33, and TABLEP33.
.P
Once booting is complete and TABLE has executed, rbootd is no longer
used by the PAWS client. From here, srmd on HP-UX and the SRM driver in
the PAWS INITLIB file take over. If srmd is not running or the proper
modules are not in INITLIB, SRM-UX will be unusable.
.SP
.H 3 "SRMD"
.SP
.P
The HP-UX SRM host emulator, srmd, is an application that runs in the
background. It is invoked by the HP-UX root user as in the example below:
.SP
.NF
# /etc/srmd
.FI
.P
The srmd driver is supported on HP-UX Series 300 only, and is
compatible with HP-UX revision 6.0 or later, though use of 98629A
cards with srmd requires revision 7.0 or later. The file /etc/srmconf
is used to configure srmd, defining how it emulates an SRM host for 
each PAWS or RMB client, and on which interfaces (dev files) it is active.
An example srmconf file is shown below:
.SP
.nf
#----------------------------------------------------------
VOLUME-TABLE

# Volume Descriptions
#
# Volume      Disk                 Temp         Root
#  Name     Volume # Uid  Gid   Directory    Directory
#----------+-------+----+-----+------------+----------
SRM_LW     :   8   : 17 :   9 :            : /srmserve
ROOT_LW    :   9   :    :     : /tmp       : /
QUIST_LW   :  10   :    :     : /          : /users/quist
BAYES_LW   :  10   :    :     : /tmp       : /users/bayes
JWH_LW     :  10   :    :     : /          : /users/jwh
DEW_LW     :  10   :    :     : /srmtmp    : /users/dew
SCHMIDT_LW :  10   :    :     : /          : /users/jws
PRINTER    :  11   :    :     : /          : /PRINTER

LAN-DEVICES

/dev/ieee		# backbone LAN
/dev/ieee.cluster	# local subnet

LAN-CLIENTS

# LAN Card Clients
#
# Client Link  Your  My                    Volume
#   Address    Node Node  Uid  Gid  Umask  List
#-------------+----+----+-----+----+-----+--------------------------
# Robert Quist :
0x80009000937 : 46 :  0 : 106 : 20 : 022 : SRM_LW,ROOT_LW,QUIST_LW
# Scott Bayes : 
0x80009003542 : 34 :  0 : 101 : 20 : 022 : SRM_LW,ROOT_LW,BAYES_LW
# Jeff Hendershot : 
0x800090133D4 : 44 :  0 : 213 : 20 : 022 : SRM_LW,JWH_LW,PRINTER
# Jeff Hendershot : 
0x8000900568A : 12 :  0 : 213 : 20 : 022 : SRM_LW,ROOT_LW,JWH_LW
# David Willis : 
0x8000903D63D : 27 :  0 : 200 : 20 : 022 : SRM_LW,DEW_LW,PRINTER
 
SRM-CLIENTS

# SRM Card Clients
#
#   Dev      Client                      Volume
#   File    Node Num   Uid   Gid  Umask  List
#---------+----------+-----+-----+-----+-----------------------------
# John Schmidt :
/dev/srm  :    32    : 103 : 20  : 022 : SRM_LW,ROOT_LW,SCHMIDT_LW
# Printer : 
/dev/srm  :    52    : 123 : 20  : 022 : SRM_LW,PRINTER

SPOOL-TABLE

# Spooling Services
#
# Spool Directory	         Spooling Command
#--------------------+-----------------------------------------------
/srmserve/PRINTER    : lp -dljet -oraw     # print raw data to ljet
/srmserve/EPRINTER   : lp -depoc -oraw     # print to EPOC printer

.fi
.SP
.H 3 "An Example Configuration"
.SP
.P
To understand these fields, it is necessary to know a little about
PAWS file system configuration. PAWS maintains a unit table, which makes
an association between devices - or in this case SRM volumes - and an
index from 1 to 50, called the unit number. PAWS initializes the 
unit table using a program called TABLE, which runs at boot time.
.P
As an example, consider disk volume 8 on an SRM whose node number is 0.
The PAWS machine contains a 98629A interface at select code 21 with
node number 34. In the example, unit entry #5 associates the SRM host,
disk volume 8, with the unit number 5. Here, because the desired SRM
host has node number 0, PAWS must specify node number
0 in order to connect with it. Unit entry #5 contains the information
that the required host node is 0, that the select code is 21
(for the 98629A connected to PAWS), and that the disk on the SRM is
volume 8.
.P
When dealing with a LAN network instead, we simulate disk
volumes and node numbers using srmd. With this explanation understood,
we can examine the srmconf file.
.P
The srmconf file is in six parts, a volume table, a LAN devices table,
a LAN card clients table, an SRM card clients table, a spool environment
table, and a spooling table. Any text following a "#" is considered a
comment and is ignored by srmd and rbootd.
.SP
.H 3 "What we're Going to DO"
.SP
.P
We need to deal with the LAN and the 98629A (SRM) interfaces in
different ways. For the LAN card, there are no such things as node
numbers, which the SRM driver and protocol depend on to know where to
connect to, and how to direct data. So on the LAN we will cause
srmd to emulate node numbers. Two node numbers need to be emulated:
the host node number (0 in the example diagram above), and the client
node number (34 in the example.) 
.P
Such emulation will not be necessary for the 98629A card, as the
required node numbers exist and are settable using switches on the cards.
For each type of card there will be a specific section of srmd's
configuration file that precisely describes the configuration 
requirements for that card type.
.P
In addition, we want to provide the system administrator of the HP-UX
server machine, the root user, the capability to restrict and control
access to the HP-UX file system through SRM-UX. Finally, we want to
provide some extra services to the PWS and RMB client users: printer
and plotter spooling. 
.P
The configuration file, /etc/srmconf, on the SRM-UX server, provides
the tools to achieve these ends. Srmconf is usually owned by the root
user, and usually has permissions of rw-r--r--, so that other users
can examine but not modify it.
.SP
.H 3 "The Block Names"
.SP
.P
There are 5 keywords that introduce the various blocks of srmconf.
They are: VOLUME-TABLE, LAN-DEVICES, LAN-CLIENTS, SRM-CLIENTS,
and SPOOL-TABLE. They must appear in the order given, and in uppercase,
exactly as shown in the example. Each block in srmconf describes a
different part of the configuration.  For all blocks, fields within each
entry in the block are separated by ":" characters. Fields must appear
in the order seen in the example (the same order as they are discussed below.)
A comment can appear as the last item in any line of the file, and is
introduced by the "#" character; anything after a "#" is ignored by
srmd until the start of the next line. You may freely insert blank
lines anywhere in the file to improve readability.
.SP
.H 3 "The Volume Table"
.SP
.P
Keyword: VOLUME-TABLE
.SP
.P
The volume table contains names and descriptions of "volumes"
(SRM volume emulations) that will be presented to PAWS or RMB clients.
Each volume is a subtree of the current mount tree of the HP-UX host
(including any accessible remote file systems previously mounted
by HP-UX RFA or NFS utilities) and is described by one line of text
in the Volume Table. A description of each field follows:
.P
The Volume Name field is the name of the volume as seen by the client.
It simulates the Volume Label of a real SRM disc. A PAWS user can see
this name by using the Filer List command to list the directory
"/" for the unit to which the volume is associated. 
.P
The Disk Volume # field is the emulated disk volume number as it would
be seen on a real SRM. This field is placed in the du field of a
tea_srm call in the PAWS program CTABLE. Procedure tea_srm is discussed
in Pascal 3.2 Workstations System, Volume 2, in the chapter Special
Configurations, under the heading Multi-Disc SRM.
.P
The Uid field is a User or Owner ID value that will be assigned to files
and directories created through the srmd server. It is an override of
the value specified in the LAN-CLIENTS and SRM-CLIENTS sections of
srmconf. If the uid field is empty, the value in the client services
section will control.
.P
The Gid field is similar to the uid field, providing group ID assignment
for newly created files and directories.
.P
The Temp Directory provides a mapping for the file name 
/WORKSTATIONS/TEMP_FILES. For many operations, the PAWS SRM driver
creates temporary files which it stores on the SRM in the directory
/WORKSTATIONS/TEMP_FILES. It is often not convenient to provide the
directory /WORKSTATIONS/TEMP_FILES at the root of each SRM-UX subtree;
this field allows you to have srmd convert that file name to one
which is more convenient, and is accessible in the subtree. The path
is always evaluated relative to the root directory field
(next paragraph), and is required to have a leading "/". If the field
is empty, no conversion is done.
.P
Root Directory provides the path on the HP-UX machine to which the
simulated SRM tree is attached. Specifying the root of the SRM ("/")
from the PAWS or RMB client will take you to this directory.
Specifying ".." from there will not go above the root directory
specified in srmconf for the volume.
.SP
.H 3 "The LAN Devices Table"
.SP
.P
Keyword: LAN-DEVICES
.SP
.P
The LAN devices table lists the LAN interfaces (HP-UX device special
files) on the server machine that will be used to support SRM-UX.
The only field in each line (except for a possible comment) is the name
of a "device special" file associated with a LAN card in the 
server (a 98643A or built-in LAN card) on which srmd is to support
SRM-UX connections. 
.P
Note that there is no cooperation guaranteed with
rbootd; if you wish to ensure that RMB and PAWS can boot off each
device specified here, rbootd must be invoked with the same device files(s).
.SP
.H 3 "The LAN Card Clients Table"
.SP
.P
Keyword: LAN-CLIENTS
.SP
.P
The Client Link Address field specifies  the LAN link address of the
98643A interface on the PAWS or RMB machine to which service is to
be provided. It is a 6-byte number (12 digits hex) which is factory-set
by HP to be unique. Many Series 300 computer BOOTROMs report this
number; if it is reported, it will appear on the left side of the 
screen, on the line where the existence of the 98643A card is reported.
If your BOOTROM does not report the Link Address, see the installation
manual that came with  your 98643A card for information on determining it.
.P
Your Node is the 2-digit emulated SRM client node number that srmd
pretends the LAN-based client to be. PAWS ignores this node number
during boot, and when assigning a "*" directory, using instead the
6-digit hex number taken from the last six digits of the LAN 
link address. RMB returns this number in response to a
"status(sc, 7)" command. The range is 0..63, although numbers less
than 10 should normally be reserved for servers, not clients.
.P
My Node is the 2-digit emulated SRM host node number the server
machine pretends to be when using the LAN card to communicate with
the client specified in the Client Link Address field. One server
machine may only pretend to be one server node for any given
client interface; for a different client interface, it may pretend
to be another host node (e.g. host node 1). Any client may have more
than one interface plugged in, allowing more than 
one emulated host node. The My Node value is used in the ba parameter
of tea_srm calls in the PAWS CTABLE program.
.P
Uid is the HP-UX User Id to be assigned to all new files and directories
created by this client using srmd, unless overridden in the Volume Table.
.P
Gid is the HP-UX Group Id to be assigned to all new files and directories
created by this client using srmd, unless overridden in the Volume Table.
Umask is the HP-UX umask to be applied to all new files and directories
created by this client using srmd. See the HP-UX reference manual,
section (1) for details.  Volume List is a list of emulated volumes
chosen from the Volumes Table above. It specifies which volumes in the
Volumes table can be accessed by each client.
.SP
.H 3 "The SRM Card Clients Table"
.SP
.P
Keyword: SRM-CLIENTS
.SP
.P
This section of srmconf is relevant only to 98629A cards. 
The first field, Dev File, is the full path to the device special
file in the SRM-UX server on which srmd is to provide service.
See mknod in the HP-UX System Administrator Manual for details on
setting up device special files. 
.P
The Client Node Num is the node number set on the switches on the 98629A
card in an RMB or PWS srmd client machine, it, along with the dev file
specified above, specifies from which clients srmd will accept a
connection request.
.P
Uid is the HP-UX User Id to be assigned to all new files and directories
created by this client using srmd, unless overridden in the Volume Table.
.P
Gid is the HP-UX Group Id to be assigned to all new files and directories
created by this client using srmd, unless overridden in the Volume Table.
.P
Umask is the HP-UX umask to be applied to all new files and directories
created by this client using srmd. See the HP-UX reference manual,
section (1) for details.
.P
Volume List is a list of emulated volumes chosen from the Volumes
Table above. It specifies which volumes in the Volumes table can be
accessed by each client.
.H 3 "The Spool Environment Table"
.SP
.P
Keyword: SPOOL-ENV
.SP
.P
This section provides an HP-UX environment for the spooling processes
to "live in." When a file is closed in a spooling directory, srmd will
pipe the contents of the file to an HP-UX shell process specified in
the Spooling Services Table (next section.) This process
needs some "environment" in which to operate. The only mandatory part of
the environment is a PATH variable. Other parts are optional, and
provide more power and flexibility to the spooling process. See
the "Bourne Shell" section of the HP-UX manual "Shells and
Miscellaneous Tools" for details on shell and environment variables,
and piping. The first and only field (except for an optional comment)
is the variable assignment field. It always has the format:
.SP
.P
variable=value
.SP
.P
See the sample srmconf listing for examples.
.SP
.H 3 "The Spooling Services Table"
.SP
.P
Keyword: SPOOL-TABLE
.SP
.P
This section of srmconf provides flexible descriptions of how SRM
printer and plotter spooling is to be emulated by SRM-UX. See the
Shared Resource Manager Workstation User's Manual for details on
spooling in the SRM environment. The first item is a Spool Directory
name. It is an absolute path on the SRM-UX server system from which
files are to be print-spooled by srmd.
.P
The second item, Spooling Command, is an HP-UX Bourne shell
command sequence to be executed in order to perform the spooling
operation. It is passed to /bin/sh by srmd, along with the contents
of the spool file. The full pathname of the file (e.g.
"/srmserve/PRINTER/Scott-job.UX") is passed in to this
command sequence as $SPOOLFILENAME. See the manual page for sh(1)
for shell programming information.
.P
After the shell command is completed, srmd will remove the spool
file, if it still exists. How print spooling is done depends partly
on how the HP-UX system's own print spooling is set up. However,
from the PAWS user's point of view, all that is required is to
place a text file into a spooling directory on SRM-UX.
.P
For example, from the PWS EDITOR, when the file is ready for printing,
one could Quit, Save, and specify a file name such as
#5:/PRINTER/Scott-job.UX. After a few minutes, the printout should
appear on the printer of the SRM-UX server machine. The file will be
removed after it is spooled. To support spooling, srmd will check
every time it closes a file it has written to. For the 
above example SPOOL-TABLE, if the file is named Scott.UX, and
is in the directory /srmserve/PRINTER, srmd will execute the command
"lp -dljet -oraw", piping to it the contents of the file as stdin,
and setting the shell variable $SPOOLFILENAME to 
"/srmserve/PRINTER/Scott-job.UX". The command is a simple invocation
of the standard HP-UX line printer spooler, lp, which tells it to
print its input to spooler device ljet (a printer), using the
device-dependent option raw. This will satisfactorily print a UX-type 
text file on most systems.
.P
The pathname you specify in the Spool Directory field is absolute
and is not modified by any volume specification. For example,
you might have two volumes, one at unit #5, starting at "/srmserve",
and the other at unit #46, starting at "/". To spool to the
above spooler, you could specify a path of either "#5:/PRINTER"
or "#46:/srmserve/PRINTER" .
.P
The above spooler example will only print files of type UX. A file
can be given type UX by creating it with a suffix of ".UX"
in PAWS revision 3.2 and later. More complicated spooling tasks can
be accomplished by substituting more complex commands. For example,
if you had an HP-UX program named textfilter that received PAWS 
.TEXT files as stdin and sent out vi-compatible text as stdout,
you could support spooling of .TEXT files using this line in srmconf:
.SP
.NF
/srmserve/TEXTPRINTER : textfilter | lp -dljet -oraw # Spool .TEXT files
.FI
.SP
.P
Here, the PAWS user would place a .TEXT file in /srmserve/TEXTPRINTER,
and it would be translated and printed, then removed.
To be realistic, you would probably have textfilter examine the file
and decide whether it is .TEXT or not before doing any conversion.
.P
The spooler model also provides a "backdoor" for tasks unrelated to
spooling to be accomplished. How to use it as a mailing daemon is left
as an exercise for the user.
.SP
.H 3 "What It All Means"
.SP
.P
The file /etc/srmconf provides an administration tool for the HP-UX
root user to define and control access by rbootd and srmd clients
(PAWS and RMB machines) to the HP-UX file system. 
In the example /etc/srmconf file, the PAWS client using the
98643A interface with Link Address 0x80009000937 has access to
three volumes. One volume, SRM_LW, is defined to 
be the subtree under "/srmserve". Attempts by the PAWS user to
prefix via this volume to "/" will always leave him at /srmserve.
As a matter of fact, /srmserve will usually be set 
up as a small "SRM world", with its own /WORKSTATIONS directory,
its own /SYSTEMS directory, etc. Booting and ordinary SRM tasks can
all be accomplished from within /srmserve.
.P
Link Address 0x80009000937 has access to two other volumes as well,
ROOT_LW and QUIST_LW. ROOT_LW is prefixed to "/" on the HP-UX
file system. This volume provides access to the whole HP-UX
file system, if read/write/execute permissions on the HP-UX
system so allow. It is a volume intended for extraordinary uses
of SRM-UX, such as data-sharing with RMB-UX or HP-UX itself,
or access to remote file systems mounted via 
NFS or RFA on the HP-UX server. QUIST_LW is prefixed to the HP-UX
home directory that user gets as his or her "home" directory when
logging to the HP-UX server machine under HP-UX; this is convenient
for those who use both PAWS and HP-UX and wish to share 
data between them Files and directories created on the volume
SRM_LW will be created with uid=17, gid=9, 
according to the override specified in the Volume table.
Those created on volumes ROOT_LW and QUIST_LW will have uid=106,
gid=20, as there is no override. Files created via any of the volumes
will have permissions 755 (rwxr-xr-x), as the umask for the client is 022.
.P
Temporary files created by the SRM driver on the PAWS client will
appear in /srmserve/WORKSTATIONS/TEMP_FILES for volume SRM_LW, in
/tmp for volume ROOT_LW, and in / for volume QUIST_LW.
.P
CTABLE will not need modification to talk to volume SRM_LW, as it
is disk Volume 8 on host node 0 (Mynode) on select code 21, which
matches the default CTABLE values. CTABLE will have to be modified
and recompiled if the PAWS user wishes to access 
ROOT_LW and/or QUIST_LW, as disk volumes 9 and 10 are not
defaults of CTABLE. See the next section for more details.
.P
Another client machine, for example, 0x80009003542, will see a
different view of the same SRM-UX host machine. This other machine
sees volume 8 the same, but files and directories created on
volume 9 (ROOT_LW) will have uid=101 instead. This machine also has 
access to another volume, volume 10, BAYES_LW, with root at
/users/bayes. Files and directories created here will have uid=101,
gid=20, which are this user's uid and gid when he logs in to HP-UX
on the server.
.P
No provision is made to allow the PAWS user
to change any of the items specified in /etc/srmconf. This is the
province of the HP-UX root user. It may be desirable to allow the 
user on PAWS to change his uid, gid, and umask during a session.
This is undecided as yet.
.SP
.H 2 "SRM and LANSRM"
.SP
.P
On the PAWS side, the Operating System and user applications communicate
with srmd using these drivers: LAN, DATA_COMM, and SRM. The drivers
normally are inserted into INITLIB using the techniques described
in Pascal 3.2 Workstations System, Vol. 2, in the chapter Special
Configurations. The file system driver SRM uses either of the device
drivers LAN or DATA_COMM, depending on whether the application is
communicating via a 98643A LAN card or via a 98629A SRM card.
.P
If one of these cards is not present in the system, or it is desired
not to use the card, the associated driver may be left out of INITLIB.
SRM can not be omitted from INITLIB if any SRM communication is
desired at all using either interface. The file LAN actually contains
2 modules: IOMPX and LAN. These must both be put into 
INITLIB for SRM-UX to work with 98643A cards, and must retain
their relative ordering: IOMPX must come before LAN.
.P
Using SRM-UX on a 98643A card in PAWS does not preclude using the
card simultaneously for other applications, for example the NRC FUSION
software (ftp and telnet utilities). IOMPX provides multiplexed access
to the LAN card. The 98629A card can only be used for SRM. It is not
a general purpose I/O card.
.H 2 "Default Configurations"
.SP
.P
TABLE configures the various drivers and devices into the unit table.
By default it will configure disk Volume 8 on any SRM or SRM-UX whose
host node number is 0 and which is connected to a 98643A or 98629A
at select code 21 in the PAWS machine, into the unit 
table at unit entry #5. In addition, if the subdirectory 
/WORKSTATIONS/SYSTEMnnnnnn (or /WORKSTATIONS/SYSTEMnn for a 98629A 
card) or /WORKSTATIONS/SYSTEM exists, unit entry #45 will be created and
associated with that subdirectory. As well, if the PAWS client is booted
from either a real SRM or from SRM-UX, that server will be assigned
units #5 and #45 as above, regardless of whether the select code, host 
node number, or disk Volume number match the defaults. Assignment of
unit #45 is contingent on the existence of its associated directory.
.P
If either the driver for the card (LAN or DATA_COMM) or the SRM driver
is not in INITLIB, units #5 and #45 will not be connected at all.
.H 3 "Custom Configurations"
.SP
.P
One can imagine wanting to make several modifications to the above
scheme: adding more unit entries with which to talk to one server,
being connected to several servers at once, talking to servers over
LAN gateways, etc. Some of these possibilities are allowed for in the 
current implementation.
.SP
.H 4 "Adding Unit Entries"
.SP
.P
This can be achieved in CTABLE. Near the end of the source, there is a
call to tea_srm which passes the number 46. Find this source line by
searching with the EDITOR for /46/, and clone it as many times as you
need extra unit entries. Then modify each clone to assign 
it an unused unit number. Below is an example:
.SP
.nf
with SRM_dav do
   begin
   { tea_srm(46, sc, ba, du);  {free unless booting from HFS 
     hard disc}
     tea_srm(45, sc, ba, du);  {for possible use as the system unit}
   end; {with}
.fi
.SP
.P
Assuming that unit #46 is to be on the same SRM-UX server as #5, you
should modify the commented-out line to look like this:
.SP
.nf
tea_srm(46, sc, ba, du);  {free unless booting from HFS hard disc}
.fi
.SP
.P
If you want to hook up a unit to another interface or server,
see later sections of this document. You will also need to modify some
lines a little farther down. The purpose is to prefix the 
unit down a desired path as the boot-up default.
.SP
.nf
{ if not unit_prefix_successful('#46:?') then zap_assigned_unit(46);}
.fi
.SP
.P
Remove the "{" and the "}" from the line and replace the "?" with the
desired default path. E.g. :
.SP
.nf
if not unit_prefix_successful('#46:/PROJECT/DOCS') then 
      zap_assigned_unit(46);
.fi
.SP
.P
will set up unit 46 pointing to the directory /PROJECT/DOCS, unless that
path can't be found, in which case unit 46 will be erased.
When the source is changed satisfactorily, compile CTABLE and execute it.
Use the FILER's Volumes command to check if things went well. Once the
Unit Table setup is being done correctly, you can copy CTABLE.CODE onto
your boot disk (or SRM-UX boot directory) naming it TABLE, TABLEP33, etc,
as needed for your specific boot setup.
.SP
.H 4 "Accessing Other Volumes"
You need to add or modify a line that calls tea_srm. Set the du value
to the desired volume number. E.g., clone the commented-out line,
and change it to look like this:
.SP
.nf
tea_srm(47, sc, ba, 10);  { free unless booting from HFS hard disc }
.fi
.SP
.P
This sets up unit 47 to talk to volume 10 on the default SRM-UX server.
See the /etc/srmconf discussion above for information on SRM_UX volumes.
Add a line that calls unit_prefix_successful as in the previous section,
and compile and execute as above.
.SP
.H 4 "Accessing Other SRM-UX Servers"
.SP
.P
Add or modify lines that call tea_srm, setting the ba value to the My
Node number (as seen in /etc/srmconf on the other HP-UX SRM-UX server
machine) desired:
.SP
.nf
tea_srm(48, sc, 1, 8);  { free unless booting from HFS hard disc }
.fi
.SP
.P
This sets up unit 48 to talk to volume 8 on an HP-UX machine whose srmd
server is pretending to be SRM host node 1 for this PAWS client.
The relevant part of the /etc/srmconf file on this HP-UX machine might
look like this:
.SP
.nf
# Scott's Workstation
0x80009003542 : 33 : 1 : 160 : 27 : 022 : SRM, BAYES
.fi
.P
where the 98643A in the PAWS client has LAN address 0x80009003542.
Note the value 1 in the "mynode" field. Add a line to call
unit_prefix_successful, compile and execute.
.SP
.H 4 "Gateways"
.SP
.P
Gateways are mechanisms to extend the communication range of a LAN
service. In the case of SRM-UX, a gateway might allow you to "get off"
the local LAN network, and communicate with other LANs, in the same or
another building, or across the country or the world. 
SRM-UX does not directly support gateways, however some alternatives
are available.
.P
The SRM-UX server, an HP-UX machine, has the ability to remote mount
file systems on other HP-UX and non-HP-UX machines. The two main tools
to achieve this are netunam (part of HP's proprietary Remote File Access
or RFA services), and Network File System or NFS, an industry standard
networking solution.
.P
Using RFA, you can provide transparent SRM-UX access to files on other
Series 300 HP-UX machines that are running rfadaemon. In order to do
this, you must first execute a netunam command(s) in the shell on the
SRM-UX server that will later execute srmd. For example, if the root
user on SRM-UX server hpfclw will execute srmd, and wants to provide 
SRM-UX access to the HP-UX machine hpfcsfb he would do this:
.SP
.nf
# netunam /net/hpfcsfb guest:apassword
# /etc/srmd
.fi
.SP
.P
The first parameter to netunam is a network special file. The second
parameter is a valid logname and password combination on hpfcsfb.
See the HP-UX documentation on netunam for details.
.P
Now PAWS machines that get SRM-UX service from hpfclw will be able
to access files on hpfcsfb using the path /net/hpfcsfb, from any
volume starting at "/" on hpfclw.
.P
If you choose to invoke srmd from the /etc/rc file on the SRM-UX
server machine, be sure to write a shell script that is called from rc
to set up all netunam connections before it invokes srmd. Netunam
can only run after inetd is invoked.
.P
Note that uids and gids should match on both the SRM-UX server and the
remote RFA-mounted machine, in order to minimize permissions confusion
and problems.
.P
To use NFS in order to provide remote file system access for SRM-UX, as
root user, install NFS on the SRM-UX server machine.  After NFS is
installed, as root user, at any time, you can mount remote file systems
for which the server has permission.  E.g.  in order to mount the
directory /users on the remote system hpxyzzy, and access it via the
local path /srmserve/usersxyzzy, make sure /srmserve/usersxyzzy exists
on the SRM-UX server (mkdir creates directories), then execute:
.P
.nf
mount -t nfs hpxyzzy:/users /srmserve/usersxyzzy
.fi
.P
Now, SRM-UX client workstations can access /users on xyzzy via path
/usersxyzzy on the volume associated with /srmserve. Note that
uids and gids should match on both the SRM-UX server and the remote
NFS-mounted machine, in order to minimize permissions confusion and
problems.

