.SP
.H 1 "SRM-UX PAWS Client ERS"
.SP
The specifications described in this document apply to a PRELIMINARY
RELEASE of the SRM-UX product. The specifications are subject to
change. CoLL has NOT committed to provide support for SRM-UX in an
official release of the Pascal Workstation product.
.SP
.H 1 "General Comments"
.SP
.H 2 "Scope of this Document"
.SP
.P
This document describes the tasks required on the workstation side
to get SRM-UX up and running with an HP-UX SRM-UX server and a Pascal
Workstation client. An important and essential companion document
to this ERS is the SRM-UX Server ERS which describes the tasks
which must be done on the server side.
.P
More specifically, this document describes :
.SP
.nf

     1.) H/W requirements and limitations
     2.) The S/W on the PaWS client side
     3.) Filer commands available with SRM-UX volumes
     4.) How to modify your TABLE program to bring SRM-UX
         units and volumes 'on-line' for easy access
.fi
.SP
.SP
.H 1 "SRM-UX on Pascal Workstation"
.P
.H 2 "A Word About Revisions"
.SP
.P
Current plans are to support SRM-UX with the next (version 3.24)
release of the Pascal Workstation. This release
is expected to be available in January of 1991. Note that no formal
commitment has been made for the 3.24 release of Pascal, nor has
there been a formal commitment for SRM-UX support at all. While
we expect this to be coming, no formal commitment has yet been made.
.P
This revision should not require any but a few very special "internals"
PaWS applications to be recompiled. On the HP-UX side, the SRM-UX
product release will require revision 7.0.
.SP
.H 2 "What SRM-UX is NOT"
.SP
.P
SRM-UX will not provide access by other machines to a PaWS file system.
It will not add multi-tasking or multi-user capabilities to PaWS.
It will not change the "look and feel" of the PaWS system as far as
the PaWS user is concerned. It need not, and does not in the 
current implementation, use any ATT or other licensed code.
It does not require significantly greater amounts of RAM or disk
in the PaWS or HP-UX machines over current SRM capabilities.
.SP
.H 2 "PaWS Side"
.SP
.H 3 "Hardware Requirements and Limitations"
.SP
.P
As described elsewhere, SRM-UX may operate over a LAN cable or
an SRM cable. The actual capabilities depend mostly on the bootrom
present in the machine to be used as the client. Series 200 bootrom
revisions were numbered 1 thru 4. Series 300 bootrom revisions
were designated A, A1, B, C, C1 and D.
.SP
.H 4 "Series 200 Workstations"
.SP
.P
Some series 200 machines are capable of operating over either the
LAN cable or SRM cable. By 'operate' we mean communicate with the
SRM-UX server once the client is booted. To operate over the LAN
cable a LAN card is required for the client as the series 200
machines do not have a built in LAN connector (see the server ERS
for details on which Series 200 machines support LAN cards).
.P
Series 200 machines with a Rev. 3 or 4 bootrom may boot from the
SRM-UX server, but only over the SRM cable. Series 200 machines
with Rev. 1 or 2 bootroms cannot ever boot from the SRM-UX server
unless they get an upgrade to a Rev. 3 or 4 bootrom.
.P
No series 200 machine may ever boot from the SRM-UX server over the
LAN cable.
.SP
.H 4 "Series 300 Workstations"
.SP
.P
All series 300 machines are capable of operating over either the
LAN cable or SRM cable. By 'operate' we mean communicate with the
SRM-UX server once the client is booted. Series 300 machines
without a built in LAN connector will need a LAN card to operate
over the LAN cable.
.P
All series 300 machines may boot from the server over the SRM cable.
Only series 300 machines with a Rev. B or later bootrom may boot over
the LAN cable from the server (any Series 300 with an older bootrom
may be upgraded to Rev. B to support booting over the LAN cable).
.SP
.SP
.H 3 "Software Description"
.P
On the PaWS side, modified existing drivers use the new LAN driver,
introduced in revision 3.22, to communicate with the srmd server as
though it were an SRM. The PaWS file system code sends data and commands
to the PaWS SRM driver, SRM, in the same way it always has. SRM
creates standard Ganglink packets for the transactions, then checks
to see if the transactions are aimed at a LAN or an SRM card. If they
are going to SRM, they go out as usual. If they are going to LAN, they
are wrapped in the LAN transport protocol by the LANSRM part of SRM,
and shipped.
.SP
.P
Packets incoming to PaWS on SRM wires are treated as usual. Packets
incoming from LAN are stripped of their transport protocol by the
LANSRM part of SRM and presented to SRM as though they had come from
the SRM card. The PaWS side approach minimizes new code, with its
attendant risk of new defects.
.SP
.H 3 "Miscellaneous Compatibility Issues"
.SP
.P
Node numbers - Currently, when using the 98643A card, PaWS replaces
the real SRM's 2-digit "system volume" node number with a 6-digit
number that is the last 6 digits of the LAN card address. We do this
in order to provide a unique name for the "*" directory: e.g.
"/WORKSTATIONS/SYSTEM001234". The uniqueness is desirable, the
change from 2 to 6 digits may not be. However, with 2 digits,
we cannot automatically provide unique numbers. (Note - any
alphabetic characters in the hex address must be capitalized in the 
name of the directory, i.e. /WORKSTATIONS/SYSTEM0034EF works but
/WORKSTATIONS/SYSTEM0034ef does not).
.P
The configuration file for SRM-UX, /etc/srmdconf,
contains a field called "Client Node"
that provides a 2-digit emulated node number for the host 
that RMB will use. PaWS will not be able to use the 2-digit number
for assigning the "*" directory, as the value is not available to
PaWS at the right time. The 2-digit value will be available to
applications which run after the boot completes, using an
existing PaWS "internal" procedure.

.P
TABLE is a configuration program for PaWS; it sets up the entries in
the PaWS unit table, usually at boot time. The code file TABLE is on
the boot microfloppy that HP ships with PaWS, and should be copied to
a boot directory on the SRM-UX server. The source for TABLE, called
CTABLE.TEXT, is supplied with PaWS on the ACCESS: or CONFIG: disks,
so that the user can easily modify the unit table configuration.

.SP
.H 2 "SRM and LANSRM"
.SP
.P
On the PaWS side, the Operating System and user applications communicate
with srmd using these drivers: LAN, DATA_COMM, and SRM. The drivers
normally are inserted into INITLIB using the techniques described
in Pascal 3.2 Workstations System, Vol. 2, in the chapter Special
Configurations. The file system driver SRM uses either of the device
drivers LAN or DATA_COMM, depending on whether the application is
communicating via a 98643A LAN card or via a 98629A SRM card.
.P
If one of these cards is not present in the system, or it is desired
not to use the card, the associated driver may be left out of INITLIB.
SRM can not be omitted from INITLIB if any SRM communication is
desired at all using either interface. The file LAN actually contains
2 modules: IOMPX and LAN. These must both be put into 
INITLIB for SRM-UX to work with 98643A cards, and must retain
their relative ordering: IOMPX must come before LAN.
.P
Using SRM-UX on a 98643A card in PaWS does not preclude using the
card simultaneously for other applications, for example the NRC FUSION
software (ftp and telnet utilities). IOMPX provides multiplexed access
to the LAN card. The 98629A card can only be used for SRM. It is not
a general purpose I/O card.
.SP
.H 2 "PaWS FILER with SRM-UX"
.SP
.P
The FILER commands available to the PaWS user will be a mixture
of SRM and HFS commands. For SRM-UX volumes the filer will
display BOTH file locking and HFS permissions information when
the extended listing request is made.

For a normal listing,
the only difference visible to the user will be where the
filer displays 'Directory type ='. For SRM volumes, something
like Directory type = SRM 21,0,8 is displayed. This shows the
information select code = 21, bus address = 0, and disk unit =
8. For HFS volumes, Directory type = 777      17     9  will
be displayed, indicating file protections 777 and uid = 17,
gid = 9. For SRM-UX volumes, Directory type = SRM-UX 21,0,8
will be displayed, i.e. the SRM type of information is
simulated.

For an extended listing with an SRM-UX volume,
the field '..directory info...' will be
enhanced to show both the SRM 
like file locking status for the file, and also the HFS
permissions associated with the file. For example,
currently SRM volumes may display
.NF

           ..directory info...
           MRWSPC CLOSED

.FI
.P
Also, the words SHARED, EXCLUSIVE and CORRUPT may replace CLOSED
in the directory info description. Of course, CLOSED, SHARED and 
EXCLUSIVE represent the file locking attributes held by the
file.

MWRSPC describes access rights to the file.

HFS volumes will display
.NF

           ..directory info...
           d777m    17u     9g

.FI
.P
If the file is not a directory, 'd' will be blank. The '777'
entry describes the file protections, 17 and 9 the user and
group id's associated with the file.

For SRM-UX volumes, the directory info field will contain a
mixture of these two formats. The HFS info will remain in
place, and also two letters will indicate the current file
locking status with 'CL' for closed, etc. :
.NF

           ...directory info.....
           d777m    17u     9g CL

.FI
Here 'CL' could also be 'EX', 'SH' or 'CO'.
.SP
.H 3 "New Commands"
.SP
.P
There will be some new commands available to the user for SRM-UX
volumes, in particular controlling HFS permissions for SRM-UX
from the workstation will be new. What will this look like ? 
Basically, the FILER's HFS command will be enhanced to work
with SRM-UX units as well as HFS units (note that for the
workstation, HFS usually means a local hard disk and not the file
system being shared with the HP-UX server). For files to which
the workstation has access, the UID and GID fields may be
modified, as well as the file mode which describes access
rights for owner, group and other. 

Currently when one tries to perform an SRM only function
on another file system, an error of 'undefined operation for
unit or file' is reported. The SRM functions allowable for
SRM-UX volumes (some aspects of the Access command) will
be loosened up so they will work with SRM-UX volumes,
likewise for HFS functions allowable for SRM-UX volumes.

.SP
.H 2 "Configuring the PaWS Unit Table"
.SP
.H 3 "Default Configurations"
.SP
.P
TABLE configures the various drivers and devices into the unit table.
By default it will configure disk Volume 8 on any SRM or SRM-UX whose
host node number is 0 and which is connected to a 98643A or 98629A
at select code 21 in the PaWS machine, into the unit 
table at unit entry #5. In addition, if the subdirectory 
/WORKSTATIONS/SYSTEMnnnnnn (or /WORKSTATIONS/SYSTEMnn for a 98629A 
card) or /WORKSTATIONS/SYSTEM exists, unit entry #45 will be created and
associated with that subdirectory. As well, if the PaWS client is booted
from either a real SRM or from SRM-UX, that server will be assigned
units #5 and #45 as above, regardless of whether the select code, host 
node number, or disk Volume number match the defaults. Assignment of
unit #45 is contingent on the existence of its associated directory.
.P
If either the driver for the card (LAN or DATA_COMM) or the SRM driver
is not in INITLIB, units #5 and #45 will not be connected at all.
.H 3 "Custom Configurations"
.SP
.P
One can imagine wanting to make several modifications to the above
scheme: adding more unit entries with which to talk to one server,
being connected to several servers at once, etc.
Some of these possibilities are allowed for in the 
current implementation.
.SP
.H 4 "Adding Unit Entries"
.SP
.P
This can be achieved in CTABLE. Near the end of the source, there is a
call to tea_srm which passes the number 46. Find this source line by
searching with the EDITOR for /46/, and clone it as many times as you
need extra unit entries. Then modify each clone to assign 
it an unused unit number. Below is an example:
.SP
.nf
with SRM_dav do
   begin
   { tea_srm(46, sc, ba, du);  {free unless booting from HFS 
     hard disc}
     tea_srm(45, sc, ba, du);  {for possible use as the system unit}
   end; {with}
.fi
.SP
.P
Assuming that unit #46 is to be on the same SRM-UX server as #5, you
should modify the commented-out line to look like this:
.SP
.nf
tea_srm(46, sc, ba, du);  {free unless booting from HFS hard disc}
.fi
.SP
.P
If you want to hook up a unit to another interface or server,
see later sections of this document. You will also need to modify some
lines a little farther down. The purpose is to prefix the 
unit down a desired path as the boot-up default.
.SP
.nf
{ if not unit_prefix_successful('#46:?') then zap_assigned_unit(46);}
.fi
.SP
.P
Remove the "{" and the "}" from the line and replace the "?" with the
desired default path. E.g. :
.SP
.nf
if not unit_prefix_successful('#46:/PROJECT/DOCS') then 
      zap_assigned_unit(46);
.fi
.SP
.P
will set up unit 46 pointing to the directory /PROJECT/DOCS, unless that
path can't be found, in which case unit 46 will be erased.
When the source is changed satisfactorily, compile CTABLE and execute it.
Use the FILER's Volumes command to check if things went well. Once the
Unit Table setup is being done correctly, you can copy CTABLE.CODE onto
your boot disk (or SRM-UX boot directory) naming it TABLE, TABLEP33, etc,
as needed for your specific boot setup.
.SP
.H 4 "Accessing Other Volumes"
You need to add or modify a line that calls tea_srm. Set the du value
to the desired volume number. E.g., clone the commented-out line,
and change it to look like this:
.SP
.nf
tea_srm(47, sc, ba, 10);  { free unless booting from HFS hard disc }
.fi
.SP
.P
This sets up unit 47 to talk to volume 10 on the default SRM-UX server.
See the /etc/srmdconf discussion above for information on SRM_UX volumes.
Add a line that calls unit_prefix_successful as in the previous section,
and compile and execute as above.
.SP
.H 4 "Accessing Other SRM-UX Servers"
.SP
.P
Add or modify lines that call tea_srm, setting the ba value to the
Server Node number (as seen in /etc/srmdconf on the other HP-UX
SRM-UX server machine) desired:
.SP
.nf
tea_srm(48, sc, 1, 8);  { free unless booting from HFS hard disc }
.fi
.SP
.P
This sets up unit 48 to talk to volume 8 on an HP-UX machine whose srmd
server is pretending to be SRM host node 1 for this PaWS client.
The relevant part of the /etc/srmdconf file on this HP-UX machine might
look like this:
.SP
.nf
# ABC's Workstation
0x80009001234 : 33 : 1 : 160 : 27 : 022 : SRM, ABC
.fi
.P
where the 98643A in the PaWS client has LAN address 0x80009001234.
Note the value 1 in the "server node" field. Add a line to call
unit_prefix_successful, compile and execute.
.SP

