.SA 1
.H 1 "	    SRM-UX RMB Client ERS - 2/22/90"
.SP
.H 2 "What is an SRM-UX RMB Client?"
.SP
.P
An SRM-UX RMB client is an HP Series 200 or 300 RMB/WS system that
communicates with an SRM-UX server, which is emulating a Shared Resource
Manager (SRM) host.  
(See the SRM-UX Server ERS for a description of the server.)
.SP
.H 2 "Software required"
.SP
.P
BASIC 6.x will bundle 
in the LAN driver developed for a third party and will modify 
the SRM driver to be able to use LAN to talk to the SRM-UX server. 
(The value of x is still under investigation, depending on how the
6.0 release is redefined.)
RMB workstation users will be able to boot up over LAN or SRM from
this server and use the HP-UX file system, dictated by constraints
set by the HP-UX system administrator.
.P
Minor changes
will be required in the Mainframe mass storage system and in
the TRANS binary.  These will be transparent to the user.
.P
A schematic of the software and hardware components follows.   
Arrows indicate dependency (e.g., the SRM binary will not run
over LAN cables without the LAN binary).  The FUSION box 
represents the NRC software that requires the LAN binary to 
work.  The modifications made to the 
LAN and SRM binaries will not impact use of the FUSION package
(this assumption will need to be tested during QA). 
.P
.nf
	 ----------                      -----------
	| FUSION   |                    | SRM BINARY|
	 ----------                      -----------
	      |                            |  |
	      |      ----------------------   |
	      |      |                        |   
	     \\ /    \\ /                       |
	    -----------                       |
	   | LAN BINARY|                      |
	    -----------                       |
		 |                            |
		 |                            |
		\\ /                          \\ /
	    -----------                  -----------
	   |  LAN CARD |                | SRM CARD  |
	    -----------                  ----------- 
		 |                            |
	 to SRM-UX over LAN           to SRM-UX over SRM 
.fi
.SP
.P
Note that the SRM binary is required for communicating to the server 
over LAN.
.SP
.H 2 "Booting from SRM-UX"
.SP
.P
Booting up from the SRM-UX server will be the same as 
booting up from any device.  Selection of the appropriate
system will be done from the menu provided by the bootrom. 
See the SRM-UX Server ERS for a complete discussion of booting from SRM-UX.
A few points particular to RMB are covered here.
.SP
.H 3 "Loading the SRM and LAN Binaries"
.SP
.P
As with the SRM, a user can load specific binaries without
having the LAN or SRM binaries loaded (if the server's /etc/boottab file
has been set up to allow this).  
If access to the server's file system is required, then the 
SRM and LAN binaries must be loaded (only the SRM binary is required to
access SRM-UX over SRM cards).
When booting over LAN cards, and loading binaries individually,
the SRM binary MUST be loaded before the LAN binary.
It is recommended that the STORE SYSTEM statement be used to
include the LAN and SRM binaries with the boot file for RMB.  This will
make configuring the server to support RMB considerably simpler.
.SP
.H 3 "Autostart Files"
.SP
.P
If /SYSTEMS/AUTOSTnn is requested but not 
present, /AUTOST will be requested instead.
When booting from the LAN, unless both the
SRM and LAN binaries are stored with the booted system,
the bootrom can only load the generic /AUTOST file 
because the emulated SRM node number is not available.
.P
Although the recommended method of booting RMB is to include 
the LAN and SRM binaries with the boot file (using STORE SYSTEM), 
an alternative is to have a /AUTOST file which
loads the SRM and LAN binaries and then queries the 
LAN card for its pseudo node number.  This program can
then load the node-specific file, /SYSTEMS/AUTOSTxx.  Such
a program is listed below:
.SP
.nf
    10    ! RE-STORE "/AUTOST"
    11    !  Suggested generic AUTOSTART file for deriving a 
    12    !  pseudo node number of a LAN card and loading the 
    13    !  appropriate node-specific AUTOST file
    14    DIM Str$[80]
    15    INTEGER Node
    17    LOAD BIN "/SYSTEMS/SRM"  !  MUST LOAD THIS ONE FIRST
    19    LOAD BIN "/SYSTEMS/LAN"
    21    Str$=SYSTEM$("MSI")
    29    STATUS VAL(Str$[9;2]),6;Node
    31    ON ERROR GOTO Errortrap
    35    LOAD "/SYSTEMS/AUTOST"&VAL$(Node)
    39    ! if LOAD succeeds, will not reach here
    41 Errortrap: !
    42    OFF ERROR 
    43    IF ERRN<>56 THEN PRINT ERRM$
    46    END
.fi
.SP
.H 2 "MSVS for accessing SRM-UX"
.SP
.P
Users will address the SRM-UX server's file system in the 
same way as they address the SRM currently.  They will
provide the select code, host node number, and volume name
in the form  ":REMOTE <sc>,<hn#>;LABEL <volname>", e.g.
.SP
.nf
	   :REMOTE 21,0;LABEL DISC1
.fi
.SP
which is the same as a standard SRM msvs.  The host node number
and volume name are determined by the mapping maintained 
in the /etc/srmdconf file by the server administrator.
.P
Because the msvs will not distinguish between an actual SRM 
server file system and the SRM/UX server file system, the 
user can execute the following program segment to find out which
type of file system he is accessing:
.SP
.nf
    DIM A$(0:2)[80]
    MSI ":REMOTE 21,0; LABEL DISC1"  ! or whatever the msvs
    CAT TO A$(*)
    PRINT A$(2)
.fi
.SP
.P
The result "FORMAT: SDF" will indicate that he is accessing a
true SRM, while "FORMAT: SRM-UX" will indicate that he is accessing an
SRM/UX file system.  (This applies for both LAN and SRM cards.)
.SP
.H 2 "Compatibility with the SRM"
.SP
.P
Almost all file system operations will be identical to the current SRM
file system operations.  There are a few exceptions, which are discussed
below:
.SP
.H 3 "Passwords/Access Control"
.SP
.P
The main difference between SRM and SRM-UX involves control of file
access.  SRM uses passwords, whereas the SRM-UX server must use the 
standard HP-UX user/group/other-read/write/execute permission scheme to
protect HP-UX users and processes on the server.  There is no good
mapping of the SRM passwords onto the HP-UX scheme.
.P
Instead the existing keywords that implement security for local HFS disks
(PERMIT, CHOWN, and CHGRP) will be enhanced to provide access control
for SRM-UX as well (within the limits of what the server administrator 
chooses to allow each client).  
The statements' syntax will not change, except to 
allow SRM-UX file names in addition to local HFS file names.
.P
Attempting to use a PROTECT statement on an SRM-UX file will cause an
error.  This is done to avoid misleading the user as to what security exists
on a file.  Using SRM style passwords in pathnames for ordinary file access
operations will be ignored.  This will make porting applications easier.
.SP
.H 3 "CAT format"
.SP
.P
The output of the CAT statement from SRM-UX will be different from SRM
to reflect the HFS-like permissions instead of the SRM passwords.
The format will be the same as HFS CAT output, except that the 
FORMAT field in the header will say "SRM-UX", 
and 16 character file names will be
supported instead of the 14 that HFS allows.  The server will hide
file names longer than 16 characters from the RMB client. 
.SP
.H 3 "Volume Labels"
.SP
.P
Attempting to use a PRINT LABEL on an SRM-UX volume will generate an
error.  The server obtains its emulated volume labels from /etc/srmdconf; 
there is not actually a real volume label associated with SRM-UX volumes.
There is no mechanism for an RMB client to change the server's emulated
volume labels.
.SP
.H 2 "LINK statement"
.SP
.P
The LINK statement is currently supported only for HFS disks.  It will
be enhanced to work on SRM-UX and SRM disks as well.  (The existing SRM
host supports the LINK functionality, but RMB currently doesn't take 
advantage of it; only PAWS does.)  The LINK 
statement syntax will not change, except to allow SRM-UX and SRM file
names in addition to local HFS file names.
.SP
.H 2 "LAN Interface Status/Control Registers"
.SP
.P
These registers have not been made available to users in the LAN 
driver provided to NRC for FUSION.  Status registers will 
be implemented to correspond as closely as possible with 
the SRM status registers, except that there will be 
additional registers for which there is no SRM analog.  
In addition, LAN has some control registers which will be 
made available.  
.SP
.nf
    Status
    Register          Meaning   
	0        Card Identification              
                    21 if the Remote Control switch (R) is set to 0
		   149 if the switch is set to 1 

	1        Interface Interrupts
		     1 = interrupts enabled 
		     0 = interrupts disabled 
 
	2        Not implemented  (Interface busy on SRM)

	3        Not implemented  (Interface Firmware ID on SRM) 

	5        Data Availability
		     0 = receiver buffer empty 
			It will always give this, as the
			performance of the LAN card is so 
			high that the BASIC user will never 
			perceive any other situation.
 
	6        Node Address
		     When the SRM binary is loaded, a "pseudo"
		     node number will be provided by the SRM-UX
		     server (from /etc/srmdconf).  This 2-digit 
		     number will be used for a node-specific 
		     autostart file (e.g., /SYSTEMS/AUTOSTxx ).  
		     If the SRM binary is not loaded, STATUS of 
		     this register will return 0.

	7        CRC Errors (and Frame Errors)
		     Cyclic redundancy check errors plus frame 
		     errors detected since powerup or reset

	8        Number of Buffer Overflows
		     in receive buffers since powerup or reset

	9        Card State       
		     0 = Card not powered up
		     1 = Card buffers incorrectly defined
		     2 = Data/address ports not responding
		     3 = Card stopped
		     4 = Normal operation
		     5 = Driver detected a non-recoverable
		          hardware error; card is stopped

       11        Available Space in Transmit Buffer

       12        Number of Transmission Retries
		     since powerup or reset

       21-26     Link Address   6 Bytes

    Control
    Register          Meaning         

       18        Initialize driver statistics to 0
		     Ordinarily done at power up

       35        Set Default Configuration
		     Causes driver to set all of its pseudo 
		     registers to power up defaults;  
		     Hardware is not reconfigured 

			Link address is set from interface card RAM
			MODE is set to 0
			Multicast mask is set to all 0's
			Receive buffer size is set to 32
			Number of receive buffers is set to 320
			Number of transmit buffers is set to 4
			LAN stats are set to zero
.fi

