
/*
** Small-C Compiler Version 2.0
**
** Copyright 1982 J. E. Hendrix
**
** Part 1
*/

#include "stdiol.h"
#include "cc.def"

/*
** miscellaneous storage
*/
char

#ifdef OPTIMIZE
  optimize, /* optimize output of staging buffer */
#endif /* OPTIMIZE */

  alarm,    /* audible alarm on errors? */
  monitor,  /* monitor function headers? */
  pause,    /* pause for operator on errors? */
  m80flg,   /* compile for M80 assembler? */

#ifdef DYNAMIC
 *stage,    /* output staging buffer */
 *symtab,   /* symbol table */
 *litq,     /* literal pool */

#ifdef HASH
 *macn,     /* macro name buffer */
#endif /* HASH */

 *macq,     /* macro string buffer */
 *pline,    /* parsing buffer */
 *mline,    /* macro buffer */

#else /* DYNAMIC */
  stage[STAGESIZE],
  symtab[SYMTBSZ],
  litq[LITABSZ],

#ifdef HASH
  macn[MACNSIZE],
#endif /* HASH */

  macq[MACQSIZE],
  pline[LINESIZE],
  mline[LINESIZE],
  swq[SWTABSZ],
#endif /* DYNAMIC */

 *line,     /* points to pline or mline */
 *lptr,     /* ptr to either */
 *glbptr,   /* ptrs to next entries */
 *locptr,   /* ptr to next local symbol */
 *stagenext,/* next addr in stage */
 *stagelast,/* last addr in stage */
  quote[2], /* literal string for '"' */
 *cptr,     /* work ptrs to any char buffer */
 *cptr2,
 *cptr3,

#ifdef CMD_LINE
#ifdef FULLC
 *argvs[MAXARGS],   /* static copy of argv */
#endif  /* FULLC */
#endif  /* CMD_LINE */

  msname[NAMESIZE], /* macro symbol name array */
  ssname[NAMESIZE]; /* static symbol name array */


int

#ifdef STGOTO
  nogo,     /* > 0 disables goto statements */
  noloc,    /* > 0 disables block locals */
#endif /* STGOTO */

/*
** the following two definitions are arrays of pointers to functions
** and should look like this:
**      (*op)()[16],
**      (*op2)()[16],
** but small-c cheats and declares an array of ints
*/
  op[16],   /* function addresses of binary operators */
  op2[16],  /* same for unsigned operators */
  opindex,  /* index to matched operator */
  opsize,   /* size of operator in bytes */
  swactive, /* true inside a switch */
  swdefault,/* default label #, else 0 */
 *swnext,   /* address of next entry */
 *swend,    /* address of last table entry */

#ifdef DYNAMIC
 *wq,       /* while queue */
#else /* DYNAMIC */
  wq[WQTABSZ],
#endif /* DYNAMIC */

#ifdef CMD_LINE
  argcs,    /* static argc */

#ifdef N_CMD_LN

#ifndef FULLC
  argvs[MAXARGS], /* static argv (new_cmd_line && !full_c) */
#endif  /* FULLC */

#else  /* N_CMD_LN */
 *argvs,    /* static argv (original version) */
#endif  /* N_CMD_LN */

#endif /* CMD_LINE */

 *wqptr,    /* ptr to next entry */
  litptr,   /* ptr to next entry */
  macptr,   /* macro buffer index */

#ifndef HASH
  mack,     /* variable k for findmac routine */
#endif /* HASH */

  pptr,     /* ptr to parsing buffer */
  oper,     /* address of binary operator function */
  ch,       /* current character of line being scanned */
  nch,      /* next character of line being scanned */
  declared, /* # of local bytes declared, else -1 when done */
  iflevel,  /* #if... nest level */
  skiplevel,/* level at which #if... skipping started */
  func1,    /* true for first function */
  nxtlab,   /* next avail label # */
  litlab,   /* label # assigned to literal pool */
  beglab,   /* beginning label -- first function */
  csp,      /* compiler relative stk ptr */
  argstk,   /* function arg sp */
  argtop,
  ncmp,     /* # open compound statements */
  errflag,  /* non-zero after 1st error in statement */
  eof,      /* set non-zero on final input eof */
  input,    /* fd # for input file */
  input2,   /* fd # for "include" file */
  output,   /* fd # for output file */
  files,    /* non-zero if file list specified on cmd line */
  filearg,  /* cur file arg index */
  glbflag,  /* non-zero if internal globals */
  ctext,    /* non-zero to intermix c-source */
  ccode,    /* non-zero while parsing c-code */
            /* zero when passing assembly code */
  listfp,   /* file pointer to list device */
  lastst,   /* last executed statement type */
 *iptr;     /* work ptr to any int buffer */

#ifdef C80
extern int fin, fout;
#endif /* C80 */

#ifdef SEPARATE
#ifdef LINK
#ifdef PDS
#asm
CC2.R:LIBRY
CC3.R:LIBRY
CC4.R:LIBRY
#endasm
#endif /* PDS */
#endif /* LINK */

extern int
  addmac(),  addsym(),  addwhile(),  amatch(),  blanks(),
  bump(),  clearstage(),  col(),  delwhile(),  endst(),
  error(),  findglb(),  findloc(),  gch(),  getint(),
  getlabel(),  illname(),  inbyte(),  inline(),  junk(),
  kill(),  lout(),  match(),  multidef(),  needtoken(),
  nextsym(),  nl(),  numeric(),  outbyte(),  outdec(),
  postlabel(),  preprocess(),  printlabel(),  putint(),
  readwhile(),  setstage(),  sout(),  streq(),  symname(),
  upper(), xgets();

extern int
  constexpr(),  expression(),  number(),  qstr(),
  test(),  stowlit();

extern int
  /*
  ** arithmetic routines prefaced with "zz" to keep M80
  ** assembler from generating error msgs when this is compiled
  */
  zzadd(),  zzand(),  zzasl(),  zzasr(),  defstora(),
  zzdiv(),  zzeq(),  entry(),  external(),  zzge(),
  zzgt(),  header(),  jump(),  zzle(),  zzlt(),  zzmod(),  modstk(),
  zzmult(),  zzne(),  zzor(),  point(),  ret(),  zzsub(),  sw(),
  trailer(),  uge(),  ugt(),  ule(),  ult(),  zzxor();
#endif /* SEPARATE */

#include "cc11.c"
#include "cc12.c"
#include "cc13.c"

#ifndef SEPARATE
#include "cc21.c"
#include "cc22.c"
#include "cc31.c"
#include "cc32.c"
#include "cc33.c"
#include "cc41.c"
#include "cc42.c"
#endif /* SEPARATE */
cc22.c"
#include "cc31.c"