/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xstat.c,v 1.2 87/04/24 16:53:29 davidb Exp $ */
/*
$Header: xstat.c,v 1.2 87/04/24 16:53:29 davidb Exp $
 /* Revision 1.2  86/10/23  14:48:48  mark
 * returns name of file stripped, of path information
 * 
 * Revision 1.1  86/10/10  12:36:03  mark
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  14:23:30  mark
 * merging in new ftp
 * 
 * Revision 1.3  86/09/29  17:02:26  mark
 * added ability to identify binary record files
 * 
 * Revision 1.2  86/09/04  20:44:48  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  17:56:43  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:00:30  mark
 * Initial revision
 * 

Unix specific function for obtaining file attributes
*/
#include <xspecial.h>
#include <xstat.h>
#include <xctype.h>
#include <ex_errno.h>	/* Contains constants used by XMAPERRNO(). */
#include <UnixXos.h>	/* Contains XMAPERRNO(). dab 861219. */
#include <xfs.h>
#include <sys/types.h>
#include <sys/stat.h>

extern int errno;
extern char *xstrrchr();
static int xtypestream();


xstat( name, special, info )
char *name;
int special;
struct xstatbuf *info;
{
	int rval;
	char buf[MXNAMELEN + 1];
	struct stat statb;
	char *ncompo;

	info->x_ptype = NATIVE;
	if( ncompo = xstrrchr( name, '/' ) )
		info->x_ncompo = ncompo + 1;
	else
		info->x_ncompo = name;
	/*
	Translate file name
	*/
	rval = xmodname( &name, special, buf, sizeof( buf ) );
	if( rval < 0 )
		return( rval );
	/*
	get Unix stat info
	*/
	rval = stat( name, &statb );
	if( rval < 0 ) {
		return( XMAPERRNO(errno) );
	}
	info->x_mode = statb.st_mode & ~( X_IFBIN | X_IFTEXT | X_PREAD |
			X_PWRITE | X_PEXEC );
	info->x_size = statb.st_size;
	info->x_osinfo = (char *)0;
	/*
	check permissions for this process
	*/
	if ( !access( name, 2 ) ) {
		info->x_mode |= X_PWRITE;
	}
	if ( !access( name, 1 ) ) {
		info->x_mode |= X_PEXEC;
	}
	if ( access( name, 4 ) ) {
		return( 0 );
	}
	info->x_mode |= X_PREAD;
	/*
	get protocol info ( ascii vs binary at the moment )
	*/
	if( info->x_mode & X_IFREG ) {
		rval = open( name, 0, 0 );
		if( rval < 0 ) {
			xperror( XMAPERRNO(errno), "xstat(open)" );
			return( 0 );	/* OK, we just don't know
				what kind of data */
		}
		info->x_mode |= xtypestream( rval );
		close( rval );
	}
	return( 0 );
}

static
xtypestream( fd )
{
	char buf[50];
	int cnt;
	char *pt;
	char *rm_pt = RECORDMARK;
	int rm_sz = sizeof( RECORDMARK ) - 1;

	cnt = read( fd, buf, sizeof( buf ) );
	/*
	if first fifty characters are printable,
	its an ascii file
	*/
	if( cnt <= 0 ) {
		xperror( XMAPERRNO(errno), "xstat(read)" );
		return( 0 );
	}
	for ( pt = buf ; rm_sz > 0 ; --rm_sz, ++pt, ++rm_pt ) {
		if( *pt != *rm_pt )
			break;
	}
	if( rm_sz == 0 ) {
		return( X_IFBIN | X_IFRECORD );
	}
	for ( pt = buf ; cnt > 0 ; --cnt, ++pt ) {
		if( !isascii( *pt ) )
			return( X_IFBIN );
	} 
	return( X_IFTEXT );
}
