/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xinit_env.c,v 1.3 87/04/24 16:51:15 davidb Exp $ */
/*
@(#)xinit_env.c	1.7 6/3/85

Unix implementation of xinit_env(3X).
*/
#include <pwd.h>
#include <xerrno.h>


char	username[20] = "USER=";
char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
#ifdef pcxenix
char	logname[64] = "LOGNAME=";
char	hz[ sizeof( "HZ=50" ) ] = "HZ=50";
char	*envinit[] =
	    {homedir, shell, "PATH=:/usr/ucb:/bin:/usr/bin", username,
		logname, hz, 0};
#else	/* pcxenix */
#ifdef BSD4dot2 /* ger */
char	*envinit[] =
 	    {homedir, shell, "PATH=:/usr/ucb:/bin:/usr/bin:/usr/local:/usr/local/bin:/usr/new:~/bin", username, 0};
#else	/* BSD4dot2 */
char	*envinit[] =
	    {homedir, shell, "PATH=:/usr/ucb:/bin:/usr/bin", username, 0};
#endif	/* BSD4dot2 */
#endif	/* pcxenix */
extern char	**environ;

extern struct passwd *getpwnam();
extern char *crypt();

char *xghome;

xinit_env( name, password, account, checkpasswd )

char *name;	/* loggin name */
char *password;	/* password */
char *account;	/* not meaningful */
int checkpasswd; /* if non-zero check password */
{
char *xpassword;	/* encrypted password */
struct passwd *pw;
int rval;

if ( !name )
	return( 0 );
/*
get user loggin info.
*/
pw = getpwnam( name );
if( !pw )
	{
	return( (password)? XEACCES : 0 );
	}
if( checkpasswd && pw->pw_passwd && *(pw->pw_passwd) )
	{
	if( !password )
		return( 0 );
	xpassword = crypt( password, pw->pw_passwd );
	if( strcmp( xpassword, pw->pw_passwd ) )
		return( XEACCES );
	}
#ifdef scoxenix5
/*
 *  SCO XENIX is reluctant to set the uid.  The "fix" is the reaffirm
 *  to XENIX that we are root before changing our uid.
 */
setuid(0);
setgid(0);
#endif
#ifdef BSD4dot2
rval = initgroups( pw->pw_name, pw->pw_gid);
#else
rval = setgid( pw->pw_gid);
#endif
if( rval < 0 )
	{
	return( XEACCES );
	}
if( chdir(pw->pw_dir) )
	{
	return( XENOTDIR );
	}
rval = setuid( pw->pw_uid);
if( rval < 0 )
	return( XEACCES );
/*
successful loggin, setup globals used by xglob and return.
*/
xghome = pw->pw_dir;
	environ = envinit;
	xstrncat(homedir, pw->pw_dir, sizeof(homedir)-6);
	xstrncat(shell, pw->pw_shell, sizeof(shell)-7);
	xstrncat(username, pw->pw_name, sizeof(username)-6);
#ifdef pcxenix
	xstrncat(logname, pw->pw_name, sizeof(logname)-8);
#endif	/* pcxenix */
return( 1 );
}
