/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: mux_io.c,v 1.2 87/04/24 16:48:43 davidb Exp $ */
/*
@(#)mux_io.c	1.5 5/8/85
Unix version of mux_io(3X)

Some implementation notes:

There are three issues which make mux_io difficult to implement on
Unix.
	1) need to avoid deadlock when either the network, terminal
	or both are idle.
	2) Strong desirability of sharing data between the activity of
	reading the terminal, and that of reading the network.
	3) need for fair scheduling when both network and terminal
	are active.  This is due to the fact that user input may
	alter how the network data is to be processed, as with data
	flushing in telnet.

	This module supports two implementations of xmux_io, one
	which satisfies (1) and (3), and one which satisfies
	(1) and (2).  The former uses two Unix processes.  The
	latter uses signals to schedule network io.

	The global variable _syskill determines which method is to be used.
	If it is 0 we use the 1-2 method.  Otherwise, we use the 1-3 method.
	The 1-2 method has the additional advantage that the process which
	called xmux_io needn't be terminated when the processing is finished.
*/

#include <sys/soioctl.h>
#include <signal.h>

static int aspid = 0;
int _dead = -1;
int _syskill = 0;			/* use kill, vs. just fall out of
					  xmux_io */
static int (*netproc)() = 0;
static int pidgen = 0;
static int od2 = 0;

static
netread( od )
	int od;
{
	int rval;

	rval = (*netproc)( aspid, od, od2 );
	if( rval == 0 ) {
		/*
		descriptor is closed, stop selecting on it.
		*/
		xsetasync( od, (int (*)())0, 2 );
	}
}


xmux_io( serv_id, io_proc1, rfd1, wfd1, io_proc2, rfd2, wfd2 )

	char *serv_id;	/* service identifier, see getclient(3X) */
	int (*io_proc1)();	/* Network to terminal process */
	int rfd1;	/* descriptor for first process to read */
	int wfd1;	/* descriptor for first process to write */
	int (*io_proc2)();	/* Terminal to network process */
	int rfd2;	/* descriptor for second process to read */
	int wfd2;	/* descriptor for second process to write */
{
	int pid;
	int mypid;
	int hispid;
	int how = 1;
	int rval;

	if ( _syskill ) {
		mypid = getpid();
		hispid = fork();  /*create new process with same text segment*/
		if( hispid < 0 )
			exit(1);
		signal( SIGINT, SIG_IGN );
		for( ;; ) {
			if ( hispid ) {
				/*
				Code executed by the old process
				*/
				(*io_proc1)( hispid, rfd1, wfd1 );
			} else {
				/*
				Code executed by the new process
				*/
				(*io_proc2)( mypid, rfd2, wfd2 );
			}
		}
	} else {
		mypid = pidgen++;
		hispid = pidgen++;
		netproc = io_proc1;
		aspid = mypid;
		od2 = wfd1;
		rval = xioctl( rfd1, FIONBIO, &how );
		if( rval < 0 ) {
			xperror( rval, "xmux_io:FIONBIO" );
			return;
		}
		xsetasync( rfd1, netread, 2 );
		for( ;; ) {
			if( _dead  == mypid ) {
				break;
			}
			if( _dead == hispid ) {
				break;
			}
			(*io_proc2)( mypid, rfd2, wfd2 );
		}
		xsetasync( rfd1, (int (*)())0, 2 );
	} /* if _syskill */
}
