/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xftpsndid.c,v 1.4 87/04/24 16:16:45 davidb Exp $ */
/*
$Header: xftpsndid.c,v 1.4 87/04/24 16:16:45 davidb Exp $
$Log:	xftpsndid.c,v $
 * Revision 1.4  87/04/24  16:16:45  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:37:03  grant
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/11/14  18:40:33  mark
 * read password regardless of type of input device
 * 
 * Revision 1.4  86/11/12  18:42:34  alexl
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:44:15  mark
 * merging in changes for new ftp
 * 
 * Revision 1.3  86/09/19  09:52:05  albert
 * should check for *account instead of account.
 * 
 * Revision 1.2  86/09/18  17:34:46  albert
 * should check *account instead of account
 * 
 * Revision 1.1  86/09/04  16:19:06  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:32:43  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:10:21  mark
 * Initial revision
 * 
*/

#include "ftplib.h"

/*
This routine exists in a seperate file so that another authentication
scheme may be substituted without having this routine contribute to
the code space of the linked object.
*/
extern char *xgetuname();
extern char *xgetpass();

xftpsendident( user, pass, account, context )
	char *user;
	char *pass;
	char *account;
	struct filesystem *context;
{
	int rval;
	char acct[80];
	char null = 0;
	int n;
	struct ftp_conn_state *ftp_pt;
	
	if( !user )
		user = &null;
	if( !pass )
		pass = &null;
	if( !account )
		account = &null;
	ftp_pt = (struct ftp_conn_state *)context->conn_state;
	if( !*user && P_FROMATTY(ftp_pt)) {
		user = acct;
		xoprintf(xstdout,"Remote User Name:"); VOID xfflush(xstdout);
		if( xogets(user, sizeof(acct) - 1, xstdin) == XNULL ) {
			if( xfeof( xstdin ) ) {
				xprintf( "\n" );
				xftpfsclose(context);
				xexit( 0 );
			} else {
				return( XEACCES );
			}
		}
		if( xstrlen(acct) - 1 <= 0 )
			return( XEACCES );
		user[xstrlen(acct) - 1] = '\0';
	} else if( !*user ) {
		return( 0 );
	}
	n = _ftpcmd( ftp_pt,"USER %s", user);
	if (n == CONTINUE)
		{
		if( !*pass /* && P_FROMATTY(ftp_pt) */) {
			/* we are preserving a quirk of previous
			versions of ftp by reading the password
			even if the session is not interactive.
			*/
			pass = xgetpass( "Remote Password:" );
			xputchar( '\n' );
		} else if ( !*pass ) {
			return( 0 );
		}
		n = _ftpcmd( ftp_pt,"PASS %s", pass);
		if (n == CONTINUE) 
			{
			if( !*account && P_FROMATTY(ftp_pt)) {
				account = acct;
				xoprintf(xstdout,"Remote Account: ");
				VOID xfflush(xstdout);
				VOID xogets(acct, sizeof(acct) - 1, xstdin);
				acct[xstrlen(acct) - 1] = '\0';
			} else if ( !account ) {
				return( 0 );
			}
			n = _ftpcmd( ftp_pt,"ACCT %s", account);
			}
		}
	if (n != COMPLETE) {
		xoprintf(xstderr, "Login failed.\n");
		return (XEACCES);
	}
	return (1);
}
