/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xflocate.c,v 1.4 87/04/24 16:14:36 davidb Exp $ */
/*
$Description:
	The network wide file specification is:
	node.user.password.account:file (for UNIX)
	node"user password account"!file (for VMS)

	Because of the differences, we need to conditionalize the code to
parse off the extra double quote for VMS.
$

$Header: xflocate.c,v 1.4 87/04/24 16:14:36 davidb Exp $
$Log:	xflocate.c,v $
 * Revision 1.4  87/04/24  16:14:36  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:36:10  grant
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/08  10:40:39  mark
 * merging in changes for new ftp
 * 
 * Revision 1.3  86/10/03  15:06:46  albert
 * 1. Conditional define separators for VMS
 * 2. Don't bother to check for password or account if no username.  Similarly,
 *    don't bother to check for account if no password.
 * 
 * Revision 2.1  86/10/03  15:04:47  albert
 * 1. Specify separators for VMS
 * 2. if no username, don't bother to check for password.  Similarly, if
 *    no password, don't bother to check for account.
 * 
 * Revision 1.1  86/09/04  16:18:56  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  17:30:20  mark
 * syncing revision level
 * 
 * Revision 1.1  86/04/18  19:09:42  mark
 * Initial revision
 * 
*/
#ifdef	vms
#define	NAME_SEP	'!'	/* separates file name from access information*/
#define USER_SEP	'\"'	/* separate system name from user name */
#define PASS_SEP	' '	/* separate user name from password */
#define ACCOUNT_SEP	' '	/* separate account name from password */
#else
#define NAME_SEP	':'	/* seperates file name from access information*/
#define USER_SEP	'.'	/* seperates system name from user name */
#define PASS_SEP	'.'	/* seperates user name from password */
#define ACCOUNT_SEP	'.'	/* seperates account name from password */
#endif

extern char *xstrchr();
extern char *xstrrchr();

xflocate( string, system, user, pass, account, name )
	char *string;
	char **system;
	char **user;
	char **pass;
	char **account;
	char **name;
{
	char *c_pt;

	c_pt = xstrchr( string, NAME_SEP );
	if( !c_pt ) {
		c_pt = &string[ xstrlen( string ) ];
		*system = c_pt;
		*user = c_pt;
		*pass = c_pt;
		*account = c_pt;
		*name = string;
		return;
	}
	*name = c_pt + 1;
	*c_pt = 0;
#ifdef	vms
	if (*(c_pt - 1) == '\"')
		*--c_pt = '\0';	/* parse of the right double quote */
#endif
	*system = string;
	c_pt = xstrchr( string, USER_SEP );
	if ( !c_pt ) {	/* no user, password nor account */
		c_pt = &string[ xstrlen( string ) ];
		*user = c_pt;
		*pass = c_pt;
		*account = c_pt;
		return;
	} else {
		*user = c_pt + 1;
		*c_pt = 0;
		string = *user;
	}
	c_pt = xstrchr( string, PASS_SEP );
	if ( !c_pt ) {	/* just user name, no password nor account */
		c_pt = &string[ xstrlen( string ) ];
		*pass = c_pt;
		*account = c_pt;
		return;
	} else {
		*pass = c_pt + 1;
		*c_pt = 0;
		string = *pass;
	}
	c_pt = xstrchr( string, ACCOUNT_SEP );
	if ( !c_pt ) {
		c_pt = &string[ xstrlen( string ) ];
		*account = c_pt;
	} else {
		*account = c_pt + 1;
		*c_pt = 0;
	}
}
