/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: fmtout.c,v 1.2 87/04/24 16:12:52 davidb Exp $ */
/*
 * @(#)fmtout.c	1.8 6/13/85
 *
 * GENERIC LIBRARY
 * 
 * filename: FMTOUT.C
 */

/*	format data under control of a format string
*/

/*	to remove the floating point code, comment out
	the definition of FLOATS
*/

/*
  #define FLOATS
 */

#include "xgenlib.h"

static	int *Pp = (int *)0;

#ifndef zilog

xpinit(svec)
int *svec;
{
	Pp = svec;
}

xpint()
{
	return *Pp++;
}

long
xplong()
{
	register long *p;

	p = (long *)Pp;
	Pp += sizeof( long ) / sizeof( int );
	return ( *p );
}

typedef	char *p2c;
typedef	p2c *p2p2c;

char *
xpptr()
{
	/* return *((p2p2c)Pp)++; */
	register p2p2c cpp = (p2p2c)Pp;
	register p2c cp = *cpp;

	cpp++;
	Pp = (int *)cpp;
	return (cp);
}

double
xpdouble()
{
	register double *p;

	p = (double *)Pp;
	Pp += sizeof( double ) / sizeof( int );
	return ( (double)0 );
}

#else

static	Rcnt;
static	int *Rvec;
static	int *Svec;

xpinit(rvec, rcnt, svec)
int *rvec;
int *svec;
{
	Rcnt = rcnt;
	Pp = Rvec = rvec;
	Svec = svec;
}

xpint()
{
	int itmp;

	if (Rcnt == 6)
		Pp = Svec;
	itmp = *Pp;
	Rcnt++;
	Pp++;
	return itmp;
}

long
xpswap(lv)
long lv;
{
	return lv<<16 | (lv>>16&0xFFFF);
}

long
xplong()
{
	long ltmp;

	switch (Rcnt) {
	case 0:
	case 2:
		ltmp = xpswap(*(long *)Pp);
		Pp += 2;
		Rcnt += 2;
		break;
	case 1:
		Pp++;
		ltmp = xpswap(*(long *)Pp);
		Pp += 2;
		Rcnt += 3;
		break;
	case 3:
		Pp++;
		ltmp = xpswap(*(long *)Pp);
		Pp = Svec;
		Rcnt += 3;
		break;
	case 4:
		ltmp = xpswap(*(long *)Pp);
		Pp = Svec;
		Rcnt += 2;
		break;
	case 5:
		Pp = Svec;
		ltmp = *(long *)Pp;
		Pp += 2;
		Rcnt += 3;
		break;
	default:
		if (Rcnt == 6)
			Pp = Svec;
		ltmp = *(long *)Pp;
		Pp += 2;
		Rcnt += 2;
		break;
	}
	return ltmp;
}

char *
xpptr()
{
	char *cptmp;

	if (Rcnt == 6)
		Pp = Svec;
	cptmp = (char *)*Pp;
	Rcnt++;
	Pp++;
	return cptmp;
}

double
xpdouble()
{
	return (double)0;
}

#endif

#ifndef zilog
_fmtout(func, funarg, string, ip)
#else
_fmtout(func, funarg, string, ip, regp, regcnt)
int *regp;
#endif
int (*func)();
char *funarg;
char *string;
int *ip;
{
	char tbuff[128], *cp, cb;
	int base;
	int is_number;
	unsigned leftadj, padchar, width, precflg, precisn, longflg, length;
	union {
		long tlong; 
		long tulong;
	}
	lw;
#ifdef	FLOATS 
	double *dp; 
#endif 

#ifndef zilog
	xpinit(ip);
#else
	xpinit(regp, regcnt, ip);
#endif

	while(*string){
		if( *string !='%'){
			for(cp=string;*cp && *cp!='%';)
				(*func)( (*cp++) & 0xff, funarg);    
			string=cp;
		} 
		else {
			is_number = 1;
			if (leftadj=(*++string == '-'))
				++string;
			padchar= *string & 0xff;
			if(padchar=='0')
				++string; 
			else padchar=' ';
			if (*string == '*') {
				/* width is an argument */
				width = xpint();
				++string;
			}
			else
				for (width=0;isdigit(*string);)
					width=width*10+(*string++-'0');
			if (precflg=(*string=='.')) {
				++string;
				if( *string == '*'){
					/* precision is an argument */
					precisn = xpint();
					++string;
				}
				else
					for (precisn=0;isdigit(*string);)
						precisn=precisn*10+(*string++-'0');
			} 
			else precisn=0;
			if (longflg=(*string =='l'))
				++string;

			switch (*string) {
#ifdef FLOATS
			case 'e': 
			case 'f': 
			case 'g': 
				if(!precflg)precisn=6;
				dp= (double *)xpdouble();
				length=dtos(*dp++, cp=tbuff, precisn, *string & 0xff); 
				break; 
#endif
			case 'B':
			case 'b':
				base=2;
				goto nosign;
			case 'O':
			case 'o':
				base=8;
				goto nosign;
			case 'U':
			case 'u':
				base=10;
				goto nosign;
			case 'X':
			case 'x':
				base=16;
				goto nosign;
			case 'D':
			case 'd':
				base= -10;
nosign:
				if (!longflg)
					longflg=(*string>='A'&&*string<='Z'); 
				if(longflg){
					lw.tlong= xplong();
				}
				else if(base<0)lw.tlong=(long)xpint();
				else lw.tulong=(unsigned)(xpint());
				ltos(lw.tlong, tbuff, base);
				if(precflg){
					cp = tbuff;
					if (lw.tlong <0) ++cp;
					length= xstrlen(cp);
					if (precisn && length < precisn+1 ) {
						movmem(cp, cp+precisn+1-length, length+1);
						setmem(cp, precisn+1-length, '0');
						length = precisn +1;
					}
					movmem( cp+length-precisn, cp+length-precisn+1, precisn+1 );
					cp[length-precisn] = '.';
				}
				length=xstrlen(cp=tbuff);
				break;
			case 's':
				cp = xpptr();
				length = xstrlen(cp);
				if(precflg && precisn<length)length=precisn;
				/* leave minus signs alone */
				is_number=0;
				break;
			case 'c':
				cb = xpint() & 0x7F;
				cp = &cb;
				length=1;
				is_number=0;
				break;
			default:
				cp=string;
				length=1;
				is_number=0;
				break;
			}
			if (!leftadj && width>length) {
				if (is_number && *cp == '-' && padchar == '0') {
					(*func)((*cp++) & 0xff, funarg);
					--length;
					--width;
				}
				while (width-- >length)
					(*func)(padchar, funarg);
			}
			if (width>length)
				width-=length; 
			else
				width=0;
			while (length--)
				(*func)((*cp++) & 0xff, funarg);
			if (leftadj && width)
				while(width--)
					(*func)(padchar, funarg);
			++string;
		}
	}
}
