/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: experror.c,v 1.2 87/04/24 16:05:22 davidb Exp $ */

/*
 * 12/16/86 dab		Changed to correspond to new error code mapping
 *			scheme. All error codes now returned by the board
 *			have ERR_MAP_OFFSET added to them. This removes
 *			the probability of overlap between EXOS error codes
 *			and System V's.
 *
 *			ERR_MAP_OFFSET is defined in include/EXOS/ex_errno.h.
 */

#include <ex_errno.h>

#ifdef BSD4dot2
int errno;	/* errno is declared in perror.c in BSD systems */
#else /* BSD4dot2 */
extern errno;
#endif /* BSD4dot2 */

extern sys_nerr;
extern char *sys_errlist[];
static char sccsId[] = "@(#)perror.c	1.2 1/14/85";

char *ex_errlist[] = {
" Operation would block",
" Operation now in progress",
" Operation already in progress",
" Socket operation on non-socket",
" Destination address required",
" Message too long",
" Protocol wrong type for socket",
" Protocol not available",
" Protocol not supported",
" Socket type not supported",
" Operation not supported on socket",
" Protocol family not supported",
" Address family not supported by protocol family",
" Address already in use",
" Can't assign requested address",
" Network is down",
" Network is unreachable",
" Network dropped connection on reset",
" Software caused connection abort",
" Connection reset by peer",
" No buffer space available",
" Socket is already connected",
" Socket is not connected",
" Can't send after socket shutdown",
" Too many references: can't splice",
" Connection timed out",
" Connection refused",
" Too many levels of symbolic links",
" File name too long",
" Host is down",
" No route to host",
};

experror( rname )

char *rname;
{
int len;
int olderrno;

olderrno = errno;
printf("experror: errno = %d\n",errno);
len = strlen( rname );
if ( len > 0 )
	{
	if (write( 2, rname, len ) != len )
		return;
	if (write( 2, ":", 1 ) != 1 )
		return;
	}
if( olderrno < MINEXERR )
	{
	/*
	print system error
	*/
	len = strlen( (sys_errlist[olderrno]) );
	write( 2, (sys_errlist[olderrno]), len );
	write( 2, "\n", 1 );
	}
else if ( olderrno > MAXEXERR )
	{
	if ( olderrno >= sys_nerr )
		{
		/*
		unknown error
		*/
		write( 2, "UNKNOWN ERROR\n", sizeof( "UNKNOWN ERROR\n" ) );
		}
	else
		{
		/*
		print system error
		*/
		len = strlen( (sys_errlist[olderrno]) );
		write( 2, (sys_errlist[olderrno]), len );
		write( 2, "\n", 1 );
		}
	}
else
	{
	/*
	print EXOS error
	*/
	len = strlen( (ex_errlist[olderrno - MINEXERR]) );
	write( 2, (ex_errlist[olderrno - MINEXERR]), len );
	write( 2, "\n", 1 );
	}
}
