/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: exreg.h,v 1.2 87/04/24 16:00:07 davidb Exp $ */
/* @(#)exreg.h	1.6 8/13/85 */
/*
 * Data structures for the Excelan exos/101 ethernet controller.
 */

/*
 * Changed all Uchars and Ushorts to u_char and u_short, respectively.
 * u_char & u_short are defined in include/EXOS/sys/extypes.h.
 * dab 841125.
 */

/*
 * The exctrl structure is used to maintain the software device during
 * it use.
 * GAP 8/8/85: ex_port should be size of system's I/O address  -- int
 * will usually do the job, but be careful.
 */
struct	exctrl {
	int	ex_port;		/* our port addr */
	int	ex_vector;		/* vector we interupt at */
	int	ex_qbank;		/* bank for message queues (pcxenix) */
#ifdef pcxenix
#ifdef KERNEL
	faddr_t	ex_imsg;		/* virtual pointer to init msg */
#else	/* KERNEL */
	long	ex_imsg;		/* virtual pointer to init msg */
#endif	/* KERNEL */
#else	/* pcxenix */
	caddr_t	ex_imsg;		/* virtual pointer to init msg */
#endif	/* pcxenix */
	dev_t	ex_dev;			/* device info for exintr() */
	u_short	ex_state;		/* state of controller */
	u_char	ex_netdown;		/* state of onboard software */
	u_char	ex_init;		/* device has been initialized */
	int	ex_uba;			/* unibus adaptor exos is on */
};

/* ex_state values */
#define	ST_INIT		0x01		/* device has been set up */
#define	ST_WAITING	0x02		/* waiting for interrupt */

/* port address byte swapping is done by inb/outb routines for the sun */
#define EX_PORTA	0		/* offset for port A */
#ifdef MULTIBUS
#define EX_PORTB	1		/* offset for port B */
#else
#define EX_PORTB	2		/* offset for port B */
#endif

/* macros for ease of use */
#define	PORTA		(ex_db.ex_port + EX_PORTA)
#define	PORTB		(ex_db.ex_port + EX_PORTB)

/* bits in port b */
#define	PB_ERROR	0x01	/* fatal error when 0 */
#define	PB_INT		0x02	/* exos has interrupted when 1 */
#define	PB_XCVRLB	0x40	/* XCVR loopback test failed (NX>=5.0) */
#define	PB_READY	0x08	/* exos is ready when 0 */

/* low and high bytes of a word */
#define	LB(x)		(((int)(x)) & 0xFF)
#define	HB(x)		((((int)(x))>>8) & 0xFF)

/* minor devices for admin device */
#define	ADMIN_FIND	0		/* used for socket()'s */
#define	ADMIN_LOGGER	1		/* used by error logger */
