/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_subr.c,v 1.2 87/04/24 15:59:31 davidb Exp $ */

/*
   revision history:
   rev  by      description
   ---  ------- -----------
   1.8  pbf     make ex_findmsg reset ST_WAITING in ex_db.ex_state after
                sleep returns. Add dev argument to ex_send. Make ex_send
                delay setting MQ_EXOS bit in msg header til after all msg
                fields are set. Add ex_klfree routine.
   1.9  pbf     Add kl_baddr field to context struct. Make ex_findmsg clear
                this field. Make ex_klfree release buffer. Lock out exos
                interrupts during ex_klfree.
 5/12/84 wrn	put "procflags" array into c(onf).c.  make ex_send do
		save(u.u_qsav) soas to handle signals, esp. out-of-band
		signals, "correctly".  Fix tsleep().
 8/13/84 wrn	Do tsleep stuff inline like 4.2.  Put a while around the
		sleeps in ex_send.
 9/9/84 wrn	New vax-compatable exos.h rearranges "struct msg".
 1/15/85 mp	Made ex_send not release buffer.  This must be handled in
		ex_intr() instead.
12/11/86 dab	Map reply code returned by board (and placed in context
		buffer by exintr()) to an error number which doesn't
		conflict with UNIX error codes.

		The mapped error code is placed in the new kl_error field.
		Kl_reply is unmolested.
 */

#define PULLIN
#include "config.h"

extern  struct exctrl ex_db;
extern  struct rmsg_area *rmsgarea;
extern  struct wmsg_area *wmsgarea;
extern  int ex_inited;
static char sccsId[] = "@(#)ex_subr.c	2.9 8/30/85";

#ifdef DEBUG
exdump(addr, len)
caddr_t	addr;
int	len;
{
register int i;
static char xa[] = "0123456789ABCDEF";
	while (len > 0) {
		printf("%6X: ", addr);
		for (i=0; i<16; i++, len--, addr++) {
			if (!(i & 0x01)) printf(" ");
			printf("%c%c", xa[(*addr>>4)&0x0F], xa[(*addr)&0x0F]);
			if (len <= 0) break;
		}
		printf("\n");
	}
}
#endif

/*
 * exsetup:
 *      - perform probe level initialization
 *      - setup controller mode according to "mode"
 *      - setup message queues
 *      - send init message to exos
 *      - look at response and return value accordingly
 */
int
exsetup(mode, dotimo)
        int mode;
	int dotimo;			/* argument of EXIOCRESET 
					 * dotimo & 0x80 => infinite timeout
					 * ( for debugger )
					 */
{
        register struct init_msg *im;
        register struct msg *current, *next;
        long i, timeout;
        long addr;
        static char magic[8] = {0xff, 0xff, 0, 0};
        register char *ap;
	int tmp, s, ststat;
	int dotimeout = !(dotimo & 0x80);

	/*
	 * Reset the board before we do anything else as
	 * the board may be active while we are setting up queues.
	 * -- bvs 850502
	 */
	EXSPL6( s );
	XIORESET();
	splx(s);
    /* link together the read ("exos to host") message queue */

        rmsgarea->ma_rlink =
		(short)EXvtop(rmsgarea->ma_rmsgs, rmsgarea->ma_rmsgs,1 );
        current = &rmsgarea->ma_rmsgs[NET_RBUFS-1];
        rmsgarea->ma_lastr = rmsgarea->ma_rmsgs;
        for (i = 0; i < NET_RBUFS; i++) {
                next = &rmsgarea->ma_rmsgs[i];
                current->nm_u.msg_hd.mh_link = (short)EXvtop(next,next,1);
                current->nm_u.msg_hd.mh_length = sizeof(union exos_u) -
			sizeof(struct headers);
                current->nm_u.msg_hd.mh_status = 3;
                current->msg_link = next;
                current = next;
        }

    /* link together the write ("host to exos") message queue */

        wmsgarea->ma_wlink =
		(short)EXvtop(wmsgarea->ma_wmsgs,wmsgarea->ma_wmsgs,1);
        current = &wmsgarea->ma_wmsgs[NET_WBUFS-1];
        wmsgarea->ma_lastw = wmsgarea->ma_wmsgs;
        for (i = 0; i < NET_WBUFS; i++) {
                next = &wmsgarea->ma_wmsgs[i];
                current->nm_u.msg_hd.mh_link = (short)EXvtop(next,next,1);
                current->nm_u.msg_hd.mh_length = sizeof(union exos_u) -
			sizeof(struct headers);
                current->nm_u.msg_hd.mh_status = 0;
                current->msg_link = next;
                current = next;
        }

    /* setup init_msg data structure */

        im = (struct init_msg *)ex_db.ex_imsg;
        clear(im, sizeof(struct init_msg));     /* zap to all zero's */
        im->im_newstyle = 1;                    /* use new-style init msg */
        im->im_mode = mode;                     /* link level */
        im->im_hdfo[0] = im->im_hdfo[1] = 1;/* do auto-byte/word swapping */
        im->im_junk[0] = 1;                 /* defeat rev-d "20 min. stop"*/
        im->im_haddrmode = 3;                   /* absolute address mode */

        /* data order test patterns */
        im->im_byteptn[0] = 1;
        im->im_byteptn[1] = 3;
        im->im_byteptn[2] = 7;
        im->im_byteptn[3] = 0xf;
        im->im_wordptn[0] = 0x103;
        im->im_wordptn[1] = 0x70f;
        im->im_longptn = 0x103070f;

        im->im_101off = im->im_101seg = 0xFFFF;
        im->im_nhosts = 1;
        im->im_result = im->im_nmb = im->im_nproc = im->im_nslots = 0xFF;

        /* prob. here calc seg which is diff from that calc in ex_getbuf() ? */
        im->im_h2exqaddr =
		((long)EXvtop(&wmsgarea->ma_wlink,&wmsgarea->ma_wlink,1)) &
		EXMASKADDR;/*seg base*/
        im->im_h2exoff =
		(short)EXvtop(&wmsgarea->ma_wlink,&wmsgarea->ma_wlink,1);
        im->im_h2extype = 0;            /* no int. when send exos a msg */
        im->im_ex2hqaddr =
		((long)EXvtop(&rmsgarea->ma_rlink,&rmsgarea->ma_rlink,1)) &
		EXMASKADDR;/*seg base*/
        im->im_ex2hoff =
		(short)EXvtop(&rmsgarea->ma_rlink,&rmsgarea->ma_rlink,1);
#ifdef MULTIBUS
	im->im_ex2htype = 3;
#else
        im->im_ex2htype = 4;	/* QBUS/VME/UNIBUS(??) vectored interrupt */
	/* Note : Modify the interrupt vector to reflect the 
	   vector you want on your system.
	*/
        im->im_ex2hu.im_ex2hvctr =  ex_db.ex_vector;
#endif
    /* give init_msg to exos */

        timeout = 1000000;
	while (1) {
		EXSPL6( s );
		ststat = XIOSTATUS();
		if (ststat & PB_ERROR) {
			splx(s);
			break;
		}
		splx(s);
		if ((--timeout == 0) && dotimeout)
			break;
	}
        if (timeout == 0) {
                printf("ex0: board failed diagnostics\n");
                return 1;
        }
    /*
     *  output addr of init msg in "absolute" format:
     *          - 0xffff0000 follwed by: the address backwards, bytewise
     */
        /* get addr into array */
#ifdef DEBUG
printf("exsetup(): conf msg at %X (physical = %X)\n",
        ex_db.ex_imsg, EXvtop(ex_db.ex_imsg,imsgbuf,0));
#endif
        addr = (long)EXvtop(ex_db.ex_imsg,ex_db.ex_imsg,1);
        for (i = 0; i < 4; i++) {
                magic[i+4] = addr;
                addr >>= 8;
        }

#ifdef DEBUG
	printf( "bytes in magic:\n" );
	for ( i = 0; i < 8 ; ++i )
		{
		tmp = magic[i];
		printf ( "%x ", 0xff & tmp );
		}
	printf( "\n" );
#endif

        /* output the bytes */
        for (ap = magic; ap <= &magic[7]; ap++) {
                timeout = 100000;
		while (1) {
			EXSPL6( s );
			if ((XIOSTATUS() & PB_READY) == 0) {
				splx(s);
				break;
			}
			splx(s);
			if ((--timeout == 0) && dotimeout)
				break;
		}
                if (timeout == 0) {
                        printf("ex0: board hung while sending init addr\n");
                        return 1;
                }
		EXSPL6( s );
		XIOWVAL((*ap)&0xff);

#ifdef S5vax750
		/* hard delay to let PB_READY go to zero 
                   (=> board ready for next byte */
		/* need observed on 750 with EXOS debugger */
		for( timeout = 1000 ; timeout > 0 ; --timeout )
			;
#endif
		splx(s);
        }

    /* wait for init to complete */

        timeout = 1000000;
        while ((im->im_result&0xff == 0xFF) && --timeout)
                ;
        if ((timeout == 0) && dotimeout) {
                printf("ex0: board hung while waiting for init to complete\n");
                return 1;
        }
	im->im_dummy2 = ststat;	/* pass back lb test result */

    /* check result of init */

        if (im->im_result) {
                printf("ex0: invalid init code: %x\n", im->im_result);
                printf("(im_mode should be 1, is %x\n)", im->im_mode);
                return 1;
        }
#ifdef  DEBUG
        printf("[nx %c.%c, ex %c.%c]\n",
                    im->im_version[1], im->im_version[0],
                    im->im_version[3], im->im_version[2]);
#endif
	EXSPL6( s );
	XIONTRUPT();
	splx(s);
#ifdef  DEBUG
        printf("ex0: init done\n");
#endif
        ex_inited = 1;          /* tell world that board is inited */
        return 0;
}

/*
 * ex_findmsg:
 *      - first find a context buffer to hold result of message
 *      - find next available message on "host to exos" message queue
 *      - sleep if necessary, to get one
 */
struct msg *
ex_findmsg()
{
        register struct msg *mp;
        register struct context *kp;
        register int s;

        EXSPL5( s );
        for (;;) {
                for (kp = context; kp < &context[NET_CONTEXTS]; kp++) {
                        if (kp->kl_state == KL_FREE) {
                                kp->kl_state = KL_BUSY;
                                goto findmsg;
                        }
                }
		printf("findmsg(): couldn't get kl buffer!\n");
                goto nightynight;
findmsg:
                mp = wmsgarea->ma_lastw;

		if ((mp->nm_u.msg_hd.mh_status & (MQ_EXOS|MQ_DONE)) == 0) {
			kp->kl_baddr = (struct buf *)0;
			kp->kl_count = 0;
			kp->kl_prevcnt = 0;
			mp->msg_context = kp;
			mp->nm_u.msg_hd.mh_status |= MQ_DONE;
			mp->nm_u.msg_hd.mh_reserved = 0;
			mp->nm_u.msg_hd.mh_length =
				sizeof(union exos_u) - sizeof(struct headers);
			clear(&mp->nm_u.msg_msg.nm_soid, 
				sizeof(union exos_u) - sizeof(struct headers));
			wmsgarea->ma_lastw = mp->msg_link;
			splx(s);
#ifdef  DEBUG_QUEUES
			printf("ex_findmsg: return mp=%X, kp=%X\n", mp, kp);
#endif	/* DEBUG_QUEUES */
			return mp;
		}
		printf("findmsg(): couldn't get message buffer!\n");
                kp->kl_state = KL_FREE;         /* release context buf */
nightynight:
                ex_db.ex_state |= ST_WAITING;
                sleep((caddr_t)&ex_db, PRIBIO);
                ex_db.ex_state &= ~ST_WAITING;
        }
}

/*
 * ex_send:
 *      - send a network message via the message queue's to the exos
 *      - set up standard header
 *      - bump board to tell it to go
 *      - wait for operation to complete and return the pointer to the
 *        result info (kept in context)
 *	- map reply code to error number to avoid overlap with UNIX error
 *	  numbers.
 *      - must not be called at interrupt level
 */
struct context *
ex_send(command, mdev, mp, dontint)
        int command;
        int mdev;
        register struct msg *mp;
        int dontint;
{
        register struct context *kp = mp->msg_context;
        register int s1, s2;
        label_t lqsav;

#ifdef DEBUG_QUEUES
printf("ex_send(%x, %x, %X, %x)\n", command, mdev, mp, dontint);
#endif

        if (!ex_inited) {
                u.u_error = ENXIO;
                return;
        }

        EXSPL5( s1 );
#ifdef STRUCTLABELT
        bcopy((caddr_t)&u.u_qsav, (caddr_t)&lqsav, sizeof (label_t));
#else
        bcopy((caddr_t)u.u_qsav, (caddr_t)lqsav, sizeof (label_t));
#endif
	/*
	 * If this proc gets hit by a signal (possibly from arrival of
	 * out-of-band data), free exos resources, THEN do the non-local goto
	 * to exit current system call.  This leaves a message pending
	 * on the board, but since we here clear only KL_BUSY, no one
	 * else will try to use this context buffer until the pending
	 * message comes back from the board and the int. routine clears
	 * KL_WAITING.
	 */
#ifdef BSD4dot2
	if (setjmp(&u.u_qsav)) {
#else
#ifdef tower
	if (setjmp(u.u_qsav)) {
#else
	if (save(u.u_qsav)) {
#endif
#endif
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
		kp->kl_state &= ~KL_BUSY;
		if(kp->kl_state & KL_READ) {
			so_state[kp->kl_dev] |= SOS_PENDRD;
		} else if(kp->kl_state & KL_WRITE) {
			so_state[kp->kl_dev] |= SOS_PENDWRT;
		}
		splx(s1);
		/* Watchout: on some systems p_addr might be, eg, p_uaddr... */
#ifdef DEBUG
/*
* printf("my proc structure (addr = %X, length = %d):\n",
* u.u_procp, sizeof(struct proc));
* exdump(u.u_procp, sizeof(struct proc));
*/
printf("resuming(%x, %X) \007 \n",
u.u_procp->p_addr, lqsav);
#endif
#ifdef BSD4dot2
		longjmp(&lqsav);
#else
#ifdef tower
		longjmp( lqsav, &u.u_procp->p_addr );
#else
#ifdef cadmus
		resume(u.u_procp->p_addr, u.u_procp->p_trnbuf, lqsav);
#else
		resume(u.u_procp->p_addr, lqsav);
#endif
#endif
#endif
#ifdef DEBUG
		printf("got past resuming (unreachable)! \007 \n");
#endif
	}
        else {
        	EXSPL5( s2 );
		mp->nm_u.msg_msg.nm_userid = (long)neartolong(kp);
		mp->nm_u.msg_msg.nm_request = command;
#ifdef  DEBUG_QUEUES
	printf("{ex_send: kp=%X} ", kp);
#endif	/* DEBUG_QUEUES */

	kp->kl_dev = mdev;
		kp->kl_state |= KL_WAITING;
		kp->kl_proc = u.u_procp;
		mp->nm_u.msg_hd.mh_status |= MQ_EXOS;
		XIONTRUPT();
		while (kp->kl_state & KL_WAITING) {
		    if (dontint)
			    sleep((caddr_t)kp, PRIBIO);
			    /* not interruptable */
		    else
			    sleep((caddr_t)kp, PZERO+1);
			    /* interruptable */
		}
		splx( s2 );
	}
#ifdef STRUCTLABELT
        bcopy((caddr_t)&lqsav, (caddr_t)&u.u_qsav, sizeof (label_t));
#else
        bcopy((caddr_t)lqsav, (caddr_t)u.u_qsav, sizeof (label_t));
#endif
        splx(s1);

#ifdef  DEBUG_QUEUES
        printf("{ex_send: reply=%x} ", kp->kl_reply);
#endif	/* DEBUG_QUEUES */
#ifdef  DEBUG_NOISE
        if (kp->kl_reply)
                printf("ex0: reply = %x\n", kp->kl_reply);
#endif	/* DEBUG_NOISE */
	/* Strip off the high order (NM_MAGIC_DATA) bit. */
	kp->kl_error = kp->kl_reply & ~NM_MAGIC_DATA;
	if (kp->kl_error >= (MINEXERR - ERR_MAP_OFFSET) &&
				 kp->kl_error <= (MAXEXERR - ERR_MAP_OFFSET))
		/* Make sure code is within the range that should be
		   mapped. We don't want to map errors such as EPIPE.
		   MINEXERR & MAXEXERR are defined in include/EXOS/ex_errno.h */
		kp->kl_error += ERR_MAP_OFFSET;
        return kp;
}


#ifndef NOSELECT
#ifdef EXOSSELECT
int selwait;
long nselcoll;
extern char procflags[];
extern setrun();

/*
 * Select call.
 */
xselect(nfd, rp, wp, timo, nfdp)
int     nfd;
fdset_pt rp;
fdset_pt wp;
long    timo;
#ifdef xenix286
unsigned far *nfdp;
#else	/* xenix286 */
unsigned *nfdp;
#endif	/* xenix286 */
{
        fd_set rd, wr;
        int nfds = 0;
        long xselscan();
        long readable = 0, writeable = 0;
        time_t t = SYSTIME;
        int s, tsel;
	long rem;
        long ncoll;
	label_t lqsav;
#ifdef integrated

/*
   The ISI optimizer breaks the code tidbits below. Believe it or not,
   generates assembly language that the assembler can't assemble - an
   invalid instruction. It attempts to mask off a bit within a byte,
   which is apparently not an instruction which the 68000 supports.

   The same problem occurs in xty.c, and is fixed in the same way.
   We force the compiler to generate code which can't be broken by the
   optimizer. The proper bit is masked off within a longword, instead
   of a byte.
*/

	long badopt;			/*avoid bad optimization*/
#else
#define badopt (procflags[procoff] & SSEL)
#endif
        int procoff = u.u_procp - &proc[0];

        if (nfd > NOFILE)
                nfd = NOFILE;
        if (nfd < 0) {
                u.u_error = EBADF;
                return;
        }
        if (rp && copyin(EXupaddr(rp),(caddr_t)&rd,sizeof(fd_set)))
                return;
        if (wp && copyin(EXupaddr(wp),(caddr_t)&wr,sizeof(fd_set)))
                return;
retry:
        ncoll = nselcoll;
        procflags[procoff] |= SSEL;
        if (rp)
                readable = xselscan(nfd, rd, &nfds, FREAD);
        if (wp)
                writeable = xselscan(nfd, wr, &nfds, FWRITE);
        if (u.u_error)
                goto done;
        if (readable || writeable)
                goto done;
        rem = (timo+999)/1000 - (SYSTIME - t);
        if (timo == 0 || rem <= 0)
                goto done;
        EXSPL6( s );
#ifdef integrated
	badopt = procflags[procoff] & SSEL;
#endif
        if (badopt == 0 || nselcoll != ncoll) {
                procflags[procoff] &= ~SSEL;
                splx(s);
                goto retry;
        }
        procflags[procoff] &= ~SSEL;
	if (rem) {
#ifdef STRUCTLABELT
		bcopy((caddr_t)&u.u_qsav, (caddr_t)&lqsav, sizeof (label_t));
#else
		bcopy((caddr_t)u.u_qsav, (caddr_t)lqsav, sizeof (label_t));
#endif
#ifdef BSD4dot2
		if (setjmp(&u.u_qsav)) {
#else
#ifdef tower
		if (setjmp(u.u_qsav)) {
#else
		if (save(u.u_qsav)) {
#endif
#endif
			rm_callout(setrun, (caddr_t)u.u_procp);
			u.u_error = EINTR;
			splx(s);
			goto done;
		}
		rem = rem*EXHZ;
		/* for 16-bit machines, retry after 64k ticks */
		if (rem >= (long)65535)
			rem = (long)0x7fff; /* must be possitive 2's comp */
		timeout(setrun, (caddr_t)u.u_procp, loint(rem));
	}
	sleep((caddr_t)&selwait, PZERO+1);
	if (rem) {
#ifdef STRUCTLABELT
		bcopy((caddr_t)&lqsav, (caddr_t)&u.u_qsav, sizeof (label_t));
#else
		bcopy((caddr_t)lqsav, (caddr_t)u.u_qsav, sizeof (label_t));
#endif
		rm_callout(setrun, (caddr_t)u.u_procp);
	}
	splx(s);
	goto retry;
done:
        rd.fds_bits[0] = readable;
        wr.fds_bits[0] = writeable;
        copyout((caddr_t)&nfds, EXupaddr(nfdp), sizeof(nfds));
        if (rp)
                copyout((caddr_t)&rd, EXupaddr(rp), sizeof(fd_set));
        if (wp)
                copyout((caddr_t)&wr, EXupaddr(wp), sizeof(fd_set));
}

long
xselscan(nfd, fds, nfdp, flag) /* used by non BSD systems, BSD has selscan */
        int nfd;
        fd_set fds;
        int *nfdp, flag;
{
        struct file *fp;
        struct inode *ip;
        long bits,res = 0;
        int i, able;
                
        bits = fds.fds_bits[0];
        while (i = xffs(bits)) {
                able = 0;
                if (i >= nfd)
                        break;
                bits &= ~(1L<<(i-1));
                fp = u.u_ofile[i-1];
                if (fp == NULL) {
                        u.u_error = EBADF;
                        return (0);
                }
                ip = (struct inode *)(fp->f_inode);
                switch (ip->i_mode & IFMT) {

                case IFCHR:
                        /*
                         * for now the only char devices we need
                         * to select on are the control side of
                         * ptys -- for the rlogin deamon, and sockets.
                         */
                        {
                            extern int sok_dev;
                            int dev = ((int)(ip->I_RDEV));
			    if (major(dev) == sok_dev)
                                able = xsoselect(minor(dev), flag);
                            else
                                able = 0;
                        }
			break;
#ifdef BSD4dot2
		case IFSOCK:
#endif
#if !( BSD4dot2 || V7 )
		case IFIFO:
#endif
#ifdef Siemens3
		case IFNAM:
#endif
                case IFBLK:
                case IFREG:
                case IFDIR:
                        able = 1;
                        break;
                }
                if (able) {
                        res |= (1L<<(i-1));
                        (*nfdp)++;
                }
        }
        return (res);
}

#ifdef	SOASYNCIO
/*
 * If signum is a valid signal number,
 * turn on the asynchronous mode for
 * sockets specified in the bitmask.
 * If signum == -1,
 * turn off the asynchronous mode for
 * sockets specified in the bitmask.
 */
xasyncio(nfd, bitmask, signum)
	register int	nfd;
	long	bitmask;
	long	signum;
{
        register int i;
	register int s;
	register long b;
                
#ifdef	DEBUGASYNC
	EXSPL6(s);
	printf("asyncio(%d): bitmask=0x%X, signum=%d\n",
		u.u_procp->p_pid, bitmask, signum);
	spl0();
#endif	/* DEBUGASYNC */
	/*
	 * Verify we have a valid bit mask
	 */
	for (b = bitmask; (i = xffs(b)) && i <= nfd; b &= ~(1L << (i-1))) {
		extern int sok_dev;
		register struct file *fp;
		register struct inode *ip;
		register int dev;

                fp = u.u_ofile[i-1];
                if (fp == NULL)
			return u.u_error = EBADF;
                ip = (struct inode *)(fp->f_inode);
                if ((ip->i_mode & IFMT) != IFCHR) 
			return u.u_error = EBADF;
		dev = (int)ip->I_RDEV;
		if (major(dev) != sok_dev)
			return u.u_error = EBADF;
	}

	/*
	 * The parameters are all valid;
	 * make the necessary changes
	 */
	for (b = bitmask; (i = xffs(b)) && i <= nfd; b &= ~(1L << (i-1))) {
		register struct file * fp = u.u_ofile[i-1];
		register struct inode * ip = (struct inode *)(fp->f_inode);
		register int mdev = minor((int)ip->I_RDEV);

		EXSPL6(s);
		if (signum >= 0)  {
			so_async[mdev] |= SOA_ON;
			so_signum[mdev] = signum;
		} else {
			so_async[mdev] &= ~SOA_ON;
			so_signum[mdev] = -1;
		}
		spl0();
	}
	return 0;
}
#endif	/* SOASYNCIO */

xffs(mask)
        long mask;
{
        register int i;
        register imask;

        if (mask == 0) return (0);
        imask = loint(mask);
        for(i=1; i<=16; i++) {
                if (imask & 1)
                        return (i);
                imask >>= 1;
        }
        imask = hiint(mask);
        for(i=17; i<=32; i++) {
                if (imask & 1)
                        return (i);
                imask >>= 1;
        }
        return (0);     /* can't get here anyway! */
}

xselwakeup(p, coll)
        register struct proc *p;
        int coll;
{
        int s;
#ifdef integrated
	long badopt;			/*avoid bad optimization*/
#else
#define badopt (procflags[procoff] & SSEL)
#endif

        if (coll) {
                nselcoll++;
                wakeup((caddr_t)&selwait);
        }
        EXSPL6( s );
        if (p) {
                if (p->p_wchan == (caddr_t)&selwait)
                        setrun(p);
                else {
                        int procoff = p - &proc[0];
#ifdef integrated
			badopt = procflags[procoff] & SSEL;
#endif
                        if ( badopt )
                                procflags[procoff] &= ~SSEL;
                }
        }
        splx(s);
}

hiint(l)
long l;
{
        union UN_long {
                long    UN_l;
                struct {
                        short Hw;
                        short Lw;
                } UN_wds;
        } ul; 

        ul.UN_l = l;
        return ul.UN_wds.Hw;
}

#endif	/* NOSELECT */
#endif	/* EXOSSELECT */

/* findproc -- find proc with pid */
struct proc *
findproc(pid)
register pid;
{
	register struct proc *p;

#ifdef zilog
	for (p = &proc[0]; p < &proc[NPROC]; p++) 
#else
#ifdef V7
	for (p = &proc[0]; p < &proc[NPROC]; p++) 
#else
#ifdef BSD4dot2
	for (p = &proc[0]; p < procNPROC ; p++) 
#else
	for (p = &proc[0]; p < &proc[v.v_proc]; p++) 
#endif
#endif
#endif
		if (p->p_pid == pid)
			return p;
	return NULL;
}

#ifdef EXOSSELECT
/*
 * remove entry in callout vector
 * which is scanned by clock interrupt
 */
rm_callout(func,arg)
int (*func)();
caddr_t arg;
{
#ifdef BSD4dot1
	register struct callout *p1, *p2;
	register int s;

	EXSPL7( s );
	for (p1 = &calltodo; (p2 = p1->c_next) != 0; p1 = p2) {
		if (p2->c_func == fun && p2->c_arg == arg) {
			if (p2->c_next && p2->c_time > 0)
				p2->c_next->c_time += p2->c_time;
			p1->c_next = p2->c_next;
			p2->c_next = callfree;
			callfree = p2;
			break;
		}
	}
	splx(s);
#else
	register struct callo *p1, *p2;
	register int tt;
	int pri;

	p1 = &callout[0];
	EXSPL7( pri );
	while(p1->c_func != 0) {
		if ((p1->c_func == func) && (p1->c_arg == arg))
			break;
		p1++;
	}
	if (p1 >= EXNCALLP ) {
		printf("Timeout entry not found, not deleted\n");
		return;
	}
	/* copy everything that follows in the list up one
	   position, adding our unused time to theirs */
	tt = p1->c_time;
	p2 = p1;
	while(p1->c_func != 0) {
		p2++;
		p1->c_time = p2->c_time + tt;
		p1->c_func = p2->c_func;
		p1->c_arg = p2->c_arg;
		tt = 0;		/* only add time to first */
		p1 = p2;
	}
	splx(pri);
#endif	/* BSD4dot1 */
}
#endif	/* EXOSSELECT */
