/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: context.h,v 1.2 87/04/24 15:28:44 davidb Exp $ */
/*
 * This structure defines the reply data from a message sent to the
 * board.  This is needed because of a problem with the message queues
 * on the board - they are not searched.  Once a message is sent to the
 * board, it EXPECTS the next sent message to be immediately following
 * (in the circular queue sense) the previous sent message.  Since we
 * need to save the write message until the sender can use it to find
 * the reply message, a deadlock situation arises.  To solve this problem
 * the following scenario is used.  Whenever we allocate a message to send
 * to the board, we also allocate a context buffer.  The ex_send() routine
 * will sleep on the address of the context buffer (which will be unique
 * across any current sleepers).  Once the reply comes in, the interrupt
 * routine will put the result of the sent message into the context
 * buffer.
 */

/*
 * Added kl_error field to context buffer. This is used by ex_subr.c: ex_send()
 * and ex_socket.c: ex_pendio() to map the reply code from the board 
 * to an error code passed back to the application to avoid overlap with 
 * any UNIX error codes. 
 * dab 861211.
 */

/*
 * Changed all Uchars and Ushorts to u_char and u_short, respectively.
 * u_char & u_short are defined in include/EXOS/sys/extypes.h.
 * dab 841125.
 */

#define	NET_CONTEXTS	50

struct	context {
	u_char	kl_state;		/* state of buffer (0 == free) */
	u_char	kl_reply;		/* reply from exos */
	u_char	kl_error;		/* error code (for u.u_error) */
	u_short	kl_count;		/* total amount of data */
	u_short	kl_prevcnt;		/* used for interrupted io */
	struct	proc *kl_proc;		/* process using this buf */
#ifdef plexus
	unsigned	*kl_baddr;
#else
	struct buf *kl_baddr;		/* pointer to data buf */
#endif
	long	kl_daddr;		/* pointer to beginnig of data area */
	dev_t	kl_dev;			/* device using this buf */
	union {
		struct sockaddr a_sa;	/* returned socket address */
		long	along;		/* a long value */
		short	ashort;		/* a short value */
		char	achar;		/* a character value */
	} kl_u;
};
#define	kl_sa		kl_u.a_sa
#define	kl_along	kl_u.along
#define	kl_ashort	kl_u.ashort
#define	kl_achar	kl_u.achar

/* kl_state's */
#define	KL_FREE		0x00		/* pseudo flag */
#define	KL_BUSY		0x01		/* buffer in use */
#define	KL_WAITING	0x02		/* somebody wants an interrupt */
#define	KL_READ		0x04		/* read request */
#define	KL_DONE		0x08		/* board reply to a read/write req */
#define KL_WRITE	0x10		/* write request */

/* used by SOSOCKET, but not SORECEIVE */
#define	kl_soid	kl_count

#ifdef	KERNEL
struct	context context[NET_CONTEXTS];
#endif
