/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: telnet.c,v 1.3 87/05/15 10:43:33 davidb Exp $ */
static char sccsId[] = "@(#)telnet.c	1.13 8/29/85";

/*
 * User telnet program.
 */
#include "telnetc.h"
#ifdef	vms
#include <ttdef.h>
#include <descrip.h>
#include <iodef.h>
#endif
#define	connected	cnctd

#define	ctrl(x)		((x) & 037)
#define	strip(x)	((x)&0177)
#define	INFINITY	((long)10000000)

int	connected = 0;
int	net = 0;
int	showoptions = 0;
int	options = 0;
int	crnull = 0;
char	prompt[] = "telnet";
char 	usage[] = 
	"telnet [-v] [-esc ??] [-o ??] [-c crnull | ascii | binary] [host]\n";

char	line[200] = { 0 };

extern	net_read(), net_write();
extern	xstrlen();
extern	char **xmkarglist();
extern  int status();

int	localecho = 1;	/* state of local echo, shared by net_read & 
			   net_write */
int	charmode = 0;	/* by default, not in char. mode if localecho */
int	tn();

struct sockaddr_in sin = { AF_INET };

static int modeset = 0;	/* flag to show if -c is used to set the mode flag */
static int dobinary = 0; /* flag to force binary mode */

xmain(argc, argv)
	int argc;
	char *argv[];
{
	xsetbuf(xstdin, 0, 0);
	xsetbuf(xstdout, 0, 0);
	while ( (argc >= 2) && (argv[1][0] == '-') ) {
		if ( !xstrcmp(argv[1], "-d")) {
			options = SO_DEBUG, argv++, argc--;
		} else if ( !xstrcmp(argv[1], "-v")) {
			showoptions = 1, argv++, argc--;
		} else if ( !xstrcmp(argv[1], "-c") && argc > 2) {
			if (!xstricmp(argv[2], "crnull"))
				crnull++;
			else if (!xstricmp(argv[2], "ascii")) {
				modeset++;
			} else if (!xstricmp(argv[2], "binary")) {
				modeset++;
				dobinary++;
			} else {
				xoprintf(xstderr, usage);
				xexit(1);
			};
			if (modeset > 1) {
				xoprintf(xstderr, usage);
				xexit(1);
			};
			if (crnull && dobinary) {
				xoprintf(xstderr, 
				"telnet: Cannot specify CRNULL in binary mode.\n");
				xexit(1);
			};
			argc -= 2;
			argv += 2;
		} else if (argc > 2 && !xstrcmp(argv[1], "-esc")) {
			/*
		 	* It would be nice to use just `e',
		 	* but that's taken for terminal emulation.
		 	*/
			escape = encontrol( argv[2] );
			argv += 2;
			argc -= 2;
		} else if(argc > 2 && !xstrcmp(argv[1], "-o")) {
			flusho = encontrol( argv[2] );
			argv += 2;
			argc -= 2;
		} else {
			xoprintf( xstderr, usage);
			xexit( 1 );
		}
	}
	if (crnull) 
		modeset++;	/* assume ASCII */
	myopts[TELOPT_ECHO] = OPT_ENABLE;	/* default */
	localecho = OPT_ENABLE;
	charmode = OPT_DISABLE;			/* option disabled */
	tn(argc, argv);
}

char	*hostname = (char *)0;

tn(argc, argv)
	int argc;
	char *argv[];
{
	register int c;
	long host_addr, xrhost();
	int madeargs = 0;
	int rval;

	if (argc < 2) {
		xstrcpy(line, "Connect ");
		xoprintf(xstdout, "(to) ");
		if( XNULL == xgets(&line[xstrlen(line)]) ) {
			xoprintf(xstderr, "Expected host name or address.\n" );
			xexit(1);
		}
		argv = xmkarglist( line, &argc );
		if( XNULL == argv || argc < 2 ) {
			xoprintf(xstderr, "Expected host name or address.\n" );
			xexit(1);
		}
		madeargs = 1;
	}
	if (argc > 3) {
		xoprintf(xstdout,"usage: %s host-name [port]\n", argv[0]);
		if( madeargs )
			xdealglob( argv );
		return;
	}
	hostname = argv[1];
	host_addr = xrhost(&hostname);
	if (host_addr != -1) {
		sin.sin_family = AF_INET;
		sin.sin_addr.s_addr = host_addr;
	} else {
		xoprintf(xstdout,"%s: unknown host\n", argv[1]);
		if( madeargs )
			xdealglob( argv );
		return;
	}
	sin.sin_port = IPPORT_TELNET;
	if (argc == 3) {
		sin.sin_port = xatoi(argv[2]);
		if (sin.sin_port < (u_short)0 ) {
			xoprintf(xstdout,"%s: bad port number\n", argv[2]);
			if( madeargs )
				xdealglob( argv );
			return;
		}
	}
	if( madeargs )
		xdealglob( argv );
	sin.sin_port = xhtons(sin.sin_port);
	if ((net = xsocket(SOCK_STREAM, (char *)0, (char *)0,
	 		options|SO_DONTLINGER|SO_SMALL)) < 0) {
		xperror( net, "xsocket");
		return;
	}
	xoprintf(xstdout,"Trying...\n");
	if (( rval = xconnect(net, (char *)&sin)) < 0) {
		xperror( rval, "xconnect");
		return;
	}
	connected++;
	call( status, "status", 0 );
	telnet(net);
}


telnet(s)
	int s;
{
	int tin = xfileno(xstdin);
	int fout = xfileno(xstdout);
	int on = 1;

	wsga(0,0);	/* always offers to be in FULL duplex */
	if (dobinary)
		wbinary(0,0);	
#ifdef	vms
	if (!modeset)
		set_binary(s);
#endif    
	xmux_io( "telnet", net_read, s, fout, net_write, tin, s );
}


#ifdef	vms
set_binary(net)
int	net;
{	/* set binary mode if current terminal has 8-bit characteristics */
int	curchar[3];		/* terminal characteristics */
$DESCRIPTOR (devnam, "TT");
int	stat;
int	iosb[2];		/* status	*/
int	termchan;		/* channel number	*/


    stat = sys$assign(&devnam, &termchan, 0, 0);
    stat = sys$qiow(0, termchan, IO$_SENSEMODE, iosb, 0, 0, curchar, 
		sizeof curchar, 0, 0, 0, 0);
    if (curchar[1] & TT$M_EIGHTBIT)
	{	/* eight bit terminal	*/
	wbinary(0,0);	/* set to binary mode	*/
	};
    sys$dassgn(termchan);	
}
#endif
