/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: net_read.c,v 1.2 87/04/24 15:20:16 davidb Exp $ */
static char sccsId[] = "@(#)net_read.c	1.10 8/29/85";

/*
 * User telnet program.
 */
#define	TELOPTS
#include "telnetc.h"

#define	ctrl(x)		((x) & 037)
#define	strip(x)	((x)&0177)
#define	INFINITY	((long)10000000)

extern  int	showoptions;
int	scc = 0;
char	sibuf[XBUFSIZ] = {0};
char	*sbp = (char *)0;
extern	int retcrlf;	/* useful for shared memory implementations */

char	ttyobuf[XBUFSIZ] = {0}, *tfrontp = ttyobuf, *tbackp = ttyobuf;
XFILE	*netoutp = XNULL;
extern	XFILE *xodopen();

char	hisopts[256] = {0};
char	myopts[256] = {0};

char	doopt[] = { IAC, DO, '%', 'c', 0 };
char	dont[] = { IAC, DONT, '%', 'c', 0 };
char	will[] = { IAC, WILL, '%', 'c', 0 };
char	wont[] = { IAC, WONT, '%', 'c', 0 };

int	flushing = 0;	/* Flag, >0 if we're flushing until TM */
int	nochange = 1;	/* no options agreed on this round */
int	pause_flag = 0; /* Flag, != 0 if we're to stop reading until restarted*/

extern int localecho;		/* local echo in force */

/*
 *  Read from net, pass to tty
 */
net_read( term_pid, net_fd, tout )

	int term_pid;	/* id of terminal to network process */
	int net_fd;	/* network descriptor */
	int tout;	/* terminal descriptor */
{
	static int firsttime = 1;
	int copy_fd;
	int rval;


	if( firsttime )
		{
		/*
		setup, if any
		*/
		copy_fd = xnewod();
		rval = xdup2( net_fd, copy_fd );
		if( rval < 0 )
			xperror( rval, "xdup2" );
		netoutp = xodopen( copy_fd, "w" );
		xsetbuf(netoutp, 0, 0);
		retcrlf = 1;		/* startoff with no remote echo */
		VOID mode(2);
		firsttime = 0;
		}
	recvflag();			/* get flags from net_write */
#ifdef TWO_PROCESSES
	while( pause_flag ) {
		xsleep(1);		/* yield processor */
		recvflag();		/* check if flag has changed */
	}
#endif	/* TWO_PROCESSES */
	scc = xread(net_fd, sibuf, sizeof(sibuf));
	if ((scc < 0) && (scc != XEOF) &&
		(( scc == XEWOULDBLOCK) || (scc == XEINTR)))
		return( 1 );
	if (scc < 0)
		{
		/*
		restore terminal state,
		terminate other process
		terminate self
		*/
		mode( 0 );
		xkill( term_pid );
		xexit( 0 );
		}
	sbp = sibuf;
	telrcv();	/* process net data */
	while ((tfrontp - tbackp) > 0)
		{
		ttyflush(tout);
		}
	return( 1 );
}


/*
 * Telnet receiver states for fsm
 */
#define	TS_DATA		0
#define	TS_IAC		1
#define	TS_WILL		2
#define	TS_WONT		3
#define	TS_DO		4
#define	TS_DONT		5
#define TS_CR		6

telrcv()
{
	register int c;
	static int state = TS_DATA;

	while (scc > 0) {
		c = *sbp++ & 0377, scc--;
		switch (state) {

		case TS_DATA:
			if (c == IAC) {
				recvflag();	/* the other side may be
						   trying to negotiate an option
						*/
				state = TS_IAC;
			} else if( flushing <= 0 ) {
				if( c == '\r' && retcrlf && scc )
					state = TS_CR;
				else
					*tfrontp++ = c;
			}
			continue;

		case TS_CR:
			if( c == '\n' )
				{
				*tfrontp++ = '\n';
				state = TS_DATA;
				}
			else if ( c == IAC )
				{
				/*
				The simplifying assumption is that '\r'
				followed by telnet control information,
				followed by '\n' isn't a telnet end of
				line.
				*/
				*tfrontp++ = '\r';
				state = TS_IAC;
				}
			else
				{
				*tfrontp++ = '\r';
				*tfrontp++ = c;
				state = TS_DATA;
				}
			continue;
		case TS_IAC:
			switch (c) {
			
			case WILL:
				state = TS_WILL;
				continue;

			case WONT:
				state = TS_WONT;
				continue;

			case DO:
				state = TS_DO;
				continue;

			case DONT:
				state = TS_DONT;
				continue;

			case DM:
				xfflush(xstdout);		/* ? */
				break;

			case NOP:
			case GA:
				break;
			case IAC:
				if( flushing <= 0 ) *tfrontp++ = c;
				break;

			default:
				break;
			}
			state = TS_DATA;
			continue;

		case TS_WILL:
			printoption("RCVD", will, c, hisopts[c] == OPT_DISABLE);
			if( c == TELOPT_TM ) {
				--flushing;
			}
			willoption(c);
			state = TS_DATA;
			continue;

		case TS_WONT:
			printoption("RCVD", wont, c, hisopts[c] == OPT_ENABLE);
			if( c == TELOPT_TM ) {
				--flushing;
			}
			wontoption(c);
			state = TS_DATA;
			continue;

		case TS_DO:
			printoption("RCVD", doopt, c, myopts[c] == OPT_DISABLE);
			dooption(c);
			state = TS_DATA;
			continue;

		case TS_DONT:
			printoption("RCVD", dont, c, myopts[c] == OPT_ENABLE);
			dontoption(c);	
			state = TS_DATA;
			continue;
		}
	}
}

willoption(option)
	int option;
{
	char *fmt;
	int reply;		/* whether to reply */

	if (hisopts[option] == OPT_ENABLE)
		return;		/* already set, no action needed */
	nochange = 0;		/* inform the other side */
	reply = (hisopts[option] == OPT_DISABLE);

	switch (option) {

	case TELOPT_ECHO:
		retcrlf = 0;
		VOID  mode(1);
		localecho = OPT_DISABLE;	/* remote echo */
	
	case TELOPT_SGA:
	case TELOPT_BINARY:
		hisopts[option] = OPT_ENABLE;
		fmt = doopt;
		break;
	
	default:
		fmt = dont;
		hisopts[option] = OPT_DISABLE;
		break;

	}
	if( reply && (netoutp != XNULL)) {
		xoprintf( netoutp, fmt, option);
		printoption("SENT", fmt, option, 0);
	};
}

wontoption(option)
	int option;
{
	char *fmt;
	int reply;	/* whether to reply or not */

	if (hisopts[option] == OPT_DISABLE)
		return;	/* already disabled, return */
	nochange = 0;		/* inform the other side something happened */
	reply = (hisopts[option] == OPT_ENABLE);

	switch (option) {

	case TELOPT_ECHO:
		retcrlf = 1;
		localecho = OPT_ENABLE;
		charmode = OPT_DISABLE;	/* set to line mode by default */
		VOID  mode(2);
	
	default:
		hisopts[option] = OPT_DISABLE;
		fmt = dont;
	}
	if( reply && (netoutp != XNULL) ) {
		xoprintf( netoutp, fmt, option);
		printoption("SENT", fmt, option, 0);
	};
}

dooption(option)
	int option;
{
	char *fmt;
	int reply;		/* whether to reply or not */

	if (myopts[option] == OPT_ENABLE)
		return;		/* already enabled */

	nochange = 0;		/* inform the other side something happened */
	reply = (myopts[option] == OPT_DISABLE);

	switch (option) {

	case TELOPT_SGA:
	case TELOPT_BINARY:
		fmt = will;
		myopts[option] = OPT_ENABLE;			
		break;

	/*
	 * fix from allegra!jdd for 3Com UNET uvtp servers
	 */
	case TELOPT_ECHO:
		retcrlf = 1;
		VOID  mode(2);
		fmt = will;
		localecho = OPT_ENABLE;
		charmode = OPT_DISABLE;	/* set to line mode by default */
		myopts[TELOPT_ECHO] = OPT_ENABLE;
		break;

	default:
		myopts[option] = OPT_DISABLE;
		fmt = wont;
		break;
	}
	if( reply && (netoutp != XNULL) ) {
		xoprintf(netoutp, fmt, option);
		printoption("SENT", fmt, option, 0);
	};
}

dontoption(option)
	int option;
{
	char *fmt;
	int reply;		/* whether to reply or not */

	if (myopts[option] == OPT_DISABLE)
		return;		/* already disabled */			
	nochange = 0;		/* inform the other side something happened */

	reply = (myopts[option] == OPT_ENABLE);

	switch (option) {

	case TELOPT_ECHO:
		retcrlf = 0;
		VOID  mode(1);
		fmt = wont;
		localecho = OPT_DISABLE;
		myopts[TELOPT_ECHO] = OPT_DISABLE;
		break;

	default:
		myopts[option] = OPT_DISABLE;
		fmt = wont;
		break;
	}
	if( reply && (netoutp != XNULL) ) {
		xoprintf(netoutp, fmt, option);
		printoption("SENT", fmt, option, 0);
	};
}


ttyflush(fd)
{
	int n;

	if ((n = tfrontp - tbackp) > 0)
		n = xwrite(fd, tbackp, n);
	if (n < 0)
		return( n );
	tbackp += n;
	if (tbackp == tfrontp)
		tbackp = tfrontp = ttyobuf;
	return( n );
}


/*VARARGS*/
printoption(direction, fmt, option, what)
	char *direction, *fmt;
	int option, what;
{
	if (!showoptions)
		return;
	xoprintf(xstdout, "%s ", direction);
	if (fmt == doopt)
		fmt = "do";
	else if (fmt == dont)
		fmt = "dont";
	else if (fmt == will)
		fmt = "will";
	else if (fmt == wont)
		fmt = "wont";
	else
		fmt = "???";
	if (option < TELOPT_SUPDUP)
		xoprintf(xstdout, "%s %s", fmt, telopts[option]);
	else
		xoprintf(xstdout, "%s %d", fmt, option);
	if (*direction == '<') {
		xoprintf(xstdout, "\r\n");
		return;
	}
	xoprintf(xstdout, " (%s)\r\n", what ? "reply" : "don't reply");
}

extern ip_forward();	/* for VMS, this is defined in net_write.c */

mode ( newval )

int newval;
{
static int oldval = 2;

if( newval == oldval )
	return;
oldval = newval;
switch ( newval ) {
	case 0:
		/*
		done before returning to user
		*/
		xrestore_term();
		break;
	case 1:
		xraw_term( ip_forward );
		break;
	case 2:
		/*
		line mode operation within telnet.
		(note signals are turned off for net_read by
		xmux_io).
		*/
		xrestore_term( );
		break;
	default:
		break;
	}
}
