/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ruptime.c,v 1.3 87/05/15 11:17:36 davidb Exp $ */
static char sccsId[] = "@(#)ruptime.c	1.8 7/16/85";

/*
 * Remote uptime command
 */
#include <sys/types.h>
#include <stdio.h>
#include <sys/extypes.h> /* For u_char, etc., defns. dab 861125. */
#include <ndir.h>
#include <utmp.h>
#include "rwhod.h"

#define	NHOSTS	100
int	nhosts = 0;
struct	hs {
	struct	whod *hs_wd;
	int	hs_nusers;
} hs[NHOSTS];
struct	whod awhod;
int	hscmp();

#define	WHDRSIZE	(sizeof (awhod) - sizeof (awhod.wd_we))
#define	RWHODIR		"/usr/spool/rwho"

char	*interval();
long	now = 0;
char	*malloc();
int	aflg = 0;

main(argc, argv)
	int argc;
	char **argv;
{
	struct direct *dp;
	int f, i, t;
	char buf[BUFSIZ]; int cc;
	register struct hs *hsp = hs;
	register struct whod *wd;
	register struct whoent *we;
	int maxloadav = 0;
	register DIR *	dirp;

	time(&t);
	argc--, argv++;
again:
	if (argc > 0 && !strcmp(*argv, "-a")) {
		aflg++;
		argc--, argv++;
		goto again;
	}
	if (chdir(RWHODIR) < 0) {
		experror(RWHODIR);
		exit(1);
	}
	if ((dirp = opendir(".")) == NULL) {
		experror(RWHODIR);
		exit(1);
	}
	while (dp=readdir(dirp)) {
		if (dp->d_ino == 0)
			continue;
		if (strncmp(dp->d_name, "whod.", 5))
			continue;
		if (nhosts == NHOSTS) {
			fprintf(stderr, "too many hosts\n");
			exit(1);
		}
		f = open(dp->d_name, 0);
		if (f > 0) {
			cc = read(f, buf, BUFSIZ);
			if (cc >= WHDRSIZE) {
				hsp->hs_wd = (struct whod *)malloc(WHDRSIZE);
				wd = (struct whod *)buf;
				xbcopy(buf, hsp->hs_wd, WHDRSIZE);
				hsp->hs_nusers = 0;
				for (i = 0; i < 2; i++)
					if (wd->wd_loadav[i] > maxloadav)
						maxloadav = wd->wd_loadav[i];
				we = (struct whoent *)(buf+cc);
				while (--we >= wd->wd_we)
					if (aflg || we->we_idle < 3600)
						hsp->hs_nusers++;
				nhosts++; hsp++;
			}
		}
		(void) close(f);
	}
	closedir(dirp);
	qsort((char *)hs, nhosts, sizeof (hs[0]), hscmp);
	(void) time(&now);
	if (nhosts == 0) {
		printf("no hosts!?!\n");
		exit(1);
	}
	for (i = 0; i < nhosts; i++) {
		hsp = &hs[i];
		if (now - hsp->hs_wd->wd_recvtime > 5 * 60) {
			printf("%-8.8s%s\n", hsp->hs_wd->wd_hostname,
			    interval(now, hsp->hs_wd->wd_recvtime, "down"));
			continue;
		}
		printf("%-8.8s%s,  %4d user%s",
		    hsp->hs_wd->wd_hostname,
		    interval(hsp->hs_wd->wd_sendtime,
			hsp->hs_wd->wd_boottime, "  up"),
		    hsp->hs_nusers,
		    hsp->hs_nusers == 1 ? "" : "s");
		if(hsp->hs_wd->wd_loadav[0] != 0)
		    printf(",  load %*.2f, %*.2f, %*.2f",
			maxloadav >= 1000 ? 5 : 4,
			    hsp->hs_wd->wd_loadav[0] / 100.0,
			maxloadav >= 1000 ? 5 : 4,
			    hsp->hs_wd->wd_loadav[1] / 100.0,
			maxloadav >= 1000 ? 5 : 4,
			    hsp->hs_wd->wd_loadav[2] / 100.0);
		printf("\n");
		cfree(hsp->hs_wd);
	}
	exit(0);
}

char *
interval(after, before, updown)
	long after, before;
	char *updown;
{
	static char resbuf[32];
	long time;
	long days, hours, minutes;

	if(before == 0 || after == 0) {
		(void) sprintf(resbuf, "%s         ", updown);
		return (resbuf);
	}
	time = after - before;
	if (time < 0 || time > 7776000L /* 3*30*24*60*60 */) {
		(void) sprintf(resbuf, "%s    ??:??", updown);
		return (resbuf);
	}
	minutes = (time + 59) / 60;		/* round to minutes */
	hours = minutes / 60; minutes %= 60;
	days = hours / 24; hours %= 24;
	if (days)
#if SYSTEM3 || SYSTEM5
		(void) sprintf(resbuf, "%s %2ld+%.2ld:%.2ld",
		    updown, days, hours, minutes);
#else
		(void) sprintf(resbuf, "%s %2ld+%02ld:%02ld",
		    updown, days, hours, minutes);
#endif
	else
#if SYSTEM3 || SYSTEM5
		(void) sprintf(resbuf, "%s    %2ld:%.2ld",
		    updown, hours, minutes);
#else
		(void) sprintf(resbuf, "%s    %2ld:%02ld",
		    updown, hours, minutes);
#endif
	return (resbuf);
}

hscmp(h1, h2)
	struct hs *h1, *h2;
{

	return (strcmp(h1->hs_wd->wd_hostname, h2->hs_wd->wd_hostname));
}
