/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: rsh.c,v 1.5 87/05/15 10:33:01 davidb Exp $ */
/*

$Header: rsh.c,v 1.5 87/05/15 10:33:01 davidb Exp $

$Project: rsh$

$Creator: $

$Locker:  $

$Source: /a/8000/8000S/sdist/src/bin/netser/rsh.c,v $

----------------------------------------------------------------------------

(C) Copyright 1984,1985,1986 by Excelan Inc. All Rights Reserved

This software is furnished under contract and may be used and copied
only in accordance with the terms of such contract and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to
any other person. No title to and ownership of the software is hereby 
transferred.
----------------------------------------------------------------------------

$Abstract: 
	This is the generic part of rsh.
$


$Dependencies: 
	This module is OS independent with the exception of 
	conditional includes.
$



$Implementation Notes: 
	This is the OS independent part of the rsh client.
	When rsh gets control at xmain entry point the xlib objects
	xstdin,xstdout and xstderr are already setup. The arguments
	are now parsed. Invoking rsh without a command is not supported.
	After successfully parsing the arguments the user specified remote
	command is built in a buffer, the user's local name obtained by
	calling xgetuname and the same is used for remote name unless the
	user specified a different remote user name with the -l option.

		Rcmd is now called to establish connections to the remote
	rshd. After the connections are successfully established xrshio
	is called to perform the data transfer. Some generic data transfer
	routines such as read_from_net and read_stdin are implemented here
	and passed as arguments to xrshio which calls them back at
	appropriate points in the data transfer loop.
$



$Log:	rsh.c,v $
 * Revision 1.5  87/05/15  10:33:01  davidb
 * PMR002078: Fixed #ifdefs on the VMS side so new UNIX C compilers won't 
 * complain
 * 
 * Revision 1.18  87/05/14  00:23:12  alexl
 * *** empty log message ***
 * 
 * Revision 1.18  87/05/13  23:55:02  alexl
 * *** empty log message ***
 * 
 * Revision 1.17  87/05/11  15:14:31  davidb
 * PMR002071. New copyright message
 * 
 * Revision 1.16  87/05/11  14:09:20  davidb
 * Add 5 lines to be replaced by new copyright message.
 * 
 * Revision 1.15  87/03/17  17:45:32  grant
 * generizied rshd and rsh
 * 
 * Revision 1.2  86/11/21  12:49:59  kball
 * Upgrade to PMR 1302 changes in UNIX sources in generic tree.
 * 
 * Revision 1.1  86/11/20  14:46:57  rajeev
 * Initial revision
 * 

$EndLog$ 


*/



/* Functions */
/* --------- */


/*
$Name: $
*/

/* 

$Description: 
$ 

$Return: 
$

$Bugs: 
$


$Method: 
$
*/
#ifdef	vms
#include 	<stdxln.h>
#include	<xstdio.h>
#include	<xctype.h>
#include	<misc.h>
#include	<socket.h>
#include	<soioctl.h>
#include	<in.h>
#include	<xerrno.h>
#define	NAMEMSG	"who are you?\n"
#endif vms

#ifdef UNIX
#include <xstdio.h>
#include <xspecial.h>
#include <xctype.h>
#include <xerrno.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/soioctl.h>
#define	NAMEMSG	"who are you?\n"
#define IMPORT extern
#define PRIVATE static
#endif	UNIX

#ifdef DOS
#include <stdxln.h>
#include <xstdio.h>
#include <xspecial.h>
#include <xctype.h>
#include <sys\types.h>
#include <exos\misc.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <errno.h>
#include <xerrno.h>

#define NAMEMSG "\n"
#endif DOS

IMPORT char *xmalloc(), *xgetuname();

/*
 * rsh - remote shell
 */
/* VARARGS */


int	options  = 0;		/* socket options	*/
int	rfd2;			/* "stderr" socket */
int 	rem;			/* remote "stdio"socket */
PRIVATE	read_from_net(),read_stdin(),rsh_abort(); 

xmain(argc, argv0)
int argc;
char **argv0;
{
char	**argv	= argv0;		/* argument list	*/
char	*host;				/* host name		*/
int 	asrsh = 0;			/* flag to show if invoked as rsh */
char	*cp;				/* character pointer	*/
char	*user = 0;			/* user name		*/
char	**ap;				/* argument pointer	*/
char	*myname;			/* my name		*/
char	*args;				/* arguments used	*/
int	cc;				/* character count	*/
int 	stdin_eof = 0;			/* remember -n option 	*/
int 	how = 1;

    	argv++, --argc;
    	if (argc == 0)
		goto usage;
	host = *argv++, --argc; /* host name is after 0th arg */

another:
    if (argc == 0)
	goto doneargs;
    if (!xstrcmp(*argv, "-l")) 
	{
	argv++, argc--;
	if (argc > 0)
	    user = *argv++, argc--; /* use different user on remote */
	goto another;
	}
    if (!xstrcmp(*argv, "-n")) /* do not attempt to read stdin */
	{
	argv++, argc--;
	stdin_eof = 1;
	goto another;
	}
    if (!xstrcmp(*argv, "-d")) 
	{
	argv++, argc--;
	options |= SO_DEBUG;
	goto another;
	}

doneargs:
    if (host == 0)
	goto usage;		/* no remote host specified	*/

    if (argv[0] == 0) 
	{
	    xoprintf(xstderr, "No command specified\n");
	    xexit(1);
	};

    myname = xgetuname(); /* get user name for current process */
    if (myname == (char *)XNULL) /* no user name for current process !?#*@*/
	{
	xoprintf(xstderr, NAMEMSG);
	xexit(1);
	}

	/* build command string */
    	cc = 0;
    	for (ap = argv; *ap; ap++)
		cc += xstrlen(*ap) + 1;
    	cp = args = xmalloc(cc);
    	for (ap = argv; *ap; ap++) 
	{
		xstrcpy(cp, *ap);
		while (*cp)
	    		cp++;
		if (ap[1])
	    	*cp++ = ' ';
	}; /* args points to the remote command now */

/*** 	now perform the protocol setup by calling xrcmd. successful
 ***	return from xrcmd implies connections to remote rshd are set up.
***/
    	rem = xrcmd(&host, IPPORT_CMDSERVER, myname,
    		user ? user : myname, args, &rfd2);
    	if (rem < 0) /* error in protocol setup */
		xexit(1);
	xioctl(rem,FIONBIO,&how);	/* set sockets to non blocking i/o */
	xioctl(rfd2,FIONBIO,&how);

	if(stdin_eof)		/* -n was specified */
		xioctl(rem, SIOCDONE, &how);	/* no more ouput on rem */

/***
	now call xrshio to do the actual data transfer
***/
    	xrshio(rem,rfd2,read_from_net,read_stdin,rsh_abort,stdin_eof);
	xexit(0);
usage:
	xoprintf(xstderr,
	    "usage: rsh host [ -l login ] [ -n ] command\n");
	xexit(1);
} /*end main*/

/*** 
	read_from_net:

	routine called by xrshio to read from a selected socket as
	specified by ready. This routine reads rfd2 and writes to 
	stderr, reads rem and writes to stdout. If an error occurs
	while reading from either rem or rfd2 it is  dropped from
	the original select mask provided by the second parameter
	readfrom.
***/
static read_from_net(ready,readfrom)
long	ready; /* mask of selected objects */
long	*readfrom; /* original select mask to be modified on err/eof */
{
	char buf[XBUFSIZ];
	int incnt;

	if (ready & (1 << rfd2)) 
	    {	/* get input from remote's stderr	*/
	    incnt = xread(rfd2, buf, sizeof buf);
	    if (incnt <= 0) 
		{
		if (incnt != XEWOULDBLOCK)
			{
			*readfrom &= ~(1 << rfd2); /* do not select anymore */
			if (incnt != XEOF)
				xperror(incnt, "Read error on stderr socket");
			}
		}
	    else
		xwrite(xfileno(xstderr), buf, incnt); /* write to stderr */
	    };

	if (ready & (1 << rem)) 
	    {	/* get input from remote's output	*/
	    incnt = xread(rem, buf, sizeof buf);
	    if (incnt <= 0) 
		{
		if (incnt != XEWOULDBLOCK)
			{
			*readfrom &= ~(1 << rem); /* do not select anymore */
			if (incnt != XEOF)
				xperror(incnt,"Read error on stdio socket");
			}
		}
	    else
		xwrite(xfileno(xstdout), buf, incnt); /* write to stdout */
	    };
} /*end read_from_net*/

/***
	read_stdin:  read from stdin and write to rem

	Returns: 0 if EOF or Error on read from standard in or write to
		   the stdio socket, rem.
		 1 if read and wrote successfully.

	Called by xrshio().

	If error prints error message and signals EOF on socket to
	remote host.  If EOF just signals EOF on socket to remote
	host.
***/
static read_stdin()
{
	char buf[XBUFSIZ],*outptr;
	int incnt,outcnt,one = 1;

	incnt = xread(xfileno(xstdin), buf, sizeof buf); /* read stdin */
    	if (incnt <= 0)
		{
		xioctl(rem, SIOCDONE, &one);	/* no more output */
		if (incnt != XEOF)
			xperror(incnt,"Read error on stdin");
		return( 0 );
		}
	while (incnt > 0) {
	    outptr = buf;
	    outcnt = xwrite(rem, outptr, incnt); /* write to remote */
	    if (outcnt < 0) {
	    	/*
	    	Should check for transitory errors such as EWOULDBLOCK
	    	here.  Otherwise, data could be lost.
	    	*/
		if( outcnt != XEWOULDBLOCK )
			{
			xioctl(rem, SIOCDONE, &one);	/* no more output */
			if (outcnt)
				xperror(outcnt,"Write error on stdio socket");
			return( 0 );
			}
		continue;	/* if transitory error */
	    }
	    incnt -= outcnt;
	    outptr += outcnt;
	};
	return( 1 );
} /*end read_stdin*/

/***
	rsh_abort:  abort rsh

	Called by xrshio().

	On user abort, try to signal remote host rshd that shutting
	down.  Close both sockets and then exit program with an error
	return code.
***/
static rsh_abort(byte)
char byte;
{
	xwrite(rfd2,&byte,1);	/* write the byte to stderr socket */
	xclose(rem);		/* close stdio socket */
	xclose(rfd2);		/* close stderr socket */
	xexit(1);		/* abort */
} /*end rsh_abort*/
