/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: nlist.c,v 1.2 87/04/24 15:11:43 davidb Exp $ */
/* %W% %G% */

#include "netstat.h"

#ifdef notdef
long	lseek();
#else
char	buf[8192] = {0};	/* read a bunch of data instead of seeking */
#endif
extern	int dflag;
extern	char *myname;

struct	exec86v7 {
	unsigned short	x7_magic;
	unsigned short	x7_textsiz;
	unsigned short	x7_datasiz;
	unsigned short	x7_bsssiz;
	unsigned short	x7_symsiz;
	unsigned short	x7_entry;
	unsigned short	x7_pad1;
	unsigned short	x7_reloc;
} exec = {0};

#define	ID86V7	0411		/* expect this in x7_magic */

int	hilo = 1;	/* data order for 68K-based cc86 */

u_short
cxswap(s)
u_short s;
{
	char *cp = (char *)&s;

	if (hilo)
		return ( ((*cp<<8) | (*(cp+1)&0xFF)) & 0x0000ffffL);
	else
		return ( ( (*(cp+1)<<8) | (*cp&0xFF) ) & 0x0000ffffL);
}

nlist(nmfile, nl)
char *nmfile;
struct nlist86v7 *nl;
{
	int nmfd;
	int nread;
	long skipsize, symsize;

	if (dflag) {
		xoprintf(xstdout, "opening net module\n" );
	}
	if ((nmfd = xdopen(nmfile, XFREAD, FILE_NAME)) == -1) {
		xperror(nmfd, nmfile);
		goto error;
	}


    /* read a.out exec header */

	nread = xread(nmfd, &exec, sizeof(exec));
	if (nread != sizeof(exec)) {
		if (nread >= 0)
			xoprintf(xstderr, "%s: incomplete read (%d/%d)\n",
				myname, nread, sizeof(exec));
		else
			xperror(nread, myname);
		goto error;
	}

	if (cxswap(exec.x7_magic) != ID86V7)
		hilo = 0;	/* try VAX/8086/PDP11 byte order */
	if (cxswap(exec.x7_magic) != ID86V7) {
		xoprintf(xstderr, "bad magic in %s\n", nmfile);
		goto error;
	}

	if (dflag) {
		xoprintf(xstdout,"magic =   0x%4x\n", cxswap(exec.x7_magic));
		xoprintf(xstdout,"textsiz = 0x%4x\n", cxswap(exec.x7_textsiz));
		xoprintf(xstdout,"datasiz = 0x%4x\n", cxswap(exec.x7_datasiz));
		xoprintf(xstdout,"bsssiz =  0x%4x\n", cxswap(exec.x7_bsssiz));
		xoprintf(xstdout,"symsiz =  0x%4x\n", cxswap(exec.x7_symsiz));
		xoprintf(xstdout,"entry =   0x%4x\n", cxswap(exec.x7_entry));
		xoprintf(xstdout,"reloc =   0x%4x\n", cxswap(exec.x7_reloc));
	}

	skipsize = cxswap(exec.x7_textsiz) + cxswap(exec.x7_datasiz);
	symsize = cxswap(exec.x7_symsiz);

	if (dflag) {
		xoprintf(xstdout, "skipping %X bytes\n", skipsize);
	}
#ifndef notdef
	while (skipsize) {
		int ntoread = MIN(sizeof(buf), skipsize);

		nread = xread(nmfd, buf, ntoread);
		if (nread < ntoread) {
			xoprintf(xstderr,
				"%s: missing text in %s.\n", myname, nmfile);
			goto error;
		}
		if (nread < 0 ) {
			xperror( nread, myname);
			goto error;
		}
		skipsize -= nread;
	}
#else
	if (xlseek(nmfd, skipsize, 1) < 0) {
		xoprintf(xstderr, "%s: lseek failed\n", myname);
		goto error;
	}
#endif

	if (dflag) {
		xoprintf(xstdout, "reading symbol table (%X bytes)\n", symsize);
	}
	while (symsize) {
		struct nlist86v7 symbol, *nlp;

		nread = xread(nmfd, &symbol, sizeof(struct nlist86v7));
		if (nread < sizeof(struct nlist86v7)) {
			xoprintf(xstderr,
				"%s: incomplete symbol table entry in %s.\n",
				myname, nmfile);
			goto error;
		}
		if (nread < 0 ) {
			xperror(nread, myname);
			goto error;
		}
		symsize -= nread;
		symbol.n_type = cxswap(symbol.n_type) & ~EXT_86V7;
		symbol.n_value = cxswap(symbol.n_value);
		for (nlp = nl; nlp->n_name[0] != 0; nlp++) {
			if (((symbol.n_type == DATA_86V7)
			  || (symbol.n_type == BSS_86V7))
			&& (xstrncmp(symbol.n_name, nlp->n_name, 8) == 0)) {
				nlp->n_type = symbol.n_type;
				nlp->n_value = symbol.n_value;
				if (dflag)
					xoprintf(xstdout, "%8.8s %x, %x\n",
						symbol.n_name,
						symbol.n_type,
						symbol.n_value);
			}
		}
	}

	xclose(nmfd);

	if (dflag) {
		xoprintf(xstdout, "ALL IS WELL\n" );
	}
	return;
error:
	xoprintf(xstderr, "%s: symbol lookup failed\n", myname);
	xexit(-1);
}
