/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: inet.c,v 1.2 87/04/24 15:09:46 davidb Exp $ */
/* %W% %G% */

#include "netstat.h"
#ifdef	vms
#include	"h_xlib/in.h"
#else
#include <netinet/in.h>
#endif

/*
   The following data structure (tcpstates) used to be contained in
   include/EXOS/netinet/tcp_fsm.h, which has been removed. dab 861118.
   Also TCP_NSTATES.
*/

#define TCP_NSTATES 11	/* The number of states in the TCP finite state
			   machine */
char *tcpstates[] = {
	"CLOSED",	"LISTEN",	"SYN_SENT",	"SYN_RCVD",
	"ESTABLISHED",	"CLOSE_WAIT",	"FIN_WAIT_1",	"CLOSING",
	"LAST_ACK",	"FIN_WAIT_2",	"TIME_WAIT",
};

long	xhtonl();

struct ipstat {
	u_short	ips_badsum;
	u_short	ips_tooshort;
};

#define	udps_badsum udps_sum
#define	udps_badlen udps_len

struct udpstat {
	u_short	udps_hdrops;
	u_short	udps_badsum;
	u_short	udps_badlen;
};

#define tcps_badsum tcps_sum
#define tcps_badoff tcps_off
#define tcps_badsegs tcps_segs

struct	tcpstat {
	u_short	tcps_badsum;
	u_short	tcps_badoff;
	u_short	tcps_hdrops;
	u_short	tcps_badsegs;
	u_short	tcps_unack;
};

union usa {
	short		Sa_family;	/* AF_INET or AF_ETYPE */
	struct {
		short	Sin_family;	/* AF_INET */
		u_short	Sin_port;	/* TCP/UDP port */
		u_long	Sin_addr;	/* Internet address */
		char	Sin_zero[8];	/* must be 0 */
	} usa_in;
	struct {
		short	Sl_family;	/* AF_ETYPE */
		u_short	Sl_types[6];	/* null-padded ENET type list */
		short	Sl_zero;	/* must be 0 */
	} usa_link;
};

/*
 * WARNING - won't align on VAX.
 */
struct route {
	u_short	ro_rt;		/* pointer to rtentry */
	union	usa ro_dst;
};

/*
 * WARNING - won't align on VAX.
 */
struct rtentry {
	union	usa rt_dst;		/* key */
	union	usa rt_gateway;		/* value */
	u_short	rt_next;       		/* next pointer */
	u_short	rt_pad0;       		/* pad */
	u_long	rt_use;			/* raw # packets forwarded */
	u_short	rt_ifp;			/* the answer: interface to use */
	u_short	rt_pad1;       		/* pad */
	char    rt_flags;               /* up/down?, host/net */
	char    rt_refcnt;              /* # held references */
	u_short rt_hash;                /* to speed lookups */
};

#define	RTF_UP		0x1		/* route useable */
#define	RTF_GATEWAY	0x2		/* destination is a gateway */
#define	RTF_HOST	0x4		/* host entry (net otherwise) */

/*
 * WARNING - won't align on VAX.
 */
struct inpcb {
	u_short	inp_next, inp_prev;	/* pointers to other pcb's */
	u_short	inp_head;		/* pointer back to chain of inpcb's
					   for this protocol */
	u_long	inp_faddr;		/* foreign host table entry */
	u_short	inp_fport;		/* foreign port */
	u_long	inp_laddr;		/* local host table entry */
	u_short	inp_lport;		/* local port */
	u_short	inp_socket;		/* back pointer to socket */
	u_short	inp_ppcb;		/* pointer to per-protocol pcb */
	struct	route inp_route;	/* placeholder for routing entry */
};

/*
 * Alignment-proof version.
 */

struct xicb {
/*00*/	u_short	xinp_next, xinp_prev;	/* pointers to other pcb's */
/*04*/	u_short	xinp_head;		/* pointer back to chain of inpcb's
					   for this protocol */
/*06*/	u_short	xinp_faddr[2];		/* foreign host table entry */
/*10*/	u_short	xinp_fport;		/* foreign port */
/*12*/	u_long	xinp_laddr;		/* local host table entry */
/*16*/	u_short	xinp_lport;		/* local port */
/*18*/	u_short	xinp_socket;		/* back pointer to socket */
/*20*/	u_short	xinp_ppcb;		/* pointer to per-protocol pcb */
/*22*/	struct	route xinp_route;	/* placeholder for routing entry */
};

#define	TCPT_NTIMERS 5
struct tcpcb {
	u_short seg_next;		/* sequencing queue */
	u_short seg_prev;
	short	t_state;		/* state of this connection */
	short	t_timer[TCPT_NTIMERS];	/* tcp timers */
	short	t_rxtshift;		/* log(2) of rexmt exp. backoff */
	short	t_tcpopt;		/* tcp options */
	short	t_ipopt;		/* ip options */
	short	t_maxseg;		/* maximum segment size */
	char	t_force;		/* 1 if forcing out a byte */
	u_char	t_flags;
#define	TF_ACKNOW	0x01			/* ack peer immediately */
#define	TF_DELACK	0x02			/* ack, but try to delay it */
#define	TF_DONTKEEP	0x04			/* don't use keep-alives */
#define	TF_NOOPT	0x08			/* don't use tcp options */
#define TF_DEBUG	0x20			/* foo */
	short	t_template;		/* skeletal packet for transmit */
	short	t_inpcb;		/* back pointer to internet pcb */
/* send sequence variables */
	u_long	snd_una;		/* send unacknowledged */
	u_long	snd_nxt;		/* send next */
	u_long	snd_up;			/* send urgent pointer */
	u_long	snd_wl1;		/* window update seg seq number */
	u_long	snd_wl2;		/* window update seg ack number */
	u_long	iss;			/* initial send sequence number */
	u_short	snd_wnd;		/* send window */
/* receive sequence variables */
	short	rcv_wnd;		/* receive window */
	u_long	rcv_nxt;		/* receive next */
	u_long	rcv_up;			/* receive urgent pointer */
	u_long	irs;			/* initial receive sequence number */
/* receive variables */
	u_long	rcv_adv;		/* advertised window */
/* retransmit variables */
	u_long	snd_max;		/* highest sequence number sent
					   used to recognize retransmits */
/* transmit timing stuff */
	short	t_idle;			/* inactivity time */
	short	t_rtt;			/* round trip time */
	u_long	t_rtseq;		/* sequence number being timed */
	short   t_srtt;                 /* smoothed round-trip time (*10) */
	short	t_throttle;		/* counter: try to throttle connections
				       	 * when system is short of buffers */
/* out-of-band data */
	char	t_oobflags;		/* have some */
	char	t_iobc;			/* input character */
#define	TCPOOB_HAVEDATA	0x01
};

struct xtcpcb {
/*00*/	u_short seg_next;		/* sequencing queue */
/*02*/	u_short seg_prev;
/*04*/	short	t_state;		/* state of this connection */
/*06*/	short	t_timer[TCPT_NTIMERS];	/* tcp timers */
/*08*/	short	t_rxtshift;		/* log(2) of rexmt exp. backoff */
/*10*/	short	t_tcpopt;		/* tcp options */
/*12*/	short	t_ipopt;		/* ip options */
/*14*/	short	t_maxseg;		/* maximum segment size */
/*16*/	char	t_force;		/* 1 if forcing out a byte */
/*17*/	u_char	t_flags;
#define	TF_ACKNOW	0x01			/* ack peer immediately */
#define	TF_DELACK	0x02			/* ack, but try to delay it */
#define	TF_DONTKEEP	0x04			/* don't use keep-alives */
#define	TF_NOOPT	0x08			/* don't use tcp options */
#define TF_DEBUG	0x20			/* foo */
/*18*/	short	t_template;		/* skeletal packet for transmit */
/*20*/	short	t_inpcb;		/* back pointer to internet pcb */
/* send sequence variables */
/*22*/	u_long	snd_una;		/* send unacknowledged */
/*26*/	u_long	snd_nxt;		/* send next */
/*30*/	u_long	snd_up;			/* send urgent pointer */
/*34*/	u_long	snd_wl1;		/* window update seg seq number */
/*38*/	u_long	snd_wl2;		/* window update seg ack number */
/*42*/	u_long	iss;			/* initial send sequence number */
/*46*/	u_short	snd_wnd;		/* send window */
/* receive sequence variables */
/*48*/	short	rcv_wnd;		/* receive window */
/*50*/	u_long	rcv_nxt;		/* receive next */
/*54*/	u_long	rcv_up;			/* receive urgent pointer */
/*58*/	u_long	irs;			/* initial receive sequence number */
/* receive variables */
/*62*/	u_long	rcv_adv;		/* advertised window */
/* retransmit variables */
/*66*/	u_long	snd_max;		/* highest sequence number sent
					   used to recognize retransmits */
/* transmit timing stuff */
/*70*/	short	t_idle;			/* inactivity time */
/*72*/	short	t_rtt;			/* round trip time */
/*74*/	u_long	t_rtseq;		/* sequence number being timed */
/*78*/	short   t_srtt;                 /* smoothed round-trip time (*10) */
/*80*/	short	t_throttle;		/* counter: try to throttle connections
				       	 * when system is short of buffers */
/* out-of-band data */
/*82*/	char	t_oobflags;		/* have some */
/*83*/	char	t_iobc;			/* input character */
#define	TCPOOB_HAVEDATA	0x01
};

struct socket {
	short	so_type;		/* generic type, see socket.h */
	short	so_options;		/* from socket call, see socket.h */
	short	so_linger;		/* time to linger while closing */
	short	so_state;		/* internal state flags SS_*, below */
	u_short	so_pcb;			/* protocol control block */
	u_short	so_proto;		/* protocol handle */
	struct	sockbuf {
		short	sb_cc;		/* actual chars in buffer */
		short	sb_hiwat;	/* max actual char count */
		short	sb_mbcnt;	/* chars of mbufs used */
		short	sb_mbmax;	/* max chars of mbufs to use */
		short	sb_lowat;	/* low water mark (not used yet) */
		short	sb_timeo;	/* timeout (not used yet) */
		u_short	sb_mb;		/* the mbuf chain */
		u_short	sb_sel;		/* process selecting read/write */
		short	sb_flags;	/* flags, see below */
	} so_rcv, so_snd;
#define	SB_LOCK		0x01		/* lock on data queue (so_rcv only) */
#define	SB_WANT		0x02		/* someone is waiting to lock */
#define	SB_WAIT		0x04		/* someone is waiting for data/space */
#define	SB_SEL		0x08		/* buffer is selected */
#define	SB_COLL		0x10		/* collision selecting */
	short	so_timeo;		/* connection timeout */
	u_short	so_error;		/* error affecting connection */
	short	so_oobmark;		/* chars to oob mark */
	short	so_pgrp;		/* pgrp for signals */
};

/*
 * Socket state bits.
 */
#define	SS_USERGONE		0x001	/* no file table ref any more */
#define	SS_ISCONNECTED		0x002	/* socket connected to a peer */
#define	SS_ISCONNECTING		0x004	/* in process of connecting to peer */
#define	SS_ISDISCONNECTING	0x008	/* in process of disconnecting */
#define	SS_CANTSENDMORE		0x010	/* can't send more data to peer */
#define	SS_CANTRCVMORE		0x020	/* can't receive more data from peer */
#define	SS_CONNAWAITING		0x040	/* connections awaiting acceptance */
#define	SS_RCVATMARK		0x080	/* at mark on input */

#define	SS_PRIV			0x100	/* privileged for broadcast, raw... */
#define	SS_NBIO			0x200	/* non-blocking ops */
#define	SS_ASYNC		0x400	/* async i/o notify */

#define SS_OOBINPROG		0x800	/* abort pending read if get outofband*/

struct	ethcb {
	u_short eth_prev, eth_next;
	u_short eth_head;
	u_short eth_socket;
	u_short	etypes[6];
};

#define et ethcb.etypes

struct xpcblock {
	union {
		struct xicb xicb;
		struct ethcb  xecb;
	} xcb;
};

#define xinpcb 	xpcb.xcb.xicb
#define xethcb	xpcb.xcb.xecb

struct	inpcb inpcb = {0};
struct	tcpcb tcpcb = {0};
struct	ethcb ethcb = {0};
struct	socket socket = {0};
struct xpcblock xpcb;
struct	rtentry rtentry;
/*
struct	protosw proto;
*/
extern	int exos;
extern	int cflag;
extern	int aflag;
extern	int nflag;
extern	int dflag;
extern	u_long xtohl();
extern	u_short xtohs();

static	int first = 1;
char	*inetname();
char	*portname();
char	*xraddr();

/*
 * Print a summary of connections related to an Internet
 * protocol.  For TCP, also give state of connection.
 * Listening processes (aflag) are suppressed unless the
 * -a (all) flag is specified.
 */
protopr(off, name)
	unsigned off;
	char *name;
{
	unsigned prev, next;
	int istcp;

	if (dflag)
		xoprintf(xstdout, "protopr(%x, %s)\n", off, name);
	if (off == 0) {
		xoprintf(xstdout,
			"%s control block: symbol not in namelist\n", name);
		return;
	}
	istcp = xstrcmp(name, "tcp") == 0;
	klseek(exos, off, 0);
	klread(exos, &xinpcb, sizeof(struct xicb));
	fixinpcb(&xinpcb, &inpcb);
	prev = off;
	if (first) {
		xoprintf(xstdout, "Active connections");
		if (aflag)
			xoprintf(xstdout, " (including servers)");
		xoprintf(xstdout, "\n");
		if (cflag)
			xoprintf(xstdout, "%-6.6s ", "PCB");
		xoprintf(xstdout,
			"%-6.6s %-5.5s %-5.5s %-5.5s %-21.21s %-21.21s %s\n",
			"Socket", "Proto", "Rcv-Q", "Snd-Q",
			"Local Address", "Foreign Address", "(state)");
		first = 0;
	}
	while (inpcb.inp_next != off) {
		struct in_addr inaddr;
		char *cp;

		next = inpcb.inp_next;
		klseek(exos, next, 0);
		klread(exos, &xinpcb, sizeof(struct xicb));
		fixinpcb(&xinpcb, &inpcb);
		if (inpcb.inp_prev != prev) {
			xoprintf(xstdout, "???\n");
			break;
		}
		if (dflag && inpcb.inp_route.ro_rt) {
			klseek(exos, inpcb.inp_route.ro_rt, 0);
			klread(exos, &rtentry, sizeof(struct rtentry));
			fixrtentry(&rtentry);
		}
		inaddr.s_addr = inpcb.inp_laddr;
		if (!aflag && IN_LNAOF(inaddr) == 0) {
			prev = next;
			continue;
		}
		klseek(exos, inpcb.inp_socket, 0);
		klread(exos, &socket, sizeof(struct socket));
		fixsocket(&socket);
		if (istcp) {
			klseek(exos, inpcb.inp_ppcb, 0);
			klread(exos, &tcpcb, sizeof (tcpcb));
			fixtcpcb(&tcpcb);
		}
		if (cflag)
			xoprintf(xstdout, "%6x ", inpcb.inp_ppcb);
		xoprintf(xstdout, "%6x %-5.5s %5d %5d",
			inpcb.inp_socket,
			name,
			socket.so_rcv.sb_cc,
			socket.so_snd.sb_cc);
		inetprint(&inpcb.inp_laddr, inpcb.inp_lport, name);
		inetprint(&inpcb.inp_faddr, inpcb.inp_fport, name);
		if (istcp) {
			if (tcpcb.t_state < 0 || tcpcb.t_state >= TCP_NSTATES)
				xoprintf(xstdout, " %d", tcpcb.t_state);
			else
				xoprintf(xstdout, " %s",
					tcpstates[tcpcb.t_state]);
		}
		xoprintf(xstdout, "\n");
		prev = next;
	}
}

protopr_eth(off, name)
	unsigned off;
	char *name;
{
	unsigned prev, next;

	if (dflag)
		xoprintf(xstdout, "protopr(%x, %s)\n", off, name);
	if (off == 0) {
		xoprintf(xstdout,
			"%s control block: symbol not in namelist\n", name);
		return;
	}
	klseek(exos, off, 0);
	klread(exos, &xethcb, sizeof(struct ethcb));
	fixethcb(&xethcb, &ethcb);
	if (ethcb.eth_next == off)
		return;
	prev = off;
	xoprintf(xstdout, "Datalink sockets:\n");
	xoprintf(xstdout, "%-6.6s %-5.5s %-5.5s %-5.5s %-30.30s\n",
		"Socket", "Proto", "Rcv-Q", "Snd-Q", "Etypes");

	while (ethcb.eth_next != off) {
		struct in_addr inaddr;
		char *cp;

		next = ethcb.eth_next;
		klseek(exos, next, 0);
		klread(exos, &xethcb, sizeof(struct ethcb));
		fixethcb(&xethcb, &ethcb);
		if (ethcb.eth_prev != prev) {
			xoprintf(xstdout, "???\n");
			break;
		}
		klseek(exos, ethcb.eth_socket, 0);
		klread(exos, &socket, sizeof(struct socket));
		fixsocket(&socket);

		xoprintf(xstdout, "%6x %-5.5s %5d %5d ",
			ethcb.eth_socket,
			name,
			socket.so_rcv.sb_cc,
			socket.so_snd.sb_cc);
		xoprintf(xstdout, "%4x %4x %4x %4x %4x %4x ",
			et[0], et[1], et[2], et[3], et[4], et[5]);
		xoprintf(xstdout, "\n");
		prev = next;
	}
}
/*
 * Dump TCP statistics structure.
 */
tcp_stats(off, name)
	unsigned off;
	char *name;
{
	struct tcpstat tcpstat;

	if (off == 0) {
		xoprintf(xstdout, "%sstat: symbol not in namelist\n", name);
		return;
	}
	klseek(exos, off, 0);
	klread(exos, (char *)&tcpstat, sizeof (tcpstat));
	tcpstat.tcps_badsum = xtohs(tcpstat.tcps_badsum);
	tcpstat.tcps_badoff = xtohs(tcpstat.tcps_badoff);
	tcpstat.tcps_hdrops = xtohs(tcpstat.tcps_hdrops);
	tcpstat.tcps_badsegs = xtohs(tcpstat.tcps_badsegs);
	tcpstat.tcps_unack = xtohs(tcpstat.tcps_unack);

	xoprintf(xstdout, "%s:\n\t%d bad header checksum%s\n", name,
		tcpstat.tcps_badsum, plural(tcpstat.tcps_badsum));
	xoprintf(xstdout, "\t%d bad header offset field%s\n",
		tcpstat.tcps_badoff, plural(tcpstat.tcps_badoff));
	xoprintf(xstdout, "\t%d incomplete header%s\n",
		tcpstat.tcps_hdrops, plural(tcpstat.tcps_hdrops));
#ifdef notdef
	xoprintf(xstdout, "\t%d bad segment%s\n",
		tcpstat.tcps_badsegs, plural(tcpstat.badsegs));
	xoprintf(xstdout, "\t%d unacknowledged packet%s\n",
		tcpstat.tcps_unack, plural(tcpstat.tcps_unack));
#endif
}

/*
 * Dump UDP statistics structure.
 */
udp_stats(off, name)
	unsigned off;
	char *name;
{
	struct udpstat udpstat;

	if (off == 0) {
		xoprintf(xstdout, "%sstat: symbol not in namelist\n", name);
		return;
	}
	klseek(exos, off, 0);
	klread(exos, (char *)&udpstat, sizeof (udpstat));
	udpstat.udps_hdrops = xtohs(udpstat.udps_hdrops);
	udpstat.udps_badsum = xtohs(udpstat.udps_badsum);
	udpstat.udps_badlen = xtohs(udpstat.udps_badlen);

	xoprintf(xstdout, "%s:\n\t%d bad header checksum%s\n", name,
		udpstat.udps_badsum, plural(udpstat.udps_badsum));
	xoprintf(xstdout, "\t%d incomplete header%s\n",
		udpstat.udps_hdrops, plural(udpstat.udps_hdrops));
	xoprintf(xstdout, "\t%d bad data length field%s\n",
		udpstat.udps_badlen, plural(udpstat.udps_badlen));
}

/*
 * Dump IP statistics structure.
 */
ip_stats(off, name)
	unsigned off;
	char *name;
{
	struct ipstat ipstat;

	if (off == 0) {
		xoprintf(xstdout, "%sstat: symbol not in namelist\n", name);
		return;
	}
	klseek(exos, off, 0);
	klread(exos, (char *)&ipstat, sizeof (ipstat));
	ipstat.ips_badsum = xtohs(ipstat.ips_badsum);
	ipstat.ips_tooshort = xtohs(ipstat.ips_tooshort);

	xoprintf(xstdout, "%s:\n\t%d bad header checksum%s\n", name,
		ipstat.ips_badsum, plural(ipstat.ips_badsum));
	xoprintf(xstdout, "\t%d with size smaller than minimum\n",
		ipstat.ips_tooshort);
/*
	xoprintf(xstdout, "\t%d with data size < data length\n",
		ipstat.ips_toosmall);
	xoprintf(xstdout, "\t%d with header length < data size\n",
		ipstat.ips_badhlen);
	xoprintf(xstdout, "\t%d with data length < header length\n",
		ipstat.ips_badlen);
*/
}

#ifdef notdef

static	char *icmpnames[] = {
	"echo reply",
	"#1",
	"#2",
	"destination unreachable",
	"source quench",
	"routing redirect",
	"#6",
	"#7",
	"echo",
	"#9",
	"#10",
	"time exceeded",
	"parameter problem",
	"time stamp",
	"time stamp reply",
	"information request",
	"information request reply"
};

/*
 * Dump ICMP statistics.
 */
icmp_stats(off, name)
	unsigned off;
	char *name;
{
	struct icmpstat icmpstat;
	register int i, first;

	if (off == 0) {
		xoprintf(xstdout, "%sstat: symbol not in namelist\n", name);
		return;
	}
	klseek(exos, off, 0);
	klread(exos, (char *)&icmpstat, sizeof (icmpstat));
	xoprintf(xstdout, "%s:\n\t%d call%s to icmp_error\n", name,
		icmpstat.icps_error, plural(icmpstat.icps_error));
	xoprintf(xstdout, "\t%d error%s not generated 'cuz old message too short\n",
		icmpstat.icps_oldshort, plural(icmpstat.icps_oldshort));
	xoprintf(xstdout, "\t%d error%s not generated 'cuz old message was icmp\n",
		icmpstat.icps_oldicmp, plural(icmpstat.icps_oldicmp));
	for (first = 1, i = 0; i < ICMP_IREQREPLY + 1; i++)
		if (icmpstat.icps_outhist[i] != 0) {
			if (first) {
				xoprintf(xstdout, "\tOutput histogram:\n");
				first = 0;
			}
			xoprintf(xstdout, "\t\t%s: %d\n", icmpnames[i],
				icmpstat.icps_outhist[i]);
		}
	xoprintf(xstdout, "\t%d message%s with bad code fields\n",
		icmpstat.icps_badcode, plural(icmpstat.icps_badcode));
	xoprintf(xstdout, "\t%d message%s < minimum length\n",
		icmpstat.icps_tooshort, plural(icmpstat.icps_tooshort));
	xoprintf(xstdout, "\t%d bad checksum%s\n",
		icmpstat.icps_checksum, plural(icmpstat.icps_checksum));
	xoprintf(xstdout, "\t%d message%s with bad length\n",
		icmpstat.icps_badlen, plural(icmpstat.icps_badlen));
	xoprintf(xstdout, "\t%d message response%s generated\n",
		icmpstat.icps_reflect, plural(icmpstat.icps_reflect));
	for (first = 1, i = 0; i < ICMP_IREQREPLY + 1; i++)
		if (icmpstat.icps_inhist[i] != 0) {
			if (first) {
				xoprintf(xstdout, "\tInput histogram:\n");
				first = 0;
			}
			xoprintf(xstdout, "\t\t%s: %d\n", icmpnames[i],
				icmpstat.icps_inhist[i]);
		}
}

#endif

/*
 * Pretty print an Internet address (net address + port).
 * If the nflag was specified, use numbers instead of names.
 */
inetprint(in, port, proto)
	u_long *in;
	int port;
	char *proto;
{
	char *sp = 0;
	char line[80], *cp, *xstrchr();

	xsprintf(line, "%.13s:", inetname(*in));
	cp = xstrchr(line, '\0');
	if (!nflag && port)
		sp = portname(xntohs(port), proto);
	if (sp || port == 0)
		xsprintf(cp, "%.8s", sp ? sp : "*");
	else
		xsprintf(cp, "%d", xntohs((u_short)port));
	xoprintf(xstdout, " %-21.21s", line);
}

/*
 * Construct an Internet address representation.
 * If the nflag has been supplied, give 
 * numeric value, otherwise try for symbolic name.
 */
char *
inetname(in)
	u_long in;
{
	char *cp = 0;
	static char line[50];

	if (!nflag) {
/*
		if (inet_lnaof(in) == INADDR_ANY) {
			struct netent *np;

			np = getnetbyaddr(inet_netof(in), AF_INET);
			if (np)
				cp = np->n_name;
		} else
*/
		cp = xraddr(in);
	}
	if (in == 0)
		xstrcpy(line, "*");
	else if (cp)
		xstrcpy(line, cp);
	else {
		u_char *ucp = (u_char *)&in;
		xsprintf(line, "%u.%u.%u.%u",
			ucp[0]&0xFF, ucp[1]&0xFF, ucp[2]&0xFF, ucp[3]&0xFF);
	}
	return (line);
}

fixrtentry(rep)
struct rtentry *rep;
{
	fixsaddr(&rep->rt_dst);
	fixsaddr(&rep->rt_gateway);
	rep->rt_next = xtohs(rep->rt_next);
	rep->rt_hash = xtohs(rep->rt_hash);
	rep->rt_use = xtohl(rep->rt_use);
	rep->rt_ifp = xtohs(rep->rt_ifp);
	if (dflag == 0)
		return;

	showsaddr(&rep->rt_dst);
	showsaddr(&rep->rt_gateway);
	xprintf("\trt_flags = %x\n", rep->rt_flags & 0xFF);
	xprintf("\trt_refcnt = %x\n", rep->rt_refcnt & 0xFF);
	xprintf("\trt_next = %x\n", rep->rt_next);
	xprintf("\trt_hash = %x\n", rep->rt_hash);
	xprintf("\trt_use = %X\n", rep->rt_use);
	xprintf("\trt_ifp = %x\n", rep->rt_ifp);
}

fixsaddr(sap)
union usa *sap;
{
	sap->Sa_family = xtohs(sap->Sa_family);
	if (sap->Sa_family == AF_INET) {
		sap->usa_in.Sin_port = xtohs(sap->usa_in.Sin_port);
		sap->usa_in.Sin_addr = xhtonl(sap->usa_in.Sin_addr);
	}
}

showsaddr(sap)
union usa *sap;
{
	if (dflag == 0)
		return;
	xprintf("\tSa_family = %x\n", sap->Sa_family);
	if (sap->Sa_family == AF_INET) {
		xprintf("\tusa_in.Sin_port = %x\n", sap->usa_in.Sin_port);
		xprintf("\tusa_in.Sin_addr = %X\n", sap->usa_in.Sin_addr);
	}
}

fixinpcb(xcbp, cbp)
struct xicb *xcbp;	/* exos-aligned input */
struct inpcb *cbp;	/* host-aligned result */
{
	cbp->inp_next = xtohs(xcbp->xinp_next);
	cbp->inp_prev = xtohs(xcbp->xinp_prev);
	cbp->inp_head = xtohs(xcbp->xinp_head);
	cbp->inp_faddr = *(u_long *)xcbp->xinp_faddr;	/* defeat alignment! */
	cbp->inp_fport = xcbp->xinp_fport;
	cbp->inp_laddr = xcbp->xinp_laddr;
	cbp->inp_lport = xcbp->xinp_lport;
	cbp->inp_socket = xtohs(xcbp->xinp_socket);
	cbp->inp_ppcb = xtohs(xcbp->xinp_ppcb);
	cbp->inp_route.ro_rt = xtohs(xcbp->xinp_route.ro_rt);
	cbp->inp_route.ro_dst = xcbp->xinp_route.ro_dst;
	fixsaddr(&cbp->inp_route.ro_dst);

	if (dflag == 0)
		return;

	xoprintf(xstdout, "inpcb(inpcb size=%d):\n", sizeof(struct inpcb));
	xoprintf(xstdout, "\tinp_next = %x\n", cbp->inp_next);
	xoprintf(xstdout, "\tinp_prev = %x\n", cbp->inp_prev);
	xoprintf(xstdout, "\tinp_head = %x\n", cbp->inp_head);
	xoprintf(xstdout, "\tinp_faddr = %X\n", xhtonl(cbp->inp_faddr));
	xoprintf(xstdout, "\tinp_fport = %x\n", xhtons(cbp->inp_fport));
	xoprintf(xstdout, "\tinp_laddr = %X\n", xhtonl(cbp->inp_laddr));
	xoprintf(xstdout, "\tinp_lport = %x\n", xhtons(cbp->inp_lport));
	xoprintf(xstdout, "\tinp_socket = %x\n", cbp->inp_socket);
	xoprintf(xstdout, "\tinp_ppcb = %x\n", cbp->inp_ppcb);
	xoprintf(xstdout, "\tinp_route.ro_rt = %x\n", cbp->inp_route.ro_rt);
	showsaddr(&cbp->inp_route.ro_dst);
}

fixethcb(xcbp, cbp)
	struct ethcb *xcbp;
	struct ethcb *cbp;
{
	cbp->eth_next = xtohs(xcbp->eth_next);
	cbp->eth_prev = xtohs(xcbp->eth_prev);
	cbp->eth_socket = xtohs(xcbp->eth_socket);

	cbp->etypes[0] = xtohs(xcbp->etypes[0]);
	cbp->etypes[1] = xtohs(xcbp->etypes[1]);
	cbp->etypes[2] = xtohs(xcbp->etypes[2]);
	cbp->etypes[3] = xtohs(xcbp->etypes[3]);
	cbp->etypes[4] = xtohs(xcbp->etypes[4]);
	cbp->etypes[5] = xhtons(xcbp->etypes[5]);
}

fixsocket(sop)
struct socket *sop;
{
	sop->so_type = xtohs(sop->so_type);
	sop->so_options = xtohs(sop->so_options);
	sop->so_linger = xtohs(sop->so_linger);
	sop->so_state = xtohs(sop->so_state);
	sop->so_pcb = xtohs(sop->so_pcb);
	sop->so_proto = xtohs(sop->so_proto);

	sop->so_rcv.sb_cc = xtohs(sop->so_rcv.sb_cc);

	sop->so_rcv.sb_hiwat = xtohs(sop->so_rcv.sb_hiwat);
	sop->so_rcv.sb_mbcnt = xtohs(sop->so_rcv.sb_mbcnt);
	sop->so_rcv.sb_mbmax = xtohs(sop->so_rcv.sb_mbmax);
	sop->so_rcv.sb_lowat = xtohs(sop->so_rcv.sb_lowat);
	sop->so_rcv.sb_timeo = xtohs(sop->so_rcv.sb_timeo);
	sop->so_rcv.sb_mb = xtohs(sop->so_rcv.sb_mb);
	sop->so_rcv.sb_sel = xtohs(sop->so_rcv.sb_sel);
	sop->so_rcv.sb_flags = xtohs(sop->so_rcv.sb_flags);

	sop->so_snd.sb_cc = xtohs(sop->so_snd.sb_cc);
	sop->so_snd.sb_hiwat = xtohs(sop->so_snd.sb_hiwat);
	sop->so_snd.sb_mbcnt = xtohs(sop->so_snd.sb_mbcnt);
	sop->so_snd.sb_mbmax = xtohs(sop->so_snd.sb_mbmax);
	sop->so_snd.sb_lowat = xtohs(sop->so_snd.sb_lowat);
	sop->so_snd.sb_timeo = xtohs(sop->so_snd.sb_timeo);
	sop->so_snd.sb_mb = xtohs(sop->so_snd.sb_mb);
	sop->so_snd.sb_sel = xtohs(sop->so_snd.sb_sel);
	sop->so_snd.sb_flags = xtohs(sop->so_snd.sb_flags);

	sop->so_timeo = xtohs(sop->so_timeo);
	sop->so_error = xtohs(sop->so_error);
	sop->so_oobmark = xtohs(sop->so_oobmark);
	sop->so_pgrp = xtohs(sop->so_pgrp);

	if (dflag == 0)
		return;

	xoprintf(xstdout, "socket size=%d\n", sizeof(struct socket));
	xoprintf(xstdout, "\tso_type = %x\n", sop->so_type);
	xoprintf(xstdout, "\tso_options = %x\n", sop->so_options);
	xoprintf(xstdout, "\tso_linger = %x\n", sop->so_linger);
	xoprintf(xstdout, "\tso_state = %x\n", sop->so_state);
	xoprintf(xstdout, "\tso_pcb = %x\n", sop->so_pcb);
	xoprintf(xstdout, "\tso_proto = %x\n", sop->so_proto);

	xoprintf(xstdout, "\tso_rcv.sb_cc = %x\n", sop->so_rcv.sb_cc);
	xoprintf(xstdout, "\tso_rcv.sb_hiwat = %x\n", sop->so_rcv.sb_hiwat);
	xoprintf(xstdout, "\tso_rcv.sb_mbcnt = %x\n", sop->so_rcv.sb_mbcnt);
	xoprintf(xstdout, "\tso_rcv.sb_mbmax = %x\n", sop->so_rcv.sb_mbmax);
	xoprintf(xstdout, "\tso_rcv.sb_lowat = %x\n", sop->so_rcv.sb_lowat);
	xoprintf(xstdout, "\tso_rcv.sb_timeo = %x\n", sop->so_rcv.sb_timeo);
	xoprintf(xstdout, "\tso_rcv.sb_mb = %x\n", sop->so_rcv.sb_mb);
	xoprintf(xstdout, "\tso_rcv.sb_sel = %x\n", sop->so_rcv.sb_sel);
	xoprintf(xstdout, "\tso_rcv.sb_flags = %x\n", sop->so_rcv.sb_flags);

	xoprintf(xstdout, "\tso_snd.sb_cc = %x\n", sop->so_snd.sb_cc);
	xoprintf(xstdout, "\tso_snd.sb_hiwat = %x\n", sop->so_snd.sb_hiwat);
	xoprintf(xstdout, "\tso_snd.sb_mbcnt = %x\n", sop->so_snd.sb_mbcnt);
	xoprintf(xstdout, "\tso_snd.sb_mbmax = %x\n", sop->so_snd.sb_mbmax);
	xoprintf(xstdout, "\tso_snd.sb_lowat = %x\n", sop->so_snd.sb_lowat);
	xoprintf(xstdout, "\tso_snd.sb_timeo = %x\n", sop->so_snd.sb_timeo);
	xoprintf(xstdout, "\tso_snd.sb_mb = %x\n", sop->so_snd.sb_mb);
	xoprintf(xstdout, "\tso_snd.sb_sel = %x\n", sop->so_snd.sb_sel);
	xoprintf(xstdout, "\tso_snd.sb_flags = %x\n", sop->so_snd.sb_flags);

	xoprintf(xstdout, "\tso_timeo = %x\n", sop->so_timeo);
	xoprintf(xstdout, "\tso_error = %x\n", sop->so_error);
	xoprintf(xstdout, "\tso_oobmark = %x\n", sop->so_oobmark);
	xoprintf(xstdout, "\tso_pgrp = %x\n", sop->so_pgrp);
}

fixtcpcb(tp)
struct tcpcb *tp;
{
	int i;

	tp->seg_next = xtohs(tp->seg_next);
	tp->seg_prev = xtohs(tp->seg_prev);
	tp->t_state = xtohs(tp->t_state);
	for (i = 0; i < TCPT_NTIMERS; i++)
		tp->t_timer[i] = xtohs(tp->t_timer[i]);
	tp->t_rxtshift = xtohs(tp->t_rxtshift);
	tp->t_tcpopt = xtohs(tp->t_tcpopt);
	tp->t_ipopt = xtohs(tp->t_ipopt);
	tp->t_maxseg = xtohs(tp->t_maxseg);
	tp->t_template = xtohs(tp->t_template);
	tp->t_inpcb = xtohs(tp->t_inpcb);

	tp->snd_una = xtohl(tp->snd_una);
	tp->snd_nxt = xtohl(tp->snd_nxt);
	tp->snd_up = xtohl(tp->snd_up);
	tp->snd_wl1 = xtohl(tp->snd_wl1);
	tp->snd_wl2 = xtohl(tp->snd_wl2);
	tp->iss = xtohl(tp->iss);
	tp->snd_wnd = xtohs(tp->snd_wnd);

	tp->rcv_wnd = xtohs(tp->rcv_wnd);
	tp->rcv_nxt = xtohl(tp->rcv_nxt);
	tp->rcv_up = xtohl(tp->rcv_up);
	tp->irs = xtohl(tp->irs);

	tp->rcv_adv = xtohl(tp->rcv_adv);
	tp->snd_max = xtohl(tp->snd_max);

	tp->t_idle = xtohs(tp->t_idle);
	tp->t_rtt = xtohs(tp->t_rtt);
	tp->t_rtseq = xtohl(tp->t_rtseq);
	tp->t_srtt = xtohs(tp->t_srtt);

	if (dflag == 0)
		return;

	xoprintf(xstdout, "tcpcb size=%d\n", sizeof(struct tcpcb));
	xoprintf(xstdout, "\tseg_next = %x\n", tp->seg_next);
	xoprintf(xstdout, "\tseg_prev = %x\n", tp->seg_prev);
	xoprintf(xstdout, "\tt_state = %x\n", tp->t_state);
	xoprintf(xstdout, "\tt_timers = ");
	for (i = 0; i < TCPT_NTIMERS; i++)
		xoprintf(xstdout, "%x  ", tp->t_timer[i]);
	xoprintf(xstdout, "\n");
	xoprintf(xstdout, "\tt_rxtshift = %x\n", tp->t_rxtshift);
	xoprintf(xstdout, "\tt_tcpopt = %x\n", tp->t_tcpopt);
	xoprintf(xstdout, "\tt_ipopt = %x\n", tp->t_ipopt);
	xoprintf(xstdout, "\tt_force = %x\n", tp->t_force&0xFF);
	xoprintf(xstdout, "\tt_flags = %x\n", tp->t_flags&0xFF);
	xoprintf(xstdout, "\tt_maxseg = %u (dec)\n", tp->t_maxseg);
	xoprintf(xstdout, "\tt_template = %x\n", tp->t_template);
	xoprintf(xstdout, "\tt_inpcb = %x\n", tp->t_inpcb);
	xoprintf(xstdout, "\tsnd_una = %U (dec)\n", tp->snd_una);
	xoprintf(xstdout, "\tsnd_nxt = %U (dec)\n", tp->snd_nxt);
	xoprintf(xstdout, "\tsnd_up = %U (dec)\n", tp->snd_up);
	xoprintf(xstdout, "\tsnd_wl1 = %U (dec)\n", tp->snd_wl1);
	xoprintf(xstdout, "\tsnd_wl2 = %U (dec)\n", tp->snd_wl2);
	xoprintf(xstdout, "\tiss = %U (dec)\n", tp->iss);
	xoprintf(xstdout, "\tsnd_wnd = %u (dec)\n", tp->snd_wnd);
	xoprintf(xstdout, "\trcv_wnd = %u (dec)\n", tp->rcv_wnd);
	xoprintf(xstdout, "\trcv_nxt = %U (dec)\n", tp->rcv_nxt);
	xoprintf(xstdout, "\trcv_up = %U (dec)\n", tp->rcv_up);
	xoprintf(xstdout, "\tirs = %U (dec)\n", tp->irs);
	xoprintf(xstdout, "\trcv_adv = %U (dec)\n", tp->rcv_adv);
	xoprintf(xstdout, "\tsnd_max = %U (dec)\n", tp->snd_max);
	xoprintf(xstdout, "\tt_idle = %u (dec)\n", tp->t_idle);
	xoprintf(xstdout, "\tt_rtt = %u (dec)\n", tp->t_rtt);
	xoprintf(xstdout, "\tt_rtseq = %U (dec)\n", tp->t_rtseq);
	xoprintf(xstdout, "\tt_srtt = %u (dec)\n", tp->t_srtt);
	xoprintf(xstdout, "\tt_throttle = %x\n", tp->t_throttle);
}

char *
portname(port, proto)
u_short port;
char *proto;
{
	if (xstrcmp(proto, "tcp") == 0) {
		switch(port) {
		case IPPORT_SYSTAT:
			return("systat");
			break;
		case IPPORT_DAYTIME:
			return("daytime");
			break;
		case IPPORT_NETSTAT:
			return("netstat");
			break;
		case IPPORT_FTP:
			return("ftp");
			break;
		case IPPORT_TELNET:
			return("telnet");
			break;
		case IPPORT_SMTP:
			return("smtp");
			break;
		case IPPORT_TIMESERVER:
			return("time");
			break;
		case IPPORT_NAMESERVER:
			return("name");
			break;
		case IPPORT_WHOIS:
			return("whois");
			break;
		case IPPORT_MTP:
			return("mtp");
			break;
		case IPPORT_RJE:
			return("rje");
			break;
		case IPPORT_FINGER:
			return("finger");
			break;
		case IPPORT_TTYLINK:
			return("link");
			break;
		case IPPORT_SUPDUP:
			return("supdup");
			break;
		case IPPORT_EXECSERVER:
			return("exec");
			break;
		case IPPORT_LOGINSERVER:
			return("login");
			break;
		case IPPORT_CMDSERVER:
			return("shell");
			break;
		case 515:
			return("printer");
			break;
		default:
			return 0;
			break;
		} /* end switch */
	} else if (xstrcmp(proto, "udp") == 0) {
		switch(port) {
		case IPPORT_ECHO:
			return("echo");
			break;
		case IPPORT_DISCARD:
			return("discard");
			break;
		case IPPORT_TFTP:
			return("tftp");
			break;
		case IPPORT_BIFFUDP:
			return("biff");
			break;
		case IPPORT_WHOSERVER:
			return("who");
			break;
		case 514:
			return("syslog");
			break;
		case 517:
			return("talk");
			break;
		case 520:
			return("route");
			break;
		case 560:
			return("rmonitor");
			break;
		case 561:
			return("monitor");
			break;
		default:
			return 0;
			break;
		} /* end switch */
	} else {
		return 0;
	}
}

dumpeth(ethcb)
	struct ethcb *ethcb;
{
	xoprintf(xstdout, "dumpxeth(): next = %4x, prev = %4x, sock = %4x\n",
		ethcb->eth_prev, ethcb->eth_next, ethcb->eth_socket);
}
