/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: cmdtab.c,v 1.4 87/04/24 14:56:35 davidb Exp $ */
/*
$Header: cmdtab.c,v 1.4 87/04/24 14:56:35 davidb Exp $
$Log:	cmdtab.c,v $
 * Revision 1.4  87/04/24  14:56:35  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:23:21  grant
 * Updating source from Generic trees
 * 
 * Revision 1.13  86/11/08  10:25:20  albert
 * close should be recognized as valid command even though there is no
 * active connection.
 * 
 * Revision 2.8  86/11/06  19:14:19  albert
 * close command should be recognized even though there is no active
 * connections.
 * 
 * Revision 2.7  86/11/04  14:12:17  albert
 * Updating source from Generic trees
 * 
 * Revision 1.12  86/10/15  15:21:53  albert
 * delete glob command for VMS.
 * 
 * Revision 2.4  86/10/12  11:58:47  albert
 * take off glob commands for VMS.
 * 
 * Revision 2.3  86/10/09  15:03:03  albert
 * Updating source from Generic trees
 * 
 * Revision 1.11  86/10/07  18:42:14  mark
 * merging in changes for new ftp
 * 
 * Revision 1.5  86/10/03  16:48:46  mark
 * added debug, verbose and sendport commands
 * 
 * Revision 1.4  86/09/24  16:48:16  albert
 * make the list alphabetical 
 * also allow help to exist in more than one command table.
 * 
 * Revision 2.2  86/09/24  15:57:29  albert
 * 1. Make command list in alphabetical order
 * 2. allow help to be a command in any other command table.
 * 
 * Revision 1.3  86/09/19  13:03:44  albert
 * update from generic source tree
 * 
 * Revision 1.3  86/09/12  10:18:06  albert
 * add in r-operations.
 * 
 * Revision 1.2  86/09/12  10:13:22  albert
 * add in r-operations
 * 
 * Revision 1.1  86/09/04  16:03:12  albert
 * Initial revision
 * 
 * Revision 1.1  86/09/04  16:00:27  albert
 * first working version
 * 
 * Revision 1.2  86/08/25  16:59:15  mark
 * syncing revision level
 * 
 * Revision 1.1  86/05/09  14:30:20  mark
 * Initial revision
 * 
*/
#ifndef lint
static char sccsid[] =
 " @(#)cmdtab.c	1.9 6/3/85";
#endif

#include "ftpc.h"

/*
 * User FTP -- Command Tables.
 */
int	copy(), setpeer(), bye();
int	gdebug(), gsendport(), gverbose();
int	delete(), mdelete();
int	tforce();
int	tinteractive(), tglob(), tbell(), thash(), tstat();
int	get(), mget();
int	help();
int	ls(), lls(), lcd(), mls();
int	lexec();
int	makedir(), renamefile(), removedir();
int	pwd(), lpwd();
int	put(), mput();
int	cd();
int	quit();
int	status();
int	user();

extern int rget();
extern int rput();

char	appendhelp[] =	"append to a file";
char	bellhelp[] =	"beep when command completed";
char	cdhelp[] =	"change remote working directory";
char	copyhelp[] =	"copy [-rgfba] source [source...] destination";
char	gdbughelp[] =	"toggle debugging";
char	connecthelp[] =	"connect to remote tftp";
char	deletehelp[] =	"delete remote file";
char	dirhelp[] =	"list contents of remote directory";
char	disconhelp[] =	"terminate ftp session";
char	forcehelp[] =	"toggle forced use of user supplied transfer modes";
#ifndef	vms
char	globhelp[] =	"toggle metacharacter expansion of local file names";
#endif
char	hashhelp[] =	"toggle printing `#' for each buffer transferred";
char	helphelp[] =	"print local help information";
char	lcdhelp[] =	"change local working directory";
char	lshelp[] =	"nlist contents of remote directory";
char	mdeletehelp[] =	"delete multiple files";
char	mdirhelp[] =	"list contents of multiple remote directories";
char	mgethelp[] =	"get multiple files";
char	mkdirhelp[] =	"make directory on the remote machine";
char	mlshelp[] =	"nlist contents of multiple remote directories";
char	mputhelp[] =	"send multiple files";
char	prompthelp[] =	"force interactive prompting on multiple commands";
char	pwdhelp[] =	"print working directory on remote machine";
char	quithelp[] =	"terminate ftp session and exit";
char	receivehelp[] =	"receive file";
char	renamehelp[] =	"rename file";
char	rgethelp[] =	"get a record structure file";
char	rmdirhelp[] =	"remove directory on the remote machine";
char	rputhelp[] =	"send a record structure file to remote host";
char	sendhelp[] =	"send one file";
char	gsporthelp[] =	"toggle sending of port commands";
char	shellhelp[] =	"execute a local command; ! is command interpreter";
char	statishelp[] =	"toggle printing of transfer statistics";
char	statushelp[] =	"get local status";
char	userhelp[] =	"send new user information";
char	llshelp[] =	"list directory on local machine";
char	lpwdhelp[] =	"print local current directory(s)";
char	ldirhelp[] = 	"long listing of local directory(s)";
char	gverbhelp[] =	"toggle verboseness";

struct cmd cmdtab[] = {
	{ "!",		shellhelp,	0,	0,	lexec },
	{ "?",			helphelp,	0,	0,	help },
	{ "append",		appendhelp,	1,	0,	put },
	{ "bell",	bellhelp,	0,	0,	tbell },
	{ "bye",	quithelp,	0,	0,	quit },
	{ "cd",		cdhelp,	1,	0,	cd },
	{ "close",		disconhelp,	0,	0,	bye },
	{ "copy",		copyhelp,	0,	0,	copy },
	{ "debug",		gdbughelp,	0,	1,	gdebug },
	{ "delete",		deletehelp,	1,	0,	delete },
	{ "dir",		dirhelp,	1,	0,	ls },
	{ "force",		forcehelp,	0,	0,	tforce },
	{ "get",		sendhelp,	1,	0,	get },
#ifndef	vms
	{ "glob",	globhelp,	0,	0,	tglob },
#endif
	{ "hash",	hashhelp,	0,	0,	thash },
	{ "help",		helphelp,	0,	1,	help },
	{ "lcd",		lcdhelp,	0,	0,	lcd },
	{ "lexec",		shellhelp,	0,	0,	lexec },
	{ "ldir",		ldirhelp,	0,	0,	lls },
	{ "lls",		llshelp,	0,	0,	lls },
	{ "lpwd",		lpwdhelp,	0,	0,	lpwd },
	{ "ls",		lshelp,	1,	0,	ls },
	{ "mdelete",		mdeletehelp,	1,	0,	mdelete },
	{ "mdir",		mdirhelp,	1,	0,	mls },
	{ "mkdir",		mkdirhelp,	1,	0,	makedir },
	{ "mls",		mlshelp,	1,	0,	mls },
	{ "mget",		mgethelp,	1,	0,	mget },
	{ "mput",		mputhelp,	1,	0,	mput },
	{ "open",		connecthelp,	0,	0,	setpeer },
	{ "prompt",		prompthelp,	0,	0,	tinteractive },
	{ "put",		receivehelp,	1,	0,	put },
	{ "pwd",		pwdhelp,	1,	0,	pwd },
	{ "quit",		quithelp,	0,	0,	quit },
	{ "recv",		receivehelp,	1,	0,	get },
	{ "rename",		renamehelp,	1,	0,	renamefile },
	{ "rget",		rgethelp,	1,	0,	rget },
	{ "rmdir",		rmdirhelp,	1,	0,	removedir },
	{ "rput",		rputhelp,	1,	0,	rput },
	{ "send",		sendhelp,	1,	0,	put },
	{ "sendport",		gsporthelp,	0,	1,	gsendport },
	{ "statistics",		statishelp,	0,	0,	tstat },
	{ "status",		statushelp,	0,	1,	status },
	{ "user",		userhelp,	1,	0,	user },
	{ "verbose",		gverbhelp,	0,	1,	gverbose },
	{ 0 },
};
