/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xfs.h,v 1.4 87/04/24 14:42:36 davidb Exp $ */
/*
$Header: xfs.h,v 1.4 87/04/24 14:42:36 davidb Exp $
$Log:	xfs.h,v $
 * Revision 1.4  87/04/24  14:42:36  davidb
 * Fixing copyright message
 * 
 * Revision 1.3  87/03/26  19:18:15  grant
 * Updating source from Generic trees
 * 
 * Revision 1.1  86/10/07  18:03:46  mark
 * merging in changes for new ftp
 * 
 * Revision 1.1  86/09/04  11:31:26  mark
 * Updating source from Generic trees
 * 
 * Revision 1.2  86/08/25  18:16:49  mark
 * syncing revision level
 * 
 * Revision 1.1  86/05/09  15:31:49  mark
 * Initial revision
 * 
*/

/*
Codes for types of file systems
*/
#define NATIVE	1	/* local filesystem */
#define FTP	2	/* file system accessed via ftp server */
#define FTAM	3	/* file system accessed via ftam server */
#define NFS	4	/* file system accessed via nfs server */
#define MSNET	5	/* file system accessed via msnet server */

/*
Structure for filesystem operations and data.
Such a structure will be allocated and filled in by efsopen.
Depending on the protocol, a connection to a file system server
may be established at that time.
*/
struct filesystem {
	int type;
	/*
	maintainance of server connection
	*/
	char *conn_state;	/* information on state of connection to
				   server, if any */
	int (*xfsopen)();	/* establish server connection, if any */
	int (*xfsclose)();	/* protocol specific routine to call
				   when filesystem is closed */
	int (*xsendident)();	/* secure transmition of authenication
				 information (probably called from
				 xfsopen) */

	int (*xabort)();	/* abort current operation according
				   to protocol conventions for doing so 
				   (to be envoked: eabort( context ))*/
	/*
	filesystem operations
	*/
	int (*xopen)();		/* open a file in the file system */
	int (*xdiropen)();	/* corresponds to xdiropen(3) */
	int (*xstat)();		/* corresponds to xstat(3) */
	int (*xglobopen)();	/* asks file system to preform name expansion,
					called eglobopen(name,special,context)*/
	int (*xchdir)();	/* corresponds to xchdir(3) */
	int (*xchattr)();	/* corresponds to xchattr(3) */
	int (*xmkdir)();	/* corresponds to xmkdir(3) */
	int (*xrmdir)();	/* corresponds to xrmdir(3) */
	int (*xrename)();	/* corresponds to xrename(3) */
	int (*xls)();		/* corresponds to xls(3) */
	int (*xpwd)();		/* corresponds to xpwd(3) */
	int (*xunlink)();	/* corresponds to xunlink(3) */
	int (*xpassthru)();	/* corresponds to xpass[ft]net(3) */

	int (*xsetattribute)();  /* pass user commands to protocol */
};
