/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: xty.c,v 1.2 87/04/24 14:16:34 davidb Exp $ */
/*	@(#)xty.c	1.1 8/16/85 */

/* xty.c -- daemons-on-board tty driver. 
 *	System 3 port by George Powers
 *	subsequent ports by Michael Swan
 *	10/28/85 billn. add tbufs for sortof-system5 scoxeinx5
 */

#define ibmxenix2

#ifdef scoxenix5

/* The following symbols were removed from super Makefile and put here to
 * avoid compilation problem.  They are used by system include files.
 */
#ifdef ibmxenix2
#define NULL 0
#else
#define M_KERNEL
#endif

#define M_OLDSIGN

#include "sys/types.h"
#include "sys/param.h"
#ifndef ibmxenix2
#include "sys/sysmacros.h"
#endif /* ibmxenix2 */
#include "sys/signal.h"
#include "sys/dir.h"
#include "sys/user.h"
#ifndef EPERM
#include "errno.h"
#endif
#include "sys/systm.h"
#include "sys/tty.h"
#include "sys/ttold.h"
#include "sys/conf.h"
#include "sys/buf.h"
/*
****************************
The following defines were barrowed from:
 "sys/file.h" to keep the compiler from running out of heap
  space:
*/
#define FREAD 01
#define FWRITE 02
/*
****************************
*/
#include "sys/proc.h"
#include "sys/var.h"
#include <sys/extypes.h>
#include <sys/socket.h>
#include "exreg.h"
#include <sys/proc_dep.h>
#include <sys/init.h>
#include <ex_ioctl.h>
#include "exos.h"
#include <sys/ts.h>
#include <arpa/telnet.h>
#ifdef PULLIN
#undef	PULLIN
#endif
#define FROMXTY
#include "config.h"

#else /* scoxenix5 */
#ifdef pcxenix

#include "sys/param.h"
#include "sys/dir.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/tty.h"
#include "sys/ttold.h"
#include "sys/buf.h"
#include "sys/conf.h"
/* #include "sys/file.h" */
/*
 * Instead of including "sys/file.h", the following defines were 
 * borrowed from that file to keep the compiler from running out
 * of heap space.
 */
#define FREAD	01
#define FWRITE	02
#include "sys/proc.h"
#include <sys/extypes.h>
#include <sys/socket.h>
#include <sys/proc_dep.h>
#include "exreg.h"
/*
 * The follow include is commented out to keep compiler from running
 * out of heap space, it doesn't seem to be needed.
 *
 * #include <exos/misc.h>
 */
#include <ex_ioctl.h>
#include "exos.h"
#include <sys/ts.h>
#include <arpa/telnet.h>
#ifdef PULLIN
#undef	PULLIN
#endif
#define FROMXTY
#include "config.h"

#else /* pcxenix */
#ifdef zilog

#include <sys/param.h>		/* ??? */
#include <sys/signal.h>
#include <sys/s.out.h>		/* user.h */
#include <sys/mmu.h>		/* user.h */
#include <sys/dir.h>		/* user.h */
#include <sys/file.h>		/* ex_subr.c */
#include <sys/proc.h>		/* user.h */
#include <sys/user.h>		/* ENXIO */
#include <sys/conf.h>
#include <sys/buf.h>
#include <sys/tty.h>
#include <arpa/telnet.h>
#include <sys/ts.h>

#include <sys/extypes.h>
#include <sys/exreg.h>
#include <exos/misc.h>		/* also includes sys/soioctl.h */
#include <sys/socket.h>
#include <net/route.h>
#include "exos.h"
#include <ex_ioctl.h>

#define TICKS
#include <sys/swap.h>
#undef  TICKS

#ifdef PULLIN
#undef PULLIN
#endif
#include "config.h"

#else /* zilog */

#include "sys/param.h"
#if	!( plexus || mostek || V7 || BSD4dot2 || xenix286 || rtpc )
#include "sys/config.h"
#include "sys/mmu.h"
#endif
#ifdef	SYSTEM5
#include "sys/types.h"
#include "sys/signal.h"
#include "sys/sysmacros.h"
#include "termio.h"
#ifndef EPERM		/* don't include twice */
#include "errno.h"
#endif
#else
#include <signal.h>
#endif
#include "sys/dir.h"
#include "sys/user.h"
#include "sys/systm.h"
#ifdef BSD4dot2
#include "sys/ioctl.h"
#endif /* BSD4dot2 */
#include "sys/tty.h"
#if	!(V7 || BSD4dot2 || rtpc)
#include "sys/ttold.h"
#else
#if	!(BSD4dot2 || rtpc)
#include "xtyioctl.h"
#endif	/* BSD4dot2 || rtpc */
#endif
#include "sys/conf.h"
#include "sys/buf.h"
#include "sys/file.h"
#include "sys/proc.h"
#if !(plexus || V7 || BSD4dot2 )
#include "sys/var.h"
#endif

#ifndef	BSD4dot2
#ifndef xenix286
#include <macros.h>
#endif  /* xenix286 */
#endif	/* BSD4dot2 */
#include <sys/extypes.h>
#include <sys/socket.h>
#include "exreg.h"
#include <sys/proc_dep.h>
#include <sys/init.h>
#include <ex_ioctl.h>
#include "exos.h"
#include <sys/ts.h>
#include <arpa/telnet.h>
#ifdef PULLIN
#undef	PULLIN
#endif
#include "config.h"

#endif /* zilog */
#endif /* pcxenix */
#endif /* scoxenix5 */

#ifdef VERBOSE
#undef	VERBOSE
#endif
#ifdef VERBOSE
#define	say	printf
#else
#define say	nada
nada(){}
#endif

#if	V7 || BSD4dot2
#define	t_proc	t_oproc
#define	t_index	t_dev
#endif

/*
 * Some systems don't have t_index
 */
#if (xenix286 || zilog || rtpc)
#define EXTYINDEX(tp) (int)((tp) - &xt_tty[0])
#else
#define EXTYINDEX(tp) ((tp)->t_index)
#endif

#ifdef	BSD4dot2
#define ASLEEP		TS_ASLEEP
#define BUSY		TS_BUSY
#define	CARR_ON		TS_CARR_ON
#define	FLUSH		TS_FLUSH
#define ISOPEN		TS_ISOPEN
#define TIMEOUT		TS_TIMEOUT
#define TTIOW		TS_TTIOW
#define	TTSTOP		TS_TTSTOP
#define WCOLL		TS_WCOLL
#define WOPEN		TS_WOPEN
#endif	/* BSD4dot2 */


#define	UDPORT	600	/* local port used by udaemon */
#define	BELL	'\07'
#define	SENDCHAR(c)	{ xputb(ts->nm_tsdata[0], (c)); \
			  xputb(ts->nm_tsdlen, 1); \
			  xttytsread(ts, tp); }

int	ud_ssave = -1;	/* socket id of udaemon connection */
int	maxlistner = 0;	/* How many listeners? */
extern struct msg *ex_findmsg();
extern struct exctrl ex_db;
#define	sendTelnet_srvrStructure(ts) { \
	xputb(ts->mh_status, xgetb(ts->mh_status) | MQ_EXOS); XIONTRUPT();}

extern struct  tty xt_tty[];
extern int	_nxty;
extern struct	tty *last_xty;

static struct Telnet_srvr *
getaTelnet_srvrStructure()
{
	short x;
	extern  struct wmsg_area *wmsgarea;
	struct msg *mp = wmsgarea->ma_lastw;
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

	if ((xgetb (mp->nm_u.msg_hd.mh_status) & (MQ_EXOS|MQ_DONE)) != 0) {
		printf("xty:  couldn't get an h2x message buffer\07\n");
		return ((struct Telnet_srvr *)NULL);
	}

	EXSPL5(x);
	xputp( mp->msg_context, (struct context *)NULL);
	xputb( mp->nm_u.msg_hd.mh_status,
		xgetb(mp->nm_u.msg_hd.mh_status) | MQ_DONE);
	xputb( mp->nm_u.msg_hd.mh_reserved, 0);
	xputw( mp->nm_u.msg_hd.mh_length,
		sizeof(union exos_u) - sizeof(struct headers));
	xcl(&mp->nm_u.msg_msg.nm_soid, 
		sizeof(union exos_u) - sizeof(struct headers));
#if (pcxenix || rtpc)
	wmsgarea->ma_lastw =
		(struct msg *)
		(xgetw( mp->nm_u.msg_hd.mh_link) & (XM_WSIZE-1));
#else /* pcxenix || rtpc */
	wmsgarea->ma_lastw = mp->msg_link;
#endif /* pcxenix || rtpc */
	splx(x);
	return (struct Telnet_srvr *)mp;
}

/* send a command to the board */
static
sendcommand(tp, command)
struct tty *tp;
int command;		/* command to be sent */
{
	struct Telnet_srvr *ts;
	/* bank switched by geta...
	*/

	ts = getaTelnet_srvrStructure();		/* get a structure */
	/*
	 *  Ignore request to send command if we've run out of
	 *  message buffers.
	 */
	if (! ts) return;
	if ( EXTYINDEX(tp) == _nxty)
		xputw( ts->nm_soid, ud_ssave);
	else
		xputw( ts->nm_soid, minor(EXTYINDEX(tp)));
	xputb( ts->nm_request, TSCOMMAND);
	xputb( ts->nm_reply, 0);
	xputb( ts->nm_tsrqst, command);
	xputb( ts->nm_tsdlen, 0);
	sendTelnet_srvrStructure(ts);
}

#ifndef SYSTEM5	/* dont use tbufs */
/* send data to the board */
static
senddata(tp)
register struct tty *tp;
{
	register struct Telnet_srvr *ts;
	register int character;
	register short datalength;

	say("[SND");
	if (tp->t_outq.c_cc == 0) {
		tp->t_state &= ~BUSY;
		return 0;
	}
	tp->t_state |= BUSY;

	/*
	 * bank switched by getaT....
	 */
	ts = getaTelnet_srvrStructure();
	if( ! ts ) {
		/*
		 * We have no message buffers.  So, we're just tossing
		 * the data.
		 */
		tp->t_state &= ~BUSY;
		for (datalength = 0; getc (&tp->t_outq) >= 0; datalength++);
		say("(%d chars discarded)]", datalength);
		return (datalength);
	}
	if ( EXTYINDEX(tp) == _nxty)
		xputw( ts->nm_soid, ud_ssave);
	else
		xputw( ts->nm_soid, minor(EXTYINDEX(tp)));
	xputb( ts->nm_request, TSCOMMAND);
	xputb( ts->nm_reply, 0);
	xputb( ts->nm_tsrqst, TSWRITE);

	/* should use getcb/putcf/bcopy here */
	for (datalength = 0; datalength < sizeof ts->nm_tsdata; datalength++) {
		character = getc(&tp->t_outq);
		if (character < 0)
			break;
		xputb( ts->nm_tsdata[datalength], character);
	}
	xputb( ts->nm_tsdlen, datalength);
	sendTelnet_srvrStructure(ts);
	say("(%d chars)]", datalength);
	return datalength;
}
#else /* SYSTEM5 */ /* use tbufs */
static
senddata(tp)
register struct tty *tp;
{
	register struct Telnet_srvr *ts;
	register int character;
	register short datalength;
	register struct ccblock *tbuf;
	char buf[50], *cp = buf;
	int i;

	tp->t_state |= BUSY;
	tbuf = &tp->t_tbuf;

	for (datalength = 0; datalength < sizeof ts->nm_tsdata; datalength++) {
		if (tbuf->c_ptr == 0 || tbuf->c_count <= 0) {
			if (tbuf->c_ptr)
				tbuf->c_ptr -= tbuf->c_size - tbuf->c_count;
			if (!(CPRES & (*linesw[tp->t_line].l_output)(tp))) {
				break;
			}
		}
		*cp++ = *tbuf->c_ptr++;
		tbuf->c_count--;
	}
	/* if got no chars, return */
	if (datalength == 0) {
		tp->t_state &= ~BUSY;
		return 0;
	}
	ts = getaTelnet_srvrStructure();
	if (! ts) return (datalength);
	if ( EXTYINDEX(tp) == _nxty)
		xputw( ts->nm_soid, ud_ssave);
	else
		xputw( ts->nm_soid, minor(EXTYINDEX(tp)));
	xputb( ts->nm_request, TSCOMMAND);
	xputb( ts->nm_reply, 0);
	xputb( ts->nm_tsrqst, TSWRITE);
	xputb( ts->nm_tsdlen, datalength);
	for (cp = buf, i = 0; i < datalength; i++)
		xputb( ts->nm_tsdata[i], *cp++);
	sendTelnet_srvrStructure(ts);
	return datalength;
}
#endif

xtykill(tp)
register struct tty *tp;
{
#ifdef	BSD4dot2
	gsignal(tp->t_pgrp, SIGHUP);
#else	/* BSD4dot2 */
	signal(tp->t_pgrp, SIGHUP);
#endif	/* BSD4dot2 */
	wakeup((caddr_t)&tp->t_rawq);	/* necessary? */
#if	!(V7 || BSD4dot2)
	wakeup((caddr_t)&tp->t_oflag);
#else
	wakeup((caddr_t)&tp->t_outq);
#endif
}

/*
 * Called when board is downloaded.
 * Cleans up any processes waiting on the (possibly crashed)
 * on-board telnet/rlogin server.
 */
xtyinit()
{
	register struct tty *tp;

	ud_ssave = -1;
	for (tp = xt_tty; tp < last_xty ; tp++)
#if	!(V7 || BSD4dot2)
		tp->t_state &= ~(CARR_ON|BUSY|TTIOW);
#else
		tp->t_state &= ~(CARR_ON|BUSY);
#endif
		if (tp->t_state & ISOPEN)
			xtykill(tp);
}

/* process TSREAD requests from the board */
xttytsread(ts, tp)
struct Telnet_srvr *ts;
struct tty *tp;
{
	register int cc = xgetb(ts->nm_tsdlen);
	register int nchars = 0;
#if	V7 || SYSTEM5 || BSD4dot2
	register int c;
#endif
	/*
	 * We assume:
	 * 	1) this is only called at interupt level
	 *	2) the window to the boards memory has already been
	 *		set up.
	 */

	say("[RD");
	if ((tp->t_state&ISOPEN) == 0)
		 return;
	say("(%d chrs)]", cc);

#ifdef	SYSTEM3
	while (cc--) {
#ifdef zilog
		(*linesw[tp->t_line].l_input)
			(tp, (long)(xgetb(ts->tsdata[nchars])&0xff), 0);
		++nchars;
#else
#ifdef DEBUG_UD
		if( tp == last_xty  ) {
			printf( "ttyT8 input %x, nchars %x, cc %x\n",
				xgetb(ts->nm_tsdata[nchars]) & 0xff,
				nchars, cc );
		}
#endif /* DEBUG_UD */
		(*linesw[tp->t_line].l_input)
			(tp, xgetb(ts->nm_tsdata[nchars]) & 0xff, 0);
		++nchars;
	}
#endif	/* zilog */
#endif	/* SYSTEM3 */

#if	V7 || SYSTEM5 || BSD4dot2
	while ( cc-- ) {
#if	V7 || BSD4dot2
		ttyinput(xgetb(ts->nm_tsdata[nchars]), tp);
		++nchars;
#else
#ifdef SYSTEM5
		{
		    int ch;

#if !(pcxenix || rtpc)
		    c = *cp++;
#else
		    c = xgetb(ts->nm_tsdata[nchars]);
#endif /* pcxenix */
		    ch = c & 0177;
		    if (tp->t_rbuf.c_ptr == NULL) {
			    break;
		    }
		    if (tp->t_iflag&IXON) {
			    if (tp->t_state&TTSTOP) {
				    if (ch == CSTART || tp->t_iflag&IXANY)
					    (*tp->t_proc)(tp, T_RESUME);
			    } else {
				    if (ch == CSTOP)
					    (*tp->t_proc)(tp, T_SUSPEND);
			    }
			    if (ch == CSTART || ch == CSTOP)
				    continue;
		    }
		    if (tp->t_iflag&ISTRIP)
			    c &= 0177;
		    else
			    c &= 0377;
		    *tp->t_rbuf.c_ptr = c;
		    tp->t_rbuf.c_count--;
		    (*linesw[tp->t_line].l_input)(tp,0);
		    ++nchars;
		}
#endif /* SYSTEM5 */
#endif /* v7 or bsd4.2 */
	}
#endif /* SYSTEM5, v7, 4.2 */
}

/* This routine processes a packet from the board. */
xttyintr(ts)
struct Telnet_srvr *ts;
{
	register struct tty *tp;
	int i;
	int soid;

	/*
	 * We assume:
	 * 	1) this is only called at interupt level
	 *	2) the window to the boards memory has already been
	 *		set up.
	 */

	/*
	 * is this the udaemon?
	 * is anybody listening?
	 * is the device number in range?
	 */

	if ((xgetb(ts->nm_tsrqst) == TSCARON ||
	     xgetb(ts->nm_tsrqst) == RLCARON ) &&
	    (xgetw(ts->nm_tsdata[0]) == UDPORT)) {
		tp = &xt_tty[xgetw(ts->nm_soid)];
	} else if (xgetw(ts->nm_soid) == ud_ssave ) {
		tp = last_xty;
	} else {
		if (xgetw (ts->nm_soid) < maxlistner ||
		    xgetb (ts->nm_tsrqst) == TSCAROFF ) {
			tp = &xt_tty[xgetw(ts->nm_soid)];
		} else {
			/*
			 * No listener, kill the connection.
			*/
			soid = xgetw (ts->nm_soid);
			/* get a structure */
			ts = getaTelnet_srvrStructure();
			if (ts) {
				xputw (ts->nm_soid, soid);
				xputb (ts->nm_request, TSCOMMAND);
				xputb (ts->nm_reply, 0);
				xputb (ts->nm_tsrqst, TSHANGUP);
				xputb (ts->nm_tsdlen, 0);
				sendTelnet_srvrStructure(ts);
			} else {
				say ("<xtty intr -no bufs>");
			}
			return;
		}
	}
	say("[XINT(%d)]", xgetb(ts->nm_tsrqst));
	if (tp > last_xty )
		 return;
	if (xgetb(ts->nm_reply)) {
		say("xty: error = %d line = %d ud = %d\n",
			xgetb(ts->nm_reply), xgetw(ts->nm_soid), ud_ssave);
		xputb( ts->nm_tsrqst, TSCAROFF );
	}
	switch (xgetb(ts->nm_tsrqst)) {
	case TSWRITE:		/* xmit interrupt... */
		tp->t_state &= ~BUSY;
		if ((tp->t_state & CARR_ON) == 0) {
			say("[TSWRITE after CAROFF]");
			break;
		}
#ifdef	BSD4dot2
		if (tp->t_line)
			(*linesw[tp->t_line].l_start)(tp);
		else
			xtstart(tp);
#else	/* BSD4dot2 */
#if	!V7
		xtproc(tp, T_OUTPUT);
#else
		xtstart(tp);
#endif
#endif	/* BSD4dot2 */
		break;

	case TSREAD:
		if ((tp->t_state & CARR_ON) == 0) {
			say("[TSREAD(%d) after CAROFF]", xgetw(ts->nm_soid));
			break;
		}
		xttytsread(ts, tp);
		break;

	case TSCARON:
	case RLCARON:
		say("[CARON]");
	    /* is this the udaemon? */
		if (xgetw(ts->nm_tsdata[0]) == UDPORT) {
			ud_ssave = xgetw(ts->nm_soid);
			tp = last_xty ;
		}
		if( (tp->t_state & CARR_ON) ) {
			printf("Xty: carrier-on sent to an active device.\n" );
		}
		tp->t_state |= CARR_ON;
		if (tp->t_state & WOPEN) {
			tp->t_state &= ~WOPEN;
			wakeup((caddr_t)&tp->t_rawq);
		}
		break;

	case TSCAROFF:
		say("[CAROFF:state=%o]", tp->t_state);
		if (tp->t_state&CARR_ON) {
			if (ud_ssave == xgetw(ts->nm_soid))
				ud_ssave = -1;
#if	!(V7 || BSD4dot2)
			tp->t_state &= ~(CARR_ON|BUSY|TTIOW);
#else
			tp->t_state &= ~(CARR_ON|BUSY);
#endif
			if (tp->t_state & ISOPEN) {
#if	V7
				flushtty(tp, (FREAD|FWRITE));
#else
				ttyflush(tp, (FREAD|FWRITE));
#endif
				xtykill(tp);
			}
		}
		/*
		Let any pending close complete
		*/
		wakeup( (caddr_t)&tp->t_state );
		break;

	case TSNVTFUNCT:
		say("[NVTFUNCT]");
#if	V7
		flushtty(tp, FREAD);
#else
		ttyflush(tp, FREAD);
#endif
		switch (xgetb(ts->nm_tsdata[0])&0xFF) {
		    case IP:	/* interrupt process */
#ifdef	BSD4dot2
			gsignal(tp->t_pgrp, SIGINT);
#else	/* BSD4dot2 */
			signal(tp->t_pgrp, SIGINT);
#endif	/* BSD4dot2 */
			break;
		    case AYT:	/* are you there? */
			break;	/* handled on-board */
		    case EC:	/* erase char */
#if	!(V7 || BSD4dot2)
			SENDCHAR(tp->t_cc[VERASE])
#else
			SENDCHAR(tp->t_erase)
#endif
			break;
		    case EL:	/* erase line */
#if	!(V7 || BSD4dot2)
			SENDCHAR(tp->t_cc[VKILL])
#else
			SENDCHAR(tp->t_kill)
#endif
			break;
		}
		break;

	case TSDOOPT:
		say("[DOOPT]");
		switch (xgetb(ts->nm_tsdata[0])&0xFF) {
		    case TELOPT_BINARY:
			break;
		    case TELOPT_ECHO:
#if	!(V7 || BSD4dot2)
			tp->t_lflag |= ECHO;
#else
			tp->t_flags |= ECHO;
#endif
			break;
		    case TELOPT_SGA:
			break;
		}
		break;

	case TSDONTOPT:
		say("[DONTOPT]");
		switch (xgetb(ts->nm_tsdata[0])&0xFF) {
		    case TELOPT_BINARY:
#if	!(V7 || BSD4dot2)
			tp->t_iflag &= ~IGNBRK;
			tp->t_iflag |= (IXON|ISTRIP|ICRNL|BRKINT);
			tp->t_oflag |= (TAB3|OPOST|ONLCR);
			tp->t_lflag |= (ICANON|ISIG);
#else
			tp->t_flags &= ~RAW;
#endif
			break;
		    case TELOPT_ECHO:
#if	!(V7 || BSD4dot2)
			tp->t_lflag &= ~ECHO;
#else
			tp->t_flags &= ~ECHO;
#endif
			break;
		    case TELOPT_SGA:
			break;
		}
		break;

	default:
		say("xty: unknown message type = %x\n", xgetb(ts->nm_tsrqst));
		break;
	}
}

/*ARGSUSED*/
xttyopen(dev, flag)
	dev_t dev;
{
	register struct tty *tp;
	int carrwasoff = 0;
	extern xtproc();
	register int mdev;
#ifdef BSD4dot2
	register int error;

	if( u.u_ttyd == NULL )
		u.u_ttyd = dev;
#endif

	say("[XTTYOPEN");
	mdev = minor(dev);
	if( mdev >= maxlistner )
		maxlistner = mdev + 1;
	if (mdev > _nxty) {
		u.u_error = ENXIO;
		return;
	}
	tp = &xt_tty[mdev];
	if ( !(tp->t_state & CARR_ON) ) {
		++carrwasoff;
	}
	if ((tp->t_state & ISOPEN) == 0) {
#if	V7 || BSD4dot2
		ttychars(tp);
		tp->t_flags = 0;
		tp->t_line = 0;
		tp->t_ispeed = B9600;
		tp->t_ospeed = B9600;
		tp->t_proc = xtstart;
#else
		ttinit(tp);
#if !(xenix286 || zilog || rtpc)
		tp->t_index = mdev;
#endif
		tp->t_proc = xtproc;
#endif
	}
	while ((tp->t_state & CARR_ON) == 0) {
		tp->t_state |= WOPEN;
		(void) sleep((caddr_t)&tp->t_rawq, TTIPRI);
	}
#ifdef  BSD4dot2
	error = ttyopen(mdev,tp);
#else
#ifdef  V7
	ttyopen(mdev,tp);
#else
	(*linesw[tp->t_line].l_open)(tp);
#endif
#endif
	if( carrwasoff && (tp->t_state & BUSY) ) {
		/*
		 The carrier off message arrived while a process was
		 in the middle of writing to the xty device,
		 the shell died first, a new getty was spawned,
		 xttyclose was never called, and in short we must
		 clean up here.
		 */
#if	V7
		flushtty(tp, (FREAD|FWRITE));
#else
		ttyflush(tp, (FREAD|FWRITE));
#endif
#if	!(V7 || BSD4dot2)
		tp->t_state &= ~(BUSY|TTIOW|TIMEOUT);
#else
		tp->t_state &= ~(BUSY);
#endif
	}
	say("]");
#ifdef BSD4dot2
	return error;
#endif
}

#ifdef plexus
xttynull(temp1,temp2)
{
register struct tty *temp1;
}
#endif


xttyclose(dev)
	dev_t dev;
{
	register struct tty *tp;
	int pri;
	register int mdev;
#ifdef  BSD4dot2
	int error;

	if( u.u_ttyd == dev )
		u.u_ttyd = NULL;
#endif /* BSD4dot2 */

	say("[XTTYCLOSE");
	mdev = minor(dev);
	tp = &xt_tty[mdev];
	if( !(tp->t_state & CARR_ON) ) {
		/*
		There is a race condition between the various processes
		which have the terminal open and the carrier off message.
		Basically, we make sure that there is nothing to hold
		up the ttyclose.
		*/
#if	V7
		flushtty(tp, (FREAD|FWRITE));
#else
		ttyflush(tp, (FREAD|FWRITE));
#endif
#if	!(V7 || BSD4dot2)
		tp->t_state &= ~(BUSY|TTIOW|TIMEOUT);
#else
		tp->t_state &= ~(BUSY);
#endif
	}
#ifdef BSD4dot2
	error = ttyclose( tp );
#else
#ifdef  V7
	ttyclose(tp);
#else
	(*linesw[tp->t_line].l_close)(tp);
#endif
#endif
	/*
	 * We always behave as though HUPCL were set.
	 * Properly, we might set HUPCL upon opening,
	 * then test on closing.  If set, we would send
	 * the HANGUP, else leave CARR_ON.  (Is HUPCL set
	 * or reset by anyone else?)
	 */
	EXSPL5( pri );
	if (tp->t_state & CARR_ON) {	/* provoke a TSCAROFF */
		sendcommand(tp, TSHANGUP);
		say("[HANGUP]");
	}
	while(tp->t_state & CARR_ON) {
		sleep( (caddr_t)&tp->t_state, PZERO+1 );
	}
	splx( pri );
	say("]");
#ifdef BSD4dot2
	return( error );
#endif /* BSD4dot2 */
}

#ifdef	BSD4dot2
xttyread(dev, uio)
	struct uio * uio;
#else	/* BSD4dot2 */
xttyread(dev)
#endif	/* BSD4dot2 */
	dev_t dev;
{
	register struct tty *tp;
	register int mdev;
#ifdef	BSD4dot2
	register int error;
#endif	/* BSD4dot2 */

	mdev = minor(dev);
	tp = &xt_tty[mdev];
	say("<");
	if ((tp->t_state & CARR_ON) == 0)
		say("Tread CARR_ON\007\n");
#ifdef	BSD4dot2
	error = (*linesw[tp->t_line].l_read)(tp, uio);
#else	/* BSD4dot2 */
	(*linesw[tp->t_line].l_read)(tp);
#endif	/* BSD4dot2 */
	say(".");
#ifdef	BSD4dot2
	return error;
#endif	/* BSD4dot2 */
}

#ifdef	BSD4dot2
xttywrite(dev, uio)
	struct uio * uio;
#else	/* BSD4dot2 */
xttywrite(dev)
#endif	/* BSD4dot2 */
	dev_t dev;
{
	register int mdev = minor(dev);
	register struct tty *tp;
#ifdef	BSD4dot2
	register int error;
#endif	/* BSD4dot2 */

	tp = &xt_tty[mdev];
	say(">");
	if ((tp->t_state & CARR_ON) == 0)
		say("Twrite CARR_ON\007\n");
#ifdef	BSD4dot2
	error = (*linesw[tp->t_line].l_write)(tp, uio);
#else	/* BSD4dot2 */
	(*linesw[tp->t_line].l_write)(tp);
#endif	/* BSD4dot2 */
	say(".");
#ifdef	BSD4dot2
	return error;
#endif	/* BSD4dot2 */
}

#ifdef	BSD4dot2
/*
 * Stop output on a line
 */
/*ARGSUSED*/
xttystop(tp, flag)
	register struct tty * tp;
{
	register int s;
	
	EXSPL5(s);
	if (tp->t_state & BUSY && !(tp->t_state & TTSTOP))
		tp->t_state |= FLUSH;
	(void)splx(s);
}
#endif	/* BSD4dot2 */

/*ARGSUSED*/
xttyioctl(dev, cmd, addr, flag)
register EXioctltype addr;
register dev_t dev;
{
	register struct tty *tp;
	register int mdev = minor(dev);
#if	BSD4dot2
	register int error;
#endif	/* BSD4dot2 */

	say("[XTTYIOCTL");
	tp = &xt_tty[mdev];
	if ((tp->t_state & CARR_ON) == 0)
		say("Tread CARR_ON\007\n");
#if	V7
	ttioctl(tp, cmd, addr, mdev);
#else
#if	BSD4dot2
	error = (*linesw[tp->t_line].l_ioctl)(tp, cmd, addr, flag);
	if (error < 0)
		error =  ttioctl(tp, cmd, addr, flag);
#else
	ttiocom(tp, cmd, addr, flag);
#endif	/* BSD4dot2 */
#endif	/* V7 */
	say("]");
#ifdef	BSD4dot2
	return error;
#endif	/* BSD4dot2 */
}

#if	!(V7 || BSD4dot2)
xtproc(tp, cmd)
register struct tty *tp;
{
	extern ttrstrt();

	switch(cmd) {
		case T_TIME:
			tp->t_state &= ~TIMEOUT;
			goto start;

		case T_WFLUSH:
			if (tp->t_outq.c_cc) {
				while (getc(&tp->t_outq) >= 0)
					;
				tp->t_state &= ~BUSY;
			}
			/* fall through */

		case T_RESUME:
			tp->t_state &= ~TTSTOP;
			goto start;

		case T_OUTPUT:
start:
			if (tp->t_state&(TIMEOUT|TTSTOP|BUSY))
				break;
			if (tp->t_state&TTIOW && tp->t_outq.c_cc==0) {
				tp->t_state &= ~TTIOW;
				wakeup((caddr_t)&tp->t_oflag);
			}
			senddata(tp);
			if (tp->t_state&OASLP &&
				tp->t_outq.c_cc <= ttlowat[tp->t_cflag&CBAUD]) {
				tp->t_state &= ~OASLP;
				wakeup((caddr_t)&tp->t_outq);
			}
			break;

		case T_SUSPEND:
			tp->t_state |= TTSTOP;
			break;

		case T_BLOCK:
			tp->t_state &= ~TTXON;
			tp->t_state |= TBLOCK;
			if (tp->t_state & BUSY)
				tp->t_state |= TTXOFF;
			else {
				senddata(tp);
			}
			break;

		case T_RFLUSH:
			if (!(tp->t_state&TBLOCK))
				break;

		case T_UNBLOCK:
			tp->t_state &= ~(TTXOFF|TBLOCK);
			if (tp->t_state & BUSY)
				tp->t_state |= TTXON;
			else
				senddata(tp);
			break;

		case T_BREAK:
			tp->t_state |= TIMEOUT;
			timeout(ttrstrt, (caddr_t)tp, EXHZ/4);
			break;
	}
}
#else
#ifdef	BSD4dot2
/*
 *  start output on tty
 */
xtstart(tp)
	struct tty *tp;
{
	register int s, cc;

	say("XTSTART");
	EXSPL5(s);

	/*
	 * If currently active, we don't do anything.
	 */
	if (tp->t_state & (TTSTOP|BUSY|TIMEOUT))
		goto out;

	/*
	 * If there are sleepers and output has drained below
	 * low water mark, wakeup the sleepers.
	 */
	if (tp->t_outq.c_cc < TTLOWAT(tp)) {
		if (tp->t_state & ASLEEP) {
			tp->t_state &= ~ ASLEEP;
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~WCOLL;
		}
	}
	if (tp->t_outq.c_cc == 0)
		goto out;
	if (tp->t_flags & (RAW|LITOUT))
		cc = ndqb(&tp->t_outq, 0);
	else {
		cc= ndqb(&tp->t_outq, 0200);
		if (cc == 0) {
			extern ttrstrt();
			cc = getc(&tp->t_outq);
			timeout(ttrstrt, (caddr_t)tp, (cc&0x7f)+6);
			tp->t_state |= TIMEOUT;
			goto out;
		}
	}

	senddata(tp);
out:
	splx(s);
}
#else
/*
 *  start output on tty
 */
xtstart(tp)
	struct tty *tp;
{
	register int s;

	say("XTSTART");
	EXSPL5(s);
	if (tp->t_state & TTSTOP)
		return;
	senddata(tp);
	splx(s);
}
#endif
#endif
