/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_xmem.c,v 1.4 87/05/14 17:49:06 davidb Exp $ */

static char sccsId[] = "$Header: ex_xmem.c,v 1.4 87/05/14 17:49:06 davidb Exp $";

/*
 * EXOS Memory/Download Driver
 *
 * This driver is used to:
 *	configure board
 *	download code to board
 *	start up code on board
 *	read/write board memory after startup
 */

#define PULLIN
#include "config.h"
#define NON_SOCKET 	-1

#ifdef BSD4dot2
#define	U_OFFSET uio->uio_offset
#define	IOMOV_W	UIO_WRITE
#define	IOMOV_R	UIO_READ
#else
#define	U_OFFSET u.u_offset
#define	IOMOV_W	B_WRITE
#define	IOMOV_R	B_READ
#endif /* BSD4dot2 */

EXbtype *ex_getbuf();

struct	msg *ex_findmsg();
struct	context *ex_send();
extern	struct exctrl ex_db;
extern  int ex_dopoll;

#if (pcxenix || rtpc)
int xm_flags;			/* internal status flags */
unsigned short xm_cp2;		/* in core copy of control port 2 */

/*
 * virtual pointer to communications area.
 */
struct hsb *xm_pca = (struct hsb *)XM_COMAREA;

extern int ex_inited;
extern long fixadr();
extern int exintr();
extern long xm_padr;		/* Location of EXOS in host memory */

/*
 * duplicate defs from sys/mmu.h to keep compiler from blowing up
 */
#ifndef scoxenix5
#ifdef pcxenix
/*
 * descriptor table structure
 */
struct desctab {
	unsigned short	d_limit;	/* offset of last byte in segment */
	unsigned short	d_loaddr;	/* low word of physical address */
	char		d_hiaddr;	/* high byte of	physical address */
	char		d_acc;		/* access control byte */
	short		d_sw;		/* software defined word, unused */
};
#endif	/* pcxenix */
#endif	/* scoxenix5 */

#ifdef pcxenix
#define DSA_TREAD	0x2
#define DSA_VALID	0x10
#define DSA_PRESENT	0x80

#define DSA_DATA	(DSA_TREAD|DSA_VALID|DSA_PRESENT)

extern int  xm_sel;		/* GDT offset for EXOS selector entry */
#endif
#ifndef scoxenix5
#ifdef pcxenix
extern int splx();
extern int spl6();
extern int xsplx();
extern int xspl6();

extern char xpic2mask;
extern char xpic2orig;
#endif	/* pcxenix */
#endif	/* scoxenix5 */
#ifdef pcxenix
#define MAX_NB_PARAMS 24
static char nb_params[MAX_NB_PARAMS];
static short nb_inited = 0;
#endif


xmopen(dev)
	dev_t dev;
{
	static int firsttime = 1;
#ifndef scoxenix5
#ifdef pcxenix
	faddr_t patcha;
	faddr_t newa;
	faddr_t splxa;
	faddr_t spl6a;
	struct desctab far *codeacc;	/* descriptor for kernel text */
	long codephys;			/* physical address of kernel text */
	char patchb[6];
	int i;
#endif	/* pcxenix */
#endif	/* scoxenix5 */

	if (!firsttime)
		return( 0 );
#ifndef scoxenix5
#ifdef pcxenix
	/*
	 * Patch spl routines (SELF MODIFYING CODE!)
	 */
	xcli();		/* no interupts */
	/*
	 * make kernel code writeable ( actually make a descriptor which 
	 * can be use to write to text ).
	 */
	codeacc = (struct desctab far *)
		((0x8L << 16) + 0x20L); /* TEXT GDT entry */
	codephys = ((long)(codeacc->d_hiaddr & 0xff) << 16) +
		((long)codeacc->d_loaddr & 0xffffL );
#ifdef DEBUG_SPL
	printf( "text physical address %x%x\n", codephys );
#endif	/* DEBUG_SPL */
	mmudescr( xm_sel, codephys, codeacc->d_limit, DSA_DATA );
	if( ex_intlev == 2 )
		xpic2mask |= 0x2;		/* we want bit 1 masked;
							that's us */
	/*
	 * all spl's evetually go through spl6, we patch in at the
	 * point where ah contains the mask for the primary pic
	 */
	spl6a = (faddr_t)spl6;
	splxa = (faddr_t)splx;
	newa = (faddr_t)xspl6;
	patcha = (faddr_t)
		(((long)(spl6a + 2) & 0xffffL) + ((long)xm_sel << 16));
	patchb[0] = 0x9a;		/* call far */
	bcopy( &newa, &patchb[1], sizeof( faddr_t ) );  /*jmp address*/
	patchb[5] = 0xcb;		/* reti */
#ifdef DEBUG_SPL
	printf( "patchb %x, %x, %x, %x, %x, %x\n",
		patchb[0] & 0xff, patchb[1] & 0xff,
		patchb[2] & 0xff, patchb[3] & 0xff,
		patchb[4] & 0xff, patchb[5] & 0xff);
	printf( "patcha %x%x", patcha );
#endif	/* DEBUG_SPL */
	for( i = 0 ; i < 6 ; ++i, ++patcha ) {
		*patcha = patchb[i];
	}
	/*
	 * now for splx
	 */
	newa = (faddr_t)xsplx;
	patcha = (faddr_t)
		(((long)(splxa) & 0xffffL) + ((long)xm_sel << 16));
	bcopy( &newa, &patchb[1], sizeof( faddr_t ) );
#ifdef DEBUG_SPL
	printf( "patchb %x, %x, %x, %x, %x, %x\n",
		patchb[0] & 0xff, patchb[1] & 0xff,
		patchb[2] & 0xff, patchb[3] & 0xff,
		patchb[4] & 0xff, patchb[5] & 0xff);
#endif	/* DEBUG_SPL */
	for( i = 0 ; i < 6 ; ++i, ++patcha ) {
		*patcha = patchb[i];
	}
	xsti();		/* interupts OK now */
#ifdef DEBUG_SPL
	{
	int s1, s2;

	printf( "xpic2mask %x, xpic2orig %x\n", xpic2mask, xpic2orig );
	s1 = spl5();
	printf( "s1 %x, imr1 %x, imr2 %x\n",
		s1, inb( 0x21 ), inb( 0xa1 ));
	s2 = spl0();
	printf( "s2 %x, imr1 %x, imr2 %x\n",
		s2, inb( 0x21 ), inb( 0xa1 ));
	splx( s1 );
	printf( "imr1 %x, imr2 %x\n",
		inb( 0x21 ), inb( 0xa1 ));
	printf( "xpic2mask %x, xpic2orig %x\n", xpic2mask, xpic2orig );
	}
#endif	/* DEBUG_SPL */
	/*
	 * Now, for our more legitimate setup activities.
	 */
#endif	/* pcxenix */
#endif	/* scoxenix5 */
#ifdef pcxenix
	/*
	 * set port location in io-space
	 */
	if( !ex_db.ex_port )
		ex_db.ex_port = 0x310;    /* factory jumper setting */
#ifdef scoxenix5
	/*
	 * FOR PC AT SCO XENIX ONLY
	 * "xm_sel" initialized to 0 in "ex_config.c"
	 * get and use a new descriptor instead of using the
	 * hardcoded one
	 */
#ifdef XMDEBUG
	printf ("xm_sel was specified as %x\n", xm_sel);
#endif
	if( !xm_sel ) {
		if(( xm_sel = dscralloc() ) == 0) {
			printf ("dscralloc error\n");
			return(u.u_error = ENXIO);
		}
#ifdef XMDEBUG
		printf ("dscralloc returned %x\n", xm_sel);
#endif
	}
#endif	/* scoxenix5 */
	/*
	 * Soft Reset
	 */
	XIORESET();
	/*
	 * setup GDT entry for window to exos memory
	 */
	mmudescr( xm_sel, xm_padr, (XM_WSIZE-1), DSA_DATA ); 
#endif
#ifdef rtpc
	if (exattach() != 0)	/* initialize VRM and AIX driver */
		return(u.u_error);
#endif
	/*
	 * set exos window to match.
	 */
	xm_flags |= XM_INIT;
	xm_cp2 = ( (unsigned short)(xm_padr >> 5) & CP2_WINADR ) | CP2_WINON;
	out( CP2_ADR, xm_cp2 );
	firsttime = 0;
	return( u.u_error );
} /* xmopen */
#endif	/* pcxenix || rtpc */



#ifdef BSD4dot2
xmread(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
xmread(dev)
	dev_t dev;
#endif
{
	register EXbatype baddr;
	register int amount;
	register long dladdr;
	register int mdev = minor(dev);
	EXbtype *dlbuf;		/* pointer to buf containing memory */
#ifdef BSD4dot2
	/*
	compensate for fact that u.u_count is a relic from before
	scatter-gather io.
	*/
	register int uiocnt;
	register struct iovec *iov;

	for (u.u_count = 0, iov = uio->uio_iov, uiocnt = 0; 
	     uiocnt < uio->uio_iovcnt; ++uiocnt, ++iov ) {
		u.u_count += iov->iov_len;
	}
#endif
#ifdef	DEBUG
	printf("xmread(%x): u.u_count=%d\n", mdev, u.u_count);
#endif
	EXgetsblk( baddr, dlbuf, BSIZE );

	while (u.u_count) {
		amount = MIN(EXBSIZE, u.u_count);
		dladdr = U_OFFSET;	/* do this BEFORE iomove */
#ifdef	DEBUG_NOISE
		printf("xmread: reading %d bytes from %x to %x\n", amount,
			dladdr, baddr);
#endif
		if (xmrw(mdev, baddr, dladdr, amount, NET_ULOAD, dlbuf))
			break;
#ifdef BSD4dot2
		uiomove(EXioaddr(baddr,dlbuf), amount, IOMOV_R, uio);
		u.u_count -= amount;
#else
		iomove(EXioaddr(baddr,dlbuf), amount, IOMOV_R);
#endif
		EXmapout( dlbuf );
		if (u.u_error)
			break;
	}
	EXbrelse(dlbuf, BSIZE);
#ifdef BSD4dot2
	uio->uio_resid = u.u_count;
	uio->uio_iov->iov_len = u.u_count;
#endif
	return(u.u_error);
}

#ifdef BSD4dot2
xmwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
xmwrite(dev)
	dev_t dev;
#endif
{
	register EXbatype baddr;
	register int amount;
	register long dladdr;
	register mdev = minor(dev);
	EXbtype *dlbuf;		/* pointer to buf containing memory */
#ifdef BSD4dot2
	/*
	compensate for fact that u.u_count is a relic from before
	scatter-gather io.
	*/
	register int uiocnt;
	register struct iovec *iov;

	for (u.u_count = 0, iov = uio->uio_iov, uiocnt = 0; 
	     uiocnt < uio->uio_iovcnt; ++uiocnt, ++iov ) {
		u.u_count += iov->iov_len;
	}
#endif
#ifdef	DEBUG
	printf("xmwrite(%x): u.u_count=%d\n", mdev, u.u_count);
#endif
	if (!suser())
		return(u.u_error = EPERM);

	EXgetsblk( baddr, dlbuf, BSIZE );

	while (u.u_count) {
		amount = MIN(EXBSIZE, u.u_count);
		dladdr = U_OFFSET;	/* do this BEFORE iomove */
#ifdef BSD4dot2
		uiomove(EXioaddr(baddr, dlbuf ), amount, IOMOV_W, uio);
		u.u_count -= amount;
#ifdef DEBUG
		if ( u.u_count < 0 ) {
			printf( "bad guess on handling of u.u_count\n" );
			u.u_count = 0;
		}
#endif
#else
		iomove(EXioaddr(baddr, dlbuf ), amount, IOMOV_W);
#endif
		EXmapout( dlbuf );
		if (u.u_error)
			break;
#ifdef	DEBUG_NOISE
		printf("xmwrite: sending %d bytes from %x to %x\n", amount,
			baddr, dladdr);
#endif
		if (xmrw(mdev, baddr, dladdr, amount, NET_DLOAD, dlbuf))
			break;
#ifdef  DEBUG3
		printf( "got to end of loop resid=%d iov_cnt=%d\n",
			uio->uio_resid, uio->uio_iov->iov_len );
#endif
	}
	EXbrelse(dlbuf, BSIZE);
#ifdef BSD4dot2
	uio->uio_resid = u.u_count;
	uio->uio_iov->iov_len = u.u_count;
#endif
	return(u.u_error);
}

xmrw(mdev, baddr, dladdr, amount, net_cmd, bp)
int mdev;
EXbatype	baddr;
long	dladdr;
EXbtype *bp;
{
	register struct net_dload *net_dload;
	register struct context *kp;
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

	if( xm_flags & XM_MODRUNNING ) {
		/*
	 	* get message buffer; send download message
	 	*/
		net_dload = (struct net_dload *)ex_findmsg( NON_SOCKET );
		xputw(net_dload->nm_length, amount);
		xputd(net_dload->nm_source, (long)EXvtop(baddr,bp,0));
#ifdef pcxenix
		xputb(net_dload->nm_xmbyte, *(char far *)baddr);
#else
		xputb(net_dload->nm_xmbyte, *baddr);
#endif
			/* for 1-character writes */
		xputd(net_dload->nm_dest, dladdr);
		kp = ex_send(net_cmd, mdev, net_dload, 0);
		kp->kl_state = KL_FREE;
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
#ifdef pcxenix
		*(char far *)baddr = kp->kl_achar;/* for 1-character reads */
#else
		*baddr = kp->kl_achar;/* for 1-character reads */
#endif
		if (kp->kl_error) {
#ifdef  DEBUG
			printf( "error in reply %x\n", kp->kl_error );
#endif
			return(u.u_error = EIO);
		}
	} else {
	    return (u.u_error = xmrw_gen (baddr, dladdr, amount, net_cmd));
	}
	return 0;
}

int
xmrw_gen (baddr, dladdr, amount, net_cmd)
	EXbatype baddr;
	long dladdr;
	int amount, net_cmd;
{
    unsigned chunk, offset;

#ifdef DEBUG_BIO
    printf( "dladdr = %x amount %d\n", dladdr, amount);
#endif	/* DEBUG_BIO */
    if( xm_flags & XM_SEGMOD ) {
	/*
	 * convert to absolute address
	 */
	dladdr = fixadr( dladdr );
    }
    xm_flags &= ~XM_PARERR;
    while( amount > 0 ) {
	offset = (unsigned) (dladdr & (XM_WSIZE - 1 ));
	if( offset + amount > XM_WSIZE )
	    chunk = XM_WSIZE - offset;
	else
	    chunk = amount;
	if( chunk > XM_CHNKSZ )
	    chunk = XM_CHNKSZ;
#ifdef DEBUG_BIO
	printf("xmrw_gen: xm_cp2 = %x windadr %x bank %x\n",
	       xm_cp2, xm_cp2&CP2_WINADR, xm_cp2&CP2_205BANK);
#endif	/* DEBUG_BIO */
	swtchbank( offtobank(dladdr) );
#ifdef DEBUG_BIO
	printf("xmrw_gen: xm_cp2 = %x windadr %x bank %x\n",
	       xm_cp2, xm_cp2&CP2_WINADR, xm_cp2&CP2_205BANK);
	printf("xmrw_gen: baddr = %x offset %x chunk = %d\n",
	       baddr, offset, chunk);
#endif	/* DEBUG_BIO */
	if ( net_cmd == NET_DLOAD ) {
	    xcpo( baddr, offset, chunk );
	} else {
	    xcpi( offset, baddr, chunk );
	}
	if( xm_flags & XM_PARERR ) {
	    return (EIO);
	    break;
	}
	amount -= chunk;
	dladdr += chunk;
	baddr += chunk;
    }
    return (0);
}

/*
 * Ioctls are used only by netload program,
 * typically in the following sequence:
 * 	
 *	EXIOCRESET
 *	seek(start of code)
 *	write, write, write...
 *	seek(start of initialized data)
 *	write, write, write...
 *	EXIOCSTART
 *
 */
/*ARGSUSED*/
xmioctl(dev, cmd, addr, flag)
	dev_t dev;
	int cmd, flag;
	EXioctltype addr;
{
	register struct net_start *net_start;
	register struct context *kp;
	register mdev = minor(dev);
	long staddr;
	int i;
	short word, fuword();
	int dotimo;

#ifdef rtpc
#include <sys/kio.h>
#include <sys/ksvc.h>
	struct ccb ccb;
	extern unsigned short exiodn;
	extern int expdev, expathid;
#endif

#ifdef  DEBUG
	printf( "xmioctl: mdev=%x cmd=%x, addr=%x, flag=%x\n",
		mdev, cmd, addr, flag );
#endif

#ifdef BSD4dot2
	/* IO_VOID passes a pointer to the original argument */
	addr = (caddr_t)(*((long *)addr));
	cmd = map_ioctl_cmd( cmd );
#ifdef  DEBUG
	printf( "xmioctl: mdev=%x cmd=%x, addr=%x, *addr=%x flag=%x\n",
		mdev, cmd, addr, (caddr_t)(*((long *)addr)), flag );
#endif
#endif

	switch (cmd) {
	case map_ioctl_cmd(EXIOCRESET):	/* reset and configure EXOS */
		if (!suser())
			return(u.u_error = EPERM);
		if (copyin(addr, (caddr_t)&dotimo, sizeof(dotimo))) {
			u.u_error = EFAULT;
			break;
		}
		if (ex_db.ex_init == 0)
#ifdef rtpc
			ex_init();	/* one-time-only initialization */
#else
			exinit();	/* one-time-only initialization */
#endif

#ifndef pcxenix
		/*
		 * Blow away anything waiting on socket.
		 */
		board_reset();
#endif	/* pcxenix */
#ifdef XTY
		xtyinit();		/* xty housekeeping */
#endif
#if !(pcxenix || rtpc)
		if (exsetup(EXOS_HOSTLOAD, dotimo))
			u.u_error = EIO;
#else	/* pcxenix || rtpc */
		xm_flags &= ~XM_MODRUNNING;
		xm_flags |= XM_SEGMOD;	/* addresses will be passed as segments */
#endif	/* pcxenix || rtpc */
		break;
	  case map_ioctl_cmd(EXIOCGCONF):/* return configuration message */
		/* might want to assure that ex_init, first */
#ifdef pcxenix
		if (copyseg(EXiocpaddr(ex_db.ex_imsg, imsgbuf),
			addr, sizeof(struct init_msg))) {
			u.u_error = EFAULT;
		}
#else
		if (copyout(EXiocpaddr(ex_db.ex_imsg, imsgbuf),
			addr, sizeof(struct init_msg))) {
			u.u_error = EFAULT;
		}
#endif /* pcxenix */
		EXmapout( imsgbuf );
		break;
	  case map_ioctl_cmd(EXIOCSTART):	/* start program running */
		if (!suser())
			return(u.u_error = EPERM);
		if (copyin(addr, (caddr_t)&staddr, sizeof(staddr))) {
			u.u_error = EFAULT;
			break;
		}
#ifdef	DEBUG
printf("xmioctl: start address=%x\n", staddr);
#endif
#if (pcxenix || rtpc)
		/*
		 * put start address into communication area
		 */
		swtchbank( XM_UPPER );
		xpokeadr(((int)(COMSTARTADR & (long)(XM_WSIZE-1))), staddr);
		if (!ex_dopoll) XIOCLRINT();
		/*
		 * write segment to control port 1
		 */
		out( CP1_ADR, (short)((staddr >> 16) & 0x0000ffffL));
		xm_flags |= XM_MODRUNNING;
		ex_inited = 1;
		if( ex_dopoll )
			timeout( exintr, 0, 1 );
#ifdef rtpc
	/* Control command that passes EXOS pathid to VRM driver.
	 * The pathid is used by the VRM to send virtual interrupts
	 * to exintr.
	 */
	if (!expdev) {
		int rv;

		ccb.result = 0;
		ccb.dev_opt = CCB_SYNCH;
		ccb.reserved = 0;
		ccb.iodn = exiodn;
		expdev++;
		if(rv = S_XSIO(&ccb, expathid)) {
			expdev = 0;
			printf("exattach: sio failed %d on iodn %d\n",
			    rv, exiodn);
		}
	}
#endif	/* rtpc */
#else	/* pcxenix || rtpc */
		net_start = (struct net_start *)ex_findmsg( NON_SOCKET );
		*((long *)&net_start->nm_sa1) = staddr;
		kp = ex_send(NET_START, mdev, net_start, 0);
#ifdef	DEBUG_NOISE
printf("xmioctl: START message sent\n");
#endif
		if (kp->kl_error)
			u.u_error = EIO;
		/*
		 * Ex_klfree deallocates this context buffer
		 * (and any others that happen to be tied up).
		 */
		ex_klfree(mdev);
#endif	/* pcxenix || rtpc */
		break;
	  case map_ioctl_cmd(EXDIRECTACCESS):	/* access board memory directly
						(this is the default until
						EXIOCSTART).
						*/
		xm_flags &= ~XM_MODRUNNING;
		xm_flags &= ~XM_SEGMOD;
		break;
	  case map_ioctl_cmd(EXMESSAGEACCESS):	/* access board memory via
						messages.
						(this is the default after
						EXIOCSTART).
						*/
		xm_flags |= XM_MODRUNNING;
		break;
	  case map_ioctl_cmd(EXRESET205):
		if (!suser())
			return(u.u_error = EPERM);
		ex_inited = 0;
		/*
		soft reset of board
		*/
		XIORESET();
		board_reset();
		/*
		initialize window
		*/
		xm_flags |= XM_INIT;
		xm_cp2 = ( (unsigned)(xm_padr >> 5) & CP2_WINADR ) | CP2_WINON;
		out( CP2_ADR, xm_cp2 );
		/*
		allow re-initialization of message queues
		*/
		ex_db.ex_init = 0;
		break;


	    case map_ioctl_cmd(EXBDSTATRESET):
			if (!suser())
			    return(u.u_error = EPERM);
	    case map_ioctl_cmd(EXBDSTAT):
		{
 			exdoioctl(cmd,addr,0);
			return(u.u_error);
		}
	     case map_ioctl_cmd(EXIOCADDRT):
	     case map_ioctl_cmd(EXIOCDELRT):
			if (!suser())
			    return(u.u_error = EPERM);
	     case map_ioctl_cmd(EXIOCSHOWRT):
	     case map_ioctl_cmd(EXIOCDISPRT):

			/* send ROUTE operation to the board */

 			exdoioctl(cmd,addr,2);
			return(u.u_error);
	     case map_ioctl_cmd(EXIOCSARP):
	     case map_ioctl_cmd(EXIOCDARP):
			/* check permission */
			if( !(u.u_ruid == 0 || u.u_uid == 0 ) )
				{
				u.u_error = EACCES;
				return( u.u_error );
				}
			/* absence of break here is diliberate */
	     case map_ioctl_cmd(EXIOCGARP):
			/* send ARP operation to the board */
		{
 			exdoioctl(cmd,addr,1);
			return(u.u_error);
		}
#if (pcxenix || rtpc)
	     case map_ioctl_cmd(EXIOCP1READ):
		if (!suser())
		    return(u.u_error = EPERM);
#ifdef DEBUG
		printf("xmioctl: read cp1 %x\n", (int) in(CP1_ADR));
#endif
		suword(addr, (int) in(CP1_ADR));
		break;
	     case map_ioctl_cmd(EXIOCP2READ):
		if (!suser())
		    return(u.u_error = EPERM);
#ifdef DEBUG
		printf("xmioctl: read cp2 %x\n", (int) xm_cp2);
#endif
		suword(addr, (int) xm_cp2 );
		break;
	     case map_ioctl_cmd(EXIOCP1WRITE):
		if (!suser())
		    return(u.u_error = EPERM);
#ifdef DEBUG
		printf("xmioctl: write cp1 %x\n", fuword(addr));
#endif
		out( CP1_ADR, fuword(addr) );
		break;
	     case map_ioctl_cmd(EXIOCP2WRITE):
		if (!suser())
		    return(u.u_error = EPERM);
		word = fuword(addr);
#ifdef DEBUG
		printf("xmioctl: write cp2 %x\n", word);
#endif
		xm_cp2 &= CP2_WINON | CP2_WINADR;
		xm_cp2 |= word & ~(CP2_WINON | CP2_WINADR );
		out(CP2_ADR, xm_cp2);
		break;
	     case map_ioctl_cmd(EXIOSWITCHON):
		printf( "EXIOSWITCHON called.\n" );
		break;
	      case map_ioctl_cmd(EXNETBIOSINIT):
		if (!suser()) return (u.u_error = EPERM);
/*		if (nb_inited) return (u.u_error = EBUSY);*/
		{
		    short length;
		    if (copyin (addr, &length, sizeof (length)))
			return (u.u_error = EFAULT);
		    if (length < 0 || length > MAX_NB_PARAMS)
			return (u.u_error = EINVAL);
		    if (copyin (addr, nb_params, length))
			return (u.u_error = EFAULT);
		}
		nb_inited = 1;
		break;
#endif	/* pcxenix || rtpc */
	default:
		u.u_error = EINVAL;
	}
	return(u.u_error);
}

/*
 * ex_nbparams() --- return Netbios parameters to Netbios.
 */
ex_nbparams (addr, length)
char *addr;
short length;
{
    char *a, *b;

    if (! nb_inited) return (-1);
    if (length > MAX_NB_PARAMS) length = MAX_NB_PARAMS;
    for (a = addr, b = nb_params; length > 0; length--)
	*a++ = *b++;
    return (0);
}
	

/* 
 * exdoioctl() --- send a random "ioctl" to the board.
 */
exdoioctl(cmd, addr, in_interesting )
	int cmd;
	EXioctltype addr;
	int in_interesting;		/* flag to copy in ioctl structure */
{
	register struct msg *mp;
	register struct context *kp;
	register long sopaddr;
	register int amount;
	register EXbatype baddr;
	EXbtype *bp;
	struct Sock_pkt *admin_pkt; 
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

	/* check that board is in a state to
	   accept messages */
	if( !(xm_flags & XM_MODRUNNING) ) {
		return( u.u_error = ENXIO );
	}

	/* get buffer where data will be kept */ 

	EXgetblk( baddr, bp, BSIZE );
	sopaddr = ((long)EXvtop(baddr,bp,0)); 

	/*
	If appropriate,
	copy ioctl structure to buffer
	*/

	if ( in_interesting  == 1)
		{
#ifdef pcxenix
		copyseg(addr, EXiocpaddr(baddr,bp), sizeof(struct EXarp_ioctl));
#else
		copyin(addr, EXiocpaddr(baddr,bp), sizeof(struct EXarp_ioctl));
#endif /* pcxenix */
		EXmapout(bp);
		}
	if (in_interesting  == 2){
#ifdef pcxenix
		copyseg( addr, EXiocpaddr(baddr,bp), sizeof(struct rtentry) );
#else
		copyin( addr, EXiocpaddr(baddr,bp), sizeof(struct rtentry) );
#endif /* pcxenix */
		EXmapout(bp);
	}

	/* send command to board */

	mp = (struct msg *)ex_findmsg( NON_SOCKET );
	kp = (struct context *)xgetp( mp->msg_context );
	kp->kl_baddr = bp;
	admin_pkt = (struct Sock_pkt *)mp;
	xputd(admin_pkt->nm_bufaddr, sopaddr);
	kp = ex_send( cmd, NON_SOCKET, mp, 0 );
	if (u.u_error = kp->kl_error)
		goto exout;

	/* copy data to user space */

	switch ( cmd ) {
		case map_ioctl_cmd(EXBDSTAT):
		case map_ioctl_cmd(EXBDSTATRESET):
#ifdef pcxenix
			if (copyseg(EXiocpaddr(baddr,bp),
				addr, sizeof(struct EXbdstats))) {
				u.u_error = EFAULT;
			}
#else
			if (copyout(EXiocpaddr(baddr,bp),
				addr, sizeof(struct EXbdstats))) {
				u.u_error = EFAULT;
			}
#endif /* pcxenix */
			EXmapout( bp );
			break;
		case map_ioctl_cmd(EXIOCSARP):
		case map_ioctl_cmd(EXIOCGARP):
		case map_ioctl_cmd(EXIOCDARP):
#ifdef pcxenix
			if (copyseg(EXiocpaddr(baddr,bp),
				addr, sizeof(struct EXarp_ioctl))) {
				u.u_error = EFAULT;
			}
#else
			if (copyout(EXiocpaddr(baddr,bp),
				addr, sizeof(struct EXarp_ioctl))) {
				u.u_error = EFAULT;
			}
#endif /* pcxenix */
			EXmapout( bp );
			break;
		case map_ioctl_cmd(EXIOCADDRT):
		case map_ioctl_cmd(EXIOCDELRT):
		case map_ioctl_cmd(EXIOCDISPRT):
		case map_ioctl_cmd(EXIOCSHOWRT):
#ifdef pcxenix
			if (copyseg(EXiocpaddr(baddr,bp),
				addr, sizeof(struct rtentry))) {
				u.u_error = EFAULT;
			}
#else
			if (copyout(EXiocpaddr(baddr,bp),
				addr, sizeof(struct rtentry))) {
				u.u_error = EFAULT;
			}
#endif
			EXmapout( bp );
			break;
		default :
			u.u_error = EIO;
			break;
		}
exout:	kp->kl_state = KL_FREE;
	if (ex_db.ex_state & ST_WAITING)
		wakeup((caddr_t)&ex_db);
	EXbrelse(bp, BSIZE);
}

