/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_subr.c,v 1.2 87/04/24 14:14:34 davidb Exp $ */

/*
   revision history:
   rev  by      description
   ---  ------- -----------
   1.8  pbf     make ex_findmsg reset ST_WAITING in ex_db.ex_state after
                sleep returns. Add dev argument to ex_send. Make ex_send
                delay setting MQ_EXOS bit in msg header til after all msg
                fields are set. Add ex_klfree routine.
   1.9  pbf     Add kl_baddr field to context struct. Make ex_findmsg clear
                this field. Make ex_klfree release buffer. Lock out exos
                interrupts during ex_klfree.
 5/12/84 wrn	put "procflags" array into c(onf).c.  make ex_send do
		save(u.u_qsav) soas to handle signals, esp. out-of-band
		signals, "correctly".  Fix tsleep().
 8/13/84 wrn	Do tsleep stuff inline like 4.2.  Put a while around the
		sleeps in ex_send.
 9/9/84 wrn	New vax-compatable exos.h rearranges "struct msg".
 1/15/85 mp	Made ex_send not release buffer.  This must be handled in
		ex_intr() instead.
 */

#define EXOSSELECT
#define EXOSASYNCIO

#define PULLIN
#include "config.h"
extern short	xso_client_id;

extern  struct exctrl ex_db;
extern  struct rmsg_area *rmsgarea;
extern  struct wmsg_area *wmsgarea;
extern  int ex_inited;
static char sccsId[] = "@(#)ex_subr.c	1.1 8/16/85";

#ifdef DEBUG
exdump(addr, len)
caddr_t	addr;
int	len;
{
register int i;
static char xa[] = "0123456789ABCDEF";
	while (len > 0) {
		printf("%6X: ", addr);
		for (i=0; i<16; i++, len--, addr++) {
			if (!(i & 0x01)) printf(" ");
			printf("%c%c", xa[(*addr>>4)&0x0F], xa[(*addr)&0x0F]);
			if (len <= 0) break;
		}
		printf("\n");
	}
}
#endif

#if !(pcxenix || rtpc)
/*
 * exsetup:
 *      - perform probe level initialization
 *      - setup controller mode according to "mode"
 *      - setup message queues
 *      - send init message to exos
 *      - look at response and return value accordingly
 */
int
exsetup(mode, dotimo)
        int mode;
	int dotimo;			/* argument of EXIOCRESET 
					 * dotimo & 0x80 => infinite timeout
					 * ( for debugger )
					 */
{
        register struct init_msg *im;
        register struct msg *current, *next;
        long i, timeout;
        long addr;
        static char magic[8] = {0xff, 0xff, 0, 0};
        register char *ap;
	int tmp, s;  /* temporary debugging variable */
	int dotimeout = !(dotimo & 0x80);

	/*
	 * Reset the board before we do anything else as
	 * the board may be active while we are setting up queues.
	 * -- bvs 850502
	 */
	EXSPL6( s );
	XIORESET();
	EXSPLX(s);
    /* link together the read ("exos to host") message queue */

        rmsgarea->ma_rlink =
		(short)EXvtop(rmsgarea->ma_rmsgs, rmsgarea->ma_rmsgs,1 );
        current = &rmsgarea->ma_rmsgs[NET_RBUFS-1];
        rmsgarea->ma_lastr = rmsgarea->ma_rmsgs;
        for (i = 0; i < NET_RBUFS; i++) {
                next = &rmsgarea->ma_rmsgs[i];
                current->nm_u.msg_hd.mh_link = (short)EXvtop(next,next,1);
                current->nm_u.msg_hd.mh_length = sizeof(union exos_u) -
			sizeof(struct headers);
                current->nm_u.msg_hd.mh_status = 3;
                current->msg_link = next;
                current = next;
        }

    /* link together the write ("host to exos") message queue */

        wmsgarea->ma_wlink =
		(short)EXvtop(wmsgarea->ma_wmsgs,wmsgarea->ma_wmsgs,1);
        current = &wmsgarea->ma_wmsgs[NET_WBUFS-1];
        wmsgarea->ma_lastw = wmsgarea->ma_wmsgs;
        for (i = 0; i < NET_WBUFS; i++) {
                next = &wmsgarea->ma_wmsgs[i];
                current->nm_u.msg_hd.mh_link = (short)EXvtop(next,next,1);
                current->nm_u.msg_hd.mh_length = sizeof(union exos_u) -
			sizeof(struct headers);
                current->nm_u.msg_hd.mh_status = 0;
                current->msg_link = next;
                current = next;
        }

    /* setup init_msg data structure */

        im = (struct init_msg *)ex_db.ex_imsg;
        clear(im, sizeof(struct init_msg));     /* zap to all zero's */
        im->im_newstyle = 1;                    /* use new-style init msg */
        im->im_mode = mode;                     /* link level */
        im->im_hdfo[0] = im->im_hdfo[1] = 1;/* do auto-byte/word swapping */
        im->im_junk[0] = 1;                 /* defeat rev-d "20 min. stop"*/
        im->im_haddrmode = 3;                   /* absolute address mode */

        /* data order test patterns */
        im->im_byteptn[0] = 1;
        im->im_byteptn[1] = 3;
        im->im_byteptn[2] = 7;
        im->im_byteptn[3] = 0xf;
        im->im_wordptn[0] = 0x103;
        im->im_wordptn[1] = 0x70f;
        im->im_longptn = 0x103070f;

        im->im_101off = im->im_101seg = 0xFFFF;
        im->im_nhosts = 1;
        im->im_result = im->im_nmb = im->im_nproc = im->im_nslots = 0xFF;

        /* prob. here calc seg which is diff from that calc in ex_getbuf() ? */
        im->im_h2exqaddr =
		((long)EXvtop(&wmsgarea->ma_wlink,&wmsgarea->ma_wlink,1)) &
		EXMASKADDR;/*seg base*/
        im->im_h2exoff =
		(short)EXvtop(&wmsgarea->ma_wlink,&wmsgarea->ma_wlink,1);
        im->im_h2extype = 0;            /* no int. when send exos a msg */
        im->im_ex2hqaddr =
		((long)EXvtop(&rmsgarea->ma_rlink,&rmsgarea->ma_rlink,1)) &
		EXMASKADDR;/*seg base*/
        im->im_ex2hoff =
		(short)EXvtop(&rmsgarea->ma_rlink,&rmsgarea->ma_rlink,1);
#ifdef MULTIBUS
	im->im_ex2htype = 3;
#else
        im->im_ex2htype = 4;	/* QBUS/VME/UNIBUS(??) vectored interrupt */
	/* Note : Modify the interrupt vector to reflect the 
	   vector you want on your system.
	*/
        im->im_ex2hu.im_ex2hvctr =  VECTOR;
#endif
    /* give init_msg to exos */

        timeout = 1000000;
	while (1) {
		EXSPL6( s );
		if (XIOSTATUS() & PB_ERROR) {
			EXSPLX(s);
			break;
		}
		EXSPLX(s);
		if ((--timeout == 0) && dotimeout)
			break;
	}
        if (timeout == 0) {
                printf("ex0: board failed diagnostics\n");
                return 1;
        }
    /*
     *  output addr of init msg in "absolute" format:
     *          - 0xffff0000 follwed by: the address backwards, bytewise
     */
        /* get addr into array */
#ifdef DEBUG
printf("exsetup(): conf msg at %X (physical = %X)\n",
        ex_db.ex_imsg, EXvtop(ex_db.ex_imsg,imsgbuf,0));
#endif
        addr = (long)EXvtop(ex_db.ex_imsg,ex_db.ex_imsg,1);
        for (i = 0; i < 4; i++) {
                magic[i+4] = addr;
                addr >>= 8;
        }
#ifdef DEBUG
	printf( "bytes in magic:\n" );
	for ( i = 0; i < 8 ; ++i )
		{
		tmp = magic[i];
		printf ( "%x ", 0xff & tmp );
		}
	printf( "\n" );
#endif
        /* output the bytes */
        for (ap = magic; ap <= &magic[7]; ap++) {
                timeout = 100000;
		while (1) {
			EXSPL6( s );
			if ((XIOSTATUS() & PB_READY) == 0) {
				EXSPLX(s);
				break;
			}
			EXSPLX(s);
			if ((--timeout == 0) && dotimeout)
				break;
		}
                if (timeout == 0) {
                        printf("ex0: board hung while sending init addr\n");
                        return 1;
                }
		EXSPL6( s );
		XIOWVAL((*ap)&0xff);
		EXSPLX(s);
        }

    /* wait for init to complete */

        timeout = 1000000;
        while ((im->im_result&0xff == 0xFF) && --timeout)
                ;
        if ((timeout == 0) && dotimeout) {
                printf("ex0: board hung while waiting for init to complete\n");
                return 1;
        }

    /* check result of init */

        if (im->im_result) {
                printf("ex0: invalid init code: %x\n", im->im_result);
                printf("(im_mode should be 1, is %x\n)", im->im_mode);
                return 1;
        }
#ifdef  DEBUG
        printf("[nx %c.%c, ex %c.%c]\n",
                    im->im_version[1], im->im_version[0],
                    im->im_version[3], im->im_version[2]);
#endif
	EXSPL6( s );
	XIONTRUPT();
	EXSPLX(s);
#ifdef  DEBUG
        printf("ex0: init done\n");
#endif
        ex_inited = 1;          /* tell world that board is inited */
        return 0;
}
#endif /* pcxenix */

/*
 * ex_findmsg:
 *      - first find a context buffer to hold result of message
 *      - find next available message on "host to exos" message queue
 *      - sleep if necessary, to get one
 */
struct msg *
ex_findmsg( socket_idx )
	short	socket_idx;
{
        struct msg *mp;		/* do not use register. */
        register struct context *kp;
        register int s;
		int	err;
#ifdef	DEBUG_KB
	static int kb_max = 0;
	int kb_cnt;
#endif	/* DEBUG_KB */
#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

        EXSPL5( s );
        for (;;) {
                for (kp = context
#ifdef	DEBUG_KB
			, kb_cnt = 1
#endif	/* DEBUG_KB */
			; kp < &context[NET_CONTEXTS]; kp++
#ifdef	DEBUG_KB
			, ++kb_cnt 
#endif	/* DEBUG_KB */
			) {
                        if (kp->kl_state == KL_FREE) {
                                kp->kl_state = KL_BUSY;
                                goto findmsg;
                        }
                }
				printf("findmsg(): couldn't get kl buffer!\n");
                goto nightynight;
findmsg:
#ifdef DEBUG_KB
		if ( kb_cnt > kb_max ) {
			kb_max = kb_cnt;
			printf( "%d context Buffers Searched.\n", kb_max );
		}
#endif /* DEBUG_KB */
		if (err = message_alloc( xso_client_id, socket_idx, &mp ))
		{
            kp->kl_state = KL_FREE;         /* release context buf */
			if (err == 1)
				printf("findmsg(): couldn't get message buffer!\n");
			else if (err == -1)
				printf( "message_alloc() error! client = %d sockidx = %d\n",
					xso_client_id, socket_idx);
			else
				printf( "message_alloc(): Unknown error %d\n", err );
		}
		else
		{
			/* got a bucket; fill it in and return.
			 */
			kp->kl_baddr = (struct buf *)0;
			kp->kl_count = 0;
			kp->kl_prevcnt = 0;
			xputp( mp->msg_context, kp);
			EXSPLX( s );
			return( mp );
		}
nightynight:
        ex_db.ex_state |= ST_WAITING;
        sleep((caddr_t)&ex_db, PRIBIO);
        ex_db.ex_state &= ~ST_WAITING;
	} /* for */
} /* ex_findmsg */

#ifndef scoxenix5
#ifdef pcxenix
extern int ex_intlev;
#endif /* pcxenix */
#endif /* scoxenix5 */
/*
 * ex_send:
 *      - send a network message via the message queue's to the exos
 *      - set up standard header
 *      - bump board to tell it to go
 *      - wait for operation to complete and return the pointer to the
 *        result info (kept in context)
 *      - must not be called at interrupt level
 */
struct context *
ex_send(command, mdev, mp, dontint)
        int command;
        int mdev;
        register struct msg *mp;
        int dontint;
{
        register struct context *kp;
        register int s1, s2;
        label_t lqsav;

#if (pcxenix || rtpc)
	extern unsigned short xm_cp2;
	swtchbank( ex_db.ex_qbank );
#endif

#ifdef DEBUG_QUEUES
printf("ex_send(%x, %x, %x, %x)\n", command, mdev, mp, dontint);
#endif
	kp = (struct context *)xgetp( mp->msg_context);
#ifdef  DEBUG_QUEUES
	printf("ex_send: kp=%x ", kp);
#endif  /* DEBUG_QUEUES */
        if (!ex_inited) {
                u.u_error = ENXIO;
                return;
        }

        EXSPL5( s1 );
#ifdef STRUCTLABELT
        bcopy((caddr_t)&u.u_qsav, (caddr_t)&lqsav, sizeof (label_t));
#else
        bcopy((caddr_t)u.u_qsav, (caddr_t)lqsav, sizeof (label_t));
#endif
	/*
	 * If this proc gets hit by a signal (possibly from arrival of
	 * out-of-band data), free exos resources, THEN do the non-local goto
	 * to exit current system call.  This leaves a message pending
	 * on the board, but since we here clear only KL_BUSY, no one
	 * else will try to use this context buffer until the pending
	 * message comes back from the board and the int. routine clears
	 * KL_WAITING.
	 */
#ifdef BSD4dot2
	if (setjmp(&u.u_qsav))
#else
#ifdef rtpc
	if (setjmp(u.u_qsav))
#else
	if (save(u.u_qsav))
#endif
#endif
	{
		if (ex_db.ex_state & ST_WAITING)
			wakeup((caddr_t)&ex_db);
		kp->kl_state &= ~KL_BUSY;
		if(kp->kl_state & KL_READ) {
			so_state[kp->kl_dev] |= SOS_PENDRD;
		} else if(kp->kl_state & KL_WRITE) {
			so_state[kp->kl_dev] |= SOS_PENDWRT;
		}
		EXSPLX(s1);
		/* Watchout: on some systems p_addr might be, eg, p_uaddr... */
#ifdef DEBUG
/*
* printf("my proc structure (addr = %x, length = %d):\n",
* u.u_procp, sizeof(struct proc));
* exdump(u.u_procp, sizeof(struct proc));
*/
printf("resuming(%x, %x)\n", u.u_procp->p_addr, lqsav);
#endif
#ifdef BSD4dot2
		longjmp(&lqsav);
#else
#ifdef rtpc
		longjmp(lqsav);
#else
#ifdef tower
		longjmp( lqsav, &u.u_procp->p_addr );
#else
#ifdef cadmus
		resume(u.u_procp->p_addr, u.u_procp->p_trnbuf, lqsav);
#else
		resume(u.u_procp->p_addr, lqsav);
#endif
#endif
#endif
#endif
#ifdef DEBUG
		printf("got past resuming (unreachable)!\n");
#endif
	}
        else {
		EXSPL5( s2 );
		xputd( mp->nm_u.msg_msg.nm_userid, (long) (kp));
		xputb( mp->nm_u.msg_msg.nm_request, (char)command);
		kp->kl_dev = mdev;
		kp->kl_state |= KL_WAITING;
		kp->kl_proc = u.u_procp;
		xputb( mp->nm_u.msg_hd.mh_status,
			xgetb(mp->nm_u.msg_hd.mh_status) | MQ_EXOS);
		if (message_send( xso_client_id, mdev, mp ) != 0)
		{
			/* Internal data structure corrupted.
			 */
			printf( "ex_send(): out of sync with clintintf!!\n" );
			u.u_error = ENXIO;
			EXSPLX( s2 );
			EXSPLX( s1 );
			return;
		}
		while (kp->kl_state & KL_WAITING) {
		    if (dontint)
			    sleep((caddr_t)kp, PRIBIO);
			    /* not interruptable */
		    else
			    sleep((caddr_t)kp, PZERO+1);
			    /* interruptable */
		}
		EXSPLX( s2 );
	}
#ifdef STRUCTLABELT
        bcopy((caddr_t)&lqsav, (caddr_t)&u.u_qsav, sizeof (label_t));
#else
        bcopy((caddr_t)lqsav, (caddr_t)u.u_qsav, sizeof (label_t));
#endif
        EXSPLX(s1);

#ifdef  DEBUG_QUEUES
        printf("{ex_send: reply=%x} ", kp->kl_reply);
#endif  /* DEBUG_QUEUES */
#ifdef  DEBUG_NOISE
        if (kp->kl_reply)
        	printf("ex_send: reply=%d ", kp->kl_reply);
#endif  /* DEBUG_NOISE */
 	
	/* Strip off the high order (NM_MAGIC_DATA) bit. */
 	kp->kl_error = kp->kl_reply & ~NM_MAGIC_DATA;
 	if (kp->kl_error >= (MINEXERR - ERR_MAP_OFFSET) &&
 				 kp->kl_error <= (MAXEXERR - ERR_MAP_OFFSET))
 		/* Make sure code is within the range that should be
 		   mapped. We don't want to map errors such as EPIPE.
 		   MINEXERR & MAXEXERR are defined in include/EXOS/ex_errno.h */
 		kp->kl_error += ERR_MAP_OFFSET;
        return kp;
}

ex_klfree(mdev)
int mdev;
{
        register struct context  *kp;

        for (kp = context; kp < &context[NET_CONTEXTS]; kp++) {
                int s;
		EXSPL5( s );

                if ((kp->kl_state & KL_BUSY) && kp->kl_dev == mdev) {
#ifdef  DEBUG
                        if (kp->kl_state&KL_WAITING)
                                printf("ex_klfree: kp=0x%X, count=%d\n",
                                        kp, kp->kl_count);
#endif  /* DEBUG */
                        if (kp->kl_baddr) {
                                EXbrelse(kp->kl_baddr, BSIZE);
                                kp->kl_baddr = (EXbtype *)0;
                        }
                        kp->kl_state = KL_FREE;
                }
                EXSPLX(s);
        }
        if (ex_db.ex_state & ST_WAITING)
                wakeup((caddr_t)&ex_db);
}

#if (pcxenix || rtpc)
ex_killprocs()
{
	int i;
	register struct context *kp;

	/*
	 * Blow away anything waiting on socket.
	 */
	for (i = 0 ; i < MAXDEVS ; ++i) {
		if (so_state[i] != SOS_FREE)
		/* should wake him up, but don't know where he is */
			so_state[i] = SOS_RESET;
	}
	for (kp = context; kp < &context[NET_CONTEXTS]; kp++) {
		if ((kp->kl_state != KL_FREE) && (kp->kl_baddr)) {
			EXbrelse(kp->kl_baddr, BSIZE);
			kp->kl_baddr = (EXbtype *)0;
		}
		if (kp->kl_state & KL_WAITING) {
			wakeup((caddr_t)kp);
			psignal(kp->kl_proc, SIGKILL);
		}
		kp->kl_state = KL_FREE;
	}
}
#endif /* pcxenix */

#ifndef NOSELECT
#ifdef EXOSSELECT
int selwait;
long nselcoll;
extern char procflags[];
extern setrun();

/*
 * Select call.
 */
xselect(nfd, rp, wp, timo, nfdp)
int     nfd;
long    timo;
#ifdef xenix286
fd_set  far *rp;
fd_set  far *wp;
unsigned far *nfdp;
#else
fd_set  *rp;
fd_set  *wp;
unsigned *nfdp;
#endif /* xenix286 */
{
        fd_set rd, wr;
        int nfds = 0;
#ifdef xenix286
		long  tmp_pt;
		faddr_t copy_pt;
#endif /* xenix286 */
        long xselscan();
        long readable = 0, writeable = 0;
        time_t t = SYSTIME;
        int s, tsel;
	long rem;
        long ncoll;
	label_t lqsav;
#ifdef BSD4dot2
	long badopt;			/*avoid bad optimization*/
#else
#define badopt (procflags[procoff] & SSEL)
#endif
        int procoff = u.u_procp - &proc[0];

        if (nfd > NOFILE)
                nfd = NOFILE;
        if (nfd < 0) {
                u.u_error = EBADF;
                return;
        }
#ifdef xenix286
		tmp_pt = (long)rp;
		copy_pt = EXupaddr(tmp_pt);
#ifdef DEBUG_IBMCOMPILER
		printf("xselect:  rp = %lx  EXupaddr(rp) = %lx\n", tmp_pt, 
			(long)copy_pt);
#endif /* DEBUG_IBMCOMPILER */
        if (rp && copyin(copy_pt,(caddr_t)&rd,sizeof(fd_set)))
#else
        if (rp && copyin(EXupaddr((long)rp), (caddr_t)&rd,sizeof(fd_set)))
#endif /* xenix286 */
                return;

#ifdef xenix286
		tmp_pt = (long)wp;
		copy_pt = EXupaddr(tmp_pt);
#ifdef DEBUG_IBMCOMPILER
		printf("xselect:  wp = %lx  EXupaddr(wp) = %lx\n", tmp_pt, 
			(long)copy_pt);
#endif /* DEBUG_IBMCOMPILER */
        if (wp && copyin(copy_pt,(caddr_t)&wr,sizeof(fd_set)))
#else
        if (wp && copyin(EXupaddr((long)wp), (caddr_t)&wr,sizeof(fd_set)))
#endif /* xenix286 */
                return;

retry:
        ncoll = nselcoll;
        procflags[procoff] |= SSEL;
        if (rp)
                readable = xselscan(nfd, rd, &nfds, FREAD);
        if (wp)
                writeable = xselscan(nfd, wr, &nfds, FWRITE);
        if (u.u_error)
                goto done;
        if (readable || writeable)
                goto done;
        rem = (timo+999)/1000 - (SYSTIME - t);
        if (timo == 0 || rem <= 0)
                goto done;
        EXSPL6( s );
#ifdef BSD4dot2
	badopt = procflags[procoff] & SSEL;
#endif
        if (badopt == 0 || nselcoll != ncoll) {
                procflags[procoff] &= ~SSEL;
                EXSPLX(s);
                goto retry;
        }
        procflags[procoff] &= ~SSEL;
	if (rem) {
#ifdef STRUCTLABELT
		bcopy((caddr_t)&u.u_qsav, (caddr_t)&lqsav, sizeof (label_t));
#else
		bcopy((caddr_t)u.u_qsav, (caddr_t)lqsav, sizeof (label_t));
#endif
#ifdef BSD4dot2
		if (setjmp(&u.u_qsav)) {
#else
		if (save(u.u_qsav)) {
#endif
			rm_callout(setrun, (caddr_t)u.u_procp);
			u.u_error = EINTR;
			EXSPLX(s);
			goto done;
		}
		rem = rem*EXHZ;
		/* for 16-bit machines, retry after 64k ticks */
		if (rem >= (long)65535)
			rem = (long)0x7fff; /* must be possitive 2's comp */
		timeout(setrun, (caddr_t)u.u_procp, loint(rem));
	}
	sleep((caddr_t)&selwait, PZERO+1);
	if (rem) {
#ifdef STRUCTLABELT
		bcopy((caddr_t)&lqsav, (caddr_t)&u.u_qsav, sizeof (label_t));
#else
		bcopy((caddr_t)lqsav, (caddr_t)u.u_qsav, sizeof (label_t));
#endif
		rm_callout(setrun, (caddr_t)u.u_procp);
	}
	EXSPLX(s);
	goto retry;
done:
	rd.fds_bits[0] = readable;
	wr.fds_bits[0] = writeable;
#ifdef xenix286
	tmp_pt = (long)nfdp;
	copy_pt = EXupaddr(tmp_pt);
    copyout((caddr_t)&nfds, copy_pt, sizeof(nfds));

    if (rp)
	{
		tmp_pt = (long)rp;
		copy_pt = EXupaddr(tmp_pt);
    	copyout((caddr_t)&rd, copy_pt, sizeof(fd_set));
	}

    if (wp)
	{
		tmp_pt = (long)wp;
		copy_pt = EXupaddr(tmp_pt);
    	copyout((caddr_t)&wr, copy_pt, sizeof(fd_set));
	}
#else
        copyout((caddr_t)&nfds, EXupaddr(nfdp), sizeof(nfds));
        if (rp)
                copyout((caddr_t)&rd, EXupaddr(rp), sizeof(fd_set));
        if (wp)
                copyout((caddr_t)&wr, EXupaddr(wp), sizeof(fd_set));
#endif
}

long
xselscan(nfd, fds, nfdp, flag)
        int nfd;
        fd_set fds;
        int *nfdp, flag;
{
        struct file *fp;
        struct inode *ip;
        long bits,res = 0;
        int i, able;
                
        bits = fds.fds_bits[0];
        while (i = xffs(bits)) {
                able = 0;
                if (i >= nfd)
                        break;
                bits &= ~(1L<<(i-1));
                fp = u.u_ofile[i-1];
                if (fp == NULL) {
                        u.u_error = EBADF;
                        return (0);
                }
                ip = (struct inode *)(fp->f_inode);
                switch (ip->i_mode & IFMT) {

                case IFCHR:
                        /*
                         * for now the only char devices we need
                         * to select on are the control side of
                         * ptys -- for the rlogin deamon, and sockets.
                         */
                        {
                            extern int sok_dev;
                            int dev = ((int)(ip->I_RDEV));
#ifdef	DEBUGASYNC
			    printf("xselscan: dev=0x%x sok=0x%x\n",dev,sok_dev);
#endif	/* DEBUGASYNC */
			    if (major(dev) == sok_dev)
                                able = xsoselect(minor(dev), flag);
                            else
                                able = 0;
                        }
			break;
#ifdef BSD4dot2
		case IFSOCK:
#endif
#if !( BSD4dot2 || V7 )
		case IFIFO:
#endif
#ifdef Siemens3
		case IFNAM:
#endif
                case IFBLK:
                case IFREG:
                case IFDIR:
                        able = 1;
                        break;
                }
                if (able) {
                        res |= (1L<<(i-1));
                        (*nfdp)++;
                }
        }
        return (res);
}

#ifdef	EXOSASYNCIO
/*
 * If signum is a valid signal number,
 * turn on the asynchronous mode for
 * sockets specified in the bitmask.
 * If signum == -1,
 * turn off the asynchronous mode for
 * sockets specified in the bitmask.
 */
xasyncio(nfd, bitmask, signum)
	register int	nfd;
	long	bitmask;
	long	signum;
{
        register int i;
	register int s;
	register long b;
                
#ifdef	DEBUGASYNC
	EXSPL6(s);
	printf("asyncio(%d): bitmask=0x%X, signum=%ld\n",
		u.u_procp->p_pid, bitmask, signum);
	spl0();
#endif	/* DEBUGASYNC */
	/*
	 * Verify we have a valid bit mask
	 */
	for (b = bitmask; (i = xffs(b)) && i <= nfd; b &= ~(1L << (i-1))) {
		extern int sok_dev;
		register struct file *fp;
		register struct inode *ip;
		register int dev;

                fp = u.u_ofile[i-1];
                if (fp == NULL)
			return u.u_error = EBADF;
                ip = (struct inode *)(fp->f_inode);
                if ((ip->i_mode & IFMT) != IFCHR) 
			return u.u_error = EBADF;
		dev = (int)ip->I_RDEV;
		if (major(dev) != sok_dev) {
#ifdef	DEBUGASYNC
			printf("asyncio: bad major dev=%d\n", major(dev));
#endif	/* DEBUGASYNC */
			return u.u_error = EBADF;
		}
	}

	/*
	 * The parameters are all valid;
	 * make the necessary changes
	 */
	for (b = bitmask; (i = xffs(b)) && i <= nfd; b &= ~(1L << (i-1))) {
		register struct file * fp = u.u_ofile[i-1];
		register struct inode * ip = (struct inode *)(fp->f_inode);
		register int mdev = minor((int)ip->I_RDEV);

		EXSPL6(s);
		if (signum >= 0)  {
#ifdef	DEBUGASYNC
		printf("asyncio(%d): mdev=%d, signum(>=0)=%ld\n",
		u.u_procp->p_pid, mdev, signum);
#endif	/* DEBUGASYNC */
			so_async[mdev] |= SOA_ON;
			so_signum[mdev] = signum;
		} else {
#ifdef	DEBUGASYNC
		printf("asyncio(%d): mdev=%d, signum(<0)=%ld\n",
		u.u_procp->p_pid, mdev, signum);
#endif	/* DEBUGASYNC */
			so_async[mdev] = 0;	/* !! DANGER !! &= ~SOA_ON; */
			so_signum[mdev] = -1;
		}
		spl0();
	}
	return 0;
}
#endif	/* EXOSASYNCIO */

xffs(mask)
        long mask;
{
        register int i;
        register imask;

        if (mask == 0) return (0);
        imask = loint(mask);
        for(i=1; i<=16; i++) {
                if (imask & 1)
                        return (i);
                imask >>= 1;
        }
        imask = hiint(mask);
        for(; i<=32; i++) {
                if (imask & 1)
                        return (i);
                imask >>= 1;
        }
        return (0);     /* can't get here anyway! */
}

xselwakeup(p, coll)
        register struct proc *p;
        int coll;
{
        int s;
#ifdef BSD4dot2
	long badopt;			/*avoid bad optimization*/
#else
#define badopt (procflags[procoff] & SSEL)
#endif

        if (coll) {
                nselcoll++;
                wakeup((caddr_t)&selwait);
        }
        EXSPL6( s );
        if (p) {
                if (p->p_wchan == (caddr_t)&selwait)
                        setrun(p);
                else {
                        int procoff = p - &proc[0];
#ifdef BSD4dot2
			badopt = procflags[procoff] & SSEL;
#endif
                        if ( badopt )
                                procflags[procoff] &= ~SSEL;
                }
        }
        EXSPLX(s);
}

hiint(l)
long l;
{
        union UN_long {
                long    UN_l;
                struct {
                        short Hw;
                        short Lw;
                } UN_wds;
        } ul; 

        ul.UN_l = l;
        return ul.UN_wds.Hw;
}

#endif /* NOSELECT */
#endif /* EXOSSELECT */

/* findproc -- find proc with pid */
struct proc *
findproc(pid)
register pid;
{
	register struct proc *p;

#ifdef zilog
	for (p = &proc[0]; p < &proc[NPROC]; p++) 
#else
#ifdef V7
	for (p = &proc[0]; p < &proc[NPROC]; p++) 
#else
#ifdef BSD4dot2
	for (p = &proc[0]; p < procNPROC ; p++) 
#else
	for (p = &proc[0]; p < &proc[v.v_proc]; p++) 
#endif
#endif
#endif
		if (p->p_pid == pid)
			return p;
	return NULL;
}

#ifdef EXOSSELECT
/*
 * remove entry in callout vector
 * which is scanned by clock interrupt
 */
rm_callout(func,arg)
int (*func)();
caddr_t arg;
{
#ifdef BSD4dot1
	register struct callout *p1, *p2;
	register int s;

	EXSPL7( s );
	for (p1 = &calltodo; (p2 = p1->c_next) != 0; p1 = p2) {
		if (p2->c_func == fun && p2->c_arg == arg) {
			if (p2->c_next && p2->c_time > 0)
				p2->c_next->c_time += p2->c_time;
			p1->c_next = p2->c_next;
			p2->c_next = callfree;
			callfree = p2;
			break;
		}
	}
	EXSPLX(s);
#else
	register struct callo *p1, *p2;
	register int tt;
	int pri;

	p1 = &callout[0];
	EXSPL7( pri );
	while(p1->c_func != 0) {
		if ((p1->c_func == func) && (p1->c_arg == arg))
			break;
		p1++;
	}
	if (p1 >= EXNCALLP ) {
		printf("Timeout entry not found, not deleted\n");
		return;
	}
	/* copy everything that follows in the list up one
	   position, adding our unused time to theirs */
	tt = p1->c_time;
	p2 = p1;
	while(p1->c_func != 0) {
		p2++;
		p1->c_time = p2->c_time + tt;
		p1->c_func = p2->c_func;
		p1->c_arg = p2->c_arg;
		tt = 0;		/* only add time to first */
		p1 = p2;
	}
	EXSPLX(pri);
#endif /* BSD4dot1 */
}
#endif /* EXOSSELECT */

#ifndef scoxenix5
#ifdef pcxenix
xsleep( channel, priority )
/*
 * This is necessary because MicroSoft or IBM screwed up their
 * interupt handling.
*/
char *channel;
int priority;
{
	register struct proc *procp;
	int s1, s2;

	EXSPL6( s1 );	/* we can not be rescheduled just now */
	procp = u.u_procp;
	procp->p_stat = 1; /* sleeping */
	procp->p_wchan = channel;
	procp->p_flag = priority;
	if( procp->p_pri > 6 ) {
		procp->p_pri = 6;
	}
	if( priority <= 25 ) {
		/*
		non-interuptable case
		*/
		EXSPL0( s2 );	/* sleep+116 */
		swtch();
		EXSPLX( s1 );
		return;
	}
	if( issig() ) {
		procp->p_wchan = 0;
		procp->p_stat = 3;
		EXSPL0( s2 );
		longjmp( (caddr_t)u.u_qsav ); /* sleep+134 */
		return;
	}
	EXSPL0( s2 );
	if( runin ) {
		runin = 0;
		wakeup( &runin );
	}
	swtch();
	if( issig() ) {
		longjmp( (caddr_t)u.u_qsav ); /* sleep+134 */
		return;
	}
	/* sleep+126 */
	EXSPLX( s1 );
	return;
}
#endif /* pcxenix */
#endif /* scoxenix5 */

