/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_client.c,v 1.3 87/04/24 14:12:42 davidb Exp $ */
#define CLIENT_MODULE


#define PULLIN
#include "config.h"
#include <sys/stdxln.h>
#include <sys/client.h>

IMPORT struct wmsg_area	*wmsgarea;
IMPORT struct exctrl	ex_db;
IMPORT int	ex_inited;
IMPORT int	xmrw_gen();

struct socket_info skt_info[ MAXDEVS ];
struct client_info client_info[ ] = 
{
	0, 0, 0, 0, 0, CLIENT_FREE,		/* 1st client */
	0, 0, 0, 0, 0, CLIENT_FREE		/* NCLIENTS client */
};

/* Index into socket_into[]/client_info[] to start search for next 
 * socket/client waiting for buckets.
 */
PRIVATE int		nxtsock_idx   = 0;
PRIVATE int		nxtclient_idx = 0;

/* Wait count for socket/client waiting for free buckets. 
 */
PRIVATE short	wcnt_socket = 0;
PRIVATE short	wcnt_client = 0;


/* ---------------- PRIVATE MACROS ---------------- */

#define post_sock_pending( pending, socketid ) { \
	short	already_pending; \
	already_pending = skt_info[ socketid ].flags & SOCK_WAITING; \
	if (pending) \
		skt_info[ socketid ].flags |= SOCK_WAITING; \
	else \
		skt_info[ socketid ].flags &= ~SOCK_WAITING; \
	if (pending && !already_pending) \
		wcnt_socket++; \
	else if (!pending && already_pending) \
		wcnt_socket--; \
}


#define post_client_pending( pending, clientid ) { \
	short	already_pending; \
	already_pending = client_info[ clientid ].flags & CLIENT_WAITING; \
	if (pending) \
		client_info[ clientid ].flags |= CLIENT_WAITING; \
	else \
		client_info[ clientid ].flags &= ~CLIENT_WAITING; \
	if (pending && !already_pending) \
		wcnt_client++; \
	else if (!pending && already_pending) \
		wcnt_client--; \
}



PRIVATE int
notify_socket() 
{
	short	client_id;
	REG int	idx;

	/* Some socket is waiting for bucket. */
	/* BE CAREFUL OF CRITICAL AREA ????? */
	/* Note that this routine is called at interrupt time. */
#ifdef XENIXNET_DBG
	printf ("ATTN: notify_socket() entered.\n" );
#endif
	for (idx = nxtsock_idx; idx < MAXDEVS; idx++) 
	{
		if ((skt_info[ idx ].flags & SOCK_WAITING) != 0) 
		{
			client_id = skt_info[ idx ].client_id;
			(*(client_info[ client_id ].notify_addr))( idx );
			nxtsock_idx = (idx < (MAXDEVS-1)? ++idx : 0);
			return( 0 );
		}
	}
	nxtsock_idx = 0;
	return( -1 );
} /* notify_socket() */




PRIVATE int
notify_client() 
{
	int		idx;
	/* Notify clients of bucket availability.
	 * Note that the notification is not associated with any
	 * particular socket.
	 */
#ifdef XENIXNET_DBG
	printf( "ATTN: notify_client() entered.\n" );
#endif
	for (idx = nxtclient_idx; idx < NCLIENTS; idx++)
	{
		if ((client_info[ idx ].flags & SOCK_WAITING) != 0)
		{
			client_info[ idx ].flags &= ~SOCK_WAITING;
			(*(client_info[ idx ].notify_addr))( -1 );
			nxtclient_idx = (idx < (NCLIENTS-1)? ++idx : 0);
			return( 0 );
		}
	}
	nxtclient_idx = 0;
	return( -1 );
} /* notify_client() */




EXPORT int
client_register( low_addr, high_addr, intr_addr, notify_addr, 
		reset_addr, client_id )
	EXaddr_t	low_addr;
	EXaddr_t	high_addr;
	VOID		(*intr_addr)();
	VOID		(*notify_addr)();
	VOID		(*reset_addr)();
	short		*client_id;
{
	short	i;
	REG struct client_info	*cp = (struct client_info *)0;

	for (i = 0; i < NCLIENTS; i++)
		if (client_info[ i ].flags == CLIENT_FREE)
		{
			cp = &client_info[ i ];
			break;
		}
	if (cp == (struct client_info *)0)
	{
		printf( "RED ALERT: client_info table full!\n" );
		return( -1 );
	}
	cp->low_addr = low_addr;
	cp->high_addr = high_addr;
	cp->intr_addr = intr_addr;
	cp->notify_addr = notify_addr;
	cp->reset_addr = reset_addr;
	cp->flags = CLIENT_REGISTERED;
	*client_id = i;
	return( 0 );
} /* client_register() */



EXPORT int
socket_alloc( client_id, socket_id )
	short	client_id;
	short	*socket_id;
{
	short	i;

#ifdef XENIXNET_DBG
	if (client_id < 0 || client_id >= NCLIENTS)
	{
		printf( "socket_alloc: invalid client_id %d.\n", client_id );
		return( -1 );
	}
	if ((client_info[ client_id ].flags & CLIENT_REGISTERED) == 0)
	{
		printf( "socket_alloc: client %d not registered.\n", client_id );
		return( -1 );		/* client not registered */
	}
#endif /* XENIXNET_DBG */
	for (i = 0; i < MAXDEVS; i++)
	{
		if (skt_info[ i ].flags == SOCK_FREE)
		{
			skt_info[ i ].flags = SOCK_IN_USE;
			skt_info[ i ].client_id = client_id;
			*socket_id = i;
			return( 0 );
		}
	}
	return( -1 );
} /* socket_alloc() */



EXPORT int
socket_set( client_id, socket_id, soid )
	short	client_id;
	short	socket_id;
	short	soid;
{
#ifdef XENIXNET_DBG
	if (client_id < 0 || client_id >= NCLIENTS)
	{
		printf( "socket_set: invalid client_id %d.\n", client_id );
		return( -1 );
	}
	if (client_info[ client_id ].flags == CLIENT_FREE)
	{
		printf( "socket_set: client %d not registered.\n", client_id );
		return( -1 );		/* client not registered */
	}
	if (socket_id < 0 || socket_id >= MAXDEVS)
	{
		printf( "socket_set: invalid socket_id %d.\n", socket_id );
		return( -1 );
	}
#endif /* XENIXNET_DBG */
	if (skt_info[ socket_id ].client_id != client_id)
	{
		printf( "socket_set: socket %d not owned by client %d.\n",
				socket_id, client_id);
		return( -1 );
	}
	skt_info[ socket_id ].soid = soid;
	skt_info[ socket_id ].flags |= SOCK_SET;
	return( 0 );
} /* socket_set() */



EXPORT int
socket_deallocate( client_id, socket_id )
	short	client_id;
	short	socket_id;
{
#ifdef XENIXNET_DBG
	if (client_id < 0 || client_id >= NCLIENTS)
	{
		printf( "socket_deallocate: invalid client_id %d.\n", client_id );
		return( -1 );
	}
	if (client_info[ client_id ].flags == CLIENT_FREE)
	{
		printf( "socket_deallocate: client %d not registered.\n", client_id );
		return( -1 );		/* client not registered */
	}
	if (socket_id < 0 || socket_id >= MAXDEVS)
	{
		printf( "socket_deallocate: invalid socket_id %d.\n", socket_id );
		return( -1 );
	}
#endif /* XENIXNET_DBG */
	if (skt_info[ socket_id ].client_id != client_id)
	{
		printf( "socket_deallocate: socket %d not owned by client %d.\n",
				socket_id, client_id);
		return( -1 );
	}
	skt_info[ socket_id ].flags = SOCK_FREE;	/* deallocate it */
	return( 0 );
} /* socket_deallocate() */



EXPORT VOID
board_reset() 
{ 
	short	i; 
	/* Reset the client interface module.  
	 * This routine will be called at board downloading time.  
	 */ 
	for (i = 0; i < NCLIENTS; i++) 
	{
		/* Notify all clients by calling the supplied reset_addr,
		 * if there is one.
		 */
		if (client_info[ i ].reset_addr == 0)
			continue;
		(*(client_info[ i ].reset_addr))();
	}
	for (i = 0; i < MAXDEVS; i++)
		if (skt_info[ i ].flags != SOCK_FREE)
			/* If entry not FREE, just mark it as RESET so that 
			 * it is still owned by the client and cannot be reused 
			 * until it is deallocated.
			 */
			skt_info[ i ].flags = SOCK_RESET;
} /* board_reset() */


EXPORT int
message_alloc( client_id, socket_id, message_ptr )
	short	client_id;
	short	socket_id;
	struct msg	**message_ptr;
{
#define PENDING		1
#define NOTPENDING	0
	/*
	 * This routine basically attempts to allocate a bucket to be sent
	 * to the board. 
	 * Normally, the allocation is requested by a socket. If the request
	 * is not associated with a socket, "socket_id" should be -1.
	 * The return codes are explained below:
	 *		 0  ==> not pending; bucket successfully allocated.
	 *		-1  ==> allocation failed due to some internal error;
	 *		 1  ==> bucket allocation pending; all bucket used.
	 * If allocation pending, skt_info/client_info flags field will
	 * be set to indicate the case; otherwise, the flags will be reset.
	 * Note that if board has not been initialized, -1 will be returned.
	 */
	REG int	s;
	REG struct msg	*mp;
	int	pending_flag = NOTPENDING;

	EXSPL5( s );
	mp = wmsgarea->ma_lastw;

	/* Try to get a bucket from the write queue.
	 */
	if ((xgetb( mp->nm_u.msg_hd.mh_status) & (MQ_EXOS | MQ_DONE)) == 0) 
	{
		/* Got it.
		 */
		xcl( &mp->nm_u.msg_msg.nm_soid,
			sizeof(union exos_u) - sizeof( struct headers));
		xputb( mp->nm_u.msg_hd.mh_status, MQ_DONE);
		xputb( mp->nm_u.msg_hd.mh_reserved, 0);
		xputw( mp->nm_u.msg_hd.mh_length,
			sizeof(union exos_u) - sizeof(struct headers));
#if (pcxenix || rtpc)
		wmsgarea->ma_lastw = (struct msg *)
			(xgetw(mp->nm_u.msg_hd.mh_link) & (XM_WSIZE-1));
#else /* pcxenix */
		wmsgarea->ma_lastw = mp->msg_link;
#endif /* pcxenix */
#ifdef  DEBUG_QUEUES
		printf("message_alloc: mp=%x\n", mp);
#endif  /* DEBUG_QUEUES */
		*message_ptr = mp;
	}
	else
		pending_flag = PENDING;		/* indicate bucket pending. */
	/*
	 * If bucket allocation successful, reset the flags in 
	 * skt_info/client_info; otherwise set the flags to
	 * indicate socket/client waiting for bucket.
	 */
	if (socket_id == -1)
	{
		if (client_id < 0 || client_id > (NCLIENTS - 1))
		{
			printf("message_alloc: client_id out of range.\n");
			pending_flag = -1;
		}
		else
		{
			post_client_pending( pending_flag, client_id );
#ifdef XENIXNET_DBG
			if (wcnt_client < 0) 
			{
				printf( " wcnt_client NEGATIVE!\n" );
				wcnt_client = 0;
			}
#endif
		}
	}
	else if (socket_id < 0 || socket_id > MAXDEVS)
	{
		printf("message_alloc: socket_id out of range.\n");
		pending_flag = -1;
	}
	else
	{
		post_sock_pending( pending_flag, socket_id );
#ifdef XENIXNET_DBG
		if (wcnt_socket < 0) 
		{
			printf( " wcnt_socket NEGATIVE!\n" ); \
			wcnt_socket = 0; \
		}
#endif
	}
	EXSPLX( s );
	return( pending_flag );
} /* message_alloc() */



EXPORT int
message_send( client_id, socket_id, message_ptr )
	short	client_id;
	short	socket_id;
	struct msg	*message_ptr;
{
	/*
	 * The main purpose of this routine is to do sanity check
	 * for the message going to the board.
	 * Two things are checked here:
	 *	- socket must not be reset
	 *	- the socket must be owned by the client
	 * This routine assumed "message_ptr" not owned by EXOS and does
	 * no checking.
	 */
	if (socket_id != -1)
	{
		if (skt_info[ socket_id ].client_id != client_id)
		{
			/* Oops! Socket does not belong to client.
			 */
			printf( "message_send: socket %d not owned by client %d\n",
				socket_id, client_id );
			return( -1 );
		}
		else if (skt_info[ socket_id ].flags & SOCK_RESET)
		{
#ifdef XENIXNET_DBG
			printf( "message_send: socket %d has been reset.\n", socket_id);
#endif
			return( -1 );
		}
	}
	xputb( message_ptr->nm_u.msg_hd.mh_status,
		xgetb( message_ptr->nm_u.msg_hd.mh_status ) | MQ_EXOS );
	XIONTRUPT();
	return( 0 );
} /* message_send() */




EXPORT short
userid_to_clientid( userid )
	EXaddr_t	userid;
{
	/* 
	 * Using the input userid to match for address ranges in the
	 * client_info to search for the client.
	 */
	short	i;

	for (i = 0; i < NCLIENTS; i++)
	{
		if (client_info[ i ].flags == CLIENT_FREE)
			continue;
		if (userid >= client_info[ i ].low_addr && 
		    userid <= client_info[ i ].high_addr)
			return( i );
	}
	return( -1 );
} /* userid_to_clientid() */



EXPORT short
soid_to_clientid( soid )
	short	soid;
{
	/* 
	 * Using the input soid to match for address ranges in the
	 * skt_info to search for the client.
	 */
	REG struct socket_info	*ptr;

	for (ptr = &skt_info[ 0 ]; ptr <= &skt_info[ MAXDEVS-1 ]; ptr++)
	{
		if ((ptr->flags & SOCK_SET) == 0)
			continue;
		if (soid == ptr->soid)
			return( ptr->client_id );
	}
	return( -1 );
} /* soid_to_clientid() */




EXPORT int
board_rw( client_id, baddr, dladdr, amount, net_cmd )
	short	client_id;
	EXbatype baddr;
	long dladdr;
	int amount;
	int net_cmd;
{
	/* This routine provides client an interface routine to do
	 * direct board memory access. Unlike the raw access done by
	 * socket client for board downloading, this routine will not
	 * grant access right if the protocol module has not been 
	 * downloaded and running.
	 */
#ifdef XENIXNET_DBG
	if (client_id < 0 || client_id >= NCLIENTS)
	{
		printf( "board_rw: invalid client_id %d.\n", client_id );
		return( -1 );
	}
	if ((client_info[ client_id ].flags & CLIENT_REGISTERED) == 0)
	{
		printf( "board_rw: client %d not registered.\n", client_id );
		return( -1 );		/* client not registered */
	}
#endif /* XENIXNET_DBG */
	if (!ex_inited)
		return( u.u_error = ENXIO );
	return( xmrw_gen( baddr, dladdr, amount, net_cmd ) );
} /* board_rw() */




EXPORT VOID
wakeup_bucket_requestor()
{
	/* This routine wakes up a client waiting for bucket
	 * resource.
	 * Both the socket and non-socket clients can be waiting for
	 * free buckets. The present scheme favors the socket clients
	 * by first going thru the "skt_info[]" list to pick up a client
	 * with waiting flag on. When the end of the list is reached
	 * with no waiting client found, the "client_info[]" list is then
	 * search. Each list maintains its own index ("nxtsock_idx" and
	 * "nxtclient_idx" respectively) as to where the search was last 
	 * stopped at and hence where the next search should begin.
	 * "Wcnt_socket" and "wcnt_client" keep  wait counts on each
	 * list so that when they are zeroes, no search of the lists
	 * is ncecessary.
	 * Note that this routine is called at interrupt time.
	 */
	if (wcnt_socket)
	{
		/* Some socket is waiting for bucket; search from
		 * present index to end of socket client list.
		 */
		if (notify_socket() == -1)
			/* End of list reached, no waiting socket
			 * client found.
			 */
			if (wcnt_client)
				notify_client();
			else if (wcnt_socket)
				/* If no non-socket client waiting,
				 * search from beging of socket client
				 * again.
				 */
				notify_socket();
	}
	else if (wcnt_client)
		notify_client();
} /* wakeup_bucket_requestor() */



#ifdef XENIXNET_DBG
#include "debug.h"


EXPORT int
exportdata( addr )
	EXioctltype addr;
{
	struct XPioctl param;
	short	idx, cmd;
	struct so_info	soinfo;

	if (copyin( addr, (caddr_t)&param, sizeof(param))) 
		return( u.u_error = EFAULT);

	idx = param.req_idx;
	cmd = param.req_cmd;
	switch (cmd)
	{
		default:
			printf( " exportdata: Unrecognized command\n");
			break;
		case RQ_SOCKETINFO:
			if (idx < 0 || idx >= MAXDEVS)
			{
				printf( "exportdata: sockinfo index limit\n" );
				return( u.u_error = EFAULT );
			}

 			if (copyout((caddr_t)&skt_info[ idx ], addr, 
				sizeof(struct socket_info)))
 				u.u_error = EFAULT;
			break;
		case RQ_CLIENTINFO:
			if (idx < 0 || idx >= NCLIENTS)
			{
				printf( "exportdata: clientidx limit\n" );
				return( u.u_error = EFAULT );
			}

 			if (copyout((caddr_t)&client_info[ idx ], addr, 
				sizeof(struct client_info)))
 				u.u_error = EFAULT;
			break;
		case RQ_NXTSOCKIDX:
 			if (copyout((caddr_t)&nxtsock_idx, addr, sizeof(nxtsock_idx)))
 				u.u_error = EFAULT;
			break;
		case RQ_NXTCLIENTIDX:
 			if (copyout((caddr_t)&nxtclient_idx, addr, sizeof(nxtclient_idx)))
 				u.u_error = EFAULT;
			break;
		case RQ_WCNTSOCKET:
 			if (copyout((caddr_t)&wcnt_socket, addr, sizeof(wcnt_socket)))
 				u.u_error = EFAULT;
			break;
		case RQ_WCNTCLIENT:
 			if (copyout((caddr_t)&wcnt_client, addr, sizeof(wcnt_client)))
 				u.u_error = EFAULT;
			break;
		case RQ_SOINFO:
			if (idx < 0 || idx >= MAXDEVS)
			{
				printf( "exportdata: so_info idx limit\n");
				return( u.u_error = EFAULT );
			}
			soinfo.soid = so_id[ idx ];
			soinfo.sostate = so_state[ idx ];
			if (copyout((caddr_t)&soinfo, addr, sizeof(struct so_info)))
				u.u_error = EFAULT;
			break;
	}
} /* exportdata */
#endif /* XENIXNET_DBG */
