/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ex_admin.c,v 1.3 87/05/14 17:49:02 davidb Exp $ */

/*
 * Administration routines for exos ethernet controller running a port
 * of the berkeley tcp/ip code.
 *
 * Written by: Kipp Hickman
 */

/*
   revision history:
   rev	by	description
   ---  ------- -----------
   1.7	pbf	Make exopen check ex_inited & return ENXIO if not set.
		Make EXIOCFIND ioctl set so_id to p_pid when setting so_state
		to SOS_RESERVED. Make exclose check so_id when reclaiming
		sockets.
   9/9/84 wrn	New vax-compatable exos.h rearranges "struct msg".
 */

#define EXOSSELECT
#define EXOSASYNCIO

#define PULLIN
#include "config.h"
#include <sys/stdxln.h>
#include <sys/client.h>

IMPORT short	xso_client_id;
#ifdef XENIXNET_DBG
#include "debug.h"
#endif


extern struct msg *ex_findmsg();
extern int ex_dopoll;
extern int ex_intlev;

struct	rmsg_area *rmsgarea;		/* read queues */
struct	wmsg_area *wmsgarea;		/* write queues */
struct	exctrl ex_db;			/* software device structure */

/* exos error logger variables */
static	short ad_logon;			/* error logger on? */
static	struct buf *ad_logbufp;		/* pointer to log buffer */
static	EXlatype ad_wp;		/* circular queue pointer for writing */
static	EXlatype ad_rp;		/* circular queue pointer for reading */
static	EXlatype ad_endp;			/* pointer to end of data buf */
static	short ad_logcount;			/* count of bytes in log buf */
static char sccsId[] = "@(#)ex_admin.c	1.1 8/16/85";

/*ARGSUSED*/
exopen(dev, flag)
	dev_t dev;
	int flag;
{
	register int mdev = minor(dev);
	EXbatype baddr;

	if (!ex_inited) {
		u.u_error = ENXIO;
		return;
	}

	switch (mdev) {
	  case ADMIN_LOGGER:
		if (ad_logon) {
			u.u_error = EBUSY;
			return(u.u_error);
		}
		ad_logcount = 0;
		EXgetlblk( baddr, ad_logbufp, BSIZE );
		ad_wp = ad_rp = (EXlatype)baddr;
		ad_endp = ad_rp + EXBSIZE;
		ad_logon = 1;
	  case ADMIN_FIND:
	  default:
		break;
	}
return(u.u_error);
}

/*ARGSUSED*/
exclose(dev, flag)
	dev_t dev;
	int flag;
{
	register int mdev = minor(dev);
	register short i;

	switch (mdev) {
	  case ADMIN_LOGGER:
		ad_logon = 0;
		brelse(ad_logbufp);
		break;
	  default:
		for (i = 0; i < MAXDEVS; i++) {
			if (so_state[i] == SOS_RESERVED && so_id[i] == u.u_procp->p_pid)
			{
				so_state[i] = SOS_FREE;
				socket_deallocate( xso_client_id, i );
			}
		}
		break;
	}
	return(u.u_error);
} /* exclose */

/*
 * exread:
 *	- read something from the admin device
 */
/*ARGSUSED*/
#ifdef BSD4dot2
exread(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
exread(dev)
	dev_t dev;
#endif
{
	register int mdev = minor(dev);
	register int count;
	register int s;

	switch (mdev) {
	  case ADMIN_LOGGER:
		while (ad_logcount == 0) {
			ad_logbufp->b_flags |= B_WANTED;
			sleep((caddr_t)ad_logbufp, PZERO+1);
		}

		EXSPL7( s );
		if (ad_wp > ad_rp)
#ifdef BSD4dot2
			uiomove(ad_rp, count = (ad_wp - ad_rp), UIO_READ, uio);
#else
			iomove(EXioaddr(ad_rp, ad_logbufp),
				count = (ad_wp - ad_rp), B_READ);
#endif
		else
#ifdef BSD4dot2
			uiomove(ad_rp, count = ad_endp - ad_rp, UIO_READ, uio);
#else
			iomove(EXioaddr(ad_rp, ad_logbufp),
				count = ad_endp - ad_rp, B_READ);
#endif
		EXmapout( ad_logbufp );
		ad_logcount -= count;
		if ((ad_rp += count) >= ad_endp)
			ad_rp = EXlogaddr(ad_logbufp);
		splx(s);
		break;
	  default:
		u.u_error = EIO;
		break;
	}
return(u.u_error);
}

/*ARGSUSED*/
#ifdef BSD4dot2
exwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
#else
exwrite(dev)
	dev_t dev;
#endif
{
	u.u_error = EIO;
	return(u.u_error);
}

#ifdef tower
int boot_time = 1;		/* tower calls all interupt handlers at bt. */
#endif

/*
 * exintr:
 *	- process exos interrupts
 */
exintr()
{
	register struct msg *read_mp;
	register struct msg *write_mp;
	register struct context *kp;
	long	user_id;
	short	client_id;
	short	soid;
#if (pcxenix || rtpc)
	unsigned short savebank;
	register int first = 1;
	extern unsigned short xm_cp2;
#endif /* pcxenix */

	if( !ex_dopoll )
		XIOCLRINT();
	if (! ex_inited) return (0);
again:

#if (pcxenix || rtpc)
#ifdef pcxenix
#ifndef scoxenix5
	if( ex_intlev == 2 ) {
		int psave;
		psave = spl7();
		outb( 0xa0, 0xb );
		if( inb( 0xa0 ) & 0x40 )
			outb( 0xa0, 0x61 );
		splx( psave );
	}
#endif
#endif
	if( first ) {
		savebank = ( xm_cp2 & CP2_205BANK ) >> 6;
		if ( xm_cp2 & CP2_ENA17 )
			savebank |= 8;
		if( ex_inited )
			exrequest();
		swtchbank(ex_db.ex_qbank);
		first = 0;
	}
#else /* pcxenix */
#ifdef tower
	if( boot_time ) {
		/*
		Tell tower system that we are here.
		*/
		boot_time = 0;
		if( ex_dopoll )
			timeout( exintr, 0, 1 );
		return ( 1 );
	}
#endif
#ifdef MULTIBUS
	if (XIOSTATUS() & 2) {	/* did the EXOS interrupt? */
		XIOCLRINT();	/* then clear the interrupt */
	} else {
		if( ex_dopoll )
			timeout( exintr, 0, 1 );
		return(0);	/* not our interupt */
	}
#endif
#ifdef	DEBUG_NOISE
printf("[ex: ");
#endif
	/*
	 * Check the status byte from board for error conditions
	 * such as bus timeout and parity error detection.
 	 * Bit zero in the status port (Port B) will be zero if a fatal
 	 * error has occurred. dab 870211.
	 */
 	if ((XIOSTATUS() & PB_ERROR) != PB_ERROR) {

		/* fault has been detected on the board */

 		printf("EXOS: board may need to be reinitialized!!!\n");
	}
#endif /* pcxenix || rtpc */
	read_mp = rmsgarea->ma_lastr;
#ifdef	DEBUG_QUEUES
	printf( "read_mp = %x, status =%x\n", (int)read_mp,
		xgetb(read_mp->nm_u.msg_hd.mh_status) & 0xff );
#endif	/* DEBUG_QUEUES */
	while ((xgetb(read_mp->nm_u.msg_hd.mh_status) & MQ_EXOS) == 0) 
	{
		/*
		 * Loop thru the bucket read_queue to find messages EXOS
		 * sent to the host.
		 */
#ifdef	DEBUG_QUEUES
printf( "read_mp = %x, status = %x, request =%d, soid = %d, userid = %lx\n",
	(int)read_mp,
	xgetb(read_mp->nm_u.msg_hd.mh_status) & 0xff,
	xgetb( read_mp->nm_u.msg_msg.nm_request ) & 0xff,
	xgetw( read_mp->nm_u.msg_msg.nm_soid ),
	xgetd( read_mp->nm_u.msg_msg.nm_userid ) );
#endif	/* DEBUG_QUEUES */

		/* 
		 * -------- NON-CLIENT MESSAGES --------
		 * Fist handles non-client oriented messages from the board.
		 * These includes spontaneous messages from the board and those
		 * from telnet/rlogin servers.
		 */
		switch( xgetb( read_mp->nm_u.msg_msg.nm_request ) &0xff )
		{
			default:
				goto clientmsg;
			case NET_PANIC:
			case NET_PRINTF:
			case IM_ALIVE:
				exlog_intr( read_mp );
				break;
#ifdef XTY
			case map_ioctl_cmd( TSCOMMAND ):
				xttyintr( read_mp );
				break;
#endif
		} /* switch */
		goto nextmsg;
clientmsg:
		/*
		 * --------- CLIENT MESSAGES ---------
		 * Now handle client messages and dispatch the message to
		 * the appropriate client.
		 */
		user_id = xgetd( read_mp->nm_u.msg_msg.nm_userid );
		if ((client_id = userid_to_clientid( (EXaddr_t)user_id)) != -1 )
		{
			/* 
			 * Interrupt the client to interrupt for 
			 * message arrival.
			 */
			intrpt_client( client_id, read_mp );
		}
		else
		{
			/*
			 * Message is unsolicited from the board. 
			 * interrupt the appropriate client.
			 */
			soid = xgetw( read_mp->nm_u.msg_msg.nm_soid);
			if ((client_id = soid_to_clientid( soid )) != -1)
			{
				intrpt_client( client_id, read_mp );
			}
			else
			{
				printf( "Unknown board msg: type = %d soid = %d userid = %X\n",
					xgetb( read_mp->nm_u.msg_msg.nm_request ) & 0xff,
					xgetw( read_mp->nm_u.msg_msg.nm_soid ),
					xgetd( read_mp->nm_u.msg_msg.nm_userid ) );
				/* 
				 * What do we do now? can assume there is no context
				 * tie-up or resource tie-up.
				 */
				goto nextmsg;		/* defensive programming */
			}
		}
nextmsg:
		xputw( read_mp->nm_u.msg_hd.mh_length,
			sizeof( union exos_u ) - sizeof( struct headers ) );
		xputb( read_mp->nm_u.msg_hd.mh_status, MQ_EXOS );
#if (pcxenix || rtpc)
		read_mp = (struct msg *)
			(xgetw( read_mp->nm_u.msg_hd.mh_link ) & (XM_WSIZE-1));
#else
		read_mp = read_mp->msg_link;
#endif
	} /* while loop on message queue */

	rmsgarea->ma_lastr = read_mp;
	/*
	 * If write_bucket is available,
	 * wake up any bucket waiting requestor.
	 */
	write_mp = wmsgarea->ma_lastw;
	if ((xgetb( write_mp->nm_u.msg_hd.mh_status ) & MQ_EXOS) == 0)
	{
		wakeup_bucket_requestor();
	}
#ifdef	DEBUG_NOISE
printf(" OK]\n");
#endif

#ifdef zilog
	dvi();		/* GAP 5/7/85: Zilog did this, I know not why */
	XIOCLRINT();
#endif

	XIONTRUPT();	/* tell EXOS to look at the message queues */
#if (pcxenix || rtpc)
	swtchbank( savebank );
#endif

#ifdef BSD4dot2
	/*
	 * GAP 2/26/85:   This looks like sheer superstition to me.
	 * <<Do not remove the nexte code line.  Removing it breaks
	 *   BSD4dot2 code and we do not know why -- bvs 850424>>
	 */
	 if((read_mp->nm_u.msg_hd.mh_status & (MQ_DONE|MQ_EXOS)) == 0) {
		goto again;
#endif
	if( ex_dopoll )
		timeout( exintr, 0, 1 );
	return 1;		/* serviced int */
} /* exintr */


xsointr( read_mp )
	register struct msg *read_mp;
{
	/* 
	 * Socket driver Interrupt Handling Routine.
	 */
	register struct Sock_printf *sp;
	register struct context *kp;
	register struct context *kpl;
	register int pix;	/* index into proc table */
	register int mdev;	/* index into socket table */
	long	user_id;

	user_id = xgetd( read_mp->nm_u.msg_msg.nm_userid );
#ifdef rtpc
	kp = (struct context *)user_id;
#else
	kp = (struct context *)( user_id & 0x0000ffffL );
#endif
	if ( (kp >= &context[0]) && (kp < &context[NET_CONTEXTS]) &&
		(( kp->kl_state & KL_BUSY ) == 0)  && 
		( kp->kl_state & KL_WAITING ) )
	{
		/*
		 *	Release buffers of io calls which got hit by a signal.
		 *  Note that unsolicited messages don't have meaningful
		 *  context pointers, thus the complicated clause above.
		 */
		if ((kp->kl_baddr) && ((kp->kl_state & (KL_READ|KL_WRITE)) == 0))
		{
			EXbrelse( kp->kl_baddr, BSIZE );
			kp->kl_baddr = (EXbtype *)0;
			kp->kl_state = KL_FREE;
			return;
		}
	}
#ifdef LMT
	if (kp == (struct context *)1)
		lmtintr( read_mp );
	else
#endif
	switch (xgetb(read_mp->nm_u.msg_msg.nm_request)&0xff) 
	{
		default:
			printf("funny message type %d\n",
			      xgetb(read_mp->nm_u.msg_msg.nm_request)&0xff);
			if ((kp >= &context[0]) || (kp < &context[NET_CONTEXTS]))
				wakeup((caddr_t)kp);
			break;

		case map_ioctl_cmd(SOSOCKET):
			kp->kl_soid = xgetw(read_mp->nm_u.msg_msg.nm_soid);
			goto finish;
		case map_ioctl_cmd(SOACCEPT):
		case map_ioctl_cmd(SOCONNECT):
		case map_ioctl_cmd(SOSOCKETADDR):
			if (xgetw(read_mp->nm_u.nm_cmd.nm_isaddr))
			    xcpi(&(read_mp->nm_u.nm_cmd.nm_saddr),
				(EXbatype)&(kp->kl_sa),
				sizeof (struct sockaddr));
			goto finish;

		case map_ioctl_cmd(SOSELWAKEUP):
#ifndef NOSELECT
			pix = xgetw(read_mp->nm_u.nm_select.nm_proc);
#ifdef	EXOSASYNCIO
#ifdef	DEBUGASYNC
			{register int s; EXSPL6(s);
			printf("xsointr: SELWAKEUP: proc: %d, socket-id: %d\n",
				proc[pix].p_pid, xgetw(read_mp->nm_u.nm_select.nm_soid));
			splx(s);}
#endif	/* DEBUGASYNC */
			mdev=xsofinddev(xgetw(read_mp->nm_u.nm_select.nm_soid));
#ifdef	DEBUGASYNC
			printf("xsointr: SELWAKEUP: dev-id: %d, socket-id: %d, status: %d, signum: %d\n",
				mdev, xgetw(read_mp->nm_u.nm_select.nm_soid), so_async[mdev], so_signum[mdev]);
#endif	/* DEBUGASYNC */
			if (mdev >= 0 && so_async[mdev] & SOA_SIGNAL) {
#ifdef	DEBUGASYNC
				printf("xsointr: signalling %d for socket %d\n", 
					proc[pix].p_pid, mdev);
#endif	/* DEBUGASYNC */
				psignal(&proc[pix], so_signum[mdev]);
				so_async[mdev] &= ~SOA_SIGNAL;
			}
#endif	/* EXOSASYNCIO */
#ifdef HOSTSELECT
			/*
			 * Use 4.2 selwakeup.
			 */
			selwakeup( (caddr_t)
#else /* HOSTSELECT */
			xselwakeup( (caddr_t)
#endif /* HOSTSELECT */
				&proc[pix],
				xgetw(read_mp->nm_u.nm_select.nm_selcoll));
#endif /* NOSELECT */
			break;

		case map_ioctl_cmd(SOIOCTL):
		{
			short iolength;
			switch (xgetw(read_mp->nm_u.nm_ioctl.nm_ioccmd)) {
				case map_ioctl_cmd(FIONREAD):
					iolength = sizeof (long);
					break; 
				case map_ioctl_cmd(SIOCSHOWRT):
				case map_ioctl_cmd(SIOCDISPRT):
					iolength = sizeof(struct rtentry);
					break;
				case map_ioctl_cmd(SIOCGKEEP):
				case map_ioctl_cmd(SIOCGLINGER):
				case map_ioctl_cmd(SIOCATMARK):
				case map_ioctl_cmd(SIOCGPGRP):
					iolength = sizeof (short);
					break;
				case map_ioctl_cmd(SIOCRCVOOB):
					iolength = sizeof (char);
					break;
				default:
					goto finish;
			} /* switch */
			xcpi(read_mp->nm_u.nm_ioctl.nm_iocdata,
			    (EXbatype)&(kp->kl_achar), iolength);
			goto finish;
		}

		case NET_ULOAD:
			kp->kl_achar = xgetb(read_mp->nm_u.nm_dload.nm_xmbyte);
			goto finish;

		case map_ioctl_cmd(SORECEIVE):
		case map_ioctl_cmd(SORECEIVE)|NM_MAGIC_DATA:
			kp->kl_state |= KL_DONE;
			if (xgetw(read_mp->nm_u.nm_packet.nm_isaddr))
			    xcpi(&(read_mp->nm_u.nm_packet.nm_saddr),
				(EXbatype)&(kp->kl_sa),
				sizeof (struct sockaddr));
			kp->kl_prevcnt = kp->kl_count;
			kp->kl_count += xgetw(read_mp->nm_u.nm_packet.nm_count);
			kp->kl_achar = xgetb(read_mp->nm_u.nm_packet.nm_data);
			goto finish;

		case map_ioctl_cmd(SOCLOSE):
 			mdev = xsofinddev( xgetw(read_mp->nm_u.msg_msg.nm_soid) );
			if (so_state[mdev] & (SOS_PENDRD|SOS_PENDWRT)) 
			{
				for(kpl=context;kpl < &context[NET_CONTEXTS];kpl++) 
				{
					if(kpl->kl_dev == mdev) 
					{
						if((kpl->kl_state & (KL_READ|KL_WRITE)) &&
				    		(kpl->kl_state & KL_DONE)) {
				  			EXbrelse(kpl->kl_baddr, BSIZE);
				  			kpl->kl_baddr = (EXbtype *)0;
				  			kpl->kl_state = KL_FREE;  
				  		} 
						else
							kpl->kl_state &= ~(KL_READ|KL_WRITE);
			       }
			   } /* for */
			}
			so_state[mdev] = SOS_FREE;
			so_id[mdev] = 0;
			socket_deallocate( xso_client_id, mdev );
#ifdef EXOSASYNCIO
 			so_async[mdev] = 0;
 			so_signum[mdev] = -1;
#endif
 			goto finish;

		case map_ioctl_cmd(SOSEND):
		case map_ioctl_cmd(SOSEND)|NM_MAGIC_DATA:
			kp->kl_state |= KL_DONE;
			kp->kl_count += xgetw (read_mp->nm_u.nm_packet.nm_count);
			goto finish;

		case map_ioctl_cmd(SOVERIFY):
		case NET_DLOAD:
		case NET_START:
		case map_ioctl_cmd(SOSELECT):
		case map_ioctl_cmd(EXBDSTAT):
		case map_ioctl_cmd(EXBDSTATRESET):
		case map_ioctl_cmd(EXIOCSARP):
		case map_ioctl_cmd(EXIOCGARP):
		case map_ioctl_cmd(EXIOCDARP):
		case map_ioctl_cmd(EXIOCADDRT):
		case map_ioctl_cmd(EXIOCDELRT):
		case map_ioctl_cmd(EXIOCSHOWRT):
		case map_ioctl_cmd(EXIOCDISPRT):
finish:
			kp->kl_reply = xgetb(read_mp->nm_u.msg_msg.nm_reply)&0xff;
			if (kp->kl_state & KL_WAITING) {
				kp->kl_state &= ~KL_WAITING;
				wakeup((caddr_t)kp);
			}
#ifdef	DEBUG_QUEUES
printf("wakeup(%x)\n", kp);
#endif	/* DEBUG_QUEUES */
			break;
		case map_ioctl_cmd(SOHASOOB):
		{
			short short_pgrp = xgetw(read_mp->nm_u.nm_hasoob.nm_sopgrp);
			int pgrp;
			extern struct proc *findproc();

			pgrp = short_pgrp;
			if (pgrp < 0){
				struct proc *p = findproc(-pgrp);
				if (p)
					psignal(p, SIGURG);
			}
			else
#ifdef BSD4dot2
				gsignal(pgrp, SIGURG);
#else
				signal(pgrp, SIGURG);
#endif
			break;
		}
	} /* switch */
} /* xsointr */



short doswap;

/*
 * exioctl:
 *	- process exos ioctl's
 */
/*ARGSUSED*/
exioctl(dev, cmd, addr, flag)
	dev_t dev;
	int cmd, flag;
	EXioctltype addr;
{
	register short i;
	int mdev = minor(dev);
	int socketdev;
	struct SOioctl param;
	struct msg *mp;
	struct context *kp;
	short ashort;
	static gotswap = 0;
	extern struct context *ex_send();

#ifdef XENIXNET_DBG
	if (cmd == EXPORTDATA)
	{
		exportdata( addr );
		return;
	}
#endif /* XENIXNET_DBG */
#ifdef  BSD4dot2
	/* IOVOID passes pointer to original argument */
	addr = (caddr_t)(*((long *)addr));
	cmd = map_ioctl_cmd(cmd);
#endif
#ifdef	DEBUG_NOISE
	printf("exioctl: cmd=%d\n", cmd);
#endif
	switch (cmd) {
#ifndef NOSELECT
#ifdef  EXOSSELECT
	  case map_ioctl_cmd(SOSELECT):
		if (copyin(addr, (caddr_t)&param, sizeof(param))) {
			u.u_error = EFAULT;
			return(u.u_error);
		}
#ifdef DEBUG_IBMCOMPILER
		printf("exioctl:\n");
		printf(    nfd = %d rp = %lx wp = %lx cbuf = %lx\n",
			param.nfd, param.rp, param.wp, param.cbuf);
#endif /* DEBUG_IBMCOMPILER */

#ifdef xenix286
		xselect((int)param.nfd, (long far *)param.rp,
			(long far *)param.wp, (long)param.timo,
			(long far *)param.cbuf);
#else
		xselect((int)param.nfd, (fd_set *)param.rp,
			(fd_set *)param.wp, (long)param.timo,
			(unsigned *)param.cbuf);
#endif /* xenix286 */
		return(u.u_error);

#ifdef	EXOSASYNCIO
	case map_ioctl_cmd(SOASYNCIO):
		if (copyin(addr, (caddr_t)&param, sizeof(param))) {
			u.u_error = EFAULT;
			return(u.u_error);
		}
		xasyncio(param.nfd, param.rp, param.wp);
		return u.u_error;

#endif	/* EXOSASYNCIO */
#endif
#endif

	  case map_ioctl_cmd(EXIOCFIND):
		/* 
		 * Allocate a socket info. entry from client interface.
		 */
		if (socket_alloc( xso_client_id, &socketdev ) == -1)
			return( u.u_error = ENOSPC );
		if (copyout((caddr_t)&socketdev, addr, sizeof(socketdev)))
			u.u_error = EFAULT;
		else {
			so_state[ socketdev ] = SOS_RESERVED;
			so_id[ socketdev ] = u.u_procp->p_pid;
		}
		return( u.u_error );
		break;
	  case map_ioctl_cmd(SOSOCKET):
		for( i= 0; i < MAXDEVS; ++i ) {
			printf( "so_state[%d] = %x\n", i, so_state[i] );
			printf( "so_id[%d] = %x\n", i, so_id[i] );
		}
		break;
	  case map_ioctl_cmd(SOSEND):
		for( i= 0; i < NET_CONTEXTS ; ++i ) {
			if( context[i].kl_state != KL_FREE )
				printf( "context buffer[%d] state = %x\n", i,
					context[i].kl_state );
			}
		break;
#ifdef NETBIOS_DEBUG
 	  case map_ioctl_cmd(SORECEIVE):
 		nb_int5c (mdev, cmd, addr, flag);
		break;
#endif
	  default:
		u.u_error = ENXIO;
	}
	return(u.u_error);
} /* exioctl */

/*
 * exlog:
 *	- used by exos printf to output a string to the log
 *	- drop characters that won't fit in the buffer
 *	- SHOULD BYTE SWAP DATA HERE!
 */
exlog( msg )
	register char *msg;
{
	register int s;

	if (ad_logon) {
		EXSPL7( s );
		while (ad_logcount < EXBSIZE) {
			if (xgetb(msg[0]) == 0)
				break;
			*ad_wp++ = (u_char)xgetb(msg[0]);
			msg++;
			ad_logcount++;
			if (ad_wp == ad_endp)
				ad_wp = EXlogaddr(ad_logbufp);
		}
		wakeup((caddr_t)ad_logbufp);
		splx(s);
	} else {
		char msgspace[50];
		char *msgpt = msgspace;
		int i = 0;

		while( (*msgpt++ = xgetb(msg[i])) != 0 )
			++i;
		printf("%s", msgspace );
	}
} /* exlog */


exlog_intr( mp )
	register struct msg	*mp;
{
	register struct Sock_printf	*sp;

	switch( xgetb( mp->nm_u.msg_msg.nm_request ) & 0xff )
	{
		case NET_PANIC:
			sp = &mp->nm_u.nm_printf;
			ex_db.ex_netdown = 1;
			printf( "exos panic\n" );  
			xcpo( (EXbatype)"exos panic\n", sp->nm_prdata, 12 );
			/* FALL THROUGH */
		case NET_PRINTF:
			sp = &mp->nm_u.nm_printf;
			exlog( sp->nm_prdata );
			break;
		case IM_ALIVE:
			ex_db.ex_netdown = 0;
			printf( "exos is alive and kicking\n" );
			break;
	}
} /* exlog_intr */

#ifdef BSD4dot2

#ifdef integrated
/*
new device driver routines for auto configuration
*/
#include "/sys/machine/qbvar.h"

int exprobe(), exslave(), exattach(), exintr();

/*
EXOS board addresses
*/
u_short *EXstd[] = { (u_short *)0x3fe800, (u_short *)0x3fe802, 0 };

/*
EXOS device driver structure
*/
struct qb_driver EXdriver =
	{ exprobe, exslave, exattach, EXstd, "ex", 0, "EX", 0 };

struct exdevice {
	short   portA;
	short   portB;
};
#endif
#endif

#ifdef uniq
/*
 * more auto-configuration junk.
 */

#include "sys/map.h"
#include "sys/uba.h"

int exprobe(), exattach(), exintr();

struct uba_device *exinfo;

unsigned short exstd[] = {0164000, 0164002, 0};

struct uba_driver exdriver = {exprobe, 0, exattach, 0, exstd, "ex", &exinfo};

struct exdevice {
	short portA;
	short portB;
};

#endif /* uniq */

#ifdef BSD4dot2
/*
Autoconfiguration routines
*/
#ifdef integrated
extern cvec;

exprobe(exaddr)
	register struct exdevice *exaddr;
{

	cvec = VECTOR;
	return(4);
}

exslave( ex, exaddr )
	register struct qb_device *ex;
	register struct exdevice *exaddr;
{

	return(1);
}

exattach( ex )
	register struct qb_device *ex;
{

	return(1);
}
#else /* integrated */
#ifdef	parallel

#include <../sundev/mbvar.h>

struct exdevice {
	short 	portA;
	short	portB;
};

int	exprobe(), exslave(), exattach(), exintr();

u_long exstd[] = { 0 };

struct mb_driver exdriver =
{
	exprobe, exslave, exattach, /*go*/0, /*done*/o, exintr,
	exstd, /*mdr_addr*/0, sizeof(struct exdevice), "ex", 0,
}

exprobe(exaddr)
	register struct exdevice *exaddr;
{
	return 4;	/* return amount of io-space */
}

exslave()
{
	return(1);
}

exattach()
{
	return(1);
}
#endif	/* parallel */
#endif /* integrated */
#endif /* BSD4dot2 */



#ifdef bsd_41
/* JUNK FOR AUTOCONFIGURE */
#include <sys/pte.h>
#include <sys/ubareg.h>
#include <sys/ubavar.h>
struct uba_device *exinfo[1];
int exprobe(), exattach();
u_short exstd[] = { 0 };
struct uba_driver exdriver =
	{ exprobe, 0, exattach, 0, exstd, "ex", exinfo };

exprobe(reg)
	caddr_t reg;
{
	register int br, cvec;		/* value-result */
#ifdef lint
	br = 0; cvec = br; br = cvec;
#endif
	ex_db.ex_port = reg;		/* where board is on unibus */
	br = 0x15;			/* BR Level 15 = UNIBUS 5 */
	cvec = VECTOR;			/* Int vector */
	return 1;
}

exattach( ex )
	register ex;
{
	return(1);
}
#endif

#ifdef uniq
/*
 * more auto-configuration junk.
 */

exprobe(reg)
caddr_t reg;
{
	register int br, cvec;
	register struct exdevice *exaddr = (struct exdevice *)reg;

	ex_db.ex_port = (int)exaddr;

	br = 15;
	cvec = VECTOR; /* 0140? */

	return (1);
}

exattach(ui)
register struct uba_device *ui;
{
}

#endif /* uniq */

