/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: ctlmain.c,v 1.2 87/04/24 13:55:42 davidb Exp $ */

/*			

@(#)ctlmain.c	1.1 8/16/85 
File Name:	ctlmain.c
Description:	exos 205 control port accessing

			------------
			Edit History
			------------

	Date		Edit Number	Comments
	----		-----------	--------
	012585		0		first release (clc)

	051385		1		initialized control port to the
					exos window location
	062185		2		modified for xenix environment
*/

#include	"def.h"
#ifdef LATICE
#include	"exoprt.h"
#else
#include	<sys/exos205.h>
#endif	/* LATICE */


#define	setctl(bit)	ctlcopy |= bit;		ioctl(ofd,EXIOCP2WRITE,&ctlcopy)
#define	clrctl(bit)	ctlcopy &= ~bit;	ioctl(ofd,EXIOCP2WRITE,&ctlcopy)

UBYTE2	ctlcopy;	/* software copy of control port contents */
extern	UBYTE2	 intport,ctlport,ackport;
extern	int ofd;


ctlini()
{
#ifdef LATICE
ctlcopy	= 0;		/* initialize software copy */
openwndw();		/* program exos window in control port [1] */
nrml_net();		/* this is a 82051 feature!!! */
lpbk_net();
#else	/* LATICE */
	ioctl(ofd, EXIOCP2READ, &ctlcopy);
	ctlcopy &=~(CP2_ENA186 | CP2_ENA586 | CP2_ENAPAR | CP2_NETNRML |
			CP2_FRCPAR | CP2_586CA );
	ioctl(ofd, EXIOCP2WRITE, &ctlcopy);
#endif	/* LATICE */
}


/* reset/enable 80186 */ 
rst_exo()
{
clrctl(CP2_ENA186);
}

enbl_exo()
{
setctl(CP2_ENA186);
}


/* reset/enable 82586 */
rst_net()
{
clrctl(CP2_ENA586);
}

enbl_net()
{
setctl(CP2_ENA586);
}


/* reset/enable parity detection circuitry */
rst_prty()
{
clrctl(CP2_ENAPAR);
}

enbl_prty()
{
clrctl(CP2_ENAPAR);
setctl(CP2_ENAPAR);
}


/* enable loopback/normal net operation */
lpbk_net()
{
clrctl(CP2_NETNRML);
}

nrml_net()
{
setctl(CP2_NETNRML);
clrctl(CP2_NETNRML);
setctl(CP2_NETNRML);
}


/* normal parity operation / force parity error */
nrml_prterr()
{
clrctl(CP2_FRCPAR);
}

frce_prterr()
{
setctl(CP2_FRCPAR);
}


/* give CA to 82586 by host/80186 */
hst_ca()
{
clrctl(CP2_586CA);
setctl(CP2_586CA);
}

exo_ca()
{
setctl(CP2_586CA);
}


int_exo()
{
#ifdef LATICE
outp(intport);
#else
ioctl( ofd, EXIOCP1WRITE, &ctlcopy);
#endif	/* LATICE */
}


exctlini()
{
#ifdef LATICE
getenv();
ctlcopy = EXOBIT+NETBIT+PRTBIT+NRMLBIT+CABIT;
openwndw();
#else
	ioctl(ofd, EXIOCP2READ, &ctlcopy);
	ctlcopy = (CP2_ENA186 | CP2_ENA586 | CP2_ENAPAR | CP2_NETNRML |
			 CP2_586CA );
	ioctl(ofd, EXIOCP2WRITE, &ctlcopy);
#endif	/* LATICE */
}

