/*	Copyright (c) 1985,1986,1987  EXCELAN, INC. 	*/
/*	  All Rights Reserved.                         	*/

/*	The copyright notice above does not evidence any 	*/
/*	actual or intended publication. 			*/

/*	THIS IS UNPUBLISHED COMPUTER SOFTWARE CONTAINING TRADE SECRETS 	*/
/*	AND CONFIDENTIAL INFORMATION PROPRIETARY TO EXCELAN, INC. 	*/

/* $Header: stdxln.h,v 1.5 87/04/24 13:50:55 davidb Exp $ */
/* 

$Header: stdxln.h,v 1.5 87/04/24 13:50:55 davidb Exp $

$Project: Software Administration, C programming conventions $

$Creator: Jay Israel, Rick Bohdanowicz $

$Locker:  $

$Source: /a/8000/8000S/sdist/205/include/EXOS/sys/stdxln.h,v $

$Abstract: 

This header file captures common definitions for C programs and must be
used as in all C programs. The document "Conventions for C Programming"
describes the usage. Note that following options are available as 
compile time define switches -

NOREG  iff defined turns the register definition off

NOPRVT iff defined makes all private identifiers public so that
       a full map of all names can be obtained for debugging

DEVMOD iff defined then turns on debug macros and a run time flag.
       if used then the final program should be linked with a module
       providing the debug routines

$


$Log:	stdxln.h,v $
 * Revision 1.5  87/04/24  13:50:55  davidb
 * Fixing copyright message
 * 
 * Revision 1.4  87/04/24  11:59:20  davidb
 * Added old copyright
 * 
 * Revision 1.3  87/03/26  19:10:53  grant
 * Updating source from Generic trees
 * 
 * Revision 1.1  87/02/18  13:55:39  richl
 * Initial revision
 * 
 * Revision 6.0  86/04/10  13:43:30  mukesh
 * Production Release
 * 
 * Revision 5.0  86/03/12  11:58:30  mukesh
 * Beta Release version.
 * 
 * Revision 4.0  86/03/11  09:04:56  mukesh
 * Alpha Release version
 * 
 * Revision 3.0  86/02/25  10:49:49  mukesh
 * Fully functional and stable engineering release.
 * 
 * Revision 2.0  86/02/13  14:40:10  mukesh
 * Stable engineering release.
 * 
 * Revision 1.1  86/01/09  14:16:09  mukesh
 * newest stdxln file.
 * 
 * Revision 1.2  86/01/07  13:43:45  navin
 * removed BOOLEAN definition
 * 
 * Revision 1.1  86/01/01  12:56:54  navin
 * Initial revision
 * 

$EndLog$


*/



/* Useful constants:						*/

#ifndef NULL
#define NULL    0	        /* Null pointer value		*/
#endif
#define NULLPT  (char *) NULL	/* Null char pointer value	*/
#define	TRUE	(-1)		/* Function TRUE  value		*/
#define	FALSE	(0)		/* Function FALSE value		*/




/* Qualifiers for functions and variables:			   */

#ifndef NOPRVT
#define	PRIVATE static		/* Local to the current module */
#else
#define PRIVATE
#endif
#define EXPORT /**/     	/* Global variable defined here & exported */
#define IMPORT extern		/* External variable defined elsewhere	   */
#define VOID int		/* Void function return			   */



#ifdef NOREG
#define REG /**/       		/* no registers 	*/
#else
#define	REG register   		/* use register 	*/
#endif

#ifndef DEVMOD			/* product mode 	*/
#define dbassert(a,i,j,f)
#define dbinit()
#define dbbug()
#define dbprintf()
#else				/* debug mode 		*/
IMPORT dbdebug; 		/* run time flag for debug mode */
IMPORT  VOID  dbbug();  	/* use the macro dbassert, below. */
IMPORT  VOID  dbinit();
IMPORT long nbdebugflag;
#define dbassert(a,i,j,f) if(dbdebug) {if(!(a)) dbbug((i), (j), (f));}
#ifdef pcxenix
#define dbprintf(arg) {\
			if (nbdebugflag & (1L << (MYID - 1))) \
			    printf arg; \
		     }
#else
#define dbprintf(arg) {\
			if (nbdebugflag & (1L << (MYID - 1))) \
			    xprintf arg; \
		     }
#endif
#endif

