echo OFF
rem
rem	Usage:  CHK_TAPE [-ab1234] [-t] [-c] [-m] [-f] [-d ds-number]
rem	  -a or -1 ... floppy tape drive A
rem	  -b or -2 ... floppy tape drive B  (default)
rem		 3 ... floppy tape drive 3
rem		 4 ... floppy tape drive 4
rem		-t ... do not print program title
rem             -m ... do not print tape status
rem             -f ... check if tape is formatted
rem             -c ... check tape capacity
rem             -d ... delete specified dataset number
rem
rem	CHK_TAPE returns with the following errorlevels:
rem		0 - tape system is ready
rem		1 - command syntax error
rem		2 - tape is write protected
rem		3 - tape is not mounted or power is off
rem		4 - tape system in error
rem		5 - memory allocation failure
rem		6 - tape is not formatted
rem		7 - dataset not found
rem	       40 - tape capacity is 40 MB
rem	       80 - tape capacity is 60 MB

rem

:loop
cls
CHK_TAPE -tm
if errorlevel 4 goto level4
if errorlevel 3 goto level3
if errorlevel 2 goto level2
if errorlevel 1 goto level1
echo Tape system is ready!
pause
goto exit

:level1
echo Command syntax error!
goto wait

:level2
echo Tape is write protected!
goto wait

:level3
echo Tape is not mounted or powered!
goto wait

:level4
echo Tape system error!

:wait
pause
goto loop

:exit
echo on
cls

